/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageBits;
import org.rhq.core.domain.content.PackageBitsBlob;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.composite.LoadedPackageBitsComposite;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.ContentUIManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.Test;

public class ContentUIManagerBeanTest
extends AbstractEJB3Test {
    private static final boolean ENABLE_TESTS = true;
    private ContentUIManagerLocal contentUIManager;
    private ContentManagerLocal contentManager;

    @Override
    protected void beforeMethod() throws Exception {
        this.contentUIManager = LookupUtil.getContentUIManager();
        this.contentManager = LookupUtil.getContentManager();
    }

    @Test(enabled=true)
    public void testPackageBits() throws Throwable {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                try {
                    Resource resource = SessionTestHelper.createNewResource(ContentUIManagerBeanTest.this.em, "testPkgBitsResource");
                    PackageType pkgType = new PackageType("testPkgBitsPT", resource.getResourceType());
                    Package pkg = new Package("testPkgBitsP", pkgType);
                    Architecture arch = new Architecture("testPkgArch");
                    PackageVersion pkgVer = new PackageVersion(pkg, "1", arch);
                    ContentUIManagerBeanTest.this.em.persist((Object)pkgType);
                    ContentUIManagerBeanTest.this.em.persist((Object)pkg);
                    ContentUIManagerBeanTest.this.em.persist((Object)arch);
                    ContentUIManagerBeanTest.this.em.persist((Object)pkgVer);
                    ContentUIManagerBeanTest.this.em.flush();
                    LoadedPackageBitsComposite composite = ContentUIManagerBeanTest.this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
                    assert (composite != null);
                    assert (composite.getPackageVersionId() == pkgVer.getId());
                    assert (composite.getPackageBitsId() == null);
                    assert (!composite.isPackageBitsAvailable());
                    assert (!composite.isPackageBitsInDatabase());
                    PackageBits packageBits = ContentUIManagerBeanTest.this.createPackageBits();
                    pkgVer.setPackageBits(packageBits);
                    pkgVer = (PackageVersion)ContentUIManagerBeanTest.this.em.merge((Object)pkgVer);
                    ContentUIManagerBeanTest.this.em.flush();
                    composite = ContentUIManagerBeanTest.this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
                    assert (composite != null);
                    assert (composite.getPackageVersionId() == pkgVer.getId());
                    assert (composite.getPackageBitsId().intValue() == packageBits.getId());
                    assert (composite.isPackageBitsAvailable());
                    assert (!composite.isPackageBitsInDatabase());
                    packageBits = (PackageBits)ContentUIManagerBeanTest.this.em.find(PackageBits.class, (Object)packageBits.getId());
                    assert (packageBits != null);
                    assert (packageBits.getBlob().getBits() == null);
                    String DATA = "testPackageBits data";
                    PackageBitsBlob packageBitsBlob = (PackageBitsBlob)ContentUIManagerBeanTest.this.em.find(PackageBitsBlob.class, (Object)packageBits.getId());
                    packageBitsBlob.setBits("testPackageBits data".getBytes());
                    ContentUIManagerBeanTest.this.em.merge((Object)packageBitsBlob);
                    ContentUIManagerBeanTest.this.em.flush();
                    composite = ContentUIManagerBeanTest.this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
                    assert (composite != null);
                    assert (composite.getPackageVersionId() == pkgVer.getId());
                    assert (composite.getPackageBitsId().intValue() == packageBits.getId());
                    assert (composite.isPackageBitsAvailable());
                    assert (composite.isPackageBitsInDatabase());
                    packageBits = (PackageBits)ContentUIManagerBeanTest.this.em.find(PackageBits.class, (Object)packageBits.getId());
                    assert (packageBits != null);
                    assert ("testPackageBits data".equals(new String(packageBits.getBlob().getBits())));
                    PackageVersion pkgVer2 = new PackageVersion(pkg, "2", arch);
                    ContentUIManagerBeanTest.this.em.persist((Object)pkgVer2);
                    ContentUIManagerBeanTest.this.em.flush();
                    composite = ContentUIManagerBeanTest.this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
                    assert (composite != null);
                    assert (composite.getPackageVersionId() == pkgVer.getId());
                    assert (composite.getPackageBitsId().intValue() == packageBits.getId());
                    assert (composite.isPackageBitsAvailable());
                    assert (composite.isPackageBitsInDatabase());
                    composite = ContentUIManagerBeanTest.this.contentUIManager.getLoadedPackageBitsComposite(pkgVer2.getId());
                    assert (composite != null);
                    assert (composite.getPackageVersionId() == pkgVer2.getId());
                    assert (composite.getPackageBitsId() == null);
                    assert (!composite.isPackageBitsAvailable());
                    assert (!composite.isPackageBitsInDatabase());
                    PackageBits packageBits2 = ContentUIManagerBeanTest.this.createPackageBits();
                    pkgVer2.setPackageBits(packageBits2);
                    pkgVer2 = (PackageVersion)ContentUIManagerBeanTest.this.em.merge((Object)pkgVer2);
                    ContentUIManagerBeanTest.this.em.flush();
                    composite = ContentUIManagerBeanTest.this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
                    assert (composite != null);
                    assert (composite.getPackageVersionId() == pkgVer.getId());
                    assert (composite.getPackageBitsId().intValue() == packageBits.getId());
                    assert (composite.isPackageBitsAvailable());
                    assert (composite.isPackageBitsInDatabase());
                    composite = ContentUIManagerBeanTest.this.contentUIManager.getLoadedPackageBitsComposite(pkgVer2.getId());
                    assert (composite != null);
                    assert (composite.getPackageVersionId() == pkgVer2.getId());
                    assert (composite.getPackageBitsId().intValue() == packageBits2.getId());
                    assert (composite.isPackageBitsAvailable());
                    assert (!composite.isPackageBitsInDatabase());
                    packageBits2 = (PackageBits)ContentUIManagerBeanTest.this.em.find(PackageBits.class, (Object)packageBits2.getId());
                    assert (packageBits2 != null);
                    assert (packageBits2.getBlob().getBits() == null);
                    String DATA2 = "testPackageBits more data";
                    packageBits2.getBlob().setBits("testPackageBits more data".getBytes());
                    ContentUIManagerBeanTest.this.em.merge((Object)packageBits2.getBlob());
                    ContentUIManagerBeanTest.this.em.flush();
                    composite = ContentUIManagerBeanTest.this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
                    assert (composite != null);
                    assert (composite.getPackageVersionId() == pkgVer.getId());
                    assert (composite.getPackageBitsId().intValue() == packageBits.getId());
                    assert (composite.isPackageBitsAvailable());
                    assert (composite.isPackageBitsInDatabase());
                    composite = ContentUIManagerBeanTest.this.contentUIManager.getLoadedPackageBitsComposite(pkgVer2.getId());
                    assert (composite != null);
                    assert (composite.getPackageVersionId() == pkgVer2.getId());
                    assert (composite.getPackageBitsId().intValue() == packageBits2.getId());
                    assert (composite.isPackageBitsAvailable());
                    assert (composite.isPackageBitsInDatabase());
                    packageBits2 = (PackageBits)ContentUIManagerBeanTest.this.em.find(PackageBits.class, (Object)packageBits2.getId());
                    assert (packageBits2 != null);
                    assert ("testPackageBits more data".equals(new String(packageBits2.getBlob().getBits())));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new RuntimeException(t);
                }
            }
        });
    }

    @Test(enabled=true)
    public void testPackageBitsBlobStream() throws Throwable {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                try {
                    File retrieved;
                    Resource resource = SessionTestHelper.createNewResource(ContentUIManagerBeanTest.this.em, "testPkgBitsLargeResource");
                    PackageType pkgType = new PackageType("testPkgBitsLargePT", resource.getResourceType());
                    Package pkg = new Package("testPkgBitsLargeP", pkgType);
                    Architecture arch = new Architecture("testPkgLargeArch");
                    PackageVersion pkgVer = new PackageVersion(pkg, "1", arch);
                    ContentUIManagerBeanTest.this.em.persist((Object)pkgType);
                    ContentUIManagerBeanTest.this.em.persist((Object)pkg);
                    ContentUIManagerBeanTest.this.em.persist((Object)arch);
                    ContentUIManagerBeanTest.this.em.persist((Object)pkgVer);
                    ContentUIManagerBeanTest.this.em.flush();
                    LoadedPackageBitsComposite composite = ContentUIManagerBeanTest.this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
                    assert (composite != null);
                    assert (composite.getPackageVersionId() == pkgVer.getId());
                    assert (composite.getPackageBitsId() == null);
                    assert (!composite.isPackageBitsAvailable());
                    assert (!composite.isPackageBitsInDatabase());
                    PackageBits packageBits = ContentUIManagerBeanTest.this.createPackageBits();
                    pkgVer.setPackageBits(packageBits);
                    pkgVer = (PackageVersion)ContentUIManagerBeanTest.this.em.merge((Object)pkgVer);
                    ContentUIManagerBeanTest.this.em.flush();
                    composite = ContentUIManagerBeanTest.this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
                    assert (composite != null);
                    assert (composite.getPackageVersionId() == pkgVer.getId());
                    assert (composite.getPackageBitsId().intValue() == packageBits.getId());
                    assert (composite.isPackageBitsAvailable());
                    assert (!composite.isPackageBitsInDatabase());
                    packageBits = (PackageBits)ContentUIManagerBeanTest.this.em.find(PackageBits.class, (Object)packageBits.getId());
                    assert (packageBits != null);
                    assert (packageBits.getBlob().getBits() == null);
                    File tempDir = ContentUIManagerBeanTest.this.getTempDir();
                    if (!tempDir.exists()) {
                        ContentUIManagerBeanTest.this.assertTrue("Unable to mkdirs " + tempDir + " for test.", tempDir.mkdirs());
                    }
                    if ((retrieved = new File(tempDir, "pulled.jar")).exists()) {
                        ContentUIManagerBeanTest.this.assertTrue("Unable to delete " + retrieved.getPath() + " for test cleanup.", retrieved.delete());
                    }
                    InputStream originalBinaryStream = this.getClass().getClassLoader().getResourceAsStream("binary-blob-sample.jar");
                    String originalDigest = new MessageDigestGenerator("SHA-256").calcDigestString(originalBinaryStream);
                    originalBinaryStream.close();
                    originalBinaryStream = this.getClass().getClassLoader().getResourceAsStream("binary-blob-sample.jar");
                    ContentUIManagerBeanTest.this.contentManager.updateBlobStream(originalBinaryStream, packageBits, null);
                    packageBits = (PackageBits)ContentUIManagerBeanTest.this.em.find(PackageBits.class, (Object)packageBits.getId());
                    composite = ContentUIManagerBeanTest.this.contentUIManager.getLoadedPackageBitsComposite(pkgVer.getId());
                    assert (composite != null);
                    assert (composite.getPackageVersionId() == pkgVer.getId());
                    assert (composite.getPackageBitsId().intValue() == packageBits.getId());
                    assert (composite.isPackageBitsAvailable());
                    assert (composite.isPackageBitsInDatabase());
                    FileOutputStream outputStream = new FileOutputStream(retrieved);
                    ContentUIManagerBeanTest.this.contentManager.writeBlobOutToStream((OutputStream)outputStream, packageBits, false);
                    String newDigest = new MessageDigestGenerator("SHA-256").calcDigestString(retrieved);
                    ContentUIManagerBeanTest.this.assertEquals("Uploaded and retrieved digests differ:", originalDigest, newDigest);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new RuntimeException(t);
                }
            }
        });
    }

    private PackageBits createPackageBits() {
        PackageBits bits = null;
        PackageBitsBlob blob = null;
        blob = new PackageBitsBlob();
        this.em.persist((Object)blob);
        bits = new PackageBits();
        bits.setId(blob.getId());
        bits.setBlob(blob);
        this.em.flush();
        return bits;
    }
}

