/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content.test;

import java.util.List;
import javax.persistence.Query;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.resource.ProductVersionManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

public class ProductVersionManagerBeanTest
extends AbstractEJB3Test {
    private ResourceType resourceType;
    private ProductVersionManagerLocal productManager;

    @Override
    protected void beforeMethod() throws Exception {
        this.productManager = LookupUtil.getProductVersionManager();
        this.setupTestEnvironment();
    }

    @Override
    protected void afterMethod() throws Exception {
        this.teardownTestEnvironment();
    }

    @Test
    public void addNewProductVersion() throws Exception {
        this.productManager.addProductVersion(this.resourceType, "1.0.0");
        this.getTransactionManager().begin();
        try {
            this.resourceType = (ResourceType)this.em.find(ResourceType.class, (Object)this.resourceType.getId());
            Query query = this.em.createNamedQuery("ProductVersion.findByResourceTypeAndVersion");
            query.setParameter("resourceType", (Object)this.resourceType);
            query.setParameter("version", (Object)"1.0.0");
            List addedProductVersion = query.getResultList();
            assert (addedProductVersion.size() == 1) : "Incorrect number of versions persisted. Expected: 1, Found: " + addedProductVersion.size();
            this.em.remove(addedProductVersion.get(0));
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            this.getTransactionManager().rollback();
        }
    }

    @Test
    public void addExistingProductVersion() throws Exception {
        this.productManager.addProductVersion(this.resourceType, "1.0.0");
        this.productManager.addProductVersion(this.resourceType, "1.0.0");
        this.getTransactionManager().begin();
        try {
            this.resourceType = (ResourceType)this.em.find(ResourceType.class, (Object)this.resourceType.getId());
            Query query = this.em.createNamedQuery("ProductVersion.findByResourceTypeAndVersion");
            query.setParameter("resourceType", (Object)this.resourceType);
            query.setParameter("version", (Object)"1.0.0");
            List addedProductVersion = query.getResultList();
            assert (addedProductVersion.size() == 1) : "Incorrect number of versions persisted. Expected: 1, Found: " + addedProductVersion.size();
            this.em.remove(addedProductVersion.get(0));
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            this.getTransactionManager().rollback();
        }
    }

    private void setupTestEnvironment() throws Exception {
        this.getTransactionManager().begin();
        try {
            this.resourceType = new ResourceType("testResourceType", "testPlugin", ResourceCategory.PLATFORM, null);
            this.em.persist((Object)this.resourceType);
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getTransactionManager().rollback();
            throw e;
        }
    }

    private void teardownTestEnvironment() throws Exception {
        this.getTransactionManager().begin();
        try {
            this.resourceType = (ResourceType)this.em.find(ResourceType.class, (Object)this.resourceType.getId());
            this.em.remove((Object)this.resourceType);
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getTransactionManager().rollback();
            throw e;
        }
    }
}

