/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.commons.lang.RandomStringUtils;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoGroup;
import org.rhq.core.domain.content.RepoGroupType;
import org.rhq.core.domain.content.RepoRelationshipType;
import org.rhq.core.domain.content.RepoRepoRelationship;
import org.rhq.core.domain.criteria.RepoCriteria;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.RepoException;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.content.metadata.ContentSourceMetadataManagerLocal;
import org.rhq.enterprise.server.plugin.pc.content.TestContentServerPluginService;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

public class RepoManagerBeanTest
extends AbstractEJB3Test {
    private static final boolean ENABLED = true;
    protected RepoManagerLocal repoManager;
    protected ContentSourceManagerLocal contentSourceManager;
    protected ContentSourceMetadataManagerLocal contentSourceMetadataManager;
    protected SubjectManagerLocal subjectManager;
    private Subject overlord;

    @Override
    protected void beforeMethod() throws Exception {
        this.overlord = LookupUtil.getSubjectManager().getOverlord();
        this.prepareScheduler();
        this.repoManager = LookupUtil.getRepoManagerLocal();
        this.contentSourceManager = LookupUtil.getContentSourceManager();
        this.contentSourceMetadataManager = LookupUtil.getContentSourceMetadataManager();
        TestContentServerPluginService pluginService = new TestContentServerPluginService(this);
    }

    @Override
    protected void afterMethod() throws Exception {
        this.unprepareServerPluginService();
        this.unprepareScheduler();
    }

    @Test(enabled=true)
    public void createABunchOfRepos() throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                PageList repos = RepoManagerBeanTest.this.repoManager.findRepos(RepoManagerBeanTest.this.overlord, new PageControl());
                int origsize = 0;
                if (repos != null) {
                    origsize = repos.size();
                }
                for (int i = 0; i < 10; ++i) {
                    Random r = new Random(System.currentTimeMillis());
                    Repo repo = new Repo(r.nextLong() + "");
                    RepoManagerBeanTest.this.repoManager.createRepo(RepoManagerBeanTest.this.overlord, repo);
                }
                repos = RepoManagerBeanTest.this.repoManager.findRepos(RepoManagerBeanTest.this.overlord, new PageControl());
                assert (repos.size() == origsize + 10);
            }
        });
    }

    @Test(enabled=true)
    public void createDeleteRepo() throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Repo repo = new Repo("testCreateDeleteRepo");
                int id = RepoManagerBeanTest.this.repoManager.createRepo(RepoManagerBeanTest.this.overlord, repo).getId();
                Repo lookedUp = RepoManagerBeanTest.this.repoManager.getRepo(RepoManagerBeanTest.this.overlord, id);
                assert (lookedUp != null);
                Repo lookedUp2 = (Repo)RepoManagerBeanTest.this.repoManager.getRepoByName(lookedUp.getName()).get(0);
                assert (lookedUp2 != null);
                assert (id == lookedUp.getId());
                assert (id == lookedUp2.getId());
                RepoManagerBeanTest.this.repoManager.deleteRepo(RepoManagerBeanTest.this.overlord, id);
                lookedUp = RepoManagerBeanTest.this.repoManager.getRepo(RepoManagerBeanTest.this.overlord, id);
                assert (lookedUp == null);
            }
        });
    }

    @Test(enabled=true)
    public void createDeleteRepoGroup() throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                EntityManager entityManager = RepoManagerBeanTest.this.getEntityManager();
                RepoGroupType groupType = new RepoGroupType("testCreateDeleteRepoGroupType");
                entityManager.persist((Object)groupType);
                entityManager.flush();
                String groupName = "testCreateDeleteRepoGroup";
                RepoGroup group = RepoManagerBeanTest.this.repoManager.getRepoGroupByName(groupName);
                assert (group == null);
                group = new RepoGroup(groupName);
                group.setRepoGroupType(groupType);
                group = RepoManagerBeanTest.this.repoManager.createRepoGroup(RepoManagerBeanTest.this.overlord, group);
                int id = group.getId();
                group = RepoManagerBeanTest.this.repoManager.getRepoGroup(RepoManagerBeanTest.this.overlord, id);
                assert (group != null);
                assert (group.getName().equals(groupName));
                RepoManagerBeanTest.this.repoManager.deleteRepoGroup(RepoManagerBeanTest.this.overlord, id);
                group = RepoManagerBeanTest.this.repoManager.getRepoGroup(RepoManagerBeanTest.this.overlord, id);
                assert (group == null);
                entityManager.remove((Object)groupType);
            }
        });
    }

    @Test(enabled=true)
    public void createFindDeleteCandidateRepo() throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws Exception {
                Repo repo = new Repo("test create candidate repo");
                PageList importedRepos = RepoManagerBeanTest.this.repoManager.findRepos(RepoManagerBeanTest.this.overlord, new PageControl());
                int origSize = 0;
                if (importedRepos != null) {
                    origSize = importedRepos.size();
                }
                repo.setCandidate(true);
                repo = RepoManagerBeanTest.this.repoManager.createRepo(RepoManagerBeanTest.this.overlord, repo);
                try {
                    assert (repo.isCandidate());
                    importedRepos = RepoManagerBeanTest.this.repoManager.findRepos(RepoManagerBeanTest.this.overlord, new PageControl());
                    assert (importedRepos.size() == origSize);
                    assert (RepoManagerBeanTest.this.repoManager.getRepo(RepoManagerBeanTest.this.overlord, repo.getId()) != null);
                }
                finally {
                    RepoManagerBeanTest.this.repoManager.deleteRepo(RepoManagerBeanTest.this.overlord, repo.getId());
                }
            }
        });
    }

    @Test(enabled=true)
    public void createDuplicateRepoGroup() throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                EntityManager entityManager = RepoManagerBeanTest.this.getEntityManager();
                RepoGroupType groupType = new RepoGroupType("testCreateDuplicateRepoGroup");
                entityManager.persist((Object)groupType);
                entityManager.flush();
                String groupName = "testCreateDuplicateRepoGroup";
                RepoGroup existing = new RepoGroup(groupName);
                existing.setRepoGroupType(groupType);
                RepoManagerBeanTest.this.repoManager.createRepoGroup(RepoManagerBeanTest.this.overlord, existing);
                existing = RepoManagerBeanTest.this.repoManager.getRepoGroupByName(groupName);
                assert (existing != null);
                RepoGroup duplicate = new RepoGroup(groupName);
                duplicate.setRepoGroupType(groupType);
                try {
                    RepoManagerBeanTest.this.repoManager.createRepoGroup(RepoManagerBeanTest.this.overlord, existing);
                    assert (false);
                }
                catch (RepoException e) {
                    // empty catch block
                }
                RepoManagerBeanTest.this.repoManager.deleteRepoGroup(RepoManagerBeanTest.this.overlord, existing.getId());
                existing = RepoManagerBeanTest.this.repoManager.getRepoGroup(RepoManagerBeanTest.this.overlord, existing.getId());
                assert (existing == null);
                entityManager.remove((Object)groupType);
            }
        });
    }

    @Test(enabled=true)
    public void getRepoGroupByNameNoGroup() throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                RepoGroup group = RepoManagerBeanTest.this.repoManager.getRepoGroupByName("foo");
                assert (group == null);
            }
        });
    }

    @Test(enabled=true)
    public void getRepoGroupTypeByName() throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                EntityManager entityManager = RepoManagerBeanTest.this.getEntityManager();
                String name = "test-repo-type";
                RepoGroupType groupType = new RepoGroupType(name);
                entityManager.persist((Object)groupType);
                entityManager.flush();
                RepoGroupType type = RepoManagerBeanTest.this.repoManager.getRepoGroupTypeByName(RepoManagerBeanTest.this.overlord, name);
                assert (type != null);
                assert (type.getName().equals(name));
                type = (RepoGroupType)entityManager.find(RepoGroupType.class, (Object)type.getId());
                entityManager.remove((Object)type);
                entityManager.flush();
            }
        });
    }

    @Test(enabled=true)
    public void addRepoRelationship() throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                EntityManager entityManager = RepoManagerBeanTest.this.getEntityManager();
                Repo repo = new Repo("repo1");
                Repo relatedRepo = new Repo("repo2");
                repo = RepoManagerBeanTest.this.repoManager.createRepo(RepoManagerBeanTest.this.overlord, repo);
                relatedRepo = RepoManagerBeanTest.this.repoManager.createRepo(RepoManagerBeanTest.this.overlord, relatedRepo);
                String relationshipTypeName = "testRelationshipType";
                RepoRelationshipType relationshipType = new RepoRelationshipType(relationshipTypeName);
                entityManager.persist((Object)relationshipType);
                entityManager.flush();
                RepoManagerBeanTest.this.repoManager.addRepoRelationship(RepoManagerBeanTest.this.overlord, repo.getId(), relatedRepo.getId(), relationshipTypeName);
                RepoCriteria repoCriteria = new RepoCriteria();
                repoCriteria.fetchRepoRepoGroups(true);
                repoCriteria.addFilterId(Integer.valueOf(repo.getId()));
                PageList repoPageList = RepoManagerBeanTest.this.repoManager.findReposByCriteria(RepoManagerBeanTest.this.overlord, repoCriteria);
                assert (repoPageList.size() == 1);
                Repo persistedRepo = (Repo)repoPageList.get(0);
                Set relationships = persistedRepo.getRepoRepoRelationships();
                assert (relationships.size() == 1);
                RepoRepoRelationship relationship = (RepoRepoRelationship)relationships.iterator().next();
                assert (relationship.getRepoRepoRelationshipPK().getRepo().getName().equals("repo1"));
                assert (relationship.getRepoRepoRelationshipPK().getRepoRelationship().getRelatedRepo().getName().equals("repo2"));
                assert (relationship.getRepoRepoRelationshipPK().getRepoRelationship().getRepoRelationshipType().getName().equals(relationshipTypeName));
            }
        });
    }

    @Test(enabled=true)
    public void findCandidatesByContentProvider() throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                String candidateRepoName = "candidate with source";
                ContentSourceType type = new ContentSourceType("testGetSyncResultsListCST");
                HashSet<ContentSourceType> types = new HashSet<ContentSourceType>();
                types.add(type);
                RepoManagerBeanTest.this.contentSourceMetadataManager.registerTypes(types);
                ContentSource contentSource = new ContentSource("testGetSyncResultsListCS", type);
                contentSource = RepoManagerBeanTest.this.contentSourceManager.simpleCreateContentSource(RepoManagerBeanTest.this.overlord, contentSource);
                Repo importedRepo = new Repo("imported repo");
                importedRepo.addContentSource(contentSource);
                importedRepo = RepoManagerBeanTest.this.repoManager.createRepo(RepoManagerBeanTest.this.overlord, importedRepo);
                Repo candidateRepo = new Repo(candidateRepoName);
                candidateRepo.setCandidate(true);
                candidateRepo.addContentSource(contentSource);
                candidateRepo = RepoManagerBeanTest.this.repoManager.createRepo(RepoManagerBeanTest.this.overlord, candidateRepo);
                RepoCriteria criteria = new RepoCriteria();
                criteria.addFilterCandidate(Boolean.valueOf(true));
                criteria.addFilterContentSourceIds(new Integer[]{contentSource.getId()});
                criteria.fetchRepoContentSources(true);
                PageList foundRepos = RepoManagerBeanTest.this.repoManager.findReposByCriteria(RepoManagerBeanTest.this.overlord, criteria);
                assert (foundRepos.size() == 1);
                Repo foundRepo = (Repo)foundRepos.get(0);
                assert (foundRepo.getName().equals(candidateRepoName));
                assert (foundRepo.isCandidate());
            }
        });
    }

    @Test(enabled=true)
    public void importCandidateRepo() throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Repo candidate = new Repo("create me");
                candidate.setCandidate(true);
                Repo created = RepoManagerBeanTest.this.repoManager.createRepo(RepoManagerBeanTest.this.overlord, candidate);
                ArrayList<Integer> repoIds = new ArrayList<Integer>(1);
                repoIds.add(created.getId());
                RepoManagerBeanTest.this.repoManager.importCandidateRepo(RepoManagerBeanTest.this.overlord, repoIds);
                RepoCriteria repoCriteria = new RepoCriteria();
                repoCriteria.addFilterId(Integer.valueOf(created.getId()));
                PageList repoList = RepoManagerBeanTest.this.repoManager.findReposByCriteria(RepoManagerBeanTest.this.overlord, repoCriteria);
                assert (repoList.size() == 1);
                Repo verify = (Repo)repoList.get(0);
                assert (verify != null);
                assert (!verify.isCandidate());
            }
        });
    }

    @Test(enabled=true)
    public void importCandidateRepoBadId() throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                try {
                    ArrayList<Integer> repoIds = new ArrayList<Integer>(1);
                    repoIds.add(12345);
                    RepoManagerBeanTest.this.repoManager.importCandidateRepo(RepoManagerBeanTest.this.overlord, repoIds);
                    assert (false);
                }
                catch (RepoException repoException) {
                    // empty catch block
                }
            }
        });
    }

    @Test(enabled=true)
    public void importNonCandidateRepo() throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Repo nonCandidate = new Repo("create me");
                Repo created = RepoManagerBeanTest.this.repoManager.createRepo(RepoManagerBeanTest.this.overlord, nonCandidate);
                try {
                    ArrayList<Integer> repoIds = new ArrayList<Integer>(1);
                    repoIds.add(created.getId());
                    RepoManagerBeanTest.this.repoManager.importCandidateRepo(RepoManagerBeanTest.this.overlord, repoIds);
                    assert (false);
                }
                catch (RepoException repoException) {
                    // empty catch block
                }
            }
        });
    }

    @Test(enabled=true)
    public void deleteCandidatesForContentSource() throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                ContentSourceType contentSourceType = new ContentSourceType("testSourceType");
                HashSet<ContentSourceType> types = new HashSet<ContentSourceType>(1);
                types.add(contentSourceType);
                RepoManagerBeanTest.this.contentSourceMetadataManager.registerTypes(types);
                ContentSource source1 = new ContentSource("testSource1", contentSourceType);
                source1 = RepoManagerBeanTest.this.contentSourceManager.simpleCreateContentSource(RepoManagerBeanTest.this.overlord, source1);
                ContentSource source2 = new ContentSource("testSource2", contentSourceType);
                source2 = RepoManagerBeanTest.this.contentSourceManager.simpleCreateContentSource(RepoManagerBeanTest.this.overlord, source2);
                Repo repo1 = new Repo("repo1");
                repo1.setCandidate(true);
                repo1.addContentSource(source1);
                Repo repo2 = new Repo("repo2");
                repo2.setCandidate(true);
                repo2.addContentSource(source2);
                Repo repo3 = new Repo("repo3");
                repo3.setCandidate(true);
                repo3.addContentSource(source1);
                repo3.addContentSource(source2);
                Repo repo4 = new Repo("repo4");
                repo4.setCandidate(true);
                repo1 = RepoManagerBeanTest.this.repoManager.createRepo(RepoManagerBeanTest.this.overlord, repo1);
                repo2 = RepoManagerBeanTest.this.repoManager.createRepo(RepoManagerBeanTest.this.overlord, repo2);
                repo3 = RepoManagerBeanTest.this.repoManager.createRepo(RepoManagerBeanTest.this.overlord, repo3);
                repo4 = RepoManagerBeanTest.this.repoManager.createRepo(RepoManagerBeanTest.this.overlord, repo4);
                RepoManagerBeanTest.this.repoManager.deleteCandidatesWithOnlyContentSource(RepoManagerBeanTest.this.overlord, source1.getId());
                assert (RepoManagerBeanTest.this.repoManager.getRepo(RepoManagerBeanTest.this.overlord, repo1.getId()) == null);
                assert (RepoManagerBeanTest.this.repoManager.getRepo(RepoManagerBeanTest.this.overlord, repo2.getId()) != null);
                assert (RepoManagerBeanTest.this.repoManager.getRepo(RepoManagerBeanTest.this.overlord, repo3.getId()) != null);
                assert (RepoManagerBeanTest.this.repoManager.getRepo(RepoManagerBeanTest.this.overlord, repo4.getId()) != null);
            }
        });
    }

    @Test(enabled=true)
    public void updateRepoWithProvider() throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                String newName = "newRepo-" + RandomStringUtils.randomAlphanumeric((int)6);
                String oldName = "testRepo-" + RandomStringUtils.randomAlphanumeric((int)6);
                ContentSourceType contentSourceType = new ContentSourceType("testSourceType");
                HashSet<ContentSourceType> types = new HashSet<ContentSourceType>(1);
                types.add(contentSourceType);
                RepoManagerBeanTest.this.contentSourceMetadataManager.registerTypes(types);
                ContentSource source = new ContentSource("testSource1", contentSourceType);
                source = RepoManagerBeanTest.this.contentSourceManager.simpleCreateContentSource(RepoManagerBeanTest.this.overlord, source);
                Repo repo = new Repo(oldName);
                repo = RepoManagerBeanTest.this.repoManager.createRepo(RepoManagerBeanTest.this.overlord, repo);
                RepoManagerBeanTest.this.repoManager.simpleAddContentSourcesToRepo(RepoManagerBeanTest.this.overlord, repo.getId(), new int[]{source.getId()});
                repo.setName(newName);
                RepoManagerBeanTest.this.repoManager.updateRepo(RepoManagerBeanTest.this.overlord, repo);
                RepoCriteria byName = new RepoCriteria();
                byName.addFilterName(newName);
                PageList reposWithNewName = RepoManagerBeanTest.this.repoManager.findReposByCriteria(RepoManagerBeanTest.this.overlord, byName);
                assert (reposWithNewName.size() == 1);
                byName = new RepoCriteria();
                byName.addFilterName(oldName);
                PageList reposWithOldName = RepoManagerBeanTest.this.repoManager.findReposByCriteria(RepoManagerBeanTest.this.overlord, byName);
                assert (reposWithOldName.size() == 0);
            }
        });
    }

    @Test(enabled=true)
    public void updateSyncSchedule() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Repo repo = new Repo("updateSyncSchedule");
                repo.setSyncSchedule("NOT A VALID CRON");
                boolean failed = false;
                try {
                    repo = RepoManagerBeanTest.this.repoManager.createRepo(RepoManagerBeanTest.this.overlord, repo);
                }
                catch (RepoException e) {
                    failed = true;
                }
                assert (failed);
                failed = false;
                repo.setSyncSchedule("0 0 3 * * ?");
                try {
                    repo = RepoManagerBeanTest.this.repoManager.createRepo(RepoManagerBeanTest.this.overlord, repo);
                }
                catch (RepoException e) {
                    failed = true;
                }
                assert (!failed);
            }
        });
    }
}

