/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content.test;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.TransactionManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.core.domain.content.ContentSyncStatus;
import org.rhq.core.domain.content.Distribution;
import org.rhq.core.domain.content.DistributionFile;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoDistribution;
import org.rhq.core.domain.content.RepoSyncResults;
import org.rhq.enterprise.server.content.ContentManagerHelper;
import org.rhq.enterprise.server.plugin.pc.content.ContentServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.content.TestContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.TestContentServerPluginService;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

public class RepoSyncingTest
extends AbstractEJB3Test {
    private static final boolean ENABLED = false;
    private Repo repo;
    private ContentSource contentSource;
    private TestContentServerPluginService pluginService;
    TestContentProvider p1;

    @Override
    protected void beforeMethod() throws Exception {
        TransactionManager tx = this.getTransactionManager();
        tx.begin();
        this.pluginService = new TestContentServerPluginService(this);
        ContentSourceType type = new ContentSourceType("testGetSyncResultsListCST");
        this.em.persist((Object)type);
        this.em.flush();
        this.contentSource = new ContentSource("testGetSyncResultsListCS", type);
        this.em.persist((Object)this.contentSource);
        this.em.flush();
        this.repo = new Repo("testRepoImportedExisting");
        this.p1 = new TestContentProvider();
        this.pluginService.associateContentProvider(this.contentSource, this.p1);
        this.repo.addContentSource(this.contentSource);
        this.em.persist((Object)this.repo);
        this.em.flush();
    }

    @Override
    protected void afterMethod() throws Exception {
        this.unprepareServerPluginService();
        this.getTransactionManager().begin();
        EntityManager em = this.getEntityManager();
        ContentSource deleteSrc = (ContentSource)em.find(ContentSource.class, (Object)this.contentSource.getId());
        em.remove((Object)deleteSrc);
        Query q = em.createNamedQuery("RepoDistribution.queryFindByRepoId");
        q.setParameter("repoId", (Object)this.repo.getId());
        List rds = q.getResultList();
        for (RepoDistribution rd : rds) {
            Distribution d = rd.getRepoDistributionPK().getDistribution();
            List dfiles = LookupUtil.getDistributionManagerLocal().getDistributionFilesByDistId(d.getId());
            for (DistributionFile df : dfiles) {
                DistributionFile dfl = (DistributionFile)em.find(DistributionFile.class, (Object)df.getId());
                em.remove((Object)dfl);
            }
            em.remove((Object)rd);
            em.remove((Object)d);
        }
        Repo delRepo = (Repo)em.find(Repo.class, (Object)this.repo.getId());
        em.remove((Object)delRepo);
        TransactionManager tx = this.getTransactionManager();
        if (tx != null) {
            tx.commit();
        }
    }

    @Test(enabled=false)
    public void testSyncResults() throws Exception {
        this.getTransactionManager().commit();
        boolean synced = this.pluginService.getContentProviderManager().synchronizeRepo(this.repo.getId());
        RepoSyncResults results = this.getSyncResults(this.repo.getId());
        System.out.println("results : " + results.getResults());
        assert (results.getResults().indexOf("MERGE COMPLETE.") > 0);
        assert (results.getPercentComplete().equals(new Long(100L)));
    }

    @Test(enabled=false)
    public void testMultipleSyncResults() throws Exception {
        this.getTransactionManager().commit();
        this.pluginService.getContentProviderManager().synchronizeRepo(this.repo.getId());
        this.pluginService.getContentProviderManager().synchronizeRepo(this.repo.getId());
        this.em.refresh((Object)this.repo);
        Query q = this.em.createNamedQuery("RepoSyncResults.getAllByRepoId");
        q.setParameter("repoId", (Object)this.repo.getId());
        List rlist = q.getResultList();
        RepoSyncResults r1 = (RepoSyncResults)rlist.get(0);
        RepoSyncResults r2 = (RepoSyncResults)rlist.get(1);
        assert (r1.getId() > r2.getId());
        rlist = this.repo.getSyncResults();
        r1 = (RepoSyncResults)rlist.get(0);
        r2 = (RepoSyncResults)rlist.get(1);
        assert (r1.getId() > r2.getId());
    }

    @Test(enabled=false)
    public void testSyncRepos() throws Exception {
        this.p1.setLongRunningSynchSleep(5000);
        assert (this.repo.getContentSources().size() == 1);
        this.getTransactionManager().commit();
        RepoSyncResults results = this.getSyncResults(this.repo.getId());
        assert (results == null);
        System.out.println("Starting sync: " + this.repo.getId());
        SyncerThread st = new SyncerThread();
        st.start();
        boolean gotPackageBits = false;
        boolean gotResults = false;
        for (int i = 0; i < 300 && !st.isSynced() && !st.isErrored(); ++i) {
            results = this.getSyncResults(this.repo.getId());
            if (results != null) {
                if (results.getStatus() == ContentSyncStatus.PACKAGEMETADATA) {
                    gotPackageBits = true;
                }
                if (results.getResults() != null) {
                    gotResults = true;
                }
            }
            Thread.sleep(1000L);
        }
        System.out.println("Finished sync");
        assert (gotPackageBits);
        assert (gotResults);
        assert (st.isSynced());
        results = this.getSyncResults(this.repo.getId());
        assert (results != null);
        assert (results.getStatus() == ContentSyncStatus.SUCCESS);
        assert (results.getResults() != null);
        assert (results.getResults().indexOf("MERGE COMPLETE.") > 0);
        results = LookupUtil.getRepoManagerLocal().getMostRecentSyncResults(LookupUtil.getSubjectManager().getOverlord(), this.repo.getId());
        assert (results != null);
    }

    @Test(enabled=false)
    public void testSyncCount() throws Exception {
        int[] ids = new int[]{this.repo.getId()};
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        this.getTransactionManager().commit();
        int syncCount = LookupUtil.getRepoManagerLocal().synchronizeRepos(overlord, ids);
        assert (syncCount == 1);
    }

    @Test(enabled=false)
    public void testCancelSync() throws Exception {
        this.getTransactionManager().commit();
        this.p1 = new TestContentProvider();
        this.p1.setLongRunningSynchSleep(10000);
        this.pluginService.associateContentProvider(this.contentSource, this.p1);
        this.prepareScheduler();
        ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
        pc.syncRepoNow(this.repo);
        for (int i = 0; i < 10; ++i) {
            RepoSyncResults res = this.getSyncResults(this.repo.getId());
            if (res != null) {
                System.out.println("status: [" + res.getStatus() + "] CTRL+C to exit");
                if (res.getStatus() == ContentSyncStatus.CANCELLED) {
                    break;
                }
            } else {
                System.out.println("CTRL+C to exit");
            }
            Thread.sleep(1000L);
            if (i != 5) continue;
            pc.cancelRepoSync(LookupUtil.getSubjectManager().getOverlord(), this.repo);
        }
        RepoSyncResults res = this.getSyncResults(this.repo.getId());
        assert (res != null);
        assert (res.getStatus() == ContentSyncStatus.CANCELLED);
        this.unprepareScheduler();
    }

    private RepoSyncResults getSyncResults(int repoId) {
        Query q = this.em.createNamedQuery("RepoSyncResults.getAllByRepoId");
        q.setParameter("repoId", (Object)repoId);
        List rlist = q.getResultList();
        if (rlist != null && rlist.size() > 0) {
            assert (rlist.size() == 1);
            RepoSyncResults retval = (RepoSyncResults)rlist.get(0);
            this.em.refresh((Object)retval);
            return (RepoSyncResults)rlist.get(0);
        }
        return null;
    }

    class SyncerThread
    extends Thread {
        boolean synced = false;
        boolean errored = false;

        SyncerThread() {
        }

        public boolean isErrored() {
            return this.errored;
        }

        @Override
        public void run() {
            try {
                TransactionManager tx = RepoSyncingTest.this.getTransactionManager();
                tx.begin();
                System.out.println("SyncerThread :: Starting sync");
                this.synced = RepoSyncingTest.this.pluginService.getContentProviderManager().synchronizeRepo(RepoSyncingTest.this.repo.getId());
                System.out.println("SyncerThread :: Finished sync : " + this.synced);
                tx.commit();
            }
            catch (Exception e) {
                this.errored = true;
                throw new RuntimeException(e);
            }
        }

        public boolean isSynced() {
            return this.synced;
        }
    }
}

