/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.persistence.Query;
import org.rhq.core.clientapi.server.core.AgentRegistrationException;
import org.rhq.core.clientapi.server.core.AgentRegistrationRequest;
import org.rhq.core.clientapi.server.core.AgentRegistrationResults;
import org.rhq.core.clientapi.server.core.AgentVersion;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.common.ProductInfo;
import org.rhq.core.domain.install.remote.AgentInstall;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.core.CoreServerMBean;
import org.rhq.enterprise.server.core.CoreServerServiceImpl;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

@Test(groups={"core.agent.registration"})
public class CoreServerServiceImplTest
extends AbstractEJB3Test {
    private static final String TEST_AGENT_NAME_PREFIX = "CoreServerServiceImplTest.Agent";
    private AgentVersion agentVersion;
    private Server server;
    private static final int A_PORT = 11111;
    private static final String A_HOST = "hostA";
    private static final int B_PORT = 22222;
    private static final String B_HOST = "hostB";
    private static final String VERSION = "1.2.3";
    private static final String BUILD = "12345";
    private static final String AGENT_VERSION = "rhq-agent.latest.version";
    private static final String AGENT_BUILD = "rhq-agent.latest.build-number";
    private static final String AGENT_MD5 = "rhq-agent.latest.md5";
    private static final String SERVER_AGENT_PROPERTIES = "rhq-server-agent-versions.properties";
    private static final String AGENT_UPDATE_PROPERTIES = "rhq-agent-update-version.properties";
    private static final String DOWNLOADS_AGENT = "rhq-downloads/rhq-agent";

    @Test(priority=-10)
    public void beforeClassStandIn() throws Exception {
        this.deleteObjects("a.obj");
        this.deleteObjects("b.obj");
    }

    @Test(priority=10, dependsOnMethods={"testNormalAgentRegistration"}, alwaysRun=true)
    public void afterClassStandIn() throws Exception {
        this.deleteObjects("a.obj");
        this.deleteObjects("b.obj");
        Query q = this.getEntityManager().createQuery("select a from Agent a where name like 'CoreServerServiceImplTest.Agent%'");
        List doomed = q.getResultList();
        for (Agent deleteMe : doomed) {
            LookupUtil.getAgentManager().deleteAgent(deleteMe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeMethod() throws Exception {
        this.setServerIdentity("CoreServerServiceImplTest.Server");
        DummyCoreServer mbean = new DummyCoreServer();
        this.prepareCustomServerService((Object)mbean, CoreServerMBean.OBJECT_NAME);
        this.agentVersion = new AgentVersion(VERSION, BUILD);
        File agentVersionFile = new File(mbean.getJBossServerDataDir(), "rhq-downloads/rhq-agent/rhq-server-agent-versions.properties");
        agentVersionFile.getParentFile().mkdirs();
        agentVersionFile.delete();
        Properties agentVersionProps = new Properties();
        agentVersionProps.put(AGENT_VERSION, this.agentVersion.getVersion());
        agentVersionProps.put(AGENT_BUILD, this.agentVersion.getBuild());
        FileOutputStream fos = new FileOutputStream(agentVersionFile);
        try {
            agentVersionProps.store(fos, "This file was created by " + CoreServerServiceImplTest.class.getName());
        }
        finally {
            fos.close();
        }
        File testLocation = new File(this.getTempDir(), ((Object)((Object)this)).getClass().getSimpleName());
        File serverVersionFile = new File(testLocation, "rhq-downloads/rhq-agent/rhq-server-agent-versions.properties");
        File agentPropertiesFile = new File(testLocation, "rhq-downloads/rhq-agent/rhq-agent-update-version.properties");
        FileInputStream fin = new FileInputStream(serverVersionFile);
        FileOutputStream fout = new FileOutputStream(agentPropertiesFile);
        StreamUtil.copy((InputStream)fin, (OutputStream)fout, (boolean)true);
        File agentBinaryFile = new File(testLocation, "rhq-downloads/rhq-agent/agent.jar");
        this.buildFakeAgentJar(agentVersionFile, agentBinaryFile);
        agentBinaryFile.setLastModified(System.currentTimeMillis() - 600000L);
        this.prepareForTestAgents();
        this.server = new Server();
        this.server.setName(this.getServerIdentity());
        this.server.setAddress("CoreServerServiceImplTest.localhost");
        this.server.setPort(12345);
        this.server.setSecurePort(12346);
        this.server.setOperationMode(Server.OperationMode.NORMAL);
        int serverId = LookupUtil.getServerManager().create(this.server);
        this.server.setId(serverId);
    }

    @Override
    protected void afterMethod() throws Exception {
        LookupUtil.getTopologyManager().updateServerMode(LookupUtil.getSubjectManager().getOverlord(), new Integer[]{this.server.getId()}, Server.OperationMode.DOWN);
        LookupUtil.getTopologyManager().deleteServer(LookupUtil.getSubjectManager().getOverlord(), Integer.valueOf(this.server.getId()));
        this.unprepareCustomServerService(CoreServerMBean.OBJECT_NAME);
        this.unprepareForTestAgents();
    }

    @Test
    public void testNewAgentRegistrationWithOldToken() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        AgentRegistrationRequest request = this.createRequest(this.prefixName("old"), "hostOld", 12345, "oldtoken");
        AgentRegistrationResults results = service.registerAgent(request);
        assert (results != null) : "cannot re-register an old agent";
        Agent agent = LookupUtil.getAgentManager().getAgentByAgentToken(results.getAgentToken());
        assert (agent.getName().equals(request.getName()));
        assert (agent.getAddress().equals(request.getAddress()));
        assert (agent.getPort() == request.getPort());
        LookupUtil.getAgentManager().deleteAgent(agent);
    }

    @Test
    public void testChangeAddressPort() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        String tuid = "" + new Random().nextInt();
        String zName = this.prefixName("Z-" + tuid);
        AgentRegistrationRequest request = this.createRequest(zName, "hostZ", 55550, null);
        AgentRegistrationResults results = service.registerAgent(request);
        assert (results != null) : "got null results";
        request = this.createRequest(zName, "hostZprime", 55550, results.getAgentToken());
        results = service.registerAgent(request);
        assert (results != null);
        Agent agent = LookupUtil.getAgentManager().getAgentByAgentToken(results.getAgentToken());
        assert (agent.getName().equals(zName));
        assert (agent.getAddress().equals("hostZprime"));
        assert (agent.getPort() == 55550);
        request = this.createRequest(zName, "hostZprime", 55551, results.getAgentToken());
        results = service.registerAgent(request);
        assert (results != null);
        agent = LookupUtil.getAgentManager().getAgentByAgentToken(results.getAgentToken());
        assert (agent.getName().equals(zName));
        assert (agent.getAddress().equals("hostZprime"));
        assert (agent.getPort() == 55551);
        request = this.createRequest(zName, "hostZdoubleprime" + tuid, 55552, results.getAgentToken());
        results = service.registerAgent(request);
        assert (results != null);
        agent = LookupUtil.getAgentManager().getAgentByAgentToken(results.getAgentToken());
        assert (agent.getName().equals(zName));
        assert (agent.getAddress().equals("hostZdoubleprime" + tuid));
        assert (agent.getPort() == 55552);
        request = this.createRequest(zName, "hostZdoubleprime" + tuid, 55552, results.getAgentToken());
        results = service.registerAgent(request);
        assert (results != null);
        agent = LookupUtil.getAgentManager().getAgentByAgentToken(results.getAgentToken());
        assert (agent.getName().equals(zName));
        assert (agent.getAddress().equals("hostZdoubleprime" + tuid));
        assert (agent.getPort() == 55552);
        AgentRegistrationRequest zReq = request;
        AgentRegistrationResults zResults = results;
        this.writeObjects("b.obj", zReq, zResults);
        request = this.createRequest(zName, B_HOST, zReq.getPort(), null);
        try {
            service.registerAgent(request);
            assert (false) : "(1) Should not have been able to register without a token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(zName, zReq.getAddress(), 22222, null);
        try {
            service.registerAgent(request);
            assert (false) : "(2) Should not have been able to register without a token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(zName, B_HOST, 22222, null);
        try {
            service.registerAgent(request);
            assert (false) : "(3) Should not have been able to register without a token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(zName, zReq.getAddress(), zReq.getPort(), null);
        try {
            service.registerAgent(request);
            assert (false) : "(4) Should not have been able to register without a token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
    }

    @Test(dependsOnMethods={"testChangeAddressPort"})
    public void testNormalAgentRegistration() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        AgentRegistrationRequest aReq = this.createRequest(this.prefixName("A"), A_HOST, 11111, null);
        AgentRegistrationResults aResults = service.registerAgent(aReq);
        assert (aResults != null) : "got null results";
        this.writeObjects("a.obj", aReq, aResults);
    }

    @Test(dependsOnMethods={"testNormalAgentRegistration"})
    public void testHijackExistingAgentAddressPort() throws Exception {
        List<Object> objs = this.readObjects("a.obj", 1);
        AgentRegistrationRequest aReq = (AgentRegistrationRequest)objs.get(0);
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        AgentRegistrationRequest request = this.createRequest(this.prefixName("B"), aReq.getAddress(), aReq.getPort(), null);
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used host/port with new agent name";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
    }

    @Test(dependsOnMethods={"testNormalAgentRegistration"})
    public void testHijackExistingAgentName() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        List<Object> objs = this.readObjects("a.obj", 1);
        AgentRegistrationRequest aReq = (AgentRegistrationRequest)objs.get(0);
        AgentRegistrationRequest request = this.createRequest(aReq.getName(), aReq.getAddress(), 22222, null);
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used agent name without a token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(aReq.getName(), B_HOST, aReq.getPort(), null);
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used agent name without a token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(aReq.getName(), B_HOST, 22222, null);
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used agent name without a token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
    }

    @Test(dependsOnMethods={"testNormalAgentRegistration"})
    public void testHijackExistingAgentAddressPortWithBogusToken() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        List<Object> objs = this.readObjects("a.obj", 1);
        AgentRegistrationRequest aReq = (AgentRegistrationRequest)objs.get(0);
        AgentRegistrationRequest request = this.createRequest(this.prefixName("B"), aReq.getAddress(), aReq.getPort(), "badtoken");
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used host/port with new agent name and invalid token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
    }

    @Test(dependsOnMethods={"testNormalAgentRegistration"})
    public void testHijackExistingAgentNameWithBogusToken() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        List<Object> objs = this.readObjects("a.obj", 1);
        AgentRegistrationRequest aReq = (AgentRegistrationRequest)objs.get(0);
        AgentRegistrationRequest request = this.createRequest(aReq.getName(), aReq.getAddress(), aReq.getPort(), "badtoken");
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used agent name with an invalid token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(aReq.getName(), aReq.getAddress(), 22222, "badtoken");
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used agent name with an invalid token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(aReq.getName(), B_HOST, aReq.getPort(), "badtoken");
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used agent name with an invalid token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(aReq.getName(), B_HOST, 22222, "badtoken");
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack a used agent name with an invalid token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
    }

    @Test(dependsOnMethods={"testNormalAgentRegistration"})
    public void testHijackExistingAgentNameWithAnotherAgentToken() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        List<Object> objs = this.readObjects("a.obj", 1);
        AgentRegistrationRequest aReq = (AgentRegistrationRequest)objs.get(0);
        objs = this.readObjects("b.obj", 2);
        AgentRegistrationRequest zReq = (AgentRegistrationRequest)objs.get(0);
        AgentRegistrationResults zResults = (AgentRegistrationResults)objs.get(1);
        AgentRegistrationRequest request = this.createRequest(aReq.getName(), aReq.getAddress(), aReq.getPort(), zResults.getAgentToken());
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack agent A using Z's token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(aReq.getName(), B_HOST, aReq.getPort(), zResults.getAgentToken());
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack agent A using Z's token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(aReq.getName(), aReq.getAddress(), 22222, zResults.getAgentToken());
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack agent A using Z's token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
        request = this.createRequest(aReq.getName(), B_HOST, 22222, zResults.getAgentToken());
        try {
            service.registerAgent(request);
            assert (false) : "Should not have been able to hijack agent A using Z's token";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
    }

    @Test(dependsOnMethods={"testNormalAgentRegistration"})
    public void testAgentHijackingAnotherAgentAddressPort() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        List<Object> objs = this.readObjects("a.obj", 2);
        AgentRegistrationRequest aReq = (AgentRegistrationRequest)objs.get(0);
        AgentRegistrationResults aResults = (AgentRegistrationResults)objs.get(1);
        objs = this.readObjects("b.obj", 1);
        AgentRegistrationRequest zReq = (AgentRegistrationRequest)objs.get(0);
        AgentRegistrationRequest request = this.createRequest(aReq.getName(), zReq.getAddress(), zReq.getPort(), aResults.getAgentToken());
        try {
            service.registerAgent(request);
            assert (false) : "An agent should not have been able to hijack another agent's host/port";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
    }

    @Test(dependsOnMethods={"testNormalAgentRegistration"})
    public void testAttemptToChangeAgentName() throws Exception {
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        List<Object> objs = this.readObjects("b.obj", 2);
        AgentRegistrationRequest zReq = (AgentRegistrationRequest)objs.get(0);
        AgentRegistrationResults zResults = (AgentRegistrationResults)objs.get(1);
        AgentRegistrationRequest request = this.createRequest(this.prefixName("newName"), zReq.getAddress(), zReq.getPort(), zResults.getAgentToken());
        try {
            service.registerAgent(request);
            assert (false) : "An agent should not be able to change its name";
        }
        catch (AgentRegistrationException ok) {
            this.debugPrintThrowable(ok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAgentUpateVersionFile() {
        AgentManagerLocal agentManager = LookupUtil.getAgentManager();
        String AGENT_VERSION = AGENT_VERSION;
        String AGENT_BUILD = AGENT_BUILD;
        String RHQ_AGENT_LATEST_MD5 = AGENT_MD5;
        String version = VERSION;
        String build = BUILD;
        try {
            File updateFile = agentManager.getAgentUpdateVersionFile();
            assert (updateFile != null) : "GetAgentUpdateVersionFile returned null.";
            Properties props = new Properties();
            FileInputStream inStream = new FileInputStream(updateFile);
            try {
                props.load(inStream);
            }
            finally {
                inStream.close();
            }
            boolean locatedAgentVersion = false;
            boolean locatedAgentBuild = false;
            for (Object property : props.keySet()) {
                if (property.toString().equals(AGENT_VERSION)) {
                    locatedAgentVersion = true;
                    continue;
                }
                if (!property.toString().equals(AGENT_BUILD)) continue;
                locatedAgentBuild = true;
            }
            assert (locatedAgentVersion) : AGENT_VERSION + " was not found.";
            assert (locatedAgentBuild) : AGENT_BUILD + " was not found.";
            File testLocation = new File(this.getTempDir(), "CoreServerServiceImplTest");
            File serverVersionFile = new File(testLocation, "rhq-downloads/rhq-agent/rhq-server-agent-versions.properties");
            File agentVersionFile = new File(testLocation, "rhq-downloads/rhq-agent/rhq-agent-update-version.properties");
            FileInputStream fin = new FileInputStream(serverVersionFile);
            FileOutputStream fout = new FileOutputStream(agentVersionFile);
            StreamUtil.copy((InputStream)fin, (OutputStream)fout, (boolean)true);
            serverVersionFile.delete();
            assert (!serverVersionFile.exists()) : "The default test file location still exists. Unable to proceed.";
            assert (agentVersionFile.exists()) : "The agent properties file was not created. Unable to proceed.";
            DummyCoreServerTweaked mbean = new DummyCoreServerTweaked(version, build);
            this.prepareCustomServerService((Object)mbean, CoreServerMBean.OBJECT_NAME);
            File agentBinaryFile = new File(testLocation, "rhq-downloads/rhq-agent/agent.jar");
            assert (agentBinaryFile.exists()) : "A fake agent binary file should already exist.";
            assert (agentBinaryFile.delete()) : "Unable to delete default binary file.";
            this.buildFakeAgentJar(agentVersionFile, agentBinaryFile);
            assert (agentBinaryFile.exists()) : "Failed to build fake agent file:" + agentBinaryFile.getCanonicalPath();
            updateFile = agentManager.getAgentUpdateVersionFile();
            props = new Properties();
            inStream = new FileInputStream(updateFile);
            try {
                props.load(inStream);
            }
            finally {
                inStream.close();
            }
            locatedAgentVersion = false;
            locatedAgentBuild = false;
            for (Object property : props.keySet()) {
                if (property.toString().equals(AGENT_VERSION)) {
                    locatedAgentVersion = true;
                    continue;
                }
                if (!property.toString().equals(AGENT_BUILD)) continue;
                locatedAgentBuild = true;
            }
            assert (locatedAgentVersion) : AGENT_VERSION + " was not found.";
            assert (props.getProperty(AGENT_VERSION).equals(version)) : "Version field did not match. Expected '" + version + "' but got '" + props.getProperty(AGENT_VERSION) + "'.";
            assert (locatedAgentBuild) : AGENT_BUILD + " was not found.";
            assert (props.getProperty(AGENT_BUILD).equals(build)) : "Version field did not match. Expected '" + version + "' but got '" + props.getProperty(AGENT_BUILD) + "'.";
            assert (props.getProperty(RHQ_AGENT_LATEST_MD5) != null) : "MD5 value not located.";
            assert (props.getProperty(RHQ_AGENT_LATEST_MD5).trim().length() > 0) : "No checksum value was located.";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testLinkAgentWithAgentInstall() throws Exception {
        AgentManagerLocal agentManager = LookupUtil.getAgentManager();
        SubjectManagerLocal sm = LookupUtil.getSubjectManager();
        AgentInstall persistedAgentInstall = agentManager.getAgentInstallByAgentName(sm.getOverlord(), "should-not-exist");
        assert (persistedAgentInstall == null);
        AgentInstall agentInstall = new AgentInstall();
        agentInstall.setSshHost("CoreServerServiceImpl-SshHost");
        agentInstall.setSshPort(Integer.valueOf(44));
        agentInstall.setSshUsername("CoreServerServiceImpl-SshUsername");
        agentInstall.setSshPassword("CoreServerServiceImpl-SshPassword");
        agentInstall = agentManager.updateAgentInstall(sm.getOverlord(), agentInstall);
        assert (agentInstall.getId() > 0) : "didn't persist properly - ID should be non-zero";
        assert (agentInstall.getAgentName() == null) : "there should be no agent name yet";
        assert (agentInstall.getInstallLocation() == null) : "there should be no install location yet";
        CoreServerServiceImpl service = new CoreServerServiceImpl();
        AgentRegistrationRequest aReq = this.createRequest(this.prefixName(".AgentInstall"), A_HOST, 11111, null, String.valueOf(agentInstall.getId()), "/tmp/CoreServerServiceImplTest/rhq-agent");
        AgentRegistrationResults aResults = service.registerAgent(aReq);
        assert (aResults != null) : "got null results";
        persistedAgentInstall = agentManager.getAgentInstallByAgentName(sm.getOverlord(), aReq.getName());
        assert (persistedAgentInstall != null) : "the new agent info is missing";
        assert (persistedAgentInstall.getAgentName().equals(aReq.getName()));
        assert (persistedAgentInstall.getInstallLocation().equals("/tmp/CoreServerServiceImplTest/rhq-agent"));
        assert (persistedAgentInstall.getSshHost().equals("CoreServerServiceImpl-SshHost"));
        assert (persistedAgentInstall.getSshPort().equals(44));
        assert (persistedAgentInstall.getSshUsername().equals("CoreServerServiceImpl-SshUsername"));
        assert (persistedAgentInstall.getSshPassword().equals("CoreServerServiceImpl-SshPassword"));
        Agent doomed = agentManager.getAgentByName(aReq.getName());
        agentManager.deleteAgent(doomed);
        persistedAgentInstall = agentManager.getAgentInstallByAgentName(sm.getOverlord(), aReq.getName());
        assert (persistedAgentInstall == null) : "the agent info should have been deleted";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildFakeAgentJar(File binaryContents, File agentBinaryFile) throws FileNotFoundException, IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "54321");
        JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(agentBinaryFile), manifest);
        BufferedInputStream in = null;
        try {
            int count;
            JarEntry entry = new JarEntry(binaryContents.getName());
            entry.setTime(binaryContents.lastModified());
            target.putNextEntry(entry);
            in = new BufferedInputStream(new FileInputStream(binaryContents));
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
            target.closeEntry();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        target.close();
    }

    private AgentRegistrationRequest createRequest(String name, String address, int port, String token) {
        return this.createRequest(name, address, port, token, BUILD, "/tmp/CoreServerServiceImplTest/rhq-agent");
    }

    private AgentRegistrationRequest createRequest(String name, String address, int port, String token, String installId, String installLocation) {
        return new AgentRegistrationRequest(name, address, port, "socket://" + address + ":" + port + "/?rhq.communications.connector.rhqtype=agent", true, token, this.agentVersion, installId, installLocation);
    }

    private String prefixName(String name) {
        return TEST_AGENT_NAME_PREFIX + name;
    }

    private void debugPrintThrowable(Throwable t) {
        System.out.println(ThrowableUtil.getAllMessages((Throwable)t));
    }

    class DummyCoreServer
    implements DummyCoreServerMBean {
        DummyCoreServer() {
        }

        public String getVersion() {
            return null;
        }

        public String getBuildNumber() {
            return null;
        }

        public Date getBootTime() {
            return null;
        }

        public File getInstallDir() {
            return null;
        }

        public File getJBossServerHomeDir() {
            return new File(CoreServerServiceImplTest.this.getTempDir(), "CoreServerServiceImplTest");
        }

        public File getJBossServerDataDir() {
            return new File(CoreServerServiceImplTest.this.getTempDir(), "CoreServerServiceImplTest");
        }

        public File getJBossServerTempDir() {
            return new File(CoreServerServiceImplTest.this.getTempDir(), "CoreServerServiceImplTest");
        }

        public File getEarDeploymentDir() {
            return new File(CoreServerServiceImplTest.this.getTempDir(), "CoreServerServiceImplTest");
        }

        public ProductInfo getProductInfo() {
            return null;
        }
    }

    static interface DummyCoreServerMBean
    extends CoreServerMBean {
    }

    private class DummyCoreServerTweaked
    extends DummyCoreServer {
        private String version;
        private String build;

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getBuildNumber() {
            return this.build;
        }

        public DummyCoreServerTweaked(String version, String build) {
            this.version = version;
            this.build = build;
        }
    }
}

