/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.transaction.TransactionManager;
import org.rhq.core.clientapi.descriptor.AgentPluginDescriptorUtil;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.core.plugin.PluginDeploymentScanner;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

public class DatabaseAndFilePluginDeploymentTest
extends AbstractEJB3Test {
    private static final String PLUGIN_NAME = "DeployTest";
    private static final String DESCRIPTORS_LOCATION = "test/deployment/";
    private static final String TEST_DIR = tmpdirRoot + "/" + DatabaseAndFilePluginDeploymentTest.class.getName() + "/";
    private static final String JARS_LOCATION = TEST_DIR + "jars";
    private static final String DEPLOY_LOCATION = TEST_DIR + "deploy";
    private static final String TESTPLUGIN_1_0_FEB = "1.0-feb";
    private static final String TESTPLUGIN_1_0_JUN = "1.0-june";
    private static final String TESTPLUGIN_1_1_FEB = "1.1-feb";
    private static final String TESTPLUGIN_1_1_JUN = "1.1-june";
    private static final String TESTPLUGIN_1_0_FEB2 = "1.0-feb-2";
    private final Map<String, File> testPluginFiles = new HashMap<String, File>();
    private final Map<String, Plugin> testPlugins = new HashMap<String, Plugin>();
    private final Map<String, Date> testTimestamps = new HashMap<String, Date>();
    private final Map<String, PluginDescriptor> testPluginDescriptors = new HashMap<String, PluginDescriptor>();
    private PluginManagerLocal pluginMgr;
    private SubjectManagerLocal subjectManager;

    private void beforeClass() throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.set(2009, 1, 1, 1, 0, 0);
        cal.set(14, 0);
        Date febDate = cal.getTime();
        cal.set(2009, 5, 1, 1, 0, 0);
        cal.set(14, 0);
        Date juneDate = cal.getTime();
        this.testTimestamps.put(TESTPLUGIN_1_0_FEB, febDate);
        this.testTimestamps.put(TESTPLUGIN_1_0_JUN, juneDate);
        this.testTimestamps.put(TESTPLUGIN_1_1_FEB, febDate);
        this.testTimestamps.put(TESTPLUGIN_1_1_JUN, juneDate);
        this.testTimestamps.put(TESTPLUGIN_1_0_FEB2, febDate);
        this.pluginMgr = LookupUtil.getPluginManager();
        this.subjectManager = LookupUtil.getSubjectManager();
        File deployDir = new File(DEPLOY_LOCATION);
        deployDir.mkdirs();
        assert (deployDir.isDirectory());
        File jarsDir = new File(JARS_LOCATION);
        jarsDir.mkdirs();
        assert (jarsDir.isDirectory());
        this.testPluginFiles.put(TESTPLUGIN_1_0_FEB, new File(jarsDir, "1.0-feb.jar"));
        this.testPluginFiles.put(TESTPLUGIN_1_0_JUN, new File(jarsDir, "1.0-june.jar"));
        this.testPluginFiles.put(TESTPLUGIN_1_1_FEB, new File(jarsDir, "1.1-feb.jar"));
        this.testPluginFiles.put(TESTPLUGIN_1_1_JUN, new File(jarsDir, "1.1-june.jar"));
        this.testPluginFiles.put(TESTPLUGIN_1_0_FEB2, new File(jarsDir, "1.0-feb-2.jar"));
        for (Map.Entry<String, File> entry : this.testPluginFiles.entrySet()) {
            String descriptor = DESCRIPTORS_LOCATION + entry.getKey() + ".xml";
            File file = entry.getValue();
            this.buildPluginJar(descriptor, file);
            assert (file.exists());
            PluginDescriptor pluginDescriptor = AgentPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)file.toURI().toURL());
            this.testPluginDescriptors.put(entry.getKey(), pluginDescriptor);
            Plugin pluginPojo = new Plugin(PLUGIN_NAME, file.getName());
            pluginPojo.setVersion(pluginDescriptor.getVersion());
            pluginPojo.setMd5(MessageDigestGenerator.getDigestString((File)file));
            pluginPojo.setMtime(this.testTimestamps.get(entry.getKey()).getTime());
            this.testPlugins.put(entry.getKey(), pluginPojo);
        }
    }

    @Test(priority=10, alwaysRun=true)
    public void afterClassStandIn() throws Exception {
        File jarsDir = new File(JARS_LOCATION);
        jarsDir.delete();
        File deployDir = new File(DEPLOY_LOCATION);
        this.emptyDirectory(deployDir);
        deployDir.delete();
    }

    @Override
    protected void beforeMethod() throws Exception {
        this.beforeClass();
        this.afterMethod();
        File deployDir = new File(DEPLOY_LOCATION);
        deployDir.mkdirs();
        assert (deployDir.isDirectory());
        File jarsDir = new File(JARS_LOCATION);
        jarsDir.mkdirs();
        assert (jarsDir.isDirectory());
        for (Map.Entry<String, File> entry : this.testPluginFiles.entrySet()) {
            String descriptor = DESCRIPTORS_LOCATION + entry.getKey() + ".xml";
            File file = entry.getValue();
            this.buildPluginJar(descriptor, file);
            assert (file.exists());
            PluginDescriptor pluginDescriptor = AgentPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)file.toURI().toURL());
            this.testPluginDescriptors.put(entry.getKey(), pluginDescriptor);
            Plugin pluginPojo = new Plugin(PLUGIN_NAME, file.getName());
            pluginPojo.setVersion(pluginDescriptor.getVersion());
            pluginPojo.setMd5(MessageDigestGenerator.getDigestString((File)file));
            pluginPojo.setMtime(this.testTimestamps.get(entry.getKey()).getTime());
            this.testPlugins.put(entry.getKey(), pluginPojo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterMethod() throws Exception {
        this.emptyDirectory(new File(DEPLOY_LOCATION));
        TransactionManager tm = this.getTransactionManager();
        tm.begin();
        try {
            Query q = this.em.createNamedQuery("Plugin.findByName");
            q.setParameter("name", (Object)PLUGIN_NAME);
            List doomedPlugins = q.getResultList();
            for (Plugin doomedPlugin : doomedPlugins) {
                this.em.remove(this.em.find(Plugin.class, (Object)doomedPlugin.getId()));
            }
        }
        catch (NoResultException noResultException) {
        }
        finally {
            tm.commit();
        }
    }

    public void test0() throws Exception {
        Plugin plugin10feb = this.deployPluginJarToFilesystem(TESTPLUGIN_1_0_FEB);
        this.deployPluginJarToDatabase(TESTPLUGIN_1_0_FEB);
        this.createScannerAndScan(TESTPLUGIN_1_0_FEB);
        this.assertPluginInDb(plugin10feb);
        this.assertPluginOnFilesystem(plugin10feb);
    }

    public void test1() throws Exception {
        Plugin plugin10feb = this.deployPluginJarToFilesystem(TESTPLUGIN_1_0_FEB);
        this.createScannerAndScan(TESTPLUGIN_1_0_FEB);
        this.assertPluginInDb(plugin10feb);
        this.assertPluginOnFilesystem(plugin10feb);
    }

    public void test2() throws Exception {
        Plugin plugin10feb = this.deployPluginJarToDatabase(TESTPLUGIN_1_0_FEB);
        PluginDeploymentScanner scanner = this.createScanner();
        this.scan(scanner, null);
        this.assertPluginInDb(plugin10feb);
        this.assertPluginOnFilesystem(plugin10feb);
        this.scan(null, TESTPLUGIN_1_0_FEB);
        this.assertPluginInDb(plugin10feb);
        this.assertPluginOnFilesystem(plugin10feb);
    }

    public void test3() throws Exception {
        Plugin plugin10jun = this.deployPluginJarToFilesystem(TESTPLUGIN_1_0_JUN);
        this.deployPluginJarToDatabase(TESTPLUGIN_1_0_FEB);
        this.createScannerAndScan(TESTPLUGIN_1_0_JUN);
        this.assertPluginInDb(plugin10jun);
        this.assertPluginOnFilesystem(plugin10jun);
    }

    public void test4() throws Exception {
        Plugin plugin10feb = this.deployPluginJarToFilesystem(TESTPLUGIN_1_0_FEB);
        Plugin plugin10jun = this.deployPluginJarToDatabase(TESTPLUGIN_1_0_JUN);
        this.createScannerAndScan(null);
        this.assertPluginInDb(plugin10jun);
        this.assertPluginOnFilesystem(plugin10jun);
        this.assertPluginNotOnFilesystem(plugin10feb);
        this.scan(null, TESTPLUGIN_1_0_JUN);
        this.assertPluginInDb(plugin10jun);
        this.assertPluginOnFilesystem(plugin10jun);
        this.assertPluginNotOnFilesystem(plugin10feb);
    }

    public void test5() throws Exception {
        Plugin plugin11jun = this.deployPluginJarToFilesystem(TESTPLUGIN_1_1_JUN);
        this.deployPluginJarToDatabase(TESTPLUGIN_1_0_JUN);
        this.createScannerAndScan(TESTPLUGIN_1_1_JUN);
        this.assertPluginInDb(plugin11jun);
        this.assertPluginOnFilesystem(plugin11jun);
    }

    public void test6() throws Exception {
        Plugin plugin10jun = this.deployPluginJarToFilesystem(TESTPLUGIN_1_0_JUN);
        Plugin plugin11jun = this.deployPluginJarToDatabase(TESTPLUGIN_1_1_JUN);
        this.createScannerAndScan(null);
        this.assertPluginInDb(plugin11jun);
        this.assertPluginOnFilesystem(plugin11jun);
        this.assertPluginNotOnFilesystem(plugin10jun);
        this.scan(null, TESTPLUGIN_1_1_JUN);
        this.assertPluginInDb(plugin11jun);
        this.assertPluginOnFilesystem(plugin11jun);
        this.assertPluginNotOnFilesystem(plugin10jun);
    }

    public void test7() throws Exception {
        Plugin plugin11feb = this.deployPluginJarToFilesystem(TESTPLUGIN_1_1_FEB);
        this.deployPluginJarToDatabase(TESTPLUGIN_1_0_JUN);
        this.createScannerAndScan(TESTPLUGIN_1_1_FEB);
        this.assertPluginInDb(plugin11feb);
        this.assertPluginOnFilesystem(plugin11feb);
    }

    public void test8() throws Exception {
        Plugin plugin10jun = this.deployPluginJarToFilesystem(TESTPLUGIN_1_0_JUN);
        Plugin plugin11feb = this.deployPluginJarToDatabase(TESTPLUGIN_1_1_FEB);
        this.createScannerAndScan(null);
        this.assertPluginInDb(plugin11feb);
        this.assertPluginOnFilesystem(plugin11feb);
        this.assertPluginNotOnFilesystem(plugin10jun);
        this.scan(null, TESTPLUGIN_1_1_FEB);
        this.assertPluginInDb(plugin11feb);
        this.assertPluginOnFilesystem(plugin11feb);
        this.assertPluginNotOnFilesystem(plugin10jun);
    }

    public void test9() throws Exception {
        Plugin plugin10feb = this.deployPluginJarToFilesystem(TESTPLUGIN_1_0_FEB);
        Plugin plugin10jun = this.deployPluginJarToFilesystem(TESTPLUGIN_1_0_JUN);
        this.deployPluginJarToDatabase(TESTPLUGIN_1_0_FEB);
        this.createScannerAndScan(null);
        this.assertPluginInDb(plugin10feb);
        this.assertPluginOnFilesystem(plugin10jun);
        this.assertPluginNotOnFilesystem(plugin10feb);
        this.scan(null, TESTPLUGIN_1_0_JUN);
        this.assertPluginInDb(plugin10jun);
        this.assertPluginOnFilesystem(plugin10jun);
        this.assertPluginNotOnFilesystem(plugin10feb);
    }

    public void test10() throws Exception {
        Plugin plugin10feb = this.deployPluginJarToFilesystem(TESTPLUGIN_1_0_FEB);
        Plugin plugin10jun = this.deployPluginJarToFilesystem(TESTPLUGIN_1_0_JUN);
        this.deployPluginJarToDatabase(TESTPLUGIN_1_0_JUN);
        this.createScannerAndScan(null);
        this.assertPluginInDb(plugin10jun);
        this.assertPluginOnFilesystem(plugin10jun);
        this.assertPluginNotOnFilesystem(plugin10feb);
        this.scan(null, TESTPLUGIN_1_0_JUN);
        this.assertPluginInDb(plugin10jun);
        this.assertPluginOnFilesystem(plugin10jun);
        this.assertPluginNotOnFilesystem(plugin10feb);
    }

    public void test11() throws Exception {
        Plugin plugin10feb = this.deployPluginJarToFilesystem(TESTPLUGIN_1_0_FEB);
        Plugin plugin10jun = this.deployPluginJarToFilesystem(TESTPLUGIN_1_0_JUN);
        Plugin plugin11feb = this.deployPluginJarToDatabase(TESTPLUGIN_1_1_FEB);
        this.createScannerAndScan(null);
        this.assertPluginInDb(plugin11feb);
        this.assertPluginOnFilesystem(plugin11feb);
        this.assertPluginNotOnFilesystem(plugin10feb);
        this.assertPluginNotOnFilesystem(plugin10jun);
        this.scan(null, TESTPLUGIN_1_1_FEB);
        this.assertPluginInDb(plugin11feb);
        this.assertPluginOnFilesystem(plugin11feb);
        this.assertPluginNotOnFilesystem(plugin10feb);
        this.assertPluginNotOnFilesystem(plugin10jun);
    }

    public void test12() throws Exception {
        Plugin plugin10feb = this.deployPluginJarToFilesystem(TESTPLUGIN_1_0_FEB);
        Plugin plugin11jun = this.deployPluginJarToFilesystem(TESTPLUGIN_1_1_JUN);
        this.deployPluginJarToDatabase(TESTPLUGIN_1_0_FEB);
        this.createScannerAndScan(null);
        this.assertPluginInDb(plugin10feb);
        this.assertPluginOnFilesystem(plugin11jun);
        this.assertPluginNotOnFilesystem(plugin10feb);
        this.scan(null, TESTPLUGIN_1_1_JUN);
        this.assertPluginInDb(plugin11jun);
        this.assertPluginOnFilesystem(plugin11jun);
        this.assertPluginNotOnFilesystem(plugin10feb);
    }

    public void test13() throws Exception {
        Plugin plugin10feb = this.deployPluginJarToFilesystem(TESTPLUGIN_1_0_FEB);
        Plugin plugin11jun = this.deployPluginJarToFilesystem(TESTPLUGIN_1_1_JUN);
        Plugin plugin11feb = this.deployPluginJarToDatabase(TESTPLUGIN_1_1_FEB);
        this.createScannerAndScan(null);
        this.assertPluginInDb(plugin11feb);
        this.assertPluginOnFilesystem(plugin11jun);
        this.assertPluginNotOnFilesystem(plugin10feb);
        this.scan(null, TESTPLUGIN_1_1_JUN);
        this.assertPluginInDb(plugin11jun);
        this.assertPluginOnFilesystem(plugin11jun);
        this.assertPluginNotOnFilesystem(plugin10feb);
    }

    public void test14() throws Exception {
        boolean plugin10feb2Exists;
        Plugin plugin10feb = this.deployPluginJarToFilesystem(TESTPLUGIN_1_0_FEB);
        Plugin plugin10feb2 = this.deployPluginJarToFilesystem(TESTPLUGIN_1_0_FEB2);
        this.deployPluginJarToDatabase(TESTPLUGIN_1_0_FEB);
        this.createScannerAndScan(null);
        this.assertPluginInDb(plugin10feb);
        boolean plugin10febExists = !this.isPluginNotOnFilesystem(plugin10feb);
        boolean bl = plugin10feb2Exists = !this.isPluginNotOnFilesystem(plugin10feb2);
        assert (plugin10febExists ^ plugin10feb2Exists);
        this.scan(null, TESTPLUGIN_1_0_FEB);
        this.assertPluginInDb(plugin10feb);
        plugin10febExists = !this.isPluginNotOnFilesystem(plugin10feb);
        boolean bl2 = plugin10feb2Exists = !this.isPluginNotOnFilesystem(plugin10feb2);
        assert (plugin10febExists ^ plugin10feb2Exists);
    }

    private void assertSamePlugin(Plugin p1, Plugin p2) throws Exception {
        assert (p1.getName().equals(p2.getName())) : "NAME: " + p1 + "!=" + p2;
        assert (p1.getMd5().equals(p2.getMd5())) : "MD5: " + p1 + "!=" + p2;
        assert (p1.getMtime() == p2.getMtime()) : "MTIME: " + p1 + "!=" + p2;
        assert (p1.getVersion().equals(p2.getVersion())) : "VERSION: " + p1 + "!=" + p2;
    }

    private void assertPluginOnFilesystem(Plugin plugin) throws Exception {
        File file = new File(DEPLOY_LOCATION, plugin.getPath());
        String version = AgentPluginDescriptorUtil.getPluginVersion((File)file, null).toString();
        String md5 = MessageDigestGenerator.getDigestString((File)file);
        long mtime = file.lastModified();
        Plugin filePlugin = new Plugin(PLUGIN_NAME, file.getName());
        filePlugin.setMd5(md5);
        filePlugin.setVersion(version);
        filePlugin.setMtime(mtime);
        this.assertSamePlugin(plugin, filePlugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertPluginInDb(Plugin plugin) throws Exception {
        Plugin dbPlugin;
        TransactionManager tm = this.getTransactionManager();
        tm.begin();
        try {
            Query q = this.em.createNamedQuery("Plugin.findByName");
            q.setParameter("name", (Object)PLUGIN_NAME);
            dbPlugin = (Plugin)q.getSingleResult();
        }
        finally {
            tm.rollback();
        }
        this.assertSamePlugin(plugin, dbPlugin);
    }

    private void assertPluginNotOnFilesystem(Plugin plugin) throws Exception {
        assert (this.isPluginNotOnFilesystem(plugin));
    }

    private boolean isPluginNotOnFilesystem(Plugin plugin) {
        File file = new File(DEPLOY_LOCATION, plugin.getPath());
        return !file.exists();
    }

    private PluginDeploymentScanner createScannerAndScan(String pluginId) throws Exception {
        PluginDeploymentScanner scanner = this.createScanner();
        this.scan(scanner, pluginId);
        return scanner;
    }

    private PluginDeploymentScanner createScanner() throws Exception {
        PluginDeploymentScanner scanner = new PluginDeploymentScanner();
        File pluginDirectoryFile = new File(DEPLOY_LOCATION);
        scanner.setAgentPluginDir(pluginDirectoryFile.getAbsolutePath());
        return scanner;
    }

    private void scan(PluginDeploymentScanner scanner, String pluginId) throws Exception {
        if (scanner != null) {
            scanner.scan();
        }
        if (pluginId != null) {
            Plugin plugin = this.testPlugins.get(pluginId);
            Plugin pluginDup = new Plugin(plugin.getName(), plugin.getPath(), plugin.getMd5());
            pluginDup.setMtime(plugin.getMtime());
            pluginDup.setVersion(plugin.getVersion());
            PluginDescriptor pluginDescriptor = this.testPluginDescriptors.get(pluginId);
            File localPluginFile = this.testPluginFiles.get(pluginId);
            this.pluginMgr.registerPlugin(pluginDup, pluginDescriptor, localPluginFile, false);
        }
    }

    private Plugin deployPluginJarToDatabase(String pluginId) throws Exception {
        Plugin plugin = this.testPlugins.get(pluginId);
        Plugin pluginPojo = new Plugin(plugin.getName(), plugin.getPath(), plugin.getMd5());
        pluginPojo.setId(0);
        pluginPojo.setDisplayName(plugin.getName());
        pluginPojo.setVersion(plugin.getVersion());
        pluginPojo.setMtime(plugin.getMtime());
        pluginPojo.setContent(StreamUtil.slurp((InputStream)new FileInputStream(this.testPluginFiles.get(pluginId))));
        TransactionManager tm = this.getTransactionManager();
        tm.begin();
        try {
            this.em.persist((Object)pluginPojo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            tm.commit();
        }
        return plugin;
    }

    private Plugin deployPluginJarToFilesystem(String pluginId) throws Exception {
        File pluginJar = this.testPluginFiles.get(pluginId);
        File deployedPluginJar = new File(DEPLOY_LOCATION, pluginJar.getName());
        FileOutputStream out = new FileOutputStream(deployedPluginJar);
        FileInputStream in = new FileInputStream(pluginJar);
        StreamUtil.copy((InputStream)in, (OutputStream)out);
        this.timestampPluginJar(deployedPluginJar, pluginId);
        return this.testPlugins.get(pluginId);
    }

    private void timestampPluginJar(File pluginJar, String pluginId) throws Exception {
        pluginJar.setLastModified(this.testTimestamps.get(pluginId).getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildPluginJar(String descriptor, File pluginJar) throws Exception {
        FileOutputStream fos = new FileOutputStream(pluginJar);
        ZipOutputStream zip = new ZipOutputStream(fos);
        try {
            ZipEntry zipEntry = new ZipEntry("META-INF/rhq-plugin.xml");
            zip.putNextEntry(zipEntry);
            InputStream input = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(descriptor);
            try {
                StreamUtil.copy((InputStream)input, (OutputStream)zip, (boolean)false);
            }
            finally {
                input.close();
            }
        }
        finally {
            zip.close();
        }
    }

    private void emptyDirectory(File dirToEmpty) {
        File[] doomedFiles;
        if (!dirToEmpty.isDirectory()) {
            return;
        }
        for (File doomedFile : doomedFiles = dirToEmpty.listFiles()) {
            doomedFile.delete();
        }
    }
}

