/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.db;

import java.util.Set;
import java.util.UUID;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.DbSetupUtility;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

@Test(groups={"db"}, singleThreaded=true)
public class DbUpgradeTest
extends AbstractEJB3Test {
    @Override
    protected void beforeMethod() throws Exception {
        DbSetupUtility.dbreset();
        DbSetupUtility.dbsetup("2.3.1");
        DbSetupUtility.dbupgrade("2.116");
    }

    @Override
    protected void afterMethod() throws Exception {
        DbSetupUtility.dbupgrade("LATEST");
    }

    public void testUpgradeToV2_119() throws Exception {
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        RoleManagerLocal roleManager = LookupUtil.getRoleManager();
        Subject overlord = subjectManager.getOverlord();
        Role customRole = new Role("role" + UUID.randomUUID());
        customRole.addPermission(Permission.MANAGE_REPOSITORIES);
        customRole.addPermission(Permission.MANAGE_MEASUREMENTS);
        customRole = roleManager.createRole(overlord, customRole);
        Set customRoleOriginalPermissions = customRole.getPermissions();
        this.assertFalse(customRoleOriginalPermissions.contains(Permission.VIEW_USERS));
        Role superuserRole = roleManager.getRole(overlord, 1);
        Set superuserRoleOriginalPermissions = superuserRole.getPermissions();
        this.assertFalse(superuserRoleOriginalPermissions.contains(Permission.VIEW_USERS));
        Role allResourcesRole = roleManager.getRole(overlord, 2);
        Set allResourcesRoleOriginalPermissions = allResourcesRole.getPermissions();
        this.assertFalse(allResourcesRoleOriginalPermissions.contains(Permission.VIEW_USERS));
        DbSetupUtility.dbupgrade("2.119");
        customRole = roleManager.getRole(overlord, customRole.getId());
        Set customRoleNewPermissions = customRole.getPermissions();
        customRoleOriginalPermissions.add(Permission.VIEW_USERS);
        this.assertEquals(customRoleOriginalPermissions, customRoleNewPermissions);
        superuserRole = roleManager.getRole(overlord, 1);
        Set superuserRoleNewPermissions = superuserRole.getPermissions();
        superuserRoleOriginalPermissions.add(Permission.VIEW_USERS);
        this.assertEquals(superuserRoleOriginalPermissions, superuserRoleNewPermissions);
        allResourcesRole = roleManager.getRole(overlord, 2);
        Set allResourcesRoleNewPermissions = allResourcesRole.getPermissions();
        allResourcesRoleOriginalPermissions.add(Permission.VIEW_USERS);
        this.assertEquals(allResourcesRoleOriginalPermissions, allResourcesRoleNewPermissions);
    }
}

