/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.discovery;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.ejb.EJBException;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlProducer;
import org.dbunit.ext.oracle.Oracle10DataTypeFactory;
import org.dbunit.ext.oracle.OracleDataTypeFactory;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;
import org.dbunit.operation.DatabaseOperation;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.rhq.core.clientapi.agent.discovery.DiscoveryAgentService;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.discovery.MergeInventoryReportResults;
import org.rhq.core.domain.discovery.MergeResourceResponse;
import org.rhq.core.domain.discovery.PlatformSyncInfo;
import org.rhq.core.domain.discovery.ResourceSyncInfo;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.CreateResourceHistory;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.collection.ArrayUtils;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.discovery.DiscoveryBossLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.ResourceTreeHelper;
import org.testng.annotations.Test;
import org.xml.sax.InputSource;

public class DiscoveryBossBeanTest
extends AbstractEJB3Test {
    private static final Log LOG = LogFactory.getLog(DiscoveryBossBeanTest.class);
    private DiscoveryBossLocal discoveryBoss;
    private SubjectManagerLocal subjectManager;
    private ResourceManagerLocal resourceManager;
    private ResourceTypeManagerLocal resourceTypeManager;
    private ResourceType platformType;
    private ResourceType serverType;
    private ResourceType serviceType1;
    private ResourceType serviceType2;
    private ResourceType storagePlatformType;
    private ResourceType storageServerType;
    private Agent agent;
    private TestServerCommunicationsService agentServiceContainer;

    @Override
    protected void beforeMethod() throws Exception {
        this.discoveryBoss = LookupUtil.getDiscoveryBoss();
        this.subjectManager = LookupUtil.getSubjectManager();
        this.resourceManager = LookupUtil.getResourceManager();
        this.resourceTypeManager = LookupUtil.getResourceTypeManager();
        this.initDB();
        this.platformType = (ResourceType)this.getEntityManager().find(ResourceType.class, (Object)15641);
        this.serverType = (ResourceType)this.getEntityManager().find(ResourceType.class, (Object)15642);
        this.serviceType1 = (ResourceType)this.getEntityManager().find(ResourceType.class, (Object)15643);
        this.serviceType2 = (ResourceType)this.getEntityManager().find(ResourceType.class, (Object)15644);
        this.agent = (Agent)this.getEntityManager().find(Agent.class, (Object)15641);
        this.storagePlatformType = (ResourceType)this.getEntityManager().find(ResourceType.class, (Object)15651);
        this.storageServerType = (ResourceType)this.getEntityManager().find(ResourceType.class, (Object)15652);
        this.agentServiceContainer = this.prepareForTestAgents();
        this.agentServiceContainer.discoveryService = (DiscoveryAgentService)Mockito.mock(DiscoveryAgentService.class);
        Mockito.when((Object)this.agentServiceContainer.discoveryService.manuallyAddResource((ResourceType)Matchers.any(ResourceType.class), Matchers.anyInt(), (Configuration)Matchers.any(Configuration.class), Matchers.anyInt())).thenAnswer((Answer)new Answer<MergeResourceResponse>(){

            public MergeResourceResponse answer(InvocationOnMock invocation) throws Throwable {
                Resource resource = new Resource(1000000);
                resource.setUuid(UUID.randomUUID().toString());
                ResourceType resourceType = (ResourceType)invocation.getArguments()[0];
                resource.setResourceType(resourceType);
                long randomLong = UUID.randomUUID().getLeastSignificantBits();
                resource.setResourceKey(DiscoveryBossBeanTest.this.prefix("key-" + randomLong));
                resource.setName(DiscoveryBossBeanTest.this.prefix("name-" + randomLong));
                int parentResourceId = (Integer)invocation.getArguments()[1];
                Resource parentResource = DiscoveryBossBeanTest.this.resourceManager.getResource(DiscoveryBossBeanTest.this.subjectManager.getOverlord(), parentResourceId);
                resource.setParentResource(parentResource);
                Integer ownerSubjectId = (Integer)invocation.getArguments()[3];
                MergeResourceResponse response = DiscoveryBossBeanTest.this.discoveryBoss.addResource(resource, ownerSubjectId.intValue());
                return response;
            }
        });
        this.prepareScheduler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterMethod() throws Exception {
        try {
            this.cleanDB();
        }
        finally {
            this.unprepareForTestAgents();
            this.unprepareScheduler();
        }
    }

    @Test(groups={"integration.ejb3"})
    public void testBasicInventoryReport() throws Exception {
        InventoryReport inventoryReport = new InventoryReport(this.agent);
        Resource platform = new Resource(this.prefix("alpha"), this.prefix("platform"), this.platformType);
        Resource server = new Resource(this.prefix("bravo"), this.prefix("server"), this.serverType);
        platform.addChildResource(server);
        Resource service1 = new Resource(this.prefix("charlie"), this.prefix("service 1"), this.serviceType1);
        Resource service2 = new Resource(this.prefix("delta"), this.prefix("service 2"), this.serviceType2);
        server.addChildResource(service1);
        server.addChildResource(service2);
        platform.setUuid(String.valueOf(new Random().nextInt()));
        server.setUuid(String.valueOf(new Random().nextInt()));
        service1.setUuid(String.valueOf(new Random().nextInt()));
        service2.setUuid(String.valueOf(new Random().nextInt()));
        inventoryReport.addAddedRoot(platform);
        MergeInventoryReportResults results = this.discoveryBoss.mergeInventoryReport(DiscoveryBossBeanTest.serialize(inventoryReport));
        assert (results != null);
        assert (this.checkIgnoredTypes(results)) : "nothing should have been ignored in this test";
        this.assertNotNull(results.getPlatformSyncInfo());
    }

    @Test(groups={"integration.ejb3"})
    public void testUpdateInventoryReport() throws Exception {
        InventoryReport inventoryReport = new InventoryReport(this.agent);
        Resource platform = new Resource(this.prefix("alpha"), this.prefix("platform"), this.platformType);
        platform.setUuid(String.valueOf(new Random().nextInt()));
        inventoryReport.addAddedRoot(platform);
        MergeInventoryReportResults results = this.discoveryBoss.mergeInventoryReport(DiscoveryBossBeanTest.serialize(inventoryReport));
        assert (results != null);
        assert (this.checkIgnoredTypes(results)) : "nothing should have been ignored in this test";
        this.assertNotNull(results.getPlatformSyncInfo());
        Collection syncInfos = this.discoveryBoss.getResourceSyncInfo(results.getPlatformSyncInfo().getPlatform().getId());
        assert (syncInfos != null);
        assert (!syncInfos.isEmpty());
        platform.setId(results.getPlatformSyncInfo().getPlatform().getId());
        inventoryReport = new InventoryReport(this.agent);
        Resource server = new Resource(this.prefix("bravo"), this.prefix("server"), this.serverType);
        platform.addChildResource(server);
        Resource service1 = new Resource(this.prefix("charlie"), this.prefix("service 1"), this.serviceType1);
        Resource service2 = new Resource(this.prefix("delta"), this.prefix("service 2"), this.serviceType2);
        server.addChildResource(service1);
        server.addChildResource(service2);
        server.setUuid(String.valueOf(new Random().nextInt()));
        service1.setUuid(String.valueOf(new Random().nextInt()));
        service2.setUuid(String.valueOf(new Random().nextInt()));
        inventoryReport.addAddedRoot(server);
        results = this.discoveryBoss.mergeInventoryReport(DiscoveryBossBeanTest.serialize(inventoryReport));
        assert (results != null);
        assert (this.checkIgnoredTypes(results)) : "nothing should have been ignored in this test";
        this.assertNotNull(results.getPlatformSyncInfo());
    }

    private boolean checkIgnoredTypes(MergeInventoryReportResults results) {
        return this.checkIgnoredTypes(results, 0);
    }

    private boolean checkIgnoredTypes(MergeInventoryReportResults results, int expectedNumberOfIgnoredTypes) {
        int numberOfRelevantIgnoredTypes = 0;
        Collection ignoredTypes = results.getIgnoredResourceTypes();
        if (null != ignoredTypes) {
            if (ignoredTypes.contains(new MergeInventoryReportResults.ResourceTypeFlyweight(this.serverType))) {
                ++numberOfRelevantIgnoredTypes;
            }
            if (ignoredTypes.contains(new MergeInventoryReportResults.ResourceTypeFlyweight(this.serviceType1))) {
                ++numberOfRelevantIgnoredTypes;
            }
            if (ignoredTypes.contains(new MergeInventoryReportResults.ResourceTypeFlyweight(this.serviceType2))) {
                ++numberOfRelevantIgnoredTypes;
            }
        }
        return expectedNumberOfIgnoredTypes == numberOfRelevantIgnoredTypes;
    }

    @Test(groups={"integration.ejb3"})
    public void testManuallyAddResource() throws Exception {
        InventoryReport inventoryReport = new InventoryReport(this.agent);
        Resource platform = new Resource(this.prefix("alpha"), this.prefix("platform"), this.platformType);
        Resource server = new Resource(this.prefix("bravo"), this.prefix("server"), this.serverType);
        platform.addChildResource(server);
        Resource service2 = new Resource(this.prefix("delta"), this.prefix("service 2"), this.serviceType2);
        server.addChildResource(service2);
        platform.setUuid(String.valueOf(new Random().nextInt()));
        server.setUuid(String.valueOf(new Random().nextInt()));
        service2.setUuid(String.valueOf(new Random().nextInt()));
        inventoryReport.addAddedRoot(platform);
        MergeInventoryReportResults results = this.discoveryBoss.mergeInventoryReport(DiscoveryBossBeanTest.serialize(inventoryReport));
        assert (results != null);
        assert (this.checkIgnoredTypes(results)) : "nothing should have been ignored in this test";
        this.assertNotNull(results.getPlatformSyncInfo());
        this.assertNotNull(results.getPlatformSyncInfo().getTopLevelServerIds());
        this.assertTrue(!results.getPlatformSyncInfo().getTopLevelServerIds().isEmpty());
        Integer resourceId = (Integer)results.getPlatformSyncInfo().getTopLevelServerIds().iterator().next();
        Collection syncInfos = this.discoveryBoss.getResourceSyncInfo(resourceId.intValue());
        assert (syncInfos != null);
        assert (!syncInfos.isEmpty());
        Resource resource1 = this.discoveryBoss.manuallyAddResource(this.subjectManager.getOverlord(), this.serviceType2.getId(), resourceId.intValue(), new Configuration());
        try {
            Resource resource2 = this.discoveryBoss.manuallyAddResource(this.subjectManager.getOverlord(), this.serviceType2.getId(), resourceId.intValue(), new Configuration());
            this.fail("Manually adding a singleton that already existed succeeded: " + resource2);
        }
        catch (EJBException e) {
            this.assertEquals(String.valueOf(e.getCause()), RuntimeException.class, e.getCause().getClass());
            this.assertTrue(String.valueOf(e.getCause()), e.getCause().getMessage().contains("singleton"));
        }
    }

    @Test(groups={"integration.ejb3"})
    public void testIgnoreUnignoreAndImportResources() throws Exception {
        InventoryReport inventoryReport = new InventoryReport(this.agent);
        Resource platform = new Resource(this.prefix("platform"), this.prefix("platform"), this.platformType);
        platform.setUuid(String.valueOf(new Random().nextInt()));
        for (int i = 0; i < 17; ++i) {
            String serverString = this.prefix("server " + String.valueOf(i));
            Resource server = new Resource(serverString, serverString, this.serverType);
            server.setUuid(String.valueOf(new Random().nextInt()));
            platform.addChildResource(server);
        }
        inventoryReport.addAddedRoot(platform);
        MergeInventoryReportResults mergeResults = this.discoveryBoss.mergeInventoryReport(DiscoveryBossBeanTest.serialize(inventoryReport));
        assert (mergeResults != null);
        assert (this.checkIgnoredTypes(mergeResults)) : "nothing should have been ignored: " + mergeResults.getIgnoredResourceTypes();
        PlatformSyncInfo platformSyncInfo = mergeResults.getPlatformSyncInfo();
        assert (platformSyncInfo != null);
        this.assertEquals(InventoryStatus.NEW, platformSyncInfo.getPlatform().getInventoryStatus());
        this.assertEquals(platform.getChildResources().size(), platformSyncInfo.getTopLevelServerIds().size());
        int platformId = platformSyncInfo.getPlatform().getId();
        LinkedList<Integer> serverIds = new LinkedList<Integer>();
        for (Integer serverId : platformSyncInfo.getTopLevelServerIds()) {
            serverIds.add(serverId);
        }
        int[] arrayOfServerIds = ArrayUtils.unwrapCollection(serverIds);
        this.discoveryBoss.importResources(this.subjectManager.getOverlord(), new int[]{platformId});
        this.discoveryBoss.ignoreResources(this.subjectManager.getOverlord(), arrayOfServerIds);
        try {
            this.discoveryBoss.importResources(this.subjectManager.getOverlord(), arrayOfServerIds);
            this.fail("Import resources should fail for ignored resources");
        }
        catch (EJBException e) {
            this.assertEquals(String.valueOf(e.getCause()), IllegalArgumentException.class, e.getCause().getClass());
            this.assertTrue(String.valueOf(e.getCause()), e.getCause().getMessage().startsWith("Can only set inventory status to"));
        }
        this.discoveryBoss.unignoreAndImportResources(this.subjectManager.getOverlord(), arrayOfServerIds);
        ArrayList<InventoryStatus> committedStatus = new ArrayList<InventoryStatus>(1);
        ArrayList<InventoryStatus> ignoredStatus = new ArrayList<InventoryStatus>(1);
        committedStatus.add(InventoryStatus.COMMITTED);
        ignoredStatus.add(InventoryStatus.IGNORED);
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addFilterParentInventoryStatuses(committedStatus);
        criteria.addFilterId((Integer)serverIds.get(0));
        PageList lookup = this.resourceManager.findResourcesByCriteria(this.subjectManager.getOverlord(), criteria);
        assert (1 == lookup.size()) : lookup;
        assert (((Resource)lookup.get(0)).getId() == ((Integer)serverIds.get(0)).intValue()) : lookup;
        criteria.addFilterParentInventoryStatuses(ignoredStatus);
        lookup = this.resourceManager.findResourcesByCriteria(this.subjectManager.getOverlord(), criteria);
        assert (lookup.isEmpty()) : lookup;
    }

    @Test(groups={"integration.ejb3"})
    public void testIgnoreResourceType() throws Exception {
        this.resourceTypeManager.setResourceTypeIgnoreFlagAndUninventoryResources(this.subjectManager.getOverlord(), this.serverType.getId(), true);
        InventoryReport inventoryReport = new InventoryReport(this.agent);
        Resource platform = new Resource(this.prefix("platform"), this.prefix("platform"), this.platformType);
        platform.setUuid(String.valueOf(new Random().nextInt()));
        Resource server = new Resource(this.prefix("server0"), this.prefix("server0"), this.serverType);
        server.setUuid(String.valueOf(new Random().nextInt()));
        platform.addChildResource(server);
        inventoryReport.addAddedRoot(platform);
        MergeInventoryReportResults mergeResults = this.discoveryBoss.mergeInventoryReport(DiscoveryBossBeanTest.serialize(inventoryReport));
        assert (mergeResults != null);
        PlatformSyncInfo platformSyncInfo = mergeResults.getPlatformSyncInfo();
        assert (platformSyncInfo != null);
        this.assertNotNull(mergeResults.getIgnoredResourceTypes());
        assert (this.checkIgnoredTypes(mergeResults, 1)) : "expected one ignored type";
        assert (mergeResults.getIgnoredResourceTypes().contains(new MergeInventoryReportResults.ResourceTypeFlyweight(this.serverType)));
        this.assertEquals(InventoryStatus.NEW, platformSyncInfo.getPlatform().getInventoryStatus());
        this.assertEquals(platformSyncInfo.getTopLevelServerIds().size(), 0);
    }

    @Test(groups={"integration.ejb3"})
    public void testReturnAllIgnoredResourceTypes() throws Exception {
        this.resourceTypeManager.setResourceTypeIgnoreFlagAndUninventoryResources(this.subjectManager.getOverlord(), this.serviceType1.getId(), true);
        this.resourceTypeManager.setResourceTypeIgnoreFlagAndUninventoryResources(this.subjectManager.getOverlord(), this.serviceType2.getId(), true);
        InventoryReport inventoryReport = new InventoryReport(this.agent);
        Resource platform = new Resource(this.prefix("platform"), this.prefix("platform"), this.platformType);
        platform.setUuid(String.valueOf(new Random().nextInt()));
        Resource server = new Resource(this.prefix("server0"), this.prefix("server0"), this.serverType);
        server.setUuid(String.valueOf(new Random().nextInt()));
        platform.addChildResource(server);
        inventoryReport.addAddedRoot(platform);
        MergeInventoryReportResults mergeResults = this.discoveryBoss.mergeInventoryReport(DiscoveryBossBeanTest.serialize(inventoryReport));
        assert (mergeResults != null);
        PlatformSyncInfo platformSyncInfo = mergeResults.getPlatformSyncInfo();
        assert (platformSyncInfo != null);
        Collection ignoredResourceTypes = mergeResults.getIgnoredResourceTypes();
        this.assertNotNull(ignoredResourceTypes);
        assert (this.checkIgnoredTypes(mergeResults, 2)) : "expected two ignored types";
        assert (ignoredResourceTypes.contains(new MergeInventoryReportResults.ResourceTypeFlyweight(this.serviceType1)));
        assert (ignoredResourceTypes.contains(new MergeInventoryReportResults.ResourceTypeFlyweight(this.serviceType2)));
    }

    @Test(groups={"integration.ejb3"})
    public void testIgnoreResourceTypeAndUninventoryResources() throws Exception {
        InventoryReport inventoryReport = new InventoryReport(this.agent);
        Resource platform = new Resource(this.prefix("platform"), this.prefix("platform"), this.platformType);
        platform.setUuid(String.valueOf(new Random().nextInt()));
        for (int i = 0; i < 17; ++i) {
            String serverString = this.prefix("server " + String.valueOf(i));
            Resource server = new Resource(serverString, serverString, this.serverType);
            server.setUuid(String.valueOf(new Random().nextInt()));
            platform.addChildResource(server);
        }
        inventoryReport.addAddedRoot(platform);
        MergeInventoryReportResults mergeResults = this.discoveryBoss.mergeInventoryReport(DiscoveryBossBeanTest.serialize(inventoryReport));
        assert (mergeResults != null);
        assert (this.checkIgnoredTypes(mergeResults)) : "nothing should have been ignored: " + mergeResults.getIgnoredResourceTypes();
        PlatformSyncInfo platformSyncInfo = mergeResults.getPlatformSyncInfo();
        assert (platformSyncInfo != null);
        int platformId = platformSyncInfo.getPlatform().getId();
        LinkedList<Integer> serverIds = new LinkedList<Integer>();
        for (Integer serverId : platformSyncInfo.getTopLevelServerIds()) {
            serverIds.add(serverId);
        }
        int[] arrayOfServerIds = ArrayUtils.unwrapCollection(serverIds);
        this.discoveryBoss.importResources(this.subjectManager.getOverlord(), new int[]{platformId});
        this.discoveryBoss.importResources(this.subjectManager.getOverlord(), arrayOfServerIds);
        ArrayList<Integer> serverTypeIdInList = new ArrayList<Integer>(1);
        serverTypeIdInList.add(this.serverType.getId());
        PageList allServers = this.resourceManager.findResourceByIds(this.subjectManager.getOverlord(), arrayOfServerIds, false, PageControl.getUnlimitedInstance());
        for (Resource aServer : allServers) {
            assert (aServer.getInventoryStatus() == InventoryStatus.COMMITTED) : "should be committed: " + aServer;
        }
        assert (allServers.getTotalSize() == arrayOfServerIds.length) : "all servers were not committed into inventory";
        this.resourceTypeManager.setResourceTypeIgnoreFlagAndUninventoryResources(this.subjectManager.getOverlord(), this.serverType.getId(), true);
        allServers = this.resourceManager.findResourceByIds(this.subjectManager.getOverlord(), arrayOfServerIds, false, PageControl.getUnlimitedInstance());
        for (Resource aServer : allServers) {
            assert (aServer.getInventoryStatus() != InventoryStatus.COMMITTED) : "should not be committed: " + aServer;
        }
        mergeResults = this.discoveryBoss.mergeInventoryReport(DiscoveryBossBeanTest.serialize(inventoryReport));
        assert (mergeResults != null);
        platformSyncInfo = mergeResults.getPlatformSyncInfo();
        assert (platformSyncInfo != null);
        this.assertNotNull(mergeResults.getIgnoredResourceTypes());
        assert (this.checkIgnoredTypes(mergeResults, 1)) : "expected one ignored type";
        assert (mergeResults.getIgnoredResourceTypes().contains(new MergeInventoryReportResults.ResourceTypeFlyweight(this.serverType)));
        this.assertEquals(InventoryStatus.COMMITTED, platformSyncInfo.getPlatform().getInventoryStatus());
        this.assertEquals(platformSyncInfo.getTopLevelServerIds().size(), 0);
    }

    @Test(groups={"integration.ejb3"})
    public void testAutoImportStorageNode() throws Exception {
        InventoryReport inventoryReport = new InventoryReport(this.agent);
        Resource storagePlatform = new Resource(this.prefix("storagePlatform"), this.prefix("storagePlatform"), this.storagePlatformType);
        storagePlatform.setUuid(String.valueOf(new Random().nextInt()));
        Resource storageNode = new Resource(this.prefix("storageNode"), this.prefix("storageNode"), this.storageServerType);
        storageNode.setUuid(String.valueOf(new Random().nextInt()));
        storagePlatform.addChildResource(storageNode);
        storageNode.setPluginConfiguration(((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.builder().addSimple("nativeTransportPort", (Object)9142)).addSimple("storagePort", (Object)7100)).addSimple("host", (Object)"localhost")).build());
        inventoryReport.addAddedRoot(storagePlatform);
        MergeInventoryReportResults mergeResults = this.discoveryBoss.mergeInventoryReport(DiscoveryBossBeanTest.serialize(inventoryReport));
        assert (mergeResults != null);
        assert (this.checkIgnoredTypes(mergeResults)) : "nothing should have been ignored: " + mergeResults.getIgnoredResourceTypes();
        PlatformSyncInfo platformSyncInfo = mergeResults.getPlatformSyncInfo();
        assert (platformSyncInfo != null);
        this.assertEquals(InventoryStatus.COMMITTED, platformSyncInfo.getPlatform().getInventoryStatus());
        this.assertEquals(storagePlatform.getChildResources().size(), platformSyncInfo.getTopLevelServerIds().size());
        storageNode = this.resourceManager.getResourceById(this.subjectManager.getOverlord(), ((Integer)platformSyncInfo.getTopLevelServerIds().iterator().next()).intValue());
        this.assertNotNull(storageNode);
        this.assertEquals(InventoryStatus.COMMITTED, storageNode.getInventoryStatus());
    }

    @Test(groups={"integration.ejb3"})
    public void testPersistUserSuppliedResourceNameOnCreatedResource() throws Exception {
        InventoryReport inventoryReport = new InventoryReport(this.agent);
        Resource platform = new Resource(this.prefix("userPlatform"), this.prefix("platform"), this.platformType);
        platform.setUuid(String.valueOf(new Random().nextInt()));
        Resource server = new Resource(this.prefix("userServer"), this.prefix("server"), this.serverType);
        server.setUuid(String.valueOf(new Random().nextInt()));
        platform.addChildResource(server);
        inventoryReport.addAddedRoot(platform);
        MergeInventoryReportResults results = this.discoveryBoss.mergeInventoryReport(DiscoveryBossBeanTest.serialize(inventoryReport));
        this.assertNotNull(results);
        assert (this.checkIgnoredTypes(results)) : "nothing should have been ignored in this test " + results.getIgnoredResourceTypes();
        PlatformSyncInfo firstDiscoverySyncInfo = results.getPlatformSyncInfo();
        this.assertNotNull(firstDiscoverySyncInfo);
        final String userSuppliedResourceName = this.prefix("User Supplied Resource Name");
        final String newResourceKey = this.prefix("Created Resource Key");
        final int serverResourceId = (Integer)firstDiscoverySyncInfo.getTopLevelServerIds().iterator().next();
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Resource serverResource = (Resource)DiscoveryBossBeanTest.this.getEntityManager().find(Resource.class, (Object)serverResourceId);
                CreateResourceHistory createResourceHistory = new CreateResourceHistory(serverResource, DiscoveryBossBeanTest.this.serviceType1, DiscoveryBossBeanTest.this.subjectManager.getOverlord().getName(), new Configuration());
                createResourceHistory.setCreatedResourceName(userSuppliedResourceName);
                createResourceHistory.setNewResourceKey(newResourceKey);
                createResourceHistory.setStatus(CreateResourceStatus.SUCCESS);
                DiscoveryBossBeanTest.this.getEntityManager().persist((Object)createResourceHistory);
                serverResource.addCreateChildResourceHistory(createResourceHistory);
                DiscoveryBossBeanTest.this.getEntityManager().flush();
            }
        });
        inventoryReport = new InventoryReport(this.agent);
        Resource service1 = new Resource(newResourceKey, this.prefix("Plugin Computed Resource Name"), this.serviceType1);
        service1.setUuid(String.valueOf(new Random().nextInt()));
        server.setId(serverResourceId);
        server.addChildResource(service1);
        inventoryReport.addAddedRoot(server);
        results = this.discoveryBoss.mergeInventoryReport(DiscoveryBossBeanTest.serialize(inventoryReport));
        this.assertNotNull(results);
        assert (this.checkIgnoredTypes(results)) : "nothing should have been ignored in this test " + results.getIgnoredResourceTypes();
        PlatformSyncInfo secondDiscoverySyncInfo = results.getPlatformSyncInfo();
        this.assertNotNull(secondDiscoverySyncInfo);
        Integer toplevelServerId = (Integer)secondDiscoverySyncInfo.getTopLevelServerIds().iterator().next();
        Collection topLevelServerSyncInfo = this.discoveryBoss.getResourceSyncInfo(toplevelServerId.intValue());
        assert (topLevelServerSyncInfo.size() == 2);
        Iterator iter = topLevelServerSyncInfo.iterator();
        Integer childId = ((ResourceSyncInfo)iter.next()).getId();
        childId = childId.equals(toplevelServerId) ? ((ResourceSyncInfo)iter.next()).getId() : childId.intValue();
        Resource service1Resource = (Resource)this.getEntityManager().find(Resource.class, (Object)childId);
        this.assertEquals(userSuppliedResourceName, service1Resource.getName());
    }

    private static <T> T serialize(T object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("****** Size of serialized object: " + baos.size()));
            }
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
            Object transfered = ois.readObject();
            return (T)transfered;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed serializing and deserializing object: " + object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDB() throws Exception {
        Connection connection = null;
        try {
            connection = DiscoveryBossBeanTest.getConnection();
            DatabaseConnection dbUnitConnection = new DatabaseConnection(connection);
            this.setDbType((IDatabaseConnection)dbUnitConnection);
            DatabaseOperation.REFRESH.execute((IDatabaseConnection)dbUnitConnection, this.getDataSet());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanDB() throws Exception {
        Connection connection = null;
        try {
            this.getTransactionManager().begin();
            Query q = this.em.createQuery("SELECT r FROM Resource r    WHERE r.resourceType.name LIKE '" + this.getPrefix() + "%'" + "       OR r.resourceType.name = 'RHQ Storage Node'" + " ORDER BY r.id DESC");
            List doomed = q.getResultList();
            for (Object removeMe : doomed) {
                Resource res = (Resource)this.em.getReference(Resource.class, (Object)((Resource)removeMe).getId());
                StorageNode storageNode = this.findStorageNode(res);
                if (storageNode != null) {
                    storageNode.setResource(null);
                }
                Iterator historyIterator = res.getCreateChildResourceRequests().iterator();
                while (historyIterator.hasNext()) {
                    CreateResourceHistory history = (CreateResourceHistory)historyIterator.next();
                    historyIterator.remove();
                    this.em.remove((Object)history);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Deleting resource " + res));
                }
                ResourceTreeHelper.deleteResource(this.em, res);
            }
            this.em.flush();
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("CANNOT CLEAN UP TEST: Cause: " + e));
                this.getTransactionManager().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            connection = DiscoveryBossBeanTest.getConnection();
            DatabaseConnection dbUnitConnection = new DatabaseConnection(connection);
            this.setDbType((IDatabaseConnection)dbUnitConnection);
            DatabaseOperation.DELETE.execute((IDatabaseConnection)dbUnitConnection, this.getDataSet());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private StorageNode findStorageNode(Resource resource) {
        List storageNodes = this.em.createQuery("SELECT s FROM StorageNode s where s.resource = :resource", StorageNode.class).setParameter("resource", (Object)resource).getResultList();
        if (storageNodes.isEmpty()) {
            return null;
        }
        return (StorageNode)storageNodes.get(0);
    }

    void setDbType(IDatabaseConnection connection) throws Exception {
        DatabaseConfig dbConfig = connection.getConfig();
        String name = connection.getConnection().getMetaData().getDatabaseProductName().toLowerCase();
        int major = connection.getConnection().getMetaData().getDatabaseMajorVersion();
        Object type = null;
        if (name.contains("postgres")) {
            type = new PostgresqlDataTypeFactory();
        } else if (name.contains("oracle")) {
            type = major >= 10 ? new Oracle10DataTypeFactory() : new OracleDataTypeFactory();
        }
        if (type != null) {
            dbConfig.setProperty("http://www.dbunit.org/properties/datatypeFactory", type);
        }
    }

    IDataSet getDataSet() throws Exception {
        FlatXmlProducer xmlProducer = new FlatXmlProducer(new InputSource(((Object)((Object)this)).getClass().getResourceAsStream(this.getDataSetFile())));
        xmlProducer.setColumnSensing(true);
        return new FlatXmlDataSet(xmlProducer);
    }

    String getDataSetFile() {
        return this.getPrefix() + ".xml";
    }

    String prefix(String suffix) {
        return this.getPrefix() + "-" + suffix;
    }

    String getPrefix() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

