/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.drift;

import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import org.apache.commons.io.FileUtils;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.drift.Drift;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionTemplate;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.shared.ResourceBuilder;
import org.rhq.core.domain.shared.ResourceTypeBuilder;
import org.rhq.enterprise.server.drift.DriftServerPluginService;
import org.rhq.enterprise.server.drift.TestDefService;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.ResourceTreeHelper;
import org.testng.annotations.Test;

@Test(groups={"drift"}, singleThreaded=true)
public abstract class AbstractDriftServerTest
extends AbstractEJB3Test {
    protected final String NAME_PREFIX = ((Object)((Object)this)).getClass().getSimpleName() + "_";
    protected final String RESOURCE_TYPE_NAME = this.NAME_PREFIX + "RESOURCE_TYPE";
    protected final String AGENT_NAME = this.NAME_PREFIX + "AGENT";
    protected final String RESOURCE_NAME = this.NAME_PREFIX + "RESOURCE";
    protected DriftServerPluginService driftServerPluginService;
    protected TestServerCommunicationsService agentServiceContainer;
    protected ResourceType resourceType;
    protected Agent agent;
    protected Resource resource;

    @Override
    protected void beforeMethod(Method testMethod) throws Exception {
        this.initDriftServer();
        this.initAgentServices();
        this.initDB();
    }

    @Override
    protected void afterMethod() throws Exception {
        this.purgeDB();
        this.shutDownDriftServer();
        this.shutDownAgentServices();
    }

    private void initDriftServer() throws Exception {
        this.driftServerPluginService = new DriftServerPluginService(this.getTempDir());
        this.prepareCustomServerPluginService(this.driftServerPluginService);
        this.driftServerPluginService.masterConfig.getPluginDirectory().mkdirs();
        String projectVersion = System.getProperty("project.version");
        File jpaDriftPlugin = new File("../plugins/drift-rhq/target/rhq-serverplugin-drift-" + projectVersion + ".jar");
        this.assertTrue("Drift server plugin JAR file not found at" + jpaDriftPlugin.getPath(), jpaDriftPlugin.exists());
        FileUtils.copyFileToDirectory((File)jpaDriftPlugin, (File)this.driftServerPluginService.masterConfig.getPluginDirectory());
        this.driftServerPluginService.startMasterPluginContainer();
    }

    private void initAgentServices() {
        this.agentServiceContainer = this.prepareForTestAgents();
        this.agentServiceContainer.driftService = new TestDefService();
    }

    private void shutDownDriftServer() throws Exception {
        this.unprepareServerPluginService();
    }

    private void shutDownAgentServices() {
        this.agentServiceContainer = null;
        this.unprepareForTestAgents();
    }

    protected void initDB() throws Exception {
        this.purgeDB();
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                AbstractDriftServerTest.this.initResourceType();
                AbstractDriftServerTest.this.initAgent();
                AbstractDriftServerTest.this.initResource();
                AbstractDriftServerTest.this.em.persist((Object)AbstractDriftServerTest.this.resourceType);
                AbstractDriftServerTest.this.em.persist((Object)AbstractDriftServerTest.this.agent);
                AbstractDriftServerTest.this.resource.setAgent(AbstractDriftServerTest.this.agent);
                AbstractDriftServerTest.this.em.persist((Object)AbstractDriftServerTest.this.resource);
            }
        });
    }

    protected void purgeDB() {
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                String name = " '" + AbstractDriftServerTest.this.NAME_PREFIX + "%' ";
                AbstractDriftServerTest.this.em.createQuery("delete from JPADrift d where d.newDriftFile like" + name).executeUpdate();
                AbstractDriftServerTest.this.em.createQuery("delete from JPADriftChangeSet cs where cs.id in ( select cs1.id from JPADriftChangeSet cs1 where cs1.driftDefinition.name like" + name + ")").executeUpdate();
                AbstractDriftServerTest.this.em.createQuery("delete from JPADriftChangeSet cs where cs.id in ( select cast(ddt.changeSetId as int) from DriftDefinitionTemplate ddt where ddt.name like" + name + ")").executeUpdate();
                AbstractDriftServerTest.this.em.createNativeQuery("delete from rhq_drift_set ds   where not exists ( select * from rhq_drift d where d.drift_set_id = ds.id )     and not exists ( select * from rhq_drift_change_set cs where cs.drift_set_id = ds.id ) ").executeUpdate();
                AbstractDriftServerTest.this.em.createQuery("delete from JPADriftFile df where df.hashId like" + name).executeUpdate();
                AbstractDriftServerTest.this.em.createQuery("delete from DriftDefinition dd where dd.name like" + name).executeUpdate();
                AbstractDriftServerTest.this.em.createQuery("delete from DriftDefinitionTemplate ddt where ddt.name like" + name).executeUpdate();
                AbstractDriftServerTest.this.deleteEntity(Resource.class, AbstractDriftServerTest.this.RESOURCE_NAME);
                AbstractDriftServerTest.this.deleteEntity(Agent.class, AbstractDriftServerTest.this.AGENT_NAME);
                AbstractDriftServerTest.this.deleteEntity(ResourceType.class, AbstractDriftServerTest.this.RESOURCE_TYPE_NAME);
            }
        });
    }

    protected void deleteEntity(Class<?> clazz, String name) {
        try {
            Object entity = this.em.createQuery("select entity from " + clazz.getSimpleName() + " entity where entity.name = :name").setParameter("name", (Object)name).getSingleResult();
            if (clazz.equals(Resource.class)) {
                ResourceTreeHelper.deleteResource(this.em, (Resource)entity);
            } else {
                this.em.remove(entity);
            }
        }
        catch (NoResultException e) {
        }
        catch (NonUniqueResultException e) {
            this.fail("Purging " + name + " failed. Expected to find one instance of " + clazz.getSimpleName() + " but found more than one. The database may not be in a consistent state.");
        }
    }

    protected void initResourceType() {
        this.resourceType = new ResourceTypeBuilder().createResourceType().withId(0).withName(this.RESOURCE_TYPE_NAME).withCategory(ResourceCategory.SERVER).withPlugin(this.RESOURCE_TYPE_NAME.toLowerCase()).build();
    }

    protected void initAgent() {
        this.agent = new Agent(this.AGENT_NAME, this.AGENT_NAME, 17080, "", this.AGENT_NAME + "_TOKEN");
    }

    protected void initResource() {
        this.resource = new ResourceBuilder().createResource().withId(0).withName(this.RESOURCE_NAME).withResourceKey(this.RESOURCE_NAME).withRandomUuid().withResourceType(this.resourceType).build();
    }

    protected Subject getOverlord() {
        return LookupUtil.getSubjectManager().getOverlord();
    }

    protected String toString(DriftDefinition def) {
        return "DriftDefinition[id: " + def.getId() + ", name: " + def.getName() + "]";
    }

    protected String toString(DriftDefinitionTemplate template) {
        return DriftDefinitionTemplate.class.getSimpleName() + "[id: " + template.getId() + ", name: " + template.getName() + "]";
    }

    protected Drift findDriftByPath(List<? extends Drift> drifts, String path) {
        for (Drift drift : drifts) {
            if (!drift.getPath().equals(path)) continue;
            return drift;
        }
        return null;
    }
}

