/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.drift;

import java.io.File;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.rhq.common.drift.ChangeSetWriterImpl;
import org.rhq.common.drift.FileEntry;
import org.rhq.common.drift.Headers;
import org.rhq.core.clientapi.server.drift.DriftServerService;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.criteria.DriftChangeSetCriteria;
import org.rhq.core.domain.criteria.DriftDefinitionCriteria;
import org.rhq.core.domain.criteria.JPADriftChangeSetCriteria;
import org.rhq.core.domain.drift.Drift;
import org.rhq.core.domain.drift.DriftCategory;
import org.rhq.core.domain.drift.DriftChangeSet;
import org.rhq.core.domain.drift.DriftChangeSetCategory;
import org.rhq.core.domain.drift.DriftConfigurationDefinition;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionTemplate;
import org.rhq.core.domain.drift.DriftFileStatus;
import org.rhq.core.domain.drift.JPADriftFile;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.ZipUtil;
import org.rhq.enterprise.server.drift.DriftManagerLocal;
import org.rhq.enterprise.server.drift.DriftServerPluginService;
import org.rhq.enterprise.server.drift.DriftServerServiceImpl;
import org.rhq.enterprise.server.drift.JPADriftServerLocal;
import org.rhq.enterprise.server.drift.TestDefService;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

public class DriftManagerBeanTest
extends AbstractEJB3Test {
    private JPADriftServerLocal jpaDriftServer;
    private DriftManagerLocal driftManager;
    private Subject overlord;
    private Resource newResource;
    private DriftServerService driftServerService;
    MessageDigestGenerator digestGenerator;

    @Override
    protected void beforeMethod() throws Exception {
        this.digestGenerator = new MessageDigestGenerator("SHA-256");
        this.jpaDriftServer = LookupUtil.getJPADriftServer();
        this.driftManager = LookupUtil.getDriftManager();
        this.overlord = LookupUtil.getSubjectManager().getOverlord();
        this.driftServerService = new DriftServerServiceImpl();
        TestServerCommunicationsService agentServiceContainer = this.prepareForTestAgents();
        agentServiceContainer.driftService = new TestDefService();
        this.prepareScheduler();
        DriftServerPluginService driftServerPluginService = new DriftServerPluginService(this.getTempDir());
        this.prepareCustomServerPluginService(driftServerPluginService);
        driftServerPluginService.masterConfig.getPluginDirectory().mkdirs();
        this.deleteDriftFiles();
        this.newResource = this.createNewResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterMethod() throws Exception {
        try {
            this.deleteNewResource(this.newResource);
        }
        finally {
            this.unprepareServerPluginService();
            this.unprepareForTestAgents();
            this.unprepareScheduler();
        }
    }

    @Test
    public void testStoreChangeSet() throws Exception {
        File rootDir = this.getTempDir();
        File changeSetsDir = new File(rootDir, "changesets");
        FileUtils.deleteDirectory((File)changeSetsDir);
        changeSetsDir.mkdirs();
        Headers headers = new Headers();
        headers.setResourceId(this.newResource.getId());
        headers.setDriftDefinitionId(1);
        headers.setDriftDefinitionName("test-1");
        headers.setBasedir(rootDir.getAbsolutePath());
        headers.setType(DriftChangeSetCategory.COVERAGE);
        headers.setVersion(0);
        String file1Hash = this.sha256("test-1-file-1");
        File changeSet1 = new File(changeSetsDir, "changeset-1.txt");
        ChangeSetWriterImpl writer = new ChangeSetWriterImpl(changeSet1, headers);
        writer.write(FileEntry.addedFileEntry((String)"test/file-1", (String)file1Hash, (Long)56789L, (Long)1024L));
        writer.close();
        File changeSet1Zip = new File(changeSetsDir, "changeset-1.zip");
        ZipUtil.zipFileOrDirectory((File)changeSet1, (File)changeSet1Zip);
        this.assertTrue("Expected to find change set zip file: " + changeSet1Zip.getPath(), changeSet1Zip.exists());
        this.jpaDriftServer.storeChangeSet(this.overlord, this.newResource.getId(), changeSet1Zip);
        JPADriftChangeSetCriteria c = new JPADriftChangeSetCriteria();
        c.addFilterResourceId(Integer.valueOf(this.newResource.getId()));
        c.fetchDrifts(true);
        PageList changeSets = this.jpaDriftServer.findDriftChangeSetsByCriteria(this.overlord, (DriftChangeSetCriteria)c);
        this.assertEquals(1, changeSets.size());
        DriftChangeSet changeSet = (DriftChangeSet)changeSets.get(0);
        this.assertEquals(0, changeSet.getVersion());
        this.assertEquals("Expected to find one entry in change set", 1, changeSet.getDrifts().size());
        JPADriftFile driftFile = this.jpaDriftServer.getDriftFile(this.overlord, file1Hash);
        this.assertNotNull(driftFile);
        this.assertEquals(DriftFileStatus.REQUESTED, driftFile.getStatus());
        String modifiedFile1Hash = this.sha256("test-2-file-1-modified");
        headers.setType(DriftChangeSetCategory.DRIFT);
        headers.setVersion(1);
        File changeSet2 = new File(changeSetsDir, "changeset-2.txt");
        writer = new ChangeSetWriterImpl(changeSet2, headers);
        writer.write(FileEntry.changedFileEntry((String)"test/file-1", (String)file1Hash, (String)modifiedFile1Hash, (Long)56789L, (Long)1024L));
        writer.close();
        File changeSet2Zip = new File(changeSetsDir, "changeset-2.zip");
        ZipUtil.zipFileOrDirectory((File)changeSet2, (File)changeSet2Zip);
        this.assertTrue("Expected to find change set file: " + changeSet2Zip.getPath(), changeSet2Zip.exists());
        this.jpaDriftServer.storeChangeSet(this.overlord, this.newResource.getId(), changeSet2Zip);
        c.addSortVersion(PageOrdering.ASC);
        c.addFilterCategory(DriftChangeSetCategory.DRIFT);
        changeSets = this.jpaDriftServer.findDriftChangeSetsByCriteria(this.overlord, (DriftChangeSetCriteria)c);
        this.assertEquals(1, changeSets.size());
        changeSet = (DriftChangeSet)changeSets.get(0);
        this.assertEquals("The change set version is wrong", 1, changeSet.getVersion());
        this.assertEquals("Expected to find one entry in change set", 1, changeSet.getDrifts().size());
        changeSet = (DriftChangeSet)changeSets.get(0);
        this.assertEquals(1, changeSet.getVersion());
        this.assertEquals(1, changeSet.getDrifts().size());
        Drift drift = (Drift)changeSet.getDrifts().iterator().next();
        this.assertEquals("test/file-1", drift.getPath());
        this.assertEquals(file1Hash, drift.getOldDriftFile().getHashId());
        this.assertEquals(modifiedFile1Hash, drift.getNewDriftFile().getHashId());
        this.assertEquals(DriftCategory.FILE_CHANGED, drift.getCategory());
        driftFile = this.jpaDriftServer.getDriftFile(this.overlord, modifiedFile1Hash);
        this.assertNotNull(driftFile);
        this.assertEquals(DriftFileStatus.REQUESTED, driftFile.getStatus());
    }

    @Test
    public void testDriftDef() throws Exception {
        Configuration config = new Configuration();
        DriftDefinition driftDefPojo = new DriftDefinition(config);
        driftDefPojo.setName("testDriftDef");
        driftDefPojo.setInterval(Long.valueOf(60L));
        driftDefPojo.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "foo/bar"));
        this.driftManager.updateDriftDefinition(this.overlord, EntityContext.forResource((int)this.newResource.getId()), driftDefPojo);
        DriftDefinitionCriteria c = new DriftDefinitionCriteria();
        c.addFilterResourceIds(new Integer[]{this.newResource.getId()});
        c.fetchConfiguration(Boolean.valueOf(true));
        PageList driftDefs = this.driftManager.findDriftDefinitionsByCriteria(this.overlord, c);
        this.assertNotNull(driftDefs);
        this.assertEquals(3, driftDefs.size());
        DriftDefinition driftDef2 = null;
        for (DriftDefinition driftDef2 : driftDefs) {
            if (!driftDefPojo.getName().equals(driftDef2.getName())) continue;
        }
        this.assertTrue(driftDef2.getConfiguration().getId() > 0);
        this.assertEquals(driftDefPojo.getName(), driftDef2.getName());
        this.assertEquals(driftDefPojo.getBasedir(), driftDef2.getBasedir());
        this.assertEquals(driftDefPojo.getInterval(), driftDef2.getInterval());
        driftDefPojo.setInterval(Long.valueOf(120L));
        this.driftManager.updateDriftDefinition(this.overlord, EntityContext.forResource((int)this.newResource.getId()), driftDefPojo);
        driftDefs = this.driftManager.findDriftDefinitionsByCriteria(this.overlord, c);
        this.assertNotNull(driftDefs);
        this.assertEquals(3, driftDefs.size());
        driftDef2 = null;
        for (DriftDefinition driftDef2 : driftDefs) {
            if (!driftDefPojo.getName().equals(driftDef2.getName())) continue;
        }
        this.assertEquals(driftDefPojo.getName(), driftDef2.getName());
        this.assertTrue(driftDef2.getConfiguration().getId() > 0);
        this.assertEquals(driftDefPojo.getBasedir(), driftDef2.getBasedir());
        this.assertEquals(120L, driftDef2.getInterval());
        driftDefPojo = new DriftDefinition(driftDef2.getConfiguration().deepCopyWithoutProxies());
        driftDefPojo.setName("testDriftDef-2");
        driftDefPojo.setInterval(Long.valueOf(30L));
        driftDefPojo.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "foo/baz"));
        this.driftManager.updateDriftDefinition(this.overlord, EntityContext.forResource((int)this.newResource.getId()), driftDefPojo);
        driftDefs = this.driftManager.findDriftDefinitionsByCriteria(this.overlord, c);
        this.assertNotNull(driftDefs);
        this.assertEquals(4, driftDefs.size());
        for (DriftDefinition driftDef2 : driftDefs) {
            if ("testDriftDef".equals(driftDef2.getName())) {
                this.assertTrue(driftDef2.getConfiguration().getId() > 0);
                this.assertEquals("foo/bar", driftDef2.getBasedir().getValueName());
                this.assertEquals(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, driftDef2.getBasedir().getValueContext());
                this.assertEquals(120L, driftDef2.getInterval());
                continue;
            }
            if ("testDriftDef-2".equals(driftDef2.getName())) {
                this.assertTrue(driftDef2.getConfiguration().getId() > 0);
                this.assertEquals(driftDefPojo.getBasedir(), driftDef2.getBasedir());
                this.assertEquals(driftDefPojo.getInterval(), driftDef2.getInterval());
                continue;
            }
            if ("test-1".equals(driftDef2.getName()) || "test-2".equals(driftDef2.getName())) continue;
            this.fail("Unexpected drift def name: " + driftDef2.getName());
        }
        this.driftManager.deleteDriftDefinition(this.overlord, EntityContext.forResource((int)this.newResource.getId()), "testDriftDef");
        driftDefs = this.driftManager.findDriftDefinitionsByCriteria(this.overlord, c);
        this.assertNotNull(driftDefs);
        this.assertEquals(3, driftDefs.size());
        for (DriftDefinition driftDef2 : driftDefs) {
            if (!driftDefPojo.getName().equals(driftDef2.getName())) continue;
        }
        this.assertTrue(driftDef2.getConfiguration().getId() > 0);
        this.assertEquals(driftDefPojo.getName(), driftDef2.getName());
        this.assertEquals(driftDefPojo.getBasedir(), driftDef2.getBasedir());
        this.assertEquals(driftDefPojo.getInterval(), driftDef2.getInterval());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDriftFiles() throws Exception {
        this.getTransactionManager().begin();
        try {
            int i = 0;
            int numDeleted = 1;
            while (numDeleted > 0) {
                numDeleted = this.getEntityManager().createQuery("delete from JPADriftFile where hash_id = '" + i + "'").executeUpdate();
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("CANNOT PREPARE TEST: " + e);
            this.getTransactionManager().rollback();
            throw e;
        }
        this.em.flush();
        this.getTransactionManager().commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource createNewResource() throws Exception {
        Resource resource;
        this.getTransactionManager().begin();
        try {
            ResourceType resourceType = new ResourceType("plat" + System.currentTimeMillis(), "test", ResourceCategory.PLATFORM, null);
            DriftDefinitionTemplate template = new DriftDefinitionTemplate();
            template.setName("test-template");
            DriftDefinition templateDef = new DriftDefinition(new Configuration());
            templateDef.setName("test-template-def");
            template.setTemplateDefinition(templateDef);
            template.setUserDefined(true);
            resourceType.addDriftDefinitionTemplate(template);
            this.em.persist((Object)resourceType);
            Agent agent = new Agent("testagent", "testaddress", 1, "", "testtoken");
            this.em.persist((Object)agent);
            this.em.flush();
            DriftDefinition test1Def = new DriftDefinition(new Configuration());
            test1Def.setName("test-1");
            DriftDefinition test2Def = new DriftDefinition(new Configuration());
            test2Def.setName("test-2");
            resource = new Resource("reskey" + System.currentTimeMillis(), "resname", resourceType);
            resource.setUuid("" + new Random().nextInt());
            resource.setAgent(agent);
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
            resource.addDriftDefinition(test1Def);
            resource.addDriftDefinition(test2Def);
            this.em.persist((Object)resource);
        }
        catch (Exception e) {
            System.out.println("CANNOT PREPARE TEST: " + e);
            this.getTransactionManager().rollback();
            throw e;
        }
        this.em.flush();
        this.getTransactionManager().commit();
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNewResource(Resource resource) throws Exception {
        if (null != resource) {
            try {
                ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
                List deletedIds = resourceManager.uninventoryResource(this.overlord, resource.getId());
                for (Integer deletedResourceId : deletedIds) {
                    resourceManager.uninventoryResourceAsyncWork(this.overlord, deletedResourceId.intValue());
                }
                this.getTransactionManager().begin();
                ResourceType type = (ResourceType)this.em.find(ResourceType.class, (Object)resource.getResourceType().getId());
                Agent agent = (Agent)this.em.find(Agent.class, (Object)resource.getAgent().getId());
                if (null != agent) {
                    this.em.remove((Object)agent);
                }
                if (null != type) {
                    this.em.remove((Object)type);
                }
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                try {
                    System.out.println("CANNOT CLEAN UP TEST (" + ((Object)((Object)this)).getClass().getSimpleName() + ")");
                    e.printStackTrace();
                    this.getTransactionManager().rollback();
                }
                catch (Exception exception) {}
            }
        }
    }

    String sha256(String s) throws Exception {
        return this.digestGenerator.calcDigestString(s);
    }
}

