/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.drift;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.criteria.DriftChangeSetCriteria;
import org.rhq.core.domain.criteria.DriftDefinitionCriteria;
import org.rhq.core.domain.criteria.DriftDefinitionTemplateCriteria;
import org.rhq.core.domain.criteria.GenericDriftChangeSetCriteria;
import org.rhq.core.domain.criteria.JPADriftChangeSetCriteria;
import org.rhq.core.domain.drift.DriftCategory;
import org.rhq.core.domain.drift.DriftChangeSet;
import org.rhq.core.domain.drift.DriftChangeSetCategory;
import org.rhq.core.domain.drift.DriftConfigurationDefinition;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionComparator;
import org.rhq.core.domain.drift.DriftDefinitionTemplate;
import org.rhq.core.domain.drift.DriftSnapshot;
import org.rhq.core.domain.drift.Filter;
import org.rhq.core.domain.drift.JPADrift;
import org.rhq.core.domain.drift.JPADriftChangeSet;
import org.rhq.core.domain.drift.JPADriftFile;
import org.rhq.core.domain.drift.JPADriftSet;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.drift.AbstractDriftServerTest;
import org.rhq.enterprise.server.drift.DriftManagerLocal;
import org.rhq.enterprise.server.drift.DriftTemplateManagerLocal;
import org.rhq.enterprise.server.drift.TestDefService;
import org.rhq.enterprise.server.safeinvoker.HibernateDetachUtility;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.test.AssertUtils;
import org.testng.annotations.Test;

public class DriftTemplateManagerBeanTest
extends AbstractDriftServerTest {
    private static final String drift1Path = "drift.1";
    private static final String drift2Path = "drift.2";
    private final String TEST_CREATE_TEMPLATE;
    private final String TEST_PIN_TEMPLATE;
    private final String driftFile1Hash;
    private final String driftFile2Hash;
    private DriftTemplateManagerLocal templateMgr;
    private DriftManagerLocal driftMgr;
    private JPADrift drift1;
    private JPADrift drift2;
    private JPADriftFile driftFile1;
    private JPADriftFile driftFile2;

    public DriftTemplateManagerBeanTest() {
        this.TEST_CREATE_TEMPLATE = this.NAME_PREFIX + "createTemplateForNegativeUpdateTests";
        this.TEST_PIN_TEMPLATE = this.NAME_PREFIX + "pinTemplate";
        this.driftFile1Hash = this.NAME_PREFIX + "a1b2c3";
        this.driftFile2Hash = this.NAME_PREFIX + "1a2b3c";
    }

    @Override
    protected void beforeMethod(Method testMethod) throws Exception {
        super.beforeMethod(testMethod);
        this.templateMgr = LookupUtil.getDriftTemplateManager();
        this.driftMgr = LookupUtil.getDriftManager();
    }

    @Override
    protected void initDB() throws Exception {
        super.initDB();
        this.agentServiceContainer.driftService = new TestDefService(){

            @Override
            public void unscheduleDriftDetection(int resourceId, DriftDefinition driftDef) {
                this.detach(driftDef);
            }

            @Override
            public void updateDriftDetection(int resourceId, DriftDefinition driftDef) {
                this.detach(driftDef);
            }

            @Override
            public void updateDriftDetection(int resourceId, DriftDefinition driftDef, DriftSnapshot driftSnapshot) {
                this.detach(driftDef);
                this.detach(driftSnapshot);
            }

            private void detach(Object object) {
                try {
                    HibernateDetachUtility.nullOutUninitializedFields((Object)object, (HibernateDetachUtility.SerializationType)HibernateDetachUtility.SerializationType.SERIALIZATION);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Test(dependsOnGroups={"pinning"})
    public void createNewTemplate() {
        final DriftDefinition definition = new DriftDefinition(new Configuration());
        definition.setName(this.NAME_PREFIX + "createNewTemplate");
        definition.setEnabled(Boolean.valueOf(true));
        definition.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        definition.setInterval(Long.valueOf(2400L));
        definition.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/foo/bar/test"));
        final DriftDefinitionTemplate newTemplate = this.templateMgr.createTemplate(this.getOverlord(), this.resourceType.getId(), true, definition);
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                ResourceType updatedType = (ResourceType)DriftTemplateManagerBeanTest.this.em.find(ResourceType.class, (Object)DriftTemplateManagerBeanTest.this.resourceType.getId());
                DriftTemplateManagerBeanTest.this.assertEquals("Failed to add new drift definition to resource type", 1, updatedType.getDriftDefinitionTemplates().size());
                DriftDefinitionTemplate expectedTemplate = new DriftDefinitionTemplate();
                expectedTemplate.setTemplateDefinition(definition);
                expectedTemplate.setUserDefined(true);
                DriftTemplateManagerBeanTest.this.assertDriftTemplateEquals("Failed to save template", expectedTemplate, newTemplate);
                DriftTemplateManagerBeanTest.this.assertTrue("The template should have its id set", newTemplate.getId() > 0);
            }
        });
    }

    @Test(groups={"negativeUpdate"})
    public void consolidatedNegativeUpdatesTest() {
        block14: {
            String msg;
            String testMethod;
            String testClass;
            block13: {
                block12: {
                    block11: {
                        block10: {
                            testClass = "Running Test: " + ((Object)((Object)this)).getClass().getSimpleName() + ".";
                            testMethod = "createTemplateForNegativeUpdateTests()";
                            System.out.println(testClass + testMethod);
                            this.createTemplateForNegativeUpdateTests();
                            testMethod = "createTemplateForNegativeUpdateTests()";
                            System.out.println(testClass + testMethod);
                            try {
                                this.doNotAllowBaseDirToBeUpdated();
                                this.fail(testMethod + ": Should have thrown exception");
                            }
                            catch (Exception e) {
                                msg = e.getMessage();
                                if (msg.matches(".*base directory.*cannot be modified")) break block10;
                                this.fail(testMethod + ": Wrong Exception: " + e.getMessage());
                            }
                        }
                        testMethod = "doNotAllowBaseDirToBeUpdated()";
                        System.out.println(testClass + testMethod);
                        try {
                            this.doNotAllowBaseDirToBeUpdated();
                            this.fail(testMethod + ": Should have thrown exception");
                        }
                        catch (Exception e) {
                            msg = e.getMessage();
                            if (msg.matches(".*base directory.*cannot be modified")) break block11;
                            this.fail(testMethod + ": Wrong Exception: " + e.getMessage());
                        }
                    }
                    testMethod = "doNotAllowFiltersToBeUpdated()";
                    System.out.println(testClass + testMethod);
                    try {
                        this.doNotAllowFiltersToBeUpdated();
                        this.fail(testMethod + ": Should have thrown exception");
                    }
                    catch (Exception e) {
                        msg = e.getMessage();
                        if (msg.matches(".*filters.*cannot be modified")) break block12;
                        this.fail(testMethod + ": Wrong Exception: " + e.getMessage());
                    }
                }
                testMethod = "doNotAllowTemplateNameToBeUpdated()";
                System.out.println(testClass + testMethod);
                try {
                    this.doNotAllowTemplateNameToBeUpdated();
                    this.fail(testMethod + ": Should have thrown exception");
                }
                catch (Exception e) {
                    msg = e.getMessage();
                    if (msg.matches(".*name.*cannot be modified")) break block13;
                    this.fail(testMethod + ": Wrong Exception: " + e.getMessage());
                }
            }
            testMethod = "doNotAllowDuplicateTemplateNames()";
            System.out.println(testClass + testMethod);
            try {
                this.doNotAllowDuplicateTemplateNames();
                this.fail(testMethod + ": Should have thrown exception");
            }
            catch (Exception e) {
                msg = e.getMessage();
                if (msg.matches(".*template name must be unique.*")) break block14;
                this.fail(testMethod + ": Wrong Exception: " + e.getMessage());
            }
        }
    }

    private void createTemplateForNegativeUpdateTests() {
        DriftDefinition definition = new DriftDefinition(new Configuration());
        definition.setName(this.TEST_CREATE_TEMPLATE);
        definition.setEnabled(Boolean.valueOf(true));
        definition.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        definition.setInterval(Long.valueOf(2400L));
        definition.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/foo/bar/test"));
        this.templateMgr.createTemplate(this.getOverlord(), this.resourceType.getId(), true, definition);
        DriftDefinitionTemplate template = this.loadTemplate(definition.getName());
        this.assertNotNull("Failed to load template", template);
    }

    private void doNotAllowBaseDirToBeUpdated() {
        DriftDefinitionTemplate template = this.loadTemplate(this.TEST_CREATE_TEMPLATE);
        DriftDefinition definition = template.getTemplateDefinition();
        definition.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/foo/bar/TEST"));
        this.templateMgr.updateTemplate(this.getOverlord(), template);
    }

    private void doNotAllowFiltersToBeUpdated() {
        DriftDefinitionTemplate template = this.loadTemplate(this.TEST_CREATE_TEMPLATE);
        DriftDefinition definition = template.getTemplateDefinition();
        definition.addExclude(new Filter("/foo/bar/TEST/conf", "*.xml"));
        this.templateMgr.updateTemplate(this.getOverlord(), template);
    }

    private void doNotAllowTemplateNameToBeUpdated() {
        DriftDefinitionTemplate template = this.loadTemplate(this.TEST_CREATE_TEMPLATE);
        template.setName(this.NAME_PREFIX + "A new name");
        this.templateMgr.updateTemplate(this.getOverlord(), template);
    }

    private void doNotAllowDuplicateTemplateNames() {
        DriftDefinition definition = new DriftDefinition(new Configuration());
        definition.setName(this.TEST_CREATE_TEMPLATE);
        definition.setEnabled(Boolean.valueOf(true));
        definition.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        definition.setInterval(Long.valueOf(2400L));
        definition.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/foo/bar/test"));
        this.templateMgr.createTemplate(this.getOverlord(), this.resourceType.getId(), true, definition);
    }

    @Test(dependsOnGroups={"pinning"})
    public void createAndUpdateTemplate() {
        String msg;
        DriftDefinition definition = new DriftDefinition(new Configuration());
        definition.setName(this.NAME_PREFIX + "test-updateTemplate");
        definition.setDescription("update template test");
        definition.setEnabled(Boolean.valueOf(true));
        definition.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        definition.setInterval(Long.valueOf(2400L));
        definition.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/foo/bar/test"));
        DriftDefinitionTemplate template = this.templateMgr.createTemplate(this.getOverlord(), this.resourceType.getId(), true, definition);
        DriftDefinition attachedDef1 = this.createDefinition(template, this.NAME_PREFIX + "attachedDef1", true);
        DriftDefinition attachedDef2 = this.createDefinition(template, this.NAME_PREFIX + "attachedDef2", true);
        DriftDefinition detachedDef1 = this.createDefinition(template, this.NAME_PREFIX + "detachedDef1", false);
        DriftDefinition detachedDef2 = this.createDefinition(template, this.NAME_PREFIX + "detachedDef2", false);
        this.driftMgr.updateDriftDefinition(this.getOverlord(), EntityContext.forResource((int)this.resource.getId()), attachedDef1);
        this.driftMgr.updateDriftDefinition(this.getOverlord(), EntityContext.forResource((int)this.resource.getId()), attachedDef2);
        this.driftMgr.updateDriftDefinition(this.getOverlord(), EntityContext.forResource((int)this.resource.getId()), detachedDef1);
        this.driftMgr.updateDriftDefinition(this.getOverlord(), EntityContext.forResource((int)this.resource.getId()), detachedDef2);
        DriftDefinition newTemplateDef = template.getTemplateDefinition();
        newTemplateDef.setInterval(Long.valueOf(4800L));
        newTemplateDef.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.plannedChanges);
        newTemplateDef.setEnabled(Boolean.valueOf(false));
        this.templateMgr.updateTemplate(this.getOverlord(), template);
        DriftDefinitionTemplate updatedTemplate = this.loadTemplate(template.getName());
        AssertUtils.assertPropertiesMatch((String)"Failed to update template", (Object)template, (Object)updatedTemplate, (String[])new String[]{"resourceType", "driftDefinitions", "templateDefinition"});
        for (DriftDefinition def : Arrays.asList(attachedDef1, attachedDef2)) {
            DriftDefinition updatedDef = this.loadDefinition(def.getId());
            msg = "Failed to propagate update to attached definition " + this.toString(updatedDef) + " - ";
            DriftDefinition updatedTemplateDef = updatedTemplate.getTemplateDefinition();
            this.assertEquals(msg + "enabled property not updated", updatedTemplateDef.isEnabled(), updatedDef.isEnabled());
            this.assertEquals(msg + "driftHandlingMode property not updated", updatedTemplateDef.getDriftHandlingMode(), updatedDef.getDriftHandlingMode());
            this.assertEquals(msg + "interval property not updated", updatedTemplateDef.getInterval(), updatedDef.getInterval());
        }
        for (DriftDefinition def : Arrays.asList(detachedDef1, detachedDef2)) {
            DriftDefinition defAfterUpdate = this.loadDefinition(def.getId());
            msg = "Detached definition " + this.toString(def) + " should not get updated - ";
            this.assertEquals(msg + "enabled property was modified", def.isEnabled(), defAfterUpdate.isEnabled());
            this.assertEquals(msg + "driftHandlingMode property was modified", def.getDriftHandlingMode(), defAfterUpdate.getDriftHandlingMode());
            this.assertEquals(msg + "interval property was modified", def.getInterval(), defAfterUpdate.getInterval());
        }
    }

    @Test(groups={"pinning"}, dependsOnGroups={"negativeUpdate"})
    public void consolidatedPinningTest() throws Exception {
        String testClass = "Running Test: " + ((Object)((Object)this)).getClass().getSimpleName() + ".";
        String testMethod = "pinTemplate()";
        System.out.println(testClass + testMethod);
        this.pinTemplate();
        testMethod = "persistChangeSetWhenTemplateGetsPinned()";
        System.out.println(testClass + testMethod);
        this.persistChangeSetWhenTemplateGetsPinned();
        testMethod = "updateAttachedDefinitionsWhenTemplateGetsPinned()";
        System.out.println(testClass + testMethod);
        this.updateAttachedDefinitionsWhenTemplateGetsPinned();
        testMethod = "doNotUpdateDetachedDefinitionsWhenTemplateGetsPinned()";
        System.out.println(testClass + testMethod);
        this.doNotUpdateDetachedDefinitionsWhenTemplateGetsPinned();
    }

    private void pinTemplate() throws Exception {
        DriftDefinition templateDef = new DriftDefinition(new Configuration());
        templateDef.setName(this.TEST_PIN_TEMPLATE);
        templateDef.setEnabled(Boolean.valueOf(true));
        templateDef.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        templateDef.setInterval(Long.valueOf(2400L));
        templateDef.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/foo/bar/test"));
        DriftDefinitionTemplate template = this.templateMgr.createTemplate(this.getOverlord(), this.resourceType.getId(), true, templateDef);
        final DriftDefinition attachedDef1 = this.createDefinition(template, this.NAME_PREFIX + "attachedDef1", true);
        final DriftDefinition attachedDef2 = this.createDefinition(template, this.NAME_PREFIX + "attachedDef2", true);
        final DriftDefinition detachedDef1 = this.createDefinition(template, this.NAME_PREFIX + "detachedDef1", false);
        final DriftDefinition detachedDef2 = this.createDefinition(template, this.NAME_PREFIX + "detachedDef2", false);
        final JPADriftChangeSet changeSet0 = new JPADriftChangeSet(this.resource, 0, DriftChangeSetCategory.COVERAGE, attachedDef1);
        this.driftFile1 = new JPADriftFile(this.driftFile1Hash);
        this.drift1 = new JPADrift(changeSet0, drift1Path, DriftCategory.FILE_ADDED, null, this.driftFile1);
        final JPADriftSet driftSet = new JPADriftSet();
        driftSet.addDrift(this.drift1);
        this.driftFile2 = new JPADriftFile(this.driftFile2Hash);
        final JPADriftChangeSet changeSet1 = new JPADriftChangeSet(this.resource, 1, DriftChangeSetCategory.DRIFT, attachedDef1);
        this.drift2 = new JPADrift(changeSet1, drift2Path, DriftCategory.FILE_ADDED, null, this.driftFile2);
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                DriftTemplateManagerBeanTest.this.em.persist((Object)attachedDef1);
                DriftTemplateManagerBeanTest.this.em.persist((Object)DriftTemplateManagerBeanTest.this.driftFile1);
                DriftTemplateManagerBeanTest.this.em.persist((Object)DriftTemplateManagerBeanTest.this.driftFile2);
                DriftTemplateManagerBeanTest.this.em.persist((Object)changeSet0);
                DriftTemplateManagerBeanTest.this.em.persist((Object)driftSet);
                changeSet0.setInitialDriftSet(driftSet);
                DriftTemplateManagerBeanTest.this.em.merge((Object)changeSet0);
                DriftTemplateManagerBeanTest.this.em.persist((Object)changeSet1);
                DriftTemplateManagerBeanTest.this.em.persist((Object)DriftTemplateManagerBeanTest.this.drift2);
                DriftTemplateManagerBeanTest.this.em.persist((Object)attachedDef2);
                DriftTemplateManagerBeanTest.this.em.persist((Object)detachedDef1);
                DriftTemplateManagerBeanTest.this.em.persist((Object)detachedDef2);
            }
        });
        this.templateMgr.pinTemplate(this.getOverlord(), template.getId(), attachedDef1.getId(), 1);
        DriftDefinitionTemplate updatedTemplate = this.loadTemplate(template.getName());
        this.assertTrue("Template should be marked pinned", updatedTemplate.isPinned());
    }

    private void persistChangeSetWhenTemplateGetsPinned() throws Exception {
        DriftDefinitionTemplate template = this.loadTemplate(this.TEST_PIN_TEMPLATE);
        GenericDriftChangeSetCriteria criteria = new GenericDriftChangeSetCriteria();
        criteria.addFilterId(template.getChangeSetId());
        PageList changeSets = this.driftMgr.findDriftChangeSetsByCriteria(this.getOverlord(), (DriftChangeSetCriteria)criteria);
        this.assertEquals("Expected to find change set for pinned template", 1, changeSets.size());
        JPADriftChangeSet expectedChangeSet = new JPADriftChangeSet(this.resource, 1, DriftChangeSetCategory.COVERAGE, null);
        List<JPADrift> expectedDrifts = Arrays.asList(new JPADrift(expectedChangeSet, drift1Path, DriftCategory.FILE_ADDED, null, this.driftFile1), new JPADrift(expectedChangeSet, this.drift2.getPath(), DriftCategory.FILE_ADDED, null, this.driftFile2));
        DriftChangeSet actualChangeSet = (DriftChangeSet)changeSets.get(0);
        ArrayList actualDrifts = new ArrayList(actualChangeSet.getDrifts());
        AssertUtils.assertCollectionMatchesNoOrder((String)"Expected to find drifts from change sets 1 and 2 in the template change set", expectedDrifts, actualDrifts, (String[])new String[]{"id", "ctime", "changeSet", "newDriftFile"});
        AssertUtils.assertPropertiesMatch((Object)this.drift1.getNewDriftFile(), (Object)this.findDriftByPath(actualDrifts, drift1Path).getNewDriftFile(), (String)("The newDriftFile property was not set correctly for " + this.drift1));
        AssertUtils.assertPropertiesMatch((Object)this.drift2.getNewDriftFile(), (Object)this.findDriftByPath(actualDrifts, drift2Path).getNewDriftFile(), (String)("The newDriftFile property was not set correctly for " + this.drift1));
    }

    private void updateAttachedDefinitionsWhenTemplateGetsPinned() throws Exception {
        DriftDefinitionTemplate template = this.loadTemplate(this.TEST_PIN_TEMPLATE);
        LinkedList<DriftDefinition> attachedDefs = new LinkedList<DriftDefinition>();
        for (DriftDefinition d : template.getDriftDefinitions()) {
            if (!d.isAttached() || !d.getName().equals(this.NAME_PREFIX + "attachedDef1") && !d.getName().equals(this.NAME_PREFIX + "attachedDef2")) continue;
            attachedDefs.add(d);
        }
        this.assertEquals("Failed to get attached definitions for " + this.toString(template), 2, attachedDefs.size());
        this.assertDefinitionIsPinned((DriftDefinition)attachedDefs.get(0));
        this.assertDefinitionIsPinned((DriftDefinition)attachedDefs.get(1));
    }

    private void doNotUpdateDetachedDefinitionsWhenTemplateGetsPinned() throws Exception {
        DriftDefinitionTemplate template = this.loadTemplate(this.TEST_PIN_TEMPLATE);
        LinkedList<DriftDefinition> detachedDefs = new LinkedList<DriftDefinition>();
        for (DriftDefinition d : template.getDriftDefinitions()) {
            if (d.isAttached() || !d.getName().equals(this.NAME_PREFIX + "detachedDef1") && !d.getName().equals(this.NAME_PREFIX + "detachedDef2")) continue;
            detachedDefs.add(d);
        }
        this.assertEquals("Failed to get detached definitions for " + this.toString(template), 2, detachedDefs.size());
        this.assertDefinitionIsNotPinned((DriftDefinition)detachedDefs.get(0));
        this.assertDefinitionIsNotPinned((DriftDefinition)detachedDefs.get(1));
    }

    @Test(dependsOnGroups={"pinning"})
    public void deleteTemplate() throws Exception {
        DriftDefinition templateDef = new DriftDefinition(new Configuration());
        templateDef.setName(this.TEST_PIN_TEMPLATE);
        templateDef.setEnabled(Boolean.valueOf(true));
        templateDef.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        templateDef.setInterval(Long.valueOf(2400L));
        templateDef.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/foo/bar/test"));
        DriftDefinitionTemplate template = this.templateMgr.createTemplate(this.getOverlord(), this.resourceType.getId(), true, templateDef);
        final DriftDefinition attachedDef1 = this.createDefinition(template, this.NAME_PREFIX + "attachedDef1", true);
        final DriftDefinition attachedDef2 = this.createDefinition(template, this.NAME_PREFIX + "attachedDef2", true);
        final DriftDefinition detachedDef1 = this.createDefinition(template, this.NAME_PREFIX + "detachedDef1", false);
        final DriftDefinition detachedDef2 = this.createDefinition(template, this.NAME_PREFIX + "detachedDef2", false);
        final JPADriftChangeSet changeSet0 = new JPADriftChangeSet(this.resource, 0, DriftChangeSetCategory.COVERAGE, attachedDef1);
        this.driftFile1 = new JPADriftFile(this.driftFile1Hash);
        this.drift1 = new JPADrift(changeSet0, drift1Path, DriftCategory.FILE_ADDED, null, this.driftFile1);
        final JPADriftSet driftSet0 = new JPADriftSet();
        driftSet0.addDrift(this.drift1);
        final JPADriftChangeSet changeSet1 = new JPADriftChangeSet(this.resource, 0, DriftChangeSetCategory.DRIFT, detachedDef1);
        this.driftFile2 = new JPADriftFile(this.driftFile2Hash);
        this.drift2 = new JPADrift(changeSet1, drift2Path, DriftCategory.FILE_ADDED, null, this.driftFile2);
        final JPADriftSet driftSet1 = new JPADriftSet();
        driftSet1.addDrift(this.drift2);
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                DriftTemplateManagerBeanTest.this.em.persist((Object)attachedDef1);
                DriftTemplateManagerBeanTest.this.em.persist((Object)attachedDef2);
                DriftTemplateManagerBeanTest.this.em.persist((Object)detachedDef1);
                DriftTemplateManagerBeanTest.this.em.persist((Object)detachedDef2);
                DriftTemplateManagerBeanTest.this.em.persist((Object)DriftTemplateManagerBeanTest.this.driftFile1);
                DriftTemplateManagerBeanTest.this.em.persist((Object)DriftTemplateManagerBeanTest.this.driftFile2);
                DriftTemplateManagerBeanTest.this.em.persist((Object)changeSet0);
                DriftTemplateManagerBeanTest.this.em.persist((Object)driftSet0);
                changeSet0.setInitialDriftSet(driftSet0);
                DriftTemplateManagerBeanTest.this.em.merge((Object)changeSet0);
                DriftTemplateManagerBeanTest.this.em.persist((Object)changeSet1);
                DriftTemplateManagerBeanTest.this.em.persist((Object)driftSet1);
                changeSet1.setInitialDriftSet(driftSet1);
                DriftTemplateManagerBeanTest.this.em.merge((Object)changeSet1);
            }
        });
        this.templateMgr.deleteTemplate(this.getOverlord(), template.getId());
        this.assertNull("Change sets belonging to attached definitions should be deleted", this.loadChangeSet(changeSet0.getId()));
        this.assertNull("Attached definition " + this.toString(attachedDef1) + " should be deleted", this.loadDefinition(attachedDef1.getId()));
        this.assertNull("Attached definition " + this.toString(attachedDef2) + " should be deleted", this.loadDefinition(attachedDef2.getId()));
        this.assertNotNull("Change sets belonging to detached definitions should not be deleted", this.loadChangeSet(changeSet1.getId()));
        this.assertDetachedDefinitionNotDeleted(detachedDef1.getId());
        this.assertDetachedDefinitionNotDeleted(detachedDef2.getId());
        this.assertNull("The template " + this.toString(template) + " should have been deleted", this.loadTemplate(template.getName(), false));
    }

    private void assertDefinitionIsPinned(DriftDefinition definition) throws Exception {
        this.assertTrue("Expected " + this.toString(definition) + " to be pinned", definition.isPinned());
        JPADriftChangeSetCriteria criteria = new JPADriftChangeSetCriteria();
        criteria.addFilterDriftDefinitionId(Integer.valueOf(definition.getId()));
        criteria.addFilterCategory(DriftChangeSetCategory.COVERAGE);
        criteria.fetchDrifts(true);
        PageList changeSets = this.driftMgr.findDriftChangeSetsByCriteria(this.getOverlord(), (DriftChangeSetCriteria)criteria);
        this.assertEquals("Expected to find one change set", 1, changeSets.size());
        JPADriftChangeSet expectedChangeSet = new JPADriftChangeSet(this.resource, 1, DriftChangeSetCategory.COVERAGE, null);
        List<JPADrift> expectedDrifts = Arrays.asList(new JPADrift(expectedChangeSet, this.drift1.getPath(), DriftCategory.FILE_ADDED, null, this.driftFile1), new JPADrift(expectedChangeSet, this.drift2.getPath(), DriftCategory.FILE_ADDED, null, this.driftFile2));
        DriftChangeSet actualChangeSet = (DriftChangeSet)changeSets.get(0);
        ArrayList actualDrifts = new ArrayList(actualChangeSet.getDrifts());
        AssertUtils.assertCollectionMatchesNoOrder((String)"Expected to find drifts from change sets 1 and 2 in the template change set", expectedDrifts, actualDrifts, (String[])new String[]{"id", "ctime", "changeSet", "newDriftFile"});
        criteria = new JPADriftChangeSetCriteria();
        criteria.addFilterStartVersion(Integer.valueOf(1));
        criteria.addFilterDriftDefinitionId(Integer.valueOf(definition.getId()));
        this.assertEquals("There should not be any drift change sets", 0, this.driftMgr.findDriftChangeSetsByCriteria(this.getOverlord(), (DriftChangeSetCriteria)criteria).size());
    }

    private void assertDefinitionIsNotPinned(DriftDefinition definition) throws Exception {
        this.assertFalse("Expected " + this.toString(definition) + " to be unpinned", definition.isPinned());
        JPADriftChangeSetCriteria criteria = new JPADriftChangeSetCriteria();
        criteria.addFilterDriftDefinitionId(Integer.valueOf(definition.getId()));
        PageList changeSets = this.driftMgr.findDriftChangeSetsByCriteria(this.getOverlord(), (DriftChangeSetCriteria)criteria);
        this.assertEquals("Did not expect to find any change sets for " + this.toString(definition) + ". Note that this " + "assertion method assumes that the definition you are testing is not supposed to have any change sets.", 0, changeSets.size());
    }

    private void assertDriftTemplateEquals(String msg, DriftDefinitionTemplate expected, DriftDefinitionTemplate actual) {
        AssertUtils.assertPropertiesMatch((String)(msg + ": basic drift definition template properties do not match"), (Object)expected, (Object)actual, (String[])new String[]{"id", "resourceType", "ctime", "templateDefinition"});
        this.assertDriftDefEquals(msg + ": template definitions do not match", expected.getTemplateDefinition(), actual.getTemplateDefinition());
    }

    private void assertDriftDefEquals(String msg, DriftDefinition expected, DriftDefinition actual) {
        DriftDefinitionComparator comparator = new DriftDefinitionComparator(DriftDefinitionComparator.CompareMode.BOTH_BASE_INFO_AND_DIRECTORY_SPECIFICATIONS);
        this.assertEquals(msg, 0, comparator.compare(expected, actual));
    }

    private void assertDetachedDefinitionNotDeleted(int definitionId) {
        DriftDefinition definition = this.loadDefinition(definitionId);
        this.assertNotNull("Detached definition " + this.toString(definition) + " should not be deleted", definition);
        this.assertNull("The detached definition's template reference should be set to null when the template is deleted", definition.getTemplate());
    }

    private DriftDefinition createDefinition(DriftDefinitionTemplate template, String defName, boolean isAttached) {
        DriftDefinition def = template.createDefinition();
        def.setName(defName);
        def.setAttached(Boolean.valueOf(isAttached));
        def.setTemplate(template);
        def.setResource(this.resource);
        return def;
    }

    private DriftDefinitionTemplate loadTemplate(String name) {
        return this.loadTemplate(name, true);
    }

    private DriftDefinitionTemplate loadTemplate(String name, boolean verifyResultsUnique) {
        DriftDefinitionTemplateCriteria criteria = new DriftDefinitionTemplateCriteria();
        criteria.addFilterResourceTypeId(Integer.valueOf(this.resourceType.getId()));
        criteria.addFilterName(name);
        criteria.fetchDriftDefinitions(true);
        criteria.fetchResourceType(true);
        PageList templates = this.templateMgr.findTemplatesByCriteria(this.getOverlord(), criteria);
        if (verifyResultsUnique) {
            this.assertEquals("Expected to find one template", 1, templates.size());
        }
        if (templates.isEmpty()) {
            return null;
        }
        return (DriftDefinitionTemplate)templates.get(0);
    }

    private DriftDefinition loadDefinition(int definitionId) {
        DriftDefinitionCriteria criteria = new DriftDefinitionCriteria();
        criteria.addFilterId(Integer.valueOf(definitionId));
        criteria.fetchConfiguration(Boolean.valueOf(true));
        criteria.fetchTemplate(Boolean.valueOf(true));
        PageList definitions = this.driftMgr.findDriftDefinitionsByCriteria(this.getOverlord(), criteria);
        if (definitions.isEmpty()) {
            return null;
        }
        return (DriftDefinition)definitions.get(0);
    }

    private DriftChangeSet<?> loadChangeSet(String id) throws Exception {
        GenericDriftChangeSetCriteria criteria = new GenericDriftChangeSetCriteria();
        criteria.addFilterId(id);
        PageList changeSets = this.driftMgr.findDriftChangeSetsByCriteria(this.getOverlord(), (DriftChangeSetCriteria)criteria);
        if (changeSets.isEmpty()) {
            return null;
        }
        return (DriftChangeSet)changeSets.get(0);
    }
}

