/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.drift;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.criteria.DriftChangeSetCriteria;
import org.rhq.core.domain.criteria.JPADriftChangeSetCriteria;
import org.rhq.core.domain.drift.DriftCategory;
import org.rhq.core.domain.drift.DriftChangeSet;
import org.rhq.core.domain.drift.DriftChangeSetCategory;
import org.rhq.core.domain.drift.DriftConfigurationDefinition;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftFileStatus;
import org.rhq.core.domain.drift.JPADrift;
import org.rhq.core.domain.drift.JPADriftChangeSet;
import org.rhq.core.domain.drift.JPADriftFile;
import org.rhq.core.domain.drift.JPADriftSet;
import org.rhq.core.domain.drift.dto.DriftChangeSetDTO;
import org.rhq.core.domain.drift.dto.DriftDTO;
import org.rhq.core.domain.drift.dto.DriftFileDTO;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.drift.AbstractDriftServerTest;
import org.rhq.enterprise.server.drift.JPADriftServerLocal;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.test.AssertUtils;
import org.testng.annotations.Test;

@Test
public class JPADriftServerBeanTest
extends AbstractDriftServerTest {
    private JPADriftServerLocal jpaDriftServer;
    private final String DRIFT_FILE_1_ID;
    private final String DRIFT_FILE_2_ID;
    private JPADriftFile driftFile1;
    private JPADriftFile driftFile2;

    public JPADriftServerBeanTest() {
        this.DRIFT_FILE_1_ID = this.NAME_PREFIX + "a1b2c3d4";
        this.DRIFT_FILE_2_ID = this.NAME_PREFIX + "1ab2b3c4d";
    }

    @Override
    protected void beforeMethod(Method testMethod) throws Exception {
        super.beforeMethod(testMethod);
        this.jpaDriftServer = LookupUtil.getJPADriftServer();
        this.driftFile1 = this.jpaDriftServer.persistDriftFile(new JPADriftFile(this.DRIFT_FILE_1_ID));
        this.driftFile2 = this.jpaDriftServer.persistDriftFile(new JPADriftFile(this.DRIFT_FILE_2_ID));
        String driftFile1Content = "drift file 1 content...";
        String driftFile2Content = "drift file 2 content...";
        this.jpaDriftServer.persistDriftFileData(this.driftFile1, IOUtils.toInputStream((String)driftFile1Content), (long)driftFile1Content.length());
        this.jpaDriftServer.persistDriftFileData(this.driftFile2, IOUtils.toInputStream((String)driftFile2Content), (long)driftFile2Content.length());
        this.driftFile1 = this.jpaDriftServer.getDriftFile(this.getOverlord(), this.DRIFT_FILE_1_ID);
        this.driftFile2 = this.jpaDriftServer.getDriftFile(this.getOverlord(), this.DRIFT_FILE_2_ID);
        this.assertDriftFilePersisted(this.driftFile1, "driftFile1", driftFile1Content);
        this.assertDriftFilePersisted(this.driftFile2, "driftFile2", driftFile2Content);
    }

    public void persistResourceChangeSet() {
        final DriftDefinition driftDef = new DriftDefinition(new Configuration());
        driftDef.setName(this.NAME_PREFIX + "persistResourceChangeSet");
        driftDef.setEnabled(Boolean.valueOf(true));
        driftDef.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        driftDef.setInterval(Long.valueOf(2400L));
        driftDef.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/foo/bar/test"));
        driftDef.setResource(this.resource);
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                JPADriftServerBeanTest.this.em.persist((Object)driftDef);
            }
        });
        DriftChangeSetDTO changeSet = new DriftChangeSetDTO();
        changeSet.setCategory(DriftChangeSetCategory.COVERAGE);
        changeSet.setVersion(1);
        changeSet.setDriftDefinitionId(driftDef.getId());
        changeSet.setResourceId(this.resource.getId());
        changeSet.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        changeSet.setCtime(Long.valueOf(System.currentTimeMillis()));
        DriftDTO drift1 = new DriftDTO();
        drift1.setCategory(DriftCategory.FILE_ADDED);
        drift1.setPath("drift.1");
        drift1.setChangeSet(changeSet);
        drift1.setCtime(Long.valueOf(System.currentTimeMillis()));
        drift1.setNewDriftFile(this.toDTo(this.driftFile1));
        DriftDTO drift2 = new DriftDTO();
        drift2.setCategory(DriftCategory.FILE_ADDED);
        drift2.setPath("drift.2");
        drift2.setChangeSet(changeSet);
        drift2.setCtime(Long.valueOf(System.currentTimeMillis()));
        drift2.setNewDriftFile(this.toDTo(this.driftFile2));
        HashSet<DriftDTO> drifts = new HashSet<DriftDTO>();
        drifts.add(drift1);
        drifts.add(drift2);
        changeSet.setDrifts(drifts);
        String newChangeSetId = this.jpaDriftServer.persistChangeSet(this.getOverlord(), (DriftChangeSet)changeSet);
        JPADriftChangeSetCriteria criteria = new JPADriftChangeSetCriteria();
        criteria.addFilterId(newChangeSetId);
        criteria.fetchDrifts(true);
        PageList changeSets = this.jpaDriftServer.findDriftChangeSetsByCriteria(this.getOverlord(), (DriftChangeSetCriteria)criteria);
        this.assertEquals("Expected to find one change set", 1, changeSets.size());
        JPADriftChangeSet jpaChangeSet = (JPADriftChangeSet)changeSets.get(0);
        this.assertEquals("Expected change set to contain two drifts. This could be a result of the change set not being persisted correctly or the criteria fetch being done incorrectly.", 2, jpaChangeSet.getDrifts().size());
        AssertUtils.assertPropertiesMatch((String)"The change set was not persisted correctly", (Object)changeSet, (Object)jpaChangeSet, (String[])new String[]{"id", "drifts", "class", "ctime"});
        List<DriftDTO> expectedDrifts = Arrays.asList(drift1, drift2);
        ArrayList actualDrifts = new ArrayList(jpaChangeSet.getDrifts());
        AssertUtils.assertCollectionMatchesNoOrder((String)"The change set drifts were not persisted correctly", expectedDrifts, actualDrifts, (String[])new String[]{"id", "ctime", "changeSet", "directory", "newDriftFile", "class"});
        AssertUtils.assertPropertiesMatch((String)("The newDriftFile property was not set correctly for " + drift1), (Object)drift1.getNewDriftFile(), (Object)this.findDriftByPath(actualDrifts, "drift.1").getNewDriftFile(), (String[])new String[]{"class", "ctime"});
        AssertUtils.assertPropertiesMatch((String)("The newDriftFile property was not set correctly for " + drift2), (Object)drift2.getNewDriftFile(), (Object)this.findDriftByPath(actualDrifts, "drift.2").getNewDriftFile(), (String[])new String[]{"class", "ctime"});
    }

    public void persistTemplateChangeSet() {
        DriftChangeSetDTO changeSet = new DriftChangeSetDTO();
        changeSet.setCategory(DriftChangeSetCategory.COVERAGE);
        changeSet.setVersion(1);
        changeSet.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        changeSet.setCtime(Long.valueOf(System.currentTimeMillis()));
        DriftDTO drift1 = new DriftDTO();
        drift1.setCategory(DriftCategory.FILE_ADDED);
        drift1.setPath("drift.1");
        drift1.setChangeSet(changeSet);
        drift1.setCtime(Long.valueOf(System.currentTimeMillis()));
        drift1.setNewDriftFile(this.toDTo(this.driftFile1));
        DriftDTO drift2 = new DriftDTO();
        drift2.setCategory(DriftCategory.FILE_ADDED);
        drift2.setPath("drift.2");
        drift2.setChangeSet(changeSet);
        drift2.setCtime(Long.valueOf(System.currentTimeMillis()));
        drift2.setNewDriftFile(this.toDTo(this.driftFile2));
        HashSet<DriftDTO> drifts = new HashSet<DriftDTO>();
        drifts.add(drift1);
        drifts.add(drift2);
        changeSet.setDrifts(drifts);
        String newChangeSetId = this.jpaDriftServer.persistChangeSet(this.getOverlord(), (DriftChangeSet)changeSet);
        JPADriftChangeSetCriteria criteria = new JPADriftChangeSetCriteria();
        criteria.addFilterId(newChangeSetId);
        criteria.fetchDrifts(true);
        PageList changeSets = this.jpaDriftServer.findDriftChangeSetsByCriteria(this.getOverlord(), (DriftChangeSetCriteria)criteria);
        this.assertEquals("Expected to find one change set", 1, changeSets.size());
        JPADriftChangeSet jpaChangeSet = (JPADriftChangeSet)changeSets.get(0);
        this.assertEquals("Expected change set to contain two drifts. This could be a result of the change set not being persisted correctly or the criteria fetch being done incorrectly.", 2, jpaChangeSet.getDrifts().size());
        AssertUtils.assertPropertiesMatch((String)"The change set was not persisted correctly", (Object)changeSet, (Object)jpaChangeSet, (String[])new String[]{"id", "drifts", "class", "ctime"});
        List<DriftDTO> expectedDrifts = Arrays.asList(drift1, drift2);
        ArrayList actualDrifts = new ArrayList(jpaChangeSet.getDrifts());
        AssertUtils.assertCollectionMatchesNoOrder((String)"The change set drifts were not persisted correctly", expectedDrifts, actualDrifts, (String[])new String[]{"id", "ctime", "changeSet", "directory", "newDriftFile", "class"});
        AssertUtils.assertPropertiesMatch((String)("The newDriftFile property was not set correctly for " + drift1), (Object)drift1.getNewDriftFile(), (Object)this.findDriftByPath(actualDrifts, "drift.1").getNewDriftFile(), (String[])new String[]{"class", "ctime"});
        AssertUtils.assertPropertiesMatch((String)("The newDriftFile property was not set correctly for " + drift2), (Object)drift2.getNewDriftFile(), (Object)this.findDriftByPath(actualDrifts, "drift.2").getNewDriftFile(), (String[])new String[]{"class", "ctime"});
    }

    public void copyChangeSet() {
        final JPADriftChangeSet changeSet = new JPADriftChangeSet(null, 0, DriftChangeSetCategory.COVERAGE, null);
        changeSet.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        JPADrift drift1 = new JPADrift(changeSet, "drift.1", DriftCategory.FILE_ADDED, null, this.driftFile1);
        JPADrift drift2 = new JPADrift(changeSet, "drift.2", DriftCategory.FILE_ADDED, null, this.driftFile2);
        final JPADriftSet driftSet = new JPADriftSet();
        driftSet.addDrift(drift1);
        driftSet.addDrift(drift2);
        final DriftDefinition driftDef = new DriftDefinition(new Configuration());
        driftDef.setName(this.NAME_PREFIX + "copyChangeSet");
        driftDef.setEnabled(Boolean.valueOf(true));
        driftDef.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        driftDef.setInterval(Long.valueOf(2400L));
        driftDef.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/foo/bar/test"));
        driftDef.setResource(this.resource);
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                JPADriftServerBeanTest.this.em.persist((Object)changeSet);
                JPADriftServerBeanTest.this.em.persist((Object)driftDef);
                JPADriftServerBeanTest.this.em.persist((Object)driftSet);
                changeSet.setInitialDriftSet(driftSet);
                JPADriftServerBeanTest.this.em.merge((Object)changeSet);
            }
        });
        this.jpaDriftServer.copyChangeSet(this.getOverlord(), changeSet.getId(), driftDef.getId(), this.resource.getId());
        JPADriftChangeSetCriteria criteria = new JPADriftChangeSetCriteria();
        criteria.addFilterDriftDefinitionId(Integer.valueOf(driftDef.getId()));
        criteria.addFilterCategory(DriftChangeSetCategory.COVERAGE);
        PageList changeSets = this.jpaDriftServer.findDriftChangeSetsByCriteria(this.getOverlord(), (DriftChangeSetCriteria)criteria);
        this.assertEquals("Expected to get back one change set", 1, changeSets.size());
        JPADriftChangeSet newChangeSet = (JPADriftChangeSet)changeSets.get(0);
        HashSet<JPADrift> expectedDrifts = new HashSet<JPADrift>(Arrays.asList(drift1, drift2));
        Set actualDrifts = newChangeSet.getDrifts();
        AssertUtils.assertCollectionMatchesNoOrder((String)"The change set drifts were not copied correctly", expectedDrifts, (Collection)actualDrifts, (String[])new String[]{"changeSet", "newDriftFile"});
    }

    private DriftFileDTO toDTo(JPADriftFile driftFile) {
        DriftFileDTO dto = new DriftFileDTO();
        dto.setHashId(driftFile.getHashId());
        dto.setDataSize(driftFile.getDataSize());
        dto.setStatus(driftFile.getStatus());
        return dto;
    }

    private void assertDriftFilePersisted(JPADriftFile driftFile, String name, String content) {
        this.assertNotNull("Failed to get " + name + " Was it persisted?", driftFile);
        this.assertEquals("The content for " + name + " is wrong", content, this.jpaDriftServer.getDriftFileBits(driftFile.getHashId()));
        this.assertEquals("The drift file status is wrong", DriftFileStatus.LOADED, driftFile.getStatus());
    }
}

