/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.drift;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.persistence.EntityManager;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.criteria.DriftChangeSetCriteria;
import org.rhq.core.domain.criteria.DriftDefinitionCriteria;
import org.rhq.core.domain.criteria.JPADriftChangeSetCriteria;
import org.rhq.core.domain.drift.DriftCategory;
import org.rhq.core.domain.drift.DriftChangeSet;
import org.rhq.core.domain.drift.DriftChangeSetCategory;
import org.rhq.core.domain.drift.DriftComplianceStatus;
import org.rhq.core.domain.drift.DriftConfigurationDefinition;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionComparator;
import org.rhq.core.domain.drift.DriftDefinitionTemplate;
import org.rhq.core.domain.drift.DriftSnapshot;
import org.rhq.core.domain.drift.JPADrift;
import org.rhq.core.domain.drift.JPADriftChangeSet;
import org.rhq.core.domain.drift.JPADriftFile;
import org.rhq.core.domain.drift.JPADriftSet;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.drift.AbstractDriftServerTest;
import org.rhq.enterprise.server.drift.DriftManagerLocal;
import org.rhq.enterprise.server.drift.DriftTemplateManagerLocal;
import org.rhq.enterprise.server.drift.TestDefService;
import org.rhq.enterprise.server.safeinvoker.HibernateDetachUtility;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.test.AssertUtils;
import org.testng.annotations.Test;

@Test
public class ManageDriftDefinitionsTest
extends AbstractDriftServerTest {
    private final String DRIFT_NOT_SUPPORTED_TYPE;
    private final String DRIFT_NOT_SUPPORTED_RESOURCE;
    private DriftManagerLocal driftMgr;
    private DriftTemplateManagerLocal templateMgr;
    private ResourceType driftNotSupportedType;
    private Resource driftNotSupportedResource;

    public ManageDriftDefinitionsTest() {
        this.DRIFT_NOT_SUPPORTED_TYPE = this.NAME_PREFIX + "DRIFT_NOT_SUPPORTED_RESOURCE_TYPE";
        this.DRIFT_NOT_SUPPORTED_RESOURCE = this.NAME_PREFIX + "DRIFT_NOT_SUPPORTED_RESOURCE";
    }

    @Override
    protected void beforeMethod(Method testMethod) throws Exception {
        super.beforeMethod(testMethod);
        this.driftMgr = LookupUtil.getDriftManager();
        this.templateMgr = LookupUtil.getDriftTemplateManager();
    }

    @Override
    protected void purgeDB() {
        super.purgeDB();
        this.deleteEntity(Resource.class, this.DRIFT_NOT_SUPPORTED_RESOURCE);
        this.deleteEntity(ResourceType.class, this.DRIFT_NOT_SUPPORTED_TYPE);
    }

    public void createDefinitionFromUnpinnedTemplate() throws Exception {
        DriftDefinition templateDef = new DriftDefinition(new Configuration());
        templateDef.setName(this.NAME_PREFIX + "createUnpinnedDefinition");
        templateDef.setEnabled(Boolean.valueOf(true));
        templateDef.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        templateDef.setInterval(Long.valueOf(2400L));
        templateDef.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/foo/bar/test"));
        DriftDefinitionTemplate template = this.templateMgr.createTemplate(this.getOverlord(), this.resourceType.getId(), false, templateDef);
        DriftDefinition definition = template.createDefinition();
        definition.setTemplate(template);
        this.driftMgr.updateDriftDefinition(this.getOverlord(), EntityContext.forResource((int)this.resource.getId()), definition);
        DriftDefinition newDef = this.loadDefinition(definition.getName());
        DriftDefinitionComparator comparator = new DriftDefinitionComparator(DriftDefinitionComparator.CompareMode.BOTH_BASE_INFO_AND_DIRECTORY_SPECIFICATIONS);
        HibernateDetachUtility.nullOutUninitializedFields((Object)newDef, (HibernateDetachUtility.SerializationType)HibernateDetachUtility.SerializationType.SERIALIZATION);
        this.assertEquals("The drift definition was not persisted correctly", 0, comparator.compare(definition, newDef));
        this.assertEquals("The template association was not set on the definition", template, newDef.getTemplate());
    }

    public void createDefinitionFromPinnedTemplate() throws Exception {
        final JPADriftChangeSet changeSet0 = new JPADriftChangeSet(null, 0, DriftChangeSetCategory.COVERAGE, null);
        changeSet0.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        final JPADriftFile driftFile1 = new JPADriftFile(this.NAME_PREFIX + "a1b2c3");
        final JPADriftFile driftFile2 = new JPADriftFile(this.NAME_PREFIX + "1a2b3c");
        JPADrift drift1 = new JPADrift(changeSet0, "drift.1", DriftCategory.FILE_ADDED, null, driftFile1);
        JPADrift drift2 = new JPADrift(changeSet0, "drift.2", DriftCategory.FILE_ADDED, null, driftFile2);
        final JPADriftSet driftSet = new JPADriftSet();
        driftSet.addDrift(drift1);
        driftSet.addDrift(drift2);
        DriftDefinition templateDef = new DriftDefinition(new Configuration());
        templateDef.setName(this.NAME_PREFIX + "createUnpinnedDefinition");
        templateDef.setEnabled(Boolean.valueOf(true));
        templateDef.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        templateDef.setInterval(Long.valueOf(2400L));
        templateDef.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/foo/bar/test"));
        templateDef.setPinned(true);
        final DriftDefinitionTemplate template = this.templateMgr.createTemplate(this.getOverlord(), this.resourceType.getId(), true, templateDef);
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                EntityManager em = ManageDriftDefinitionsTest.this.getEntityManager();
                em.persist((Object)driftFile1);
                em.persist((Object)driftFile2);
                em.persist((Object)changeSet0);
                em.persist((Object)driftSet);
                changeSet0.setInitialDriftSet(driftSet);
                em.merge((Object)changeSet0);
                template.setChangeSetId(changeSet0.getId());
                em.merge((Object)template);
            }
        });
        DriftDefinition definition = template.createDefinition();
        definition.setTemplate(template);
        final AtomicBoolean agentInvoked = new AtomicBoolean(false);
        this.agentServiceContainer.driftService = new TestDefService(){

            @Override
            public void updateDriftDetection(int resourceId, DriftDefinition driftDef, DriftSnapshot snapshot) {
                try {
                    HibernateDetachUtility.nullOutUninitializedFields((Object)driftDef, (HibernateDetachUtility.SerializationType)HibernateDetachUtility.SerializationType.SERIALIZATION);
                    HibernateDetachUtility.nullOutUninitializedFields((Object)snapshot, (HibernateDetachUtility.SerializationType)HibernateDetachUtility.SerializationType.SERIALIZATION);
                    agentInvoked.set(true);
                    ManageDriftDefinitionsTest.this.assertNotNull("Expected snapshot drift instances collection to be non-null", snapshot.getDriftInstances());
                    ManageDriftDefinitionsTest.this.assertEquals("Expected snapshot to contain two drift entries", 2, snapshot.getDriftInstances().size());
                }
                catch (Exception e) {
                    String msg = "Do not pass attached entites to agent since those entities are outside of Hibernate's control. The persistence context should be flushed and cleared to ensure that only detached objects are sent to the agent";
                    throw new RuntimeException(msg, e);
                }
            }
        };
        this.driftMgr.updateDriftDefinition(this.getOverlord(), EntityContext.forResource((int)this.resource.getId()), definition);
        DriftDefinition newDef = this.loadDefinition(definition.getName());
        this.assertTrue("The drift definition should be marked as pinned", newDef.isPinned());
        JPADriftChangeSetCriteria criteria = new JPADriftChangeSetCriteria();
        criteria.addFilterDriftDefinitionId(Integer.valueOf(definition.getId()));
        criteria.addFilterCategory(DriftChangeSetCategory.COVERAGE);
        criteria.fetchDrifts(true);
        PageList changeSets = this.driftMgr.findDriftChangeSetsByCriteria(this.getOverlord(), (DriftChangeSetCriteria)criteria);
        this.assertEquals("Expected to find one change set", 1, changeSets.size());
        JPADriftChangeSet expectedChangeSet = new JPADriftChangeSet(this.resource, 1, DriftChangeSetCategory.COVERAGE, null);
        List<JPADrift> expectedDrifts = Arrays.asList(new JPADrift(expectedChangeSet, drift1.getPath(), DriftCategory.FILE_ADDED, null, driftFile1), new JPADrift(expectedChangeSet, drift2.getPath(), DriftCategory.FILE_ADDED, null, driftFile2));
        DriftChangeSet actualChangeSet = (DriftChangeSet)changeSets.get(0);
        ArrayList actualDrifts = new ArrayList(actualChangeSet.getDrifts());
        AssertUtils.assertCollectionMatchesNoOrder((String)"Expected to find drifts from change sets 1 and 2 in the template change set", expectedDrifts, actualDrifts, (String[])new String[]{"id", "ctime", "changeSet", "newDriftFile"});
        this.assertTrue("Failed to send drift definition along with snapshot to agent", agentInvoked.get());
    }

    public void unpinDefinition() {
        DriftDefinition templateDef = new DriftDefinition(new Configuration());
        templateDef.setName(this.NAME_PREFIX + "unpin_def_template");
        templateDef.setEnabled(Boolean.valueOf(true));
        templateDef.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        templateDef.setInterval(Long.valueOf(2400L));
        templateDef.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/foo/bar/test"));
        DriftDefinitionTemplate template = this.templateMgr.createTemplate(this.getOverlord(), this.resourceType.getId(), true, templateDef);
        DriftDefinition definition = template.createDefinition();
        definition.setName(this.NAME_PREFIX + "unpin");
        definition.setEnabled(Boolean.valueOf(true));
        definition.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/foo/bar/test"));
        definition.setComplianceStatus(DriftComplianceStatus.OUT_OF_COMPLIANCE_DRIFT);
        definition.setInterval(Long.valueOf(1800L));
        definition.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        definition.setPinned(true);
        this.driftMgr.updateDriftDefinition(this.getOverlord(), EntityContext.forResource((int)this.resource.getId()), definition);
        DriftDefinition newDef = this.loadDefinition(definition.getName());
        this.assertNotNull("Failed to load new definition, " + this.toString(definition));
        newDef.setPinned(false);
        this.driftMgr.updateDriftDefinition(this.getOverlord(), EntityContext.forResource((int)this.resource.getId()), newDef);
        DriftDefinition updatedDef = this.loadDefinition(definition.getName());
        this.assertNotNull("Failed to load updated definition, " + this.toString(newDef));
        this.assertFalse("The updated definition should be set to unpinned", updatedDef.isPinned());
        this.assertEquals("The updated definition should be set to in compliance", DriftComplianceStatus.IN_COMPLIANCE, updatedDef.getComplianceStatus());
    }

    private DriftDefinition loadDefinition(String name) {
        DriftDefinitionCriteria criteria = new DriftDefinitionCriteria();
        criteria.addFilterResourceIds(new Integer[]{this.resource.getId()});
        criteria.addFilterName(name);
        criteria.fetchConfiguration(Boolean.valueOf(true));
        criteria.fetchResource(Boolean.valueOf(true));
        criteria.fetchTemplate(Boolean.valueOf(true));
        PageList driftDefs = this.driftMgr.findDriftDefinitionsByCriteria(this.getOverlord(), criteria);
        this.assertEquals("Expected to find one drift definition", 1, driftDefs.size());
        return (DriftDefinition)driftDefs.get(0);
    }
}

