/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.drift;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.EJBException;
import javax.persistence.EntityManager;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.criteria.DriftChangeSetCriteria;
import org.rhq.core.domain.criteria.GenericDriftChangeSetCriteria;
import org.rhq.core.domain.drift.DriftCategory;
import org.rhq.core.domain.drift.DriftChangeSet;
import org.rhq.core.domain.drift.DriftChangeSetCategory;
import org.rhq.core.domain.drift.DriftConfigurationDefinition;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionTemplate;
import org.rhq.core.domain.drift.DriftSnapshot;
import org.rhq.core.domain.drift.JPADrift;
import org.rhq.core.domain.drift.JPADriftChangeSet;
import org.rhq.core.domain.drift.JPADriftFile;
import org.rhq.core.domain.drift.JPADriftSet;
import org.rhq.core.domain.server.EntitySerializer;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.drift.AbstractDriftServerTest;
import org.rhq.enterprise.server.drift.DriftManagerLocal;
import org.rhq.enterprise.server.drift.DriftTemplateManagerLocal;
import org.rhq.enterprise.server.drift.TestDefService;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.test.AssertUtils;
import org.testng.annotations.Test;

public class ManageSnapshotsTest
extends AbstractDriftServerTest {
    private DriftManagerLocal driftMgr;
    private DriftTemplateManagerLocal templateMgr;

    @Override
    protected void beforeMethod(Method testMethod) throws Exception {
        super.beforeMethod(testMethod);
        this.driftMgr = LookupUtil.getDriftManager();
        this.templateMgr = LookupUtil.getDriftTemplateManager();
    }

    public void pinningSnapshotShouldSetDriftDefAsPinned() {
        DriftDefinition driftDef = this.createAndPersistDriftDef(this.NAME_PREFIX + "setPinnedFlag");
        final JPADriftChangeSet changeSet = new JPADriftChangeSet(this.resource, 0, DriftChangeSetCategory.COVERAGE, driftDef);
        final JPADriftFile driftFile1 = new JPADriftFile(this.NAME_PREFIX + "a1b2c3");
        JPADrift drift = new JPADrift(changeSet, "drift.1", DriftCategory.FILE_ADDED, null, driftFile1);
        final JPADriftSet driftSet = new JPADriftSet();
        driftSet.addDrift(drift);
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                EntityManager em = ManageSnapshotsTest.this.getEntityManager();
                em.persist((Object)driftFile1);
                em.persist((Object)changeSet);
                em.persist((Object)driftSet);
                changeSet.setInitialDriftSet(driftSet);
                em.merge((Object)changeSet);
            }
        });
        this.driftMgr.pinSnapshot(this.getOverlord(), driftDef.getId(), 0);
        DriftDefinition updatedDriftDef = this.driftMgr.getDriftDefinition(this.getOverlord(), driftDef.getId());
        this.assertNotNull("Failed to get " + this.toString(driftDef), updatedDriftDef);
        this.assertTrue("Failed to set pinned flag of " + this.toString(driftDef), updatedDriftDef.isPinned());
    }

    public void pinningSnapshotShouldMakeSnapshotTheInitialChangeSet() throws Exception {
        DriftDefinition driftDef = this.createAndPersistDriftDef(this.NAME_PREFIX + "makeSnapshotVersionZero");
        final JPADriftChangeSet changeSet0 = new JPADriftChangeSet(this.resource, 0, DriftChangeSetCategory.COVERAGE, driftDef);
        final JPADriftFile driftFile1 = new JPADriftFile(this.NAME_PREFIX + "a1b2c3");
        JPADrift drift1 = new JPADrift(changeSet0, "drift.1", DriftCategory.FILE_ADDED, null, driftFile1);
        final JPADriftSet driftSet = new JPADriftSet();
        driftSet.addDrift(drift1);
        final JPADriftFile driftFile2 = new JPADriftFile(this.NAME_PREFIX + "1a2b3c");
        final JPADriftChangeSet changeSet1 = new JPADriftChangeSet(this.resource, 1, DriftChangeSetCategory.DRIFT, driftDef);
        final JPADrift drift2 = new JPADrift(changeSet1, "drift.2", DriftCategory.FILE_ADDED, null, driftFile2);
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                EntityManager em = ManageSnapshotsTest.this.getEntityManager();
                em.persist((Object)driftFile1);
                em.persist((Object)driftFile2);
                em.persist((Object)changeSet0);
                em.persist((Object)driftSet);
                changeSet0.setInitialDriftSet(driftSet);
                em.merge((Object)changeSet0);
                em.persist((Object)changeSet1);
                em.persist((Object)drift2);
            }
        });
        this.driftMgr.pinSnapshot(this.getOverlord(), driftDef.getId(), 1);
        GenericDriftChangeSetCriteria criteria = new GenericDriftChangeSetCriteria();
        criteria.addFilterDriftDefinitionId(Integer.valueOf(driftDef.getId()));
        PageList changeSets = this.driftMgr.findDriftChangeSetsByCriteria(this.getOverlord(), (DriftChangeSetCriteria)criteria);
        this.assertEquals("All change sets except the change set representing the pinned snapshot should be removed", 1, changeSets.size());
        DriftChangeSet changeSet = (DriftChangeSet)changeSets.get(0);
        this.assertEquals("The pinned snapshot version should be reset to zero", 0, changeSet.getVersion());
        this.assertEquals("The change set category is wrong", DriftChangeSetCategory.COVERAGE, changeSet.getCategory());
        JPADriftChangeSet expectedChangeSet = new JPADriftChangeSet(this.resource, 1, DriftChangeSetCategory.COVERAGE, driftDef);
        List<JPADrift> expectedDrifts = Arrays.asList(new JPADrift(expectedChangeSet, drift1.getPath(), DriftCategory.FILE_ADDED, null, driftFile1), new JPADrift(expectedChangeSet, drift2.getPath(), DriftCategory.FILE_ADDED, null, driftFile2));
        ArrayList actualDrifts = new ArrayList(changeSet.getDrifts());
        AssertUtils.assertCollectionMatchesNoOrder((String)"Expected to find drifts from change sets 1 and 2 in the new initial change set", expectedDrifts, actualDrifts, (String[])new String[]{"id", "ctime", "changeSet", "newDriftFile"});
        AssertUtils.assertPropertiesMatch((Object)drift1.getNewDriftFile(), (Object)this.findDriftByPath(actualDrifts, "drift.1").getNewDriftFile(), (String)("The newDriftFile property was not set correctly for " + drift1));
        AssertUtils.assertPropertiesMatch((Object)drift2.getNewDriftFile(), (Object)this.findDriftByPath(actualDrifts, "drift.2").getNewDriftFile(), (String)("The newDriftFile property was not set correctly for " + drift1));
    }

    public void pinningSnapshotShouldSendRequestToAgent() {
        DriftDefinition driftDef = this.createAndPersistDriftDef(this.NAME_PREFIX + "setPinnedFlag");
        final JPADriftChangeSet changeSet = new JPADriftChangeSet(this.resource, 0, DriftChangeSetCategory.COVERAGE, driftDef);
        final JPADriftFile driftFile1 = new JPADriftFile(this.NAME_PREFIX + "a1b2c3");
        JPADrift drift = new JPADrift(changeSet, "drift.1", DriftCategory.FILE_ADDED, null, driftFile1);
        final JPADriftSet driftSet = new JPADriftSet();
        driftSet.addDrift(drift);
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                EntityManager em = ManageSnapshotsTest.this.getEntityManager();
                em.persist((Object)driftFile1);
                em.persist((Object)changeSet);
                em.persist((Object)driftSet);
                changeSet.setInitialDriftSet(driftSet);
                em.merge((Object)changeSet);
            }
        });
        final AtomicBoolean agentInvoked = new AtomicBoolean(false);
        this.agentServiceContainer.driftService = new TestDefService(){

            @Override
            public void pinSnapshot(int resourceId, String configName, DriftSnapshot snapshot) {
                try {
                    agentInvoked.set(true);
                    ObjectOutputStream stream = new ObjectOutputStream(new ByteArrayOutputStream());
                    EntitySerializer.writeExternalRemote((Object)resourceId, (ObjectOutput)stream);
                    EntitySerializer.writeExternalRemote((Object)configName, (ObjectOutput)stream);
                    EntitySerializer.writeExternalRemote((Object)snapshot, (ObjectOutput)stream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.driftMgr.pinSnapshot(this.getOverlord(), driftDef.getId(), 0);
        this.assertTrue("Failed to send request to agent to pin snapshot", agentInvoked.get());
    }

    @Test
    public void doNotAllowSnapshotToBePinnedWhenDefinitionIsAttachedToPinnedTemplate() {
        DriftDefinition templateDef = new DriftDefinition(new Configuration());
        templateDef.setName(this.NAME_PREFIX + "Template-Pinned_Test");
        templateDef.setEnabled(Boolean.valueOf(true));
        templateDef.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        templateDef.setInterval(Long.valueOf(2400L));
        templateDef.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/foo/bar/test"));
        final DriftDefinitionTemplate template = this.templateMgr.createTemplate(this.getOverlord(), this.resourceType.getId(), true, templateDef);
        template.setChangeSetId("1234");
        final DriftDefinition driftDef = template.createDefinition();
        driftDef.setResource(this.resource);
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                EntityManager em = ManageSnapshotsTest.this.getEntityManager();
                em.merge((Object)template);
                em.persist((Object)driftDef);
            }
        });
        try {
            this.driftMgr.pinSnapshot(this.getOverlord(), driftDef.getId(), 0);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Got expected IAE");
        }
        catch (EJBException ee) {
            if (ee.getCause() != null && ee.getCause() instanceof IllegalArgumentException) {
                System.out.println("Got expected EJBException wrapping an IAR");
            }
            throw ee;
        }
    }

    private DriftDefinition createAndPersistDriftDef(String name) {
        final DriftDefinition driftDef = new DriftDefinition(new Configuration());
        driftDef.setName(name);
        driftDef.setEnabled(Boolean.valueOf(true));
        driftDef.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        driftDef.setInterval(Long.valueOf(1800L));
        driftDef.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/foo/bar/test"));
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                driftDef.setResource(ManageSnapshotsTest.this.resource);
                ManageSnapshotsTest.this.getEntityManager().persist((Object)driftDef);
            }
        });
        return driftDef;
    }
}

