/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.event.test;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.criteria.EventCriteria;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.event.EventSource;
import org.rhq.core.domain.event.composite.EventComposite;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.Test;

public class EventManagerTest
extends AbstractEJB3Test {
    private EventManagerLocal eventManager;
    private SubjectManagerLocal subjectManager;

    @Override
    protected void beforeMethod() {
        try {
            this.eventManager = LookupUtil.getEventManager();
            this.subjectManager = LookupUtil.getSubjectManager();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    @Test
    public void testEventsSimple() throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Resource resource = SessionTestHelper.createNewResource(EventManagerTest.this.em, "fake resource");
                EventDefinition eDef = EventManagerTest.this.createEventDefinition(resource);
                EventManagerTest.this.em.persist((Object)eDef);
                long now = System.currentTimeMillis();
                EventSource evSrc = new EventSource("ESource", eDef, resource);
                Event ev = new Event("EType", "ESource", now, EventSeverity.INFO, "This is a test", evSrc);
                EventManagerTest.this.em.persist((Object)evSrc);
                EventManagerTest.this.em.persist((Object)ev);
                EventManagerTest.this.em.flush();
                int resourceId = resource.getId();
                Query queryByTime = EventManagerTest.this.em.createNamedQuery("Event.FIND_EVENTS_FOR_RESOURCE_ID_AND_TIME");
                long t1 = now - 1000L;
                long t2 = now + 1000L;
                queryByTime.setParameter("resourceId", (Object)resourceId);
                queryByTime.setParameter("start", (Object)t1);
                queryByTime.setParameter("end", (Object)t2);
                List resultsByTime = queryByTime.getResultList();
                assert (resultsByTime.size() == 1) : "Expected 1 Event, got " + resultsByTime.size();
                Query queryBySeverity = EventManagerTest.this.em.createNamedQuery("Event.FIND_EVENTS_FOR_RESOURCE_ID_AND_TIME_Severity");
                queryBySeverity.setParameter("severity", (Object)EventSeverity.INFO);
                queryBySeverity.setParameter("resourceId", (Object)resourceId);
                queryBySeverity.setParameter("start", (Object)t1);
                queryBySeverity.setParameter("end", (Object)t2);
                List resultsBySeverity = queryBySeverity.getResultList();
                assert (resultsBySeverity.size() == 1) : "Expected 1 Event, got " + resultsBySeverity.size();
            }
        });
    }

    @Test
    public void testEventManager() throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                boolean bucketCounts;
                Resource resource = SessionTestHelper.createNewResource(EventManagerTest.this.em, "fake resource");
                EventDefinition eDef = EventManagerTest.this.createEventDefinition(resource);
                EventManagerTest.this.em.persist((Object)eDef);
                EventManagerTest.this.em.flush();
                long now = System.currentTimeMillis();
                EventSource evSrc = new EventSource("ESource", eDef, resource);
                Event ev = new Event("EType", "ESource", now, EventSeverity.INFO, "This is a 2nd test", evSrc);
                EventManagerTest.this.eventManager.addEventData(EventManagerTest.this.newEventMap(evSrc, EventManagerTest.this.wrapEvents(new Event[]{ev})));
                int resourceId = resource.getId();
                long t1 = now - 1000L;
                long t2 = now + 1000L;
                Subject overlord = LookupUtil.getSubjectManager().getOverlord();
                int[] buckets = EventManagerTest.this.eventManager.getEventCounts(overlord, resourceId, t1, t2, 3);
                assert (buckets != null) : "Buckets should not be null, but were null";
                assert (buckets.length == 3) : "Expected 3 buckets, but got " + buckets.length;
                boolean bl = bucketCounts = buckets[0] == 0 && buckets[1] == 1 && buckets[2] == 0;
                assert (bucketCounts) : "Expected bucket counts were [0 1 0] Received [" + buckets[0] + " " + buckets[1] + " " + buckets[2] + "]";
                PageControl pc = PageControl.getUnlimitedInstance();
                EntityContext context = EntityContext.forResource((int)resourceId);
                PageList res = EventManagerTest.this.eventManager.findEventComposites(overlord, context, t1, t2, null, null, null, pc);
                assert (res.size() == 1) : "Expected 1 Event, got " + res.size();
                res = EventManagerTest.this.eventManager.findEventComposites(overlord, context, t1, t2, new EventSeverity[]{EventSeverity.INFO}, null, null, pc);
                assert (res.size() == 1) : "Expected 1 Event, got " + res.size();
                res = EventManagerTest.this.eventManager.findEventComposites(overlord, context, t1, t2, new EventSeverity[]{EventSeverity.WARN}, null, null, pc);
                assert (res.size() == 0) : "Expected 0 Events, got " + res.size();
            }
        });
    }

    @Test
    public void testGetEventDetailForEventId() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Resource resource = SessionTestHelper.createNewResource(EventManagerTest.this.em, "fake resource");
                EventDefinition eventDefinition = EventManagerTest.this.createEventDefinition(resource);
                EventManagerTest.this.em.persist((Object)eventDefinition);
                EventSource eventSource = EventManagerTest.this.createEventSource(eventDefinition, resource);
                EventManagerTest.this.em.persist((Object)eventSource);
                Event event = EventManagerTest.this.createEvent(eventSource, EventSeverity.FATAL);
                EventManagerTest.this.em.persist((Object)event);
                EventManagerTest.this.em.flush();
                EventComposite eventDetail = EventManagerTest.this.eventManager.getEventDetailForEventId(EventManagerTest.this.subjectManager.getOverlord(), event.getId());
                EventManagerTest.this.assertNotNull(eventDetail);
                EventManagerTest.this.assertEquals(resource.getName(), eventDetail.getResourceName());
                EventManagerTest.this.assertEquals(event.getSourceLocation(), eventDetail.getSourceLocation());
                EventManagerTest.this.assertEquals(event.getSeverity(), eventDetail.getSeverity());
            }
        });
    }

    @Test
    public void testPurgeEventsForResourceContext() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Resource resource = SessionTestHelper.createNewResource(EventManagerTest.this.em, "fake resource");
                EventDefinition eventDefinition = EventManagerTest.this.createEventDefinition(resource);
                EventManagerTest.this.em.persist((Object)eventDefinition);
                EventSource eventSource = EventManagerTest.this.createEventSource(eventDefinition, resource);
                EventManagerTest.this.em.persist((Object)eventSource);
                int eventCount = 7;
                for (int i = 0; i < eventCount; ++i) {
                    Event event = EventManagerTest.this.createEvent(eventSource, EventSeverity.FATAL);
                    EventManagerTest.this.em.persist((Object)event);
                }
                EventManagerTest.this.em.flush();
                int deletedCount = EventManagerTest.this.eventManager.purgeEventsForContext(EventManagerTest.this.subjectManager.getOverlord(), EntityContext.forResource((int)resource.getId()));
                EventManagerTest.this.assertEquals(eventCount, deletedCount);
            }
        });
    }

    @Test
    public void testPurgeEventsForResourceGroupContext() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Subject subject = SessionTestHelper.createNewSubject(EventManagerTest.this.em, "fake subject");
                Role role = SessionTestHelper.createNewRoleForSubject(EventManagerTest.this.em, subject, "fake role");
                ResourceGroup resourceGroup = SessionTestHelper.createNewCompatibleGroupForRole(EventManagerTest.this.em, role, "fake group");
                Resource resource = SessionTestHelper.createNewResourceForGroup(EventManagerTest.this.em, resourceGroup, "fake resource");
                EventDefinition eventDefinition = EventManagerTest.this.createEventDefinition(resource);
                EventManagerTest.this.em.persist((Object)eventDefinition);
                EventSource eventSource = EventManagerTest.this.createEventSource(eventDefinition, resource);
                EventManagerTest.this.em.persist((Object)eventSource);
                int eventCount = 7;
                for (int i = 0; i < eventCount; ++i) {
                    Event event = EventManagerTest.this.createEvent(eventSource, EventSeverity.FATAL);
                    EventManagerTest.this.em.persist((Object)event);
                }
                EventManagerTest.this.em.flush();
                int deletedCount = EventManagerTest.this.eventManager.purgeEventsForContext(EventManagerTest.this.subjectManager.getOverlord(), EntityContext.forGroup((int)resourceGroup.getId()));
                EventManagerTest.this.assertEquals(eventCount, deletedCount);
            }
        });
    }

    @Test
    public void testGetEventCountsBySeverity() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Resource resource = SessionTestHelper.createNewResource(EventManagerTest.this.em, "fake resource");
                EventDefinition eventDefinition = EventManagerTest.this.createEventDefinition(resource);
                EventManagerTest.this.em.persist((Object)eventDefinition);
                EventSource eventSource = EventManagerTest.this.createEventSource(eventDefinition, resource);
                EventManagerTest.this.em.persist((Object)eventSource);
                int fatalEventCount = 7;
                for (int i = 0; i < fatalEventCount; ++i) {
                    Event event = EventManagerTest.this.createEvent(eventSource, EventSeverity.FATAL);
                    EventManagerTest.this.em.persist((Object)event);
                }
                int warnEventCount = 5;
                for (int i = 0; i < warnEventCount; ++i) {
                    Event event = EventManagerTest.this.createEvent(eventSource, EventSeverity.WARN);
                    EventManagerTest.this.em.persist((Object)event);
                }
                int infoEventCount = 9;
                for (int i = 0; i < infoEventCount; ++i) {
                    Event event = EventManagerTest.this.createEvent(eventSource, EventSeverity.INFO);
                    EventManagerTest.this.em.persist((Object)event);
                }
                EventManagerTest.this.em.flush();
                Map eventCountsBySeverity = EventManagerTest.this.eventManager.getEventCountsBySeverity(EventManagerTest.this.subjectManager.getOverlord(), resource.getId(), 0L, System.currentTimeMillis());
                EventManagerTest.this.assertEquals(3, eventCountsBySeverity.keySet().size());
                EventManagerTest.this.assertEquals(fatalEventCount, (Integer)eventCountsBySeverity.get(EventSeverity.FATAL));
                EventManagerTest.this.assertEquals(warnEventCount, (Integer)eventCountsBySeverity.get(EventSeverity.WARN));
                EventManagerTest.this.assertEquals(infoEventCount, (Integer)eventCountsBySeverity.get(EventSeverity.INFO));
            }
        });
    }

    @Test
    public void testGetEventCountsBySeverityForGroup() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Subject subject = SessionTestHelper.createNewSubject(EventManagerTest.this.em, "fake subject");
                Role role = SessionTestHelper.createNewRoleForSubject(EventManagerTest.this.em, subject, "fake role");
                ResourceGroup resourceGroup = SessionTestHelper.createNewCompatibleGroupForRole(EventManagerTest.this.em, role, "fake group");
                Resource resource = SessionTestHelper.createNewResourceForGroup(EventManagerTest.this.em, resourceGroup, "fake resource");
                EventDefinition eventDefinition = EventManagerTest.this.createEventDefinition(resource);
                EventManagerTest.this.em.persist((Object)eventDefinition);
                EventSource eventSource = EventManagerTest.this.createEventSource(eventDefinition, resource);
                EventManagerTest.this.em.persist((Object)eventSource);
                int fatalEventCount = 7;
                for (int i = 0; i < fatalEventCount; ++i) {
                    Event event = EventManagerTest.this.createEvent(eventSource, EventSeverity.FATAL);
                    EventManagerTest.this.em.persist((Object)event);
                }
                int warnEventCount = 5;
                for (int i = 0; i < warnEventCount; ++i) {
                    Event event = EventManagerTest.this.createEvent(eventSource, EventSeverity.WARN);
                    EventManagerTest.this.em.persist((Object)event);
                }
                int infoEventCount = 9;
                for (int i = 0; i < infoEventCount; ++i) {
                    Event event = EventManagerTest.this.createEvent(eventSource, EventSeverity.INFO);
                    EventManagerTest.this.em.persist((Object)event);
                }
                EventManagerTest.this.em.flush();
                Map eventCountsBySeverity = EventManagerTest.this.eventManager.getEventCountsBySeverityForGroup(EventManagerTest.this.subjectManager.getOverlord(), resourceGroup.getId(), 0L, System.currentTimeMillis());
                EventManagerTest.this.assertEquals(3, eventCountsBySeverity.keySet().size());
                EventManagerTest.this.assertEquals(fatalEventCount, (Integer)eventCountsBySeverity.get(EventSeverity.FATAL));
                EventManagerTest.this.assertEquals(warnEventCount, (Integer)eventCountsBySeverity.get(EventSeverity.WARN));
                EventManagerTest.this.assertEquals(infoEventCount, (Integer)eventCountsBySeverity.get(EventSeverity.INFO));
            }
        });
    }

    @Test
    public void testFindEventsByCriteria() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Event event;
                int i;
                Resource resource = SessionTestHelper.createNewResource(EventManagerTest.this.em, "fake resource");
                EventDefinition eventDefinition = EventManagerTest.this.createEventDefinition(resource);
                EventManagerTest.this.em.persist((Object)eventDefinition);
                EventSource eventSource = EventManagerTest.this.createEventSource(eventDefinition, resource);
                EventManagerTest.this.em.persist((Object)eventSource);
                Set events = EventManagerTest.this.newEventSet();
                for (i = 0; i < 4; ++i) {
                    event = EventManagerTest.this.createEvent(eventSource, EventSeverity.FATAL);
                    events.add(event);
                    EventManagerTest.this.em.persist((Object)event);
                }
                for (i = 0; i < 7; ++i) {
                    event = EventManagerTest.this.createEvent(eventSource, EventSeverity.WARN);
                    events.add(event);
                    EventManagerTest.this.em.persist((Object)event);
                }
                for (i = 0; i < 13; ++i) {
                    event = EventManagerTest.this.createEvent(eventSource, EventSeverity.INFO);
                    events.add(event);
                    EventManagerTest.this.em.persist((Object)event);
                }
                EventManagerTest.this.em.flush();
                EventCriteria criteria = new EventCriteria();
                criteria.addFilterResourceId(Integer.valueOf(resource.getId()));
                criteria.setStrict(true);
                criteria.clearPaging();
                PageList foundEvents = EventManagerTest.this.eventManager.findEventsByCriteria(EventManagerTest.this.subjectManager.getOverlord(), criteria);
                EventManagerTest.this.assertNotNull(foundEvents);
                EventManagerTest.this.assertTrue("#findEventsByCriteria should have found all generated events", events.containsAll((Collection<?>)foundEvents) && foundEvents.containsAll((Collection)events));
            }
        });
    }

    private EventDefinition createEventDefinition(Resource resource) {
        return new EventDefinition(resource.getResourceType(), "fake event definition");
    }

    private EventSource createEventSource(EventDefinition eventDefinition, Resource resource) {
        return new EventSource("fake source location", eventDefinition, resource);
    }

    private Event createEvent(EventSource eventSource, EventSeverity eventSeverity) {
        return new Event("fake event type", eventSource.getLocation(), System.currentTimeMillis(), eventSeverity, "fake event detail", eventSource);
    }

    private Map<EventSource, Set<Event>> newEventMap(EventSource eventSource, Set<Event> events) {
        HashMap<EventSource, Set<Event>> eventMap = new HashMap<EventSource, Set<Event>>();
        eventMap.put(eventSource, events);
        return eventMap;
    }

    private Set<Event> wrapEvents(Event ... event) {
        Set<Event> set = this.newEventSet();
        Collections.addAll(set, event);
        return set;
    }

    private Set<Event> newEventSet() {
        return new HashSet<Event>();
    }
}

