/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.inventory;

import java.util.List;
import java.util.Random;
import javax.persistence.Query;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.drift.DriftConfigurationDefinition;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionTemplate;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

@Test
public class UninventoryTest
extends AbstractEJB3Test {
    private Resource newResource;

    @Override
    protected void beforeMethod() throws Exception {
        this.prepareForTestAgents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterMethod() throws Exception {
        try {
            if (this.newResource != null) {
                this.deleteNewResource(this.newResource);
                this.newResource = null;
            }
        }
        finally {
            this.unprepareForTestAgents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDriftDefRemoval() throws Exception {
        Query qDef;
        Query qTemplate;
        ResourceTypeCreator rtCreator = new ResourceTypeCreator(){

            @Override
            public void modifyResourceTypeToPersist(ResourceType resourceType) {
                DriftDefinitionTemplate template = new DriftDefinitionTemplate();
                template.setName("drift1");
                template.setDescription("drift def template");
                Configuration config = new Configuration();
                DriftDefinition driftDef = new DriftDefinition(config);
                driftDef.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/"));
                driftDef.setName("drift1");
                template.setTemplateDefinition(driftDef);
                resourceType.addDriftDefinitionTemplate(template);
            }
        };
        ResourceCreator rCreator = new ResourceCreator(){

            @Override
            public void modifyResourceToPersist(Resource resource) {
                Configuration config = new Configuration();
                DriftDefinition driftDef = new DriftDefinition(config);
                driftDef.setBasedir(new DriftDefinition.BaseDirectory(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, "/boo"));
                driftDef.setName("drift-def-name");
                resource.addDriftDefinition(driftDef);
            }
        };
        Resource resource = this.createNewResource(rtCreator, rCreator);
        int templateId = ((DriftDefinitionTemplate)resource.getResourceType().getDriftDefinitionTemplates().iterator().next()).getId();
        int driftDefId = ((DriftDefinition)resource.getDriftDefinitions().iterator().next()).getId();
        String qTemplateString = "select t from DriftDefinitionTemplate t where t.id = :id";
        String qDefString = "select dc from DriftDefinition dc where dc.id = :id";
        this.getTransactionManager().begin();
        try {
            qTemplate = this.getEntityManager().createQuery(qTemplateString).setParameter("id", (Object)templateId);
            qDef = this.getEntityManager().createQuery(qDefString).setParameter("id", (Object)driftDefId);
            this.assertEquals("drift template didn't get added", 1, qTemplate.getResultList().size());
            this.assertEquals("drift template def didn't get added", 1, qDef.getResultList().size());
        }
        finally {
            this.getTransactionManager().commit();
        }
        this.deleteNewResource(resource);
        this.getTransactionManager().begin();
        try {
            qTemplate = this.getEntityManager().createQuery(qTemplateString).setParameter("id", (Object)templateId);
            qDef = this.getEntityManager().createQuery(qDefString).setParameter("id", (Object)driftDefId);
            this.assertEquals("drift template didn't get purged", 0, qTemplate.getResultList().size());
            this.assertEquals("drift template def didn't get purged", 0, qDef.getResultList().size());
        }
        finally {
            this.getTransactionManager().commit();
        }
    }

    private Resource createNewResource(ResourceTypeCreator rtCreator, ResourceCreator rCreator) throws Exception {
        Resource resource;
        this.getTransactionManager().begin();
        try {
            ResourceType resourceType = new ResourceType("plat" + System.currentTimeMillis(), "test", ResourceCategory.PLATFORM, null);
            if (rtCreator != null) {
                rtCreator.modifyResourceTypeToPersist(resourceType);
            }
            this.em.persist((Object)resourceType);
            Agent agent = new Agent("testagent", "testaddress", 1, "", "testtoken");
            this.em.persist((Object)agent);
            this.em.flush();
            resource = new Resource("reskey" + System.currentTimeMillis(), "resname", resourceType);
            resource.setUuid("" + new Random().nextInt());
            resource.setAgent(agent);
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
            if (rCreator != null) {
                rCreator.modifyResourceToPersist(resource);
            }
            this.em.persist((Object)resource);
        }
        catch (Exception e) {
            System.out.println("CANNOT PREPARE TEST: " + e);
            this.getTransactionManager().rollback();
            throw e;
        }
        this.em.flush();
        this.getTransactionManager().commit();
        this.newResource = resource;
        return resource;
    }

    private void deleteNewResource(Resource resource) throws Exception {
        if (null != resource) {
            try {
                ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
                Subject overlord = LookupUtil.getSubjectManager().getOverlord();
                List deletedIds = resourceManager.uninventoryResource(overlord, resource.getId());
                for (Integer deletedResourceId : deletedIds) {
                    resourceManager.uninventoryResourceAsyncWork(overlord, deletedResourceId.intValue());
                }
                this.getTransactionManager().begin();
                this.em = this.getEntityManager();
                ResourceType type = (ResourceType)this.em.find(ResourceType.class, (Object)resource.getResourceType().getId());
                Agent agent = (Agent)this.em.find(Agent.class, (Object)resource.getAgent().getId());
                if (null != agent) {
                    this.em.remove((Object)agent);
                }
                if (null != type) {
                    this.em.remove((Object)type);
                }
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                try {
                    System.out.println("CANNOT CLEAN UP TEST (" + ((Object)((Object)this)).getClass().getSimpleName() + ") Cause: " + e);
                    this.getTransactionManager().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static interface ResourceCreator {
        public void modifyResourceToPersist(Resource var1);
    }

    private static interface ResourceTypeCreator {
        public void modifyResourceTypeToPersist(ResourceType var1);
    }
}

