/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import org.joda.time.DateTime;
import org.joda.time.Hours;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.rhq.core.clientapi.agent.measurement.MeasurementAgentService;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementAggregate;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.drift.DriftServerPluginService;
import org.rhq.enterprise.server.measurement.AggregateTestData;
import org.rhq.enterprise.server.measurement.Buckets;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.storage.StorageClientManager;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.ResourceTreeHelper;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.StorageSession;
import org.rhq.server.metrics.domain.AggregateType;
import org.rhq.server.metrics.domain.MetricsTable;
import org.rhq.test.AssertUtils;
import org.testng.annotations.Test;

public class MeasurementDataManagerBeanTest
extends AbstractEJB3Test {
    private static final String RHQ_SERVER_NAME_PROPERTY_VALUE = "TestServer";
    private static final boolean ENABLED = true;
    private final String RESOURCE_TYPE = ((Object)((Object)this)).getClass().getName() + "_TYPE";
    private final String PLUGIN = ((Object)((Object)this)).getClass().getName() + "_PLUGIN";
    private final String AGENT_NAME = ((Object)((Object)this)).getClass().getName() + "_AGENT";
    private final String DYNAMIC_DEF_NAME = ((Object)((Object)this)).getClass().getName() + "_DYNAMIC";
    private final String RESOURCE_KEY = ((Object)((Object)this)).getClass().getName() + "_RESOURCE_KEY";
    private final String RESOURCE_NAME = ((Object)((Object)this)).getClass().getName() + "_NAME";
    private final String RESOURCE_UUID = ((Object)((Object)this)).getClass().getSimpleName() + "_UUID";
    private ResourceType resourceType;
    private Server server;
    private Agent agent;
    private MeasurementDefinition dynamicMeasuremenDef;
    private Resource resource;
    private MeasurementSchedule dynamicSchedule;
    private AlertDefinition alertDefinition;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private MeasurementDataManagerLocal dataManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private StorageClientManager storageClientManager;
    private MetricsDAO metricsDAO;
    private TestServerCommunicationsService agentServiceContainer;
    private String oldServerName;

    private Subject getOverlord() {
        return this.subjectManager.getOverlord();
    }

    @Override
    protected void beforeMethod() throws Exception {
        this.agentServiceContainer = this.prepareForTestAgents();
        this.prepareScheduler();
        this.metricsDAO = this.storageClientManager.getMetricsDAO();
        DriftServerPluginService driftServerPluginService = new DriftServerPluginService(this.getTempDir());
        this.prepareCustomServerPluginService(driftServerPluginService);
        driftServerPluginService.masterConfig.getPluginDirectory().mkdirs();
        this.setServerIdentity(RHQ_SERVER_NAME_PROPERTY_VALUE);
        this.createInventory();
        this.insertDummyReport();
        this.agentServiceContainer.addStartedAgent(this.agent);
    }

    @Override
    protected void afterMethod() throws Exception {
        this.purgeDB(true);
        this.unprepareServerPluginService();
        this.unprepareScheduler();
        this.unprepareForTestAgents();
    }

    @Test(enabled=true)
    public void findRawNumericData() {
        DateTime now = new DateTime();
        DateTime beginTime = now.minusHours(4);
        DateTime endTime = now;
        Buckets buckets = new Buckets(beginTime, endTime);
        MeasurementScheduleRequest request = new MeasurementScheduleRequest(this.dynamicSchedule);
        MeasurementReport report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(buckets.get(0) + 10L, request, Double.valueOf(1.1)));
        report.addData(new MeasurementDataNumeric(buckets.get(0) + 20L, request, Double.valueOf(2.2)));
        report.addData(new MeasurementDataNumeric(buckets.get(0) + 30L, request, Double.valueOf(3.3)));
        report.addData(new MeasurementDataNumeric(buckets.get(59) + 10L, request, Double.valueOf(4.4)));
        report.addData(new MeasurementDataNumeric(buckets.get(59) + 20L, request, Double.valueOf(5.5)));
        report.addData(new MeasurementDataNumeric(buckets.get(59) + 30L, request, Double.valueOf(6.6)));
        this.dataManager.mergeMeasurementReport(report);
        this.waitForRawInserts();
        List<MeasurementDataNumericHighLowComposite> actualData = this.findDataForContext(this.getOverlord(), EntityContext.forResource((int)this.resource.getId()), this.dynamicSchedule, beginTime.getMillis(), endTime.getMillis());
        this.assertEquals("Expected to get back 60 data points.", buckets.getNumDataPoints(), actualData.size());
        MeasurementDataNumericHighLowComposite expectedBucket0Data = new MeasurementDataNumericHighLowComposite(buckets.get(0), MeasurementDataManagerBeanTest.divide(6.6, 3), 3.3, 1.1);
        MeasurementDataNumericHighLowComposite expectedBucket59Data = new MeasurementDataNumericHighLowComposite(buckets.get(59), MeasurementDataManagerBeanTest.divide(16.5, 3), 6.6, 4.4);
        MeasurementDataNumericHighLowComposite expectedBucket29Data = new MeasurementDataNumericHighLowComposite(buckets.get(29), Double.NaN, Double.NaN, Double.NaN);
        AssertUtils.assertPropertiesMatch((String)"The data for bucket 0 does not match the expected values.", (Object)expectedBucket0Data, (Object)actualData.get(0), (Double)1.0E-4, (String[])new String[0]);
        AssertUtils.assertPropertiesMatch((String)"The data for bucket 59 does not match the expected values.", (Object)expectedBucket59Data, (Object)actualData.get(59), (Double)1.0E-4, (String[])new String[0]);
        AssertUtils.assertPropertiesMatch((String)"The data for bucket 29 does not match the expected values.", (Object)expectedBucket29Data, (Object)actualData.get(29), (String[])new String[0]);
    }

    static double divide(double dividend, int divisor) {
        return new BigDecimal(Double.toString(dividend)).divide(new BigDecimal(Integer.toString(divisor)), MathContext.DECIMAL64).doubleValue();
    }

    @Test(enabled=true)
    public void getRawAggregate() {
        DateTime now = new DateTime();
        DateTime beginTime = now.minusHours(4);
        DateTime endTime = now;
        Buckets buckets = new Buckets(beginTime, endTime);
        MeasurementScheduleRequest request = new MeasurementScheduleRequest(this.dynamicSchedule);
        MeasurementReport report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(buckets.get(0) + 10L, request, Double.valueOf(1.1)));
        report.addData(new MeasurementDataNumeric(buckets.get(0) + 20L, request, Double.valueOf(2.2)));
        report.addData(new MeasurementDataNumeric(buckets.get(0) + 30L, request, Double.valueOf(3.3)));
        report.addData(new MeasurementDataNumeric(buckets.get(59) + 10L, request, Double.valueOf(4.4)));
        report.addData(new MeasurementDataNumeric(buckets.get(59) + 20L, request, Double.valueOf(5.5)));
        report.addData(new MeasurementDataNumeric(buckets.get(59) + 30L, request, Double.valueOf(6.6)));
        this.dataManager.mergeMeasurementReport(report);
        this.waitForRawInserts();
        MeasurementAggregate actual = this.dataManager.getMeasurementAggregate(this.getOverlord(), this.dynamicSchedule.getId(), beginTime.getMillis(), endTime.getMillis());
        MeasurementAggregate expected = new MeasurementAggregate(Double.valueOf(1.1), Double.valueOf(MeasurementDataManagerBeanTest.divide(23.1, 6)), Double.valueOf(6.6));
        AssertUtils.assertPropertiesMatch((String)"Aggregate does not match", (Object)expected, (Object)actual, (Double)1.0E-4, (String[])new String[0]);
    }

    @Test(enabled=true)
    public void find1HourNumericData() throws Exception {
        DateTime now = new DateTime();
        DateTime beginTime = now.minusDays(11);
        DateTime endTime = now;
        Buckets buckets = new Buckets(beginTime, endTime);
        List<AggregateTestData> data = Arrays.asList(new AggregateTestData(buckets.get(0), this.dynamicSchedule.getId(), 2.0, 3.0, 1.0), new AggregateTestData(buckets.get(0) + Hours.ONE.toStandardDuration().getMillis(), this.dynamicSchedule.getId(), 5.0, 6.0, 4.0), new AggregateTestData(buckets.get(0) + Hours.TWO.toStandardDuration().getMillis(), this.dynamicSchedule.getId(), 3.0, 3.0, 3.0), new AggregateTestData(buckets.get(59), this.dynamicSchedule.getId(), 5.0, 9.0, 2.0), new AggregateTestData(buckets.get(59) + Hours.ONE.toStandardDuration().getMillis(), this.dynamicSchedule.getId(), 5.0, 6.0, 4.0), new AggregateTestData(buckets.get(59) + Hours.TWO.toStandardDuration().getMillis(), this.dynamicSchedule.getId(), 3.0, 3.0, 3.0));
        this.insert1HourData(data);
        List<MeasurementDataNumericHighLowComposite> actualData = this.findDataForContext(this.getOverlord(), EntityContext.forResource((int)this.resource.getId()), this.dynamicSchedule, beginTime.getMillis(), endTime.getMillis());
        this.assertEquals("Expected to get back 60 data points.", buckets.getNumDataPoints(), actualData.size());
        MeasurementDataNumericHighLowComposite expectedBucket0Data = new MeasurementDataNumericHighLowComposite(buckets.get(0), MeasurementDataManagerBeanTest.divide(10.0, 3), 6.0, 1.0);
        MeasurementDataNumericHighLowComposite expectedBucket59Data = new MeasurementDataNumericHighLowComposite(buckets.get(59), MeasurementDataManagerBeanTest.divide(13.0, 3), 9.0, 2.0);
        AssertUtils.assertPropertiesMatch((String)"The data for bucket 0 does not match the expected values.", (Object)expectedBucket0Data, (Object)actualData.get(0), (Double)1.0E-4, (String[])new String[0]);
        AssertUtils.assertPropertiesMatch((String)"The data for bucket 59 does not match the expected values.", (Object)expectedBucket59Data, (Object)actualData.get(59), (Double)1.0E-4, (String[])new String[0]);
    }

    @Test(enabled=true)
    public void gettingLiveDataTriggersAlerts() throws Exception {
        this.agentServiceContainer.measurementService = (MeasurementAgentService)Mockito.mock(MeasurementAgentService.class);
        Mockito.when((Object)this.agentServiceContainer.measurementService.getRealTimeMeasurementValue(Mockito.anyInt(), Mockito.anySetOf(MeasurementScheduleRequest.class))).then((Answer)new Answer<Set<MeasurementData>>(){

            public Set<MeasurementData> answer(InvocationOnMock invocation) throws Throwable {
                Set requests = (Set)invocation.getArguments()[1];
                HashSet<MeasurementData> ret = new HashSet<MeasurementData>();
                for (MeasurementScheduleRequest req : requests) {
                    ret.add((MeasurementData)new MeasurementDataNumeric(System.currentTimeMillis(), req, Double.valueOf(System.nanoTime())));
                }
                return ret;
            }
        });
        this.dataManager.findLiveData(this.getOverlord(), this.resource.getId(), new int[]{this.dynamicMeasuremenDef.getId()}, Long.valueOf(Long.MAX_VALUE));
        Thread.sleep(3000L);
        LookupUtil.getAlertConditionCacheManager().reloadAllCaches();
        this.dataManager.findLiveData(this.getOverlord(), this.resource.getId(), new int[]{this.dynamicMeasuremenDef.getId()}, Long.valueOf(Long.MAX_VALUE));
        Thread.sleep(3000L);
        AlertCriteria aCrit = new AlertCriteria();
        aCrit.addFilterResourceIds(new Integer[]{this.resource.getId()});
        PageList alerts = LookupUtil.getAlertManager().findAlertsByCriteria(this.getOverlord(), aCrit);
        this.assertEquals("Unexpected number of alerts on the resource.", 1, alerts.size());
    }

    private void createInventory() throws Exception {
        this.purgeDB(false);
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                MeasurementDataManagerBeanTest.this.resourceType = new ResourceType(MeasurementDataManagerBeanTest.this.RESOURCE_TYPE, MeasurementDataManagerBeanTest.this.PLUGIN, ResourceCategory.SERVER, null);
                MeasurementDataManagerBeanTest.this.em.persist((Object)MeasurementDataManagerBeanTest.this.resourceType);
                MeasurementDataManagerBeanTest.this.server = new Server();
                MeasurementDataManagerBeanTest.this.server.setName(MeasurementDataManagerBeanTest.RHQ_SERVER_NAME_PROPERTY_VALUE);
                MeasurementDataManagerBeanTest.this.server.setAddress("localhost");
                MeasurementDataManagerBeanTest.this.server.setPort(7080);
                MeasurementDataManagerBeanTest.this.server.setSecurePort(7443);
                MeasurementDataManagerBeanTest.this.server.setComputePower(1);
                MeasurementDataManagerBeanTest.this.server.setOperationMode(Server.OperationMode.MAINTENANCE);
                int serverId = LookupUtil.getServerManager().create(MeasurementDataManagerBeanTest.this.server);
                assert (serverId > 0) : "could not create our server identity in the DB";
                MeasurementDataManagerBeanTest.this.agent = new Agent(MeasurementDataManagerBeanTest.this.AGENT_NAME, "localhost", 9999, "", "randomToken");
                MeasurementDataManagerBeanTest.this.agent.setServer(MeasurementDataManagerBeanTest.this.server);
                MeasurementDataManagerBeanTest.this.em.persist((Object)MeasurementDataManagerBeanTest.this.agent);
                MeasurementDataManagerBeanTest.this.dynamicMeasuremenDef = new MeasurementDefinition(MeasurementDataManagerBeanTest.this.resourceType, MeasurementDataManagerBeanTest.this.DYNAMIC_DEF_NAME);
                MeasurementDataManagerBeanTest.this.dynamicMeasuremenDef.setDefaultOn(true);
                MeasurementDataManagerBeanTest.this.dynamicMeasuremenDef.setDataType(DataType.MEASUREMENT);
                MeasurementDataManagerBeanTest.this.dynamicMeasuremenDef.setMeasurementType(NumericType.DYNAMIC);
                MeasurementDataManagerBeanTest.this.em.persist((Object)MeasurementDataManagerBeanTest.this.dynamicMeasuremenDef);
                MeasurementDataManagerBeanTest.this.resource = new Resource(MeasurementDataManagerBeanTest.this.RESOURCE_KEY, MeasurementDataManagerBeanTest.this.RESOURCE_NAME, MeasurementDataManagerBeanTest.this.resourceType);
                MeasurementDataManagerBeanTest.this.resource.setUuid(MeasurementDataManagerBeanTest.this.RESOURCE_UUID);
                MeasurementDataManagerBeanTest.this.resource.setInventoryStatus(InventoryStatus.COMMITTED);
                MeasurementDataManagerBeanTest.this.resource.setAgent(MeasurementDataManagerBeanTest.this.agent);
                MeasurementDataManagerBeanTest.this.em.persist((Object)MeasurementDataManagerBeanTest.this.resource);
                MeasurementDataManagerBeanTest.this.dynamicSchedule = new MeasurementSchedule(MeasurementDataManagerBeanTest.this.dynamicMeasuremenDef, MeasurementDataManagerBeanTest.this.resource);
                MeasurementDataManagerBeanTest.this.dynamicSchedule.setEnabled(true);
                MeasurementDataManagerBeanTest.this.resource.addSchedule(MeasurementDataManagerBeanTest.this.dynamicSchedule);
                MeasurementDataManagerBeanTest.this.em.persist((Object)MeasurementDataManagerBeanTest.this.dynamicSchedule);
            }
        });
        this.alertDefinition = new AlertDefinition();
        AlertCondition cond = new AlertCondition(this.alertDefinition, AlertConditionCategory.CHANGE);
        cond.setName(this.DYNAMIC_DEF_NAME);
        cond.setMeasurementDefinition(this.dynamicMeasuremenDef);
        this.alertDefinition.setName("liveDataTestAlert");
        this.alertDefinition.setResource(this.resource);
        this.alertDefinition.setPriority(AlertPriority.MEDIUM);
        this.alertDefinition.setRecoveryId(Integer.valueOf(0));
        this.alertDefinition.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        this.alertDefinition.setConditions(Collections.singleton(cond));
        this.alertDefinition.setEnabled(true);
        this.alertDefinition.setConditionExpression(BooleanExpression.ALL);
        AlertDefinitionManagerLocal alertDefinitionManager = LookupUtil.getAlertDefinitionManager();
        alertDefinitionManager.createAlertDefinitionInNewTransaction(this.getOverlord(), this.alertDefinition, Integer.valueOf(this.resource.getId()), true);
        LookupUtil.getAlertConditionCacheManager().reloadAllCaches();
    }

    private void purgeDB(boolean assumeResourceExists) {
        this.purgeMetricsTables();
        ResourceCriteria c = new ResourceCriteria();
        c.addFilterInventoryStatus(null);
        c.addFilterResourceKey(this.RESOURCE_KEY);
        c.fetchSchedules(true);
        c.fetchAlertDefinitions(true);
        PageList r = this.resourceManager.findResourcesByCriteria(this.subjectManager.getOverlord(), c);
        if (assumeResourceExists && !r.isEmpty()) {
            this.assertTrue("Should be only 1 resource", r.size() == 1);
        }
        if (!r.isEmpty()) {
            Resource doomedResource = (Resource)r.get(0);
            this.deleteAlertDefinitions(doomedResource.getAlertDefinitions());
        }
        this.executeInTransaction(false, new TransactionCallback((List)r){
            final /* synthetic */ List val$r;
            {
                this.val$r = list;
            }

            @Override
            public void execute() throws Exception {
                if (!this.val$r.isEmpty()) {
                    Resource delete = (Resource)MeasurementDataManagerBeanTest.this.em.find(Resource.class, (Object)((Resource)this.val$r.get(0)).getId());
                    MeasurementDataManagerBeanTest.this.deleteMeasurementSchedules(delete);
                    MeasurementDataManagerBeanTest.this.deleteResource(delete);
                }
                MeasurementDataManagerBeanTest.this.deleteAgent();
                MeasurementDataManagerBeanTest.this.deleteServer();
                MeasurementDataManagerBeanTest.this.deleteDynamicMeasurementDef();
                MeasurementDataManagerBeanTest.this.deleteResourceType();
            }
        });
    }

    private void deleteDynamicMeasurementDef() {
        this.em.createQuery("delete from MeasurementDefinition where dataType = :dataType and name = :name").setParameter("dataType", (Object)DataType.MEASUREMENT).setParameter("name", (Object)this.DYNAMIC_DEF_NAME).executeUpdate();
    }

    private void deleteAgent() {
        this.em.createQuery("delete from Agent where name = :name").setParameter("name", (Object)this.AGENT_NAME).executeUpdate();
    }

    private void deleteServer() {
        this.em.createQuery("delete from Server where name = :name").setParameter("name", (Object)RHQ_SERVER_NAME_PROPERTY_VALUE).executeUpdate();
    }

    private void deleteResourceType() {
        this.em.createQuery("delete from ResourceType where name = :name and plugin = :plugin").setParameter("name", (Object)this.RESOURCE_TYPE).setParameter("plugin", (Object)this.PLUGIN).executeUpdate();
    }

    private void deleteResource(Resource doomedResource) {
        ResourceTreeHelper.deleteResource(this.em, doomedResource);
        this.em.flush();
    }

    private void deleteMeasurementSchedules(Resource doomedResource) {
        for (MeasurementSchedule ms : doomedResource.getSchedules()) {
            int i = this.em.createQuery("delete from MeasurementSchedule where id = :msId").setParameter("msId", (Object)ms.getId()).executeUpdate();
            this.em.flush();
            System.out.println("Deleted [" + i + "] schedules with id [" + ms.getId() + "]");
        }
    }

    private void deleteAlertDefinitions(Collection<AlertDefinition> defs) {
        AlertDefinitionManagerLocal alertDefinitionManager = LookupUtil.getAlertDefinitionManager();
        int[] ids = new int[defs.size()];
        int i = 0;
        for (AlertDefinition def : defs) {
            ids[i++] = def.getId();
            LookupUtil.getAlertManager().deleteAlertsByContext(this.getOverlord(), EntityContext.forResource((int)def.getResource().getId()));
        }
        alertDefinitionManager.removeAlertDefinitions(this.getOverlord(), ids);
        alertDefinitionManager.purgeUnusedAlertDefinitions();
        for (i = 0; i < ids.length; ++i) {
            alertDefinitionManager.purgeInternals(ids[i]);
        }
    }

    private void insertDummyReport() {
        DateTime now = new DateTime();
        MeasurementReport dummyReport = new MeasurementReport();
        dummyReport.addData(new MeasurementDataNumeric(now.getMillis(), -1, Double.valueOf(0.0)));
        this.dataManager.mergeMeasurementReport(dummyReport);
    }

    private void purgeMetricsTables() {
        try {
            StorageSession session = this.storageClientManager.getSession();
            session.execute("TRUNCATE " + MetricsTable.RAW);
            session.execute("TRUNCATE " + MetricsTable.ONE_HOUR);
            session.execute("TRUNCATE " + MetricsTable.SIX_HOUR);
            session.execute("TRUNCATE " + MetricsTable.TWENTY_FOUR_HOUR);
            session.execute("TRUNCATE " + MetricsTable.INDEX);
        }
        catch (NoHostAvailableException e) {
            throw new RuntimeException("An error occurred while purging metrics tables", e);
        }
    }

    private void insert1HourData(List<AggregateTestData> data) {
        ArrayList metrics = new ArrayList(data.size());
        for (AggregateTestData datum : data) {
            this.metricsDAO.insertOneHourData(datum.getScheduleId(), datum.getTimestamp(), AggregateType.MIN, datum.getMin().doubleValue());
            this.metricsDAO.insertOneHourData(datum.getScheduleId(), datum.getTimestamp(), AggregateType.AVG, datum.getAvg().doubleValue());
            this.metricsDAO.insertOneHourData(datum.getScheduleId(), datum.getTimestamp(), AggregateType.MAX, datum.getMax().doubleValue());
        }
    }

    private List<MeasurementDataNumericHighLowComposite> findDataForContext(Subject subject, EntityContext context, MeasurementSchedule schedule, long beginTime, long endTime) {
        List data = this.dataManager.findDataForContext(subject, context, schedule.getDefinition().getId(), beginTime, endTime, 60);
        if (data.isEmpty()) {
            return Collections.emptyList();
        }
        return (List)data.get(0);
    }

    private void waitForRawInserts() {
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

