/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ejb.EJB;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.joda.time.DateTime;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementBaseline;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementOOB;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.drift.DriftServerPluginService;
import org.rhq.enterprise.server.measurement.MeasurementBaselineManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementOOBManagerLocal;
import org.rhq.enterprise.server.measurement.TestMeasurementOOB;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.storage.StorageClientManager;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.test.TransactionCallbackReturnable;
import org.rhq.enterprise.server.util.Overlord;
import org.rhq.enterprise.server.util.ResourceTreeHelper;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.test.AssertUtils;
import org.testng.annotations.Test;

public class MeasurementOOBManagerBeanTest
extends AbstractEJB3Test {
    private final String RESOURCE_TYPE = ((Object)((Object)this)).getClass().getName() + "_TYPE";
    private final String PLUGIN = ((Object)((Object)this)).getClass().getName() + "_PLUGIN";
    private final String AGENT_NAME = ((Object)((Object)this)).getClass().getName() + "_AGENT";
    private final String DYNAMIC_DEF_NAME = ((Object)((Object)this)).getClass().getName() + "_DYNAMIC";
    private final String RESOURCE_KEY = ((Object)((Object)this)).getClass().getName() + "_RESOURCE_KEY";
    private final String RESOURCE_NAME = ((Object)((Object)this)).getClass().getName() + "_NAME";
    private final String RESOURCE_UUID = ((Object)((Object)this)).getClass().getSimpleName() + "_UUID";
    private ResourceType resourceType;
    private Agent agent;
    private Resource resource;
    private List<MeasurementDefinition> measurementDefs;
    private List<MeasurementSchedule> schedules;
    @Inject
    @Overlord
    private Subject overlord;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private MeasurementOOBManagerLocal oobManager;
    @EJB
    private MeasurementBaselineManagerLocal baselineManager;
    @EJB
    StorageClientManager storageClientManager;
    private MetricsDAO metricsDAO;

    @Override
    protected void beforeMethod() throws Exception {
        DriftServerPluginService driftServerPluginService = new DriftServerPluginService(this.getTempDir());
        this.prepareCustomServerPluginService(driftServerPluginService);
        driftServerPluginService.masterConfig.getPluginDirectory().mkdirs();
        this.measurementDefs = new ArrayList<MeasurementDefinition>();
        this.schedules = new ArrayList<MeasurementSchedule>();
        this.metricsDAO = this.storageClientManager.getMetricsDAO();
        this.createInventory();
    }

    @Override
    protected void afterMethod() throws Exception {
        this.purgeDB();
    }

    @Test
    public void calculateOOBs() {
        final MeasurementSchedule schedule1 = this.createSchedule();
        final MeasurementSchedule schedule2 = this.createSchedule();
        MeasurementSchedule schedule3 = this.createSchedule();
        DateTime currentHour = DateTime.now().hourOfDay().roundFloorCopy();
        final DateTime lastHour = currentHour.minusHours(1);
        this.insertBaselines(Arrays.asList(this.baseline(schedule1, 4.34, 5.2, 3.9), this.baseline(schedule2, 7.43, 7.49, 7.38), this.baseline(schedule3, 3.2, 3.6, 2.95)));
        List<AggregateNumericMetric> metrics = Arrays.asList(new AggregateNumericMetric(schedule1.getId(), Double.valueOf(3.8), Double.valueOf(2.11), Double.valueOf(4.6), lastHour.getMillis()), new AggregateNumericMetric(schedule2.getId(), Double.valueOf(9.492), Double.valueOf(9.481), Double.valueOf(9.53), lastHour.getMillis()), new AggregateNumericMetric(schedule3.getId(), Double.valueOf(3.15), Double.valueOf(2.96), Double.valueOf(3.59), lastHour.getMillis()));
        this.oobManager.computeOOBsForLastHour(this.overlord, metrics);
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                EntityManager em = MeasurementOOBManagerBeanTest.this.getEntityManager();
                List oobs = em.createQuery("select oob from MeasurementOOB oob").getResultList();
                ArrayList<TestMeasurementOOB> actual = new ArrayList<TestMeasurementOOB>();
                for (MeasurementOOB oob : oobs) {
                    actual.add(new TestMeasurementOOB(oob));
                }
                List<TestMeasurementOOB> expected = Arrays.asList(new TestMeasurementOOB(schedule1.getId(), lastHour.getMillis(), 138), new TestMeasurementOOB(schedule2.getId(), lastHour.getMillis(), 1855));
                AssertUtils.assertCollectionEqualsNoOrder(expected, actual, (String)"The OOBs do not match");
            }
        });
    }

    private void createInventory() throws Exception {
        this.purgeDB();
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                MeasurementOOBManagerBeanTest.this.resourceType = new ResourceType(MeasurementOOBManagerBeanTest.this.RESOURCE_TYPE, MeasurementOOBManagerBeanTest.this.PLUGIN, ResourceCategory.SERVER, null);
                MeasurementOOBManagerBeanTest.this.em.persist((Object)MeasurementOOBManagerBeanTest.this.resourceType);
                MeasurementOOBManagerBeanTest.this.agent = new Agent(MeasurementOOBManagerBeanTest.this.AGENT_NAME, "localhost", 9999, "", "randomToken");
                MeasurementOOBManagerBeanTest.this.em.persist((Object)MeasurementOOBManagerBeanTest.this.agent);
                MeasurementOOBManagerBeanTest.this.resource = new Resource(MeasurementOOBManagerBeanTest.this.RESOURCE_KEY, MeasurementOOBManagerBeanTest.this.RESOURCE_NAME, MeasurementOOBManagerBeanTest.this.resourceType);
                MeasurementOOBManagerBeanTest.this.resource.setUuid(MeasurementOOBManagerBeanTest.this.RESOURCE_UUID);
                MeasurementOOBManagerBeanTest.this.resource.setAgent(MeasurementOOBManagerBeanTest.this.agent);
                MeasurementOOBManagerBeanTest.this.em.persist((Object)MeasurementOOBManagerBeanTest.this.resource);
            }
        });
    }

    private void purgeDB() {
        this.purgeBaselines();
        this.purgeOOBs();
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                ResourceCriteria c = new ResourceCriteria();
                c.addFilterInventoryStatus(null);
                c.addFilterResourceKey(MeasurementOOBManagerBeanTest.this.RESOURCE_KEY);
                c.fetchSchedules(true);
                PageList r = MeasurementOOBManagerBeanTest.this.resourceManager.findResourcesByCriteria(MeasurementOOBManagerBeanTest.this.overlord, c);
                if (!r.isEmpty()) {
                    MeasurementOOBManagerBeanTest.this.assertTrue("Should be only 1 resource", r.size() == 1);
                    Resource doomedResource = (Resource)r.get(0);
                    MeasurementOOBManagerBeanTest.this.deleteMeasurementSchedules();
                    MeasurementOOBManagerBeanTest.this.deleteResource(doomedResource);
                }
                MeasurementOOBManagerBeanTest.this.deleteAgent();
                MeasurementOOBManagerBeanTest.this.deleteDynamicMeasurementDef();
                MeasurementOOBManagerBeanTest.this.deleteResourceType();
            }
        });
    }

    private void deleteDynamicMeasurementDef() {
        if (!this.measurementDefs.isEmpty()) {
            this.em.createQuery("delete from MeasurementDefinition d where d in :defs").setParameter("defs", this.measurementDefs).executeUpdate();
        }
    }

    private void deleteAgent() {
        this.em.createQuery("delete from Agent where name = :name").setParameter("name", (Object)this.AGENT_NAME).executeUpdate();
    }

    private void deleteResourceType() {
        this.em.createQuery("delete from ResourceType where name = :name and plugin = :plugin").setParameter("name", (Object)this.RESOURCE_TYPE).setParameter("plugin", (Object)this.PLUGIN).executeUpdate();
    }

    private void deleteResource(Resource doomedResource) {
        ResourceTreeHelper.deleteResource(this.em, doomedResource);
        this.em.flush();
    }

    private void deleteMeasurementSchedules() {
        for (MeasurementSchedule schedule : this.schedules) {
            this.em.createQuery("delete from MeasurementSchedule where id = :id").setParameter("id", (Object)schedule.getId()).executeUpdate();
        }
        this.em.flush();
    }

    public void purgeBaselines() {
        this.purgeTables("rhq_measurement_bline");
    }

    public void purgeOOBs() {
        this.purgeTables("rhq_measurement_oob");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeTables(String ... tables) {
        Connection connection = null;
        try {
            connection = MeasurementOOBManagerBeanTest.getConnection();
            connection.setAutoCommit(false);
            for (String table : tables) {
                Statement statement = connection.createStatement();
                try {
                    statement.execute("delete from " + table);
                }
                finally {
                    JDBCUtil.safeClose((Statement)statement);
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                throw new RuntimeException("Failed to rollback transaction", e1);
            }
            throw new RuntimeException("Failed to purge data from " + tables, e);
        }
        finally {
            JDBCUtil.safeClose((Connection)connection);
        }
    }

    private void insertBaselines(final List<MeasurementBaseline> baselines) {
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                EntityManager em = MeasurementOOBManagerBeanTest.this.getEntityManager();
                for (MeasurementBaseline baseline : baselines) {
                    em.persist((Object)baseline);
                }
            }
        });
    }

    private MeasurementBaseline baseline(MeasurementSchedule schedule, double mean, double max, double min) {
        MeasurementBaseline baseline = new MeasurementBaseline();
        baseline.setSchedule(schedule);
        baseline.setMean(Double.valueOf(mean));
        baseline.setMax(Double.valueOf(max));
        baseline.setMin(Double.valueOf(min));
        return baseline;
    }

    private MeasurementSchedule createSchedule() {
        return this.executeInTransaction(false, new TransactionCallbackReturnable<MeasurementSchedule>(){

            @Override
            public MeasurementSchedule execute() throws Exception {
                EntityManager em = MeasurementOOBManagerBeanTest.this.getEntityManager();
                MeasurementDefinition definition = new MeasurementDefinition(MeasurementOOBManagerBeanTest.this.resourceType, MeasurementOOBManagerBeanTest.this.DYNAMIC_DEF_NAME + MeasurementOOBManagerBeanTest.this.measurementDefs.size());
                definition.setDefaultOn(true);
                definition.setDataType(DataType.MEASUREMENT);
                definition.setMeasurementType(NumericType.DYNAMIC);
                em.persist((Object)definition);
                MeasurementSchedule schedule = new MeasurementSchedule(definition, MeasurementOOBManagerBeanTest.this.resource);
                schedule.setEnabled(true);
                MeasurementOOBManagerBeanTest.this.resource.addSchedule(schedule);
                em.persist((Object)schedule);
                MeasurementOOBManagerBeanTest.this.schedules.add(schedule);
                MeasurementOOBManagerBeanTest.this.measurementDefs.add(definition);
                return schedule;
            }
        });
    }
}

