/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.ResourceMeasurementScheduleRequest;
import org.rhq.core.domain.resource.Agent;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestAgentClient;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;

public class AbstractMeasurementScheduleManagerTest
extends AbstractEJB3Test {
    @Override
    public TestServerCommunicationsService prepareForTestAgents() {
        return this.prepareForTestAgents(new MeasurementScheduleTestServerCommunicationsService());
    }

    public static class MeasurementScheduleTestServerCommunicationsService
    extends TestServerCommunicationsService {
        private long expectedInterval = 30000L;
        private boolean expectedIsEnabled = false;
        private boolean isTested = false;
        private List<String> failures = new ArrayList<String>();

        @Override
        public AgentClient getKnownAgentClient(Agent agent) {
            MeasurementScheduleTestAgentClient testClient = new MeasurementScheduleTestAgentClient(agent, this);
            this.agentClients.put(agent, testClient);
            return testClient;
        }

        public void init() {
            this.expectedInterval = 30000L;
            this.expectedIsEnabled = false;
            this.isTested = false;
            this.failures.clear();
        }

        public void setExpectedInterval(long expectedInterval) {
            this.expectedInterval = expectedInterval;
        }

        public void setExpectedIsEnabled(boolean expectedIsEnabled) {
            this.expectedIsEnabled = expectedIsEnabled;
        }

        public boolean isTested() {
            return this.isTested;
        }

        public boolean hasFailures() {
            return !this.failures.isEmpty();
        }

        public List<String> getFailures() {
            return this.failures;
        }

        public class MeasurementScheduleTestAgentClient
        extends TestAgentClient {
            public MeasurementScheduleTestAgentClient(Agent agent, TestServerCommunicationsService commService) {
                super(agent, commService);
            }

            @Override
            public void updateCollection(Set<ResourceMeasurementScheduleRequest> resourceSchedules) {
                for (ResourceMeasurementScheduleRequest rmsr : resourceSchedules) {
                    for (MeasurementScheduleRequest msr : rmsr.getMeasurementSchedules()) {
                        String msg;
                        MeasurementScheduleTestServerCommunicationsService.this.isTested = true;
                        if (msr.getInterval() != MeasurementScheduleTestServerCommunicationsService.this.expectedInterval) {
                            msg = "Illegal Schedule Interval, expected " + MeasurementScheduleTestServerCommunicationsService.this.expectedInterval + ", got: " + msr;
                            MeasurementScheduleTestServerCommunicationsService.this.failures.add(msg);
                        }
                        if (msr.isEnabled() == MeasurementScheduleTestServerCommunicationsService.this.expectedIsEnabled) continue;
                        msg = "Illegal Schedule isEnabled, expected " + MeasurementScheduleTestServerCommunicationsService.this.expectedIsEnabled + ", got: " + msr;
                        MeasurementScheduleTestServerCommunicationsService.this.failures.add(msg);
                    }
                }
            }
        }
    }
}

