/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement.test;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.persistence.Query;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.criteria.AvailabilityCriteria;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.ResourceAvailability;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.resource.group.composite.ResourceGroupAvailability;
import org.rhq.core.domain.resource.group.composite.ResourceGroupComposite;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityPoint;
import org.rhq.enterprise.server.resource.ResourceAvailabilityManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerPluginService;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.test.TransactionCallbackReturnable;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.Test;

public class AvailabilityManagerTest
extends AbstractEJB3Test {
    private static final boolean ENABLE_TESTS = true;
    private static final AvailabilityType UP = AvailabilityType.UP;
    private static final AvailabilityType DOWN = AvailabilityType.DOWN;
    private static final AvailabilityType DISABLED = AvailabilityType.DISABLED;
    private static final AvailabilityType UNKNOWN = AvailabilityType.UNKNOWN;
    private AvailabilityManagerLocal availabilityManager;
    private ResourceAvailabilityManagerLocal resourceAvailabilityManager;
    private ResourceManagerLocal resourceManager;
    private Subject overlord;
    private Agent theAgent;
    private Resource theResource;
    private ResourceType theResourceType;
    private List<Resource> additionalResources;
    private Availability availability1;
    private Availability availability2;
    private Availability availability3;
    private TestServerPluginService testServerPluginService;

    @Override
    protected void beforeMethod() {
        try {
            this.prepareScheduler();
            this.availabilityManager = LookupUtil.getAvailabilityManager();
            this.resourceAvailabilityManager = LookupUtil.getResourceAvailabilityManager();
            this.resourceManager = LookupUtil.getResourceManager();
            this.overlord = LookupUtil.getSubjectManager().getOverlord();
            this.additionalResources = new ArrayList<Resource>();
            this.testServerPluginService = new TestServerPluginService(this.getTempDir());
            this.prepareCustomServerPluginService(this.testServerPluginService);
            this.testServerPluginService.masterConfig.getPluginDirectory().mkdirs();
            this.testServerPluginService.startMasterPluginContainer();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    @Override
    protected void afterMethod() throws Exception {
        try {
            this.prepareForTestAgents();
            if (this.theResource != null) {
                this.resourceManager.uninventoryResource(this.overlord, this.theResource.getId());
                this.resourceManager.uninventoryResourceAsyncWork(this.overlord, this.theResource.getId());
                this.theResource = null;
            }
            if (this.additionalResources != null) {
                for (Resource res : this.additionalResources) {
                    this.resourceManager.uninventoryResource(this.overlord, res.getId());
                    this.resourceManager.uninventoryResourceAsyncWork(this.overlord, res.getId());
                }
            }
            if (this.theResourceType != null) {
                this.getTransactionManager().begin();
                this.em.remove(this.em.find(ResourceType.class, (Object)this.theResourceType.getId()));
                this.theResourceType = null;
                this.getTransactionManager().commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.unprepareForTestAgents();
            this.unprepareScheduler();
            this.unprepareServerPluginService();
            this.testServerPluginService.stopMasterPluginContainer();
        }
    }

    @Test(enabled=true)
    public void testInsertPastAvailabilities() throws Exception {
        Long now = System.currentTimeMillis();
        Long middle = now - 30000L;
        Long then = now - 60000L;
        this.beginTx();
        try {
            this.setupResource();
            this.commitAndClose();
            Availability aThen = new Availability(this.theResource, then, UP);
            aThen.setEndTime(middle);
            Availability aMiddle = new Availability(this.theResource, middle, DOWN);
            aMiddle.setEndTime(now);
            Availability aNow = new Availability(this.theResource, now, UP);
            this.persistAvailability(aThen);
            this.persistAvailability(aNow);
            this.persistAvailability(aMiddle);
            this.beginTx();
            Query q = this.em.createNamedQuery("Availability.findByResource");
            q.setParameter("resourceId", (Object)this.theResource.getId());
            List avails = q.getResultList();
            assert (avails.size() == 3) : "Did not get 3 availabilities but " + avails.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (0 == this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    @Test(enabled=true)
    public void testPurgeAvailabilities() throws Exception {
        Long now = System.currentTimeMillis();
        Long middle = now - 30000L;
        Long then = now - 60000L;
        this.beginTx();
        try {
            this.setupResource();
            this.commitAndClose();
            Availability aThen = new Availability(this.theResource, then, UP);
            Availability aMiddle = new Availability(this.theResource, middle, DOWN);
            aMiddle.setEndTime(now);
            Availability aNow = new Availability(this.theResource, now, UP);
            this.persistAvailability(aThen);
            this.persistAvailability(aMiddle);
            this.persistAvailability(aNow);
            this.beginTx();
            int purged = this.availabilityManager.purgeAvailabilities(now - 29999L);
            assert (purged == 2) : "Didn't purge 2 --> " + purged;
            Query q = this.em.createNamedQuery("Availability.findByResource");
            q.setParameter("resourceId", (Object)this.theResource.getId());
            List avails = q.getResultList();
            assert (avails.size() == 2);
            assert (((Availability)avails.get(0)).getAvailabilityType() == DOWN);
            assert (((Availability)avails.get(0)).getStartTime().equals(middle));
            assert (((Availability)avails.get(0)).getEndTime().equals(now));
            assert (((Availability)avails.get(1)).getAvailabilityType() == UP);
            assert (((Availability)avails.get(1)).getStartTime().equals(now));
            assert (((Availability)avails.get(1)).getEndTime() == null);
            purged = this.availabilityManager.purgeAvailabilities(now + 12345L);
            assert (purged == 1) : "Didn't purge 1 --> " + purged;
            purged = this.availabilityManager.purgeAvailabilities(now + 12345L);
            assert (purged == 0) : "Didn't purge 0 --> " + purged;
            q = this.em.createNamedQuery("Availability.findByResource");
            q.setParameter("resourceId", (Object)this.theResource.getId());
            avails = q.getResultList();
            assert (avails.size() == 1);
            assert (((Availability)avails.get(0)).getAvailabilityType() == UP);
            assert (((Availability)avails.get(0)).getStartTime().equals(now));
            assert (((Availability)avails.get(0)).getEndTime() == null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (0 == this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    @Test(enabled=true)
    public void testGetResourceAvailabilities() throws Exception {
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                AvailabilityManagerTest.this.setupResource();
            }
        });
        long now = System.currentTimeMillis();
        AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
        List avails = this.availabilityManager.getAvailabilitiesForResource(this.overlord, this.theResource.getId(), 1L, now);
        assert (avails.size() == 1) : "Should only be initial unknown avail data";
        assert (((Availability)avails.get(0)).getAvailabilityType() == UNKNOWN);
        assert (((Availability)avails.get(0)).getStartTime().equals(1L));
        assert (((Availability)avails.get(0)).getEndTime().equals(now));
        Long startMillis = 60000L;
        Availability avail = new Availability(this.theResource, startMillis, UP);
        report.addAvailability(avail);
        this.availabilityManager.mergeAvailabilityReport(report);
        avails = this.availabilityManager.getAvailabilitiesForResource(this.overlord, this.theResource.getId(), 30000L, startMillis + 10000L);
        this.assertEquals("Range should cover both avails", 2, avails.size());
        assert (((Availability)avails.get(0)).getAvailabilityType() == UNKNOWN);
        assert (((Availability)avails.get(0)).getStartTime().equals(30000L));
        assert (((Availability)avails.get(0)).getEndTime().equals(60000L));
        assert (((Availability)avails.get(1)).getAvailabilityType() == UP);
        assert (((Availability)avails.get(1)).getStartTime().equals(60000L));
        assert (((Availability)avails.get(1)).getEndTime().equals(startMillis + 10000L));
        avails = this.availabilityManager.getAvailabilitiesForResource(this.overlord, this.theResource.getId(), startMillis.longValue(), startMillis + 10000L);
        this.assertEquals("Range start on avail start border and extending to future", 1, avails.size());
        assert (((Availability)avails.get(0)).getAvailabilityType() == UP);
        assert (((Availability)avails.get(0)).getStartTime().equals(startMillis));
        assert (((Availability)avails.get(0)).getEndTime().equals(startMillis + 10000L));
        avails = this.availabilityManager.getAvailabilitiesForResource(this.overlord, this.theResource.getId(), 1000L, startMillis - 10000L);
        this.assertEquals("Range completely in first avail", 1, avails.size());
        assert (((Availability)avails.get(0)).getAvailabilityType() == UNKNOWN);
        assert (((Availability)avails.get(0)).getStartTime().equals(1000L));
        assert (((Availability)avails.get(0)).getEndTime().equals(startMillis - 10000L));
        avails = this.availabilityManager.getAvailabilitiesForResource(this.overlord, this.theResource.getId(), startMillis + 5000L, startMillis + 10000L);
        this.assertEquals("Range completely in last avail", 1, avails.size());
        assert (((Availability)avails.get(0)).getAvailabilityType() == UP);
        assert (((Availability)avails.get(0)).getStartTime().equals(startMillis + 5000L));
        assert (((Availability)avails.get(0)).getEndTime().equals(startMillis + 10000L));
        report = new AvailabilityReport(false, this.theAgent.getName());
        report.setEnablementReport(true);
        report.addAvailability(new Availability(this.theResource, Long.valueOf(startMillis + 10000L), DISABLED));
        this.availabilityManager.mergeAvailabilityReport(report);
        report = new AvailabilityReport(false, this.theAgent.getName());
        report.setEnablementReport(true);
        report.addAvailability(new Availability(this.theResource, Long.valueOf(startMillis + 15000L), UNKNOWN));
        this.availabilityManager.mergeAvailabilityReport(report);
        report = new AvailabilityReport(false, this.theAgent.getName());
        report.addAvailability(new Availability(this.theResource, Long.valueOf(startMillis + 20000L), UP));
        this.availabilityManager.mergeAvailabilityReport(report);
        report = new AvailabilityReport(false, this.theAgent.getName());
        report.addAvailability(new Availability(this.theResource, Long.valueOf(startMillis + 30000L), DOWN));
        this.availabilityManager.mergeAvailabilityReport(report);
        avails = this.availabilityManager.getAvailabilitiesForResource(this.overlord, this.theResource.getId(), startMillis - 15000L, startMillis + 35000L);
        this.assertEquals("Range should cover 45000 - 95000", 6, avails.size());
        assert (((Availability)avails.get(0)).getAvailabilityType() == UNKNOWN);
        assert (((Availability)avails.get(0)).getStartTime().equals(45000L));
        assert (((Availability)avails.get(0)).getEndTime().equals(60000L));
        assert (((Availability)avails.get(1)).getAvailabilityType() == UP);
        assert (((Availability)avails.get(1)).getStartTime().equals(60000L));
        assert (((Availability)avails.get(1)).getEndTime().equals(70000L));
        assert (((Availability)avails.get(2)).getAvailabilityType() == DISABLED);
        assert (((Availability)avails.get(2)).getStartTime().equals(70000L));
        assert (((Availability)avails.get(2)).getEndTime().equals(75000L));
        assert (((Availability)avails.get(3)).getAvailabilityType() == UNKNOWN);
        assert (((Availability)avails.get(3)).getStartTime().equals(75000L));
        assert (((Availability)avails.get(3)).getEndTime().equals(80000L));
        assert (((Availability)avails.get(4)).getAvailabilityType() == UP);
        assert (((Availability)avails.get(4)).getStartTime().equals(80000L));
        assert (((Availability)avails.get(4)).getEndTime().equals(90000L));
        assert (((Availability)avails.get(5)).getAvailabilityType() == DOWN);
        assert (((Availability)avails.get(5)).getStartTime().equals(90000L));
        assert (((Availability)avails.get(5)).getEndTime().equals(95000L));
    }

    @Test(enabled=true)
    public void testGetResourceAvailabilities_2() throws Exception {
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                AvailabilityManagerTest.this.setupResource();
            }
        });
        long now = System.currentTimeMillis();
        AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
        List avails = this.availabilityManager.getAvailabilitiesForResource(this.overlord, this.theResource.getId(), 1L, now);
        assert (avails.size() == 1) : "Should only be initial unknown avail data";
        assert (((Availability)avails.get(0)).getAvailabilityType() == UNKNOWN);
        assert (((Availability)avails.get(0)).getStartTime().equals(1L));
        assert (((Availability)avails.get(0)).getEndTime().equals(now));
        Long startMillis = 60000L;
        Availability avail = new Availability(this.theResource, startMillis, UP);
        report.addAvailability(avail);
        this.availabilityManager.mergeAvailabilityReport(report);
        avails = this.availabilityManager.getAvailabilitiesForResource(this.overlord, this.theResource.getId(), 30000L, startMillis + 10000L);
        this.assertEquals("Range should cover both avails", 2, avails.size());
        assert (((Availability)avails.get(0)).getAvailabilityType() == UNKNOWN);
        assert (((Availability)avails.get(0)).getStartTime().equals(30000L));
        assert (((Availability)avails.get(0)).getEndTime().equals(60000L));
        assert (((Availability)avails.get(1)).getAvailabilityType() == UP);
        assert (((Availability)avails.get(1)).getStartTime().equals(60000L));
        assert (((Availability)avails.get(1)).getEndTime().equals(startMillis + 10000L));
        this.availabilityManager.purgeAvailabilities(System.currentTimeMillis());
        avails = this.availabilityManager.getAvailabilitiesForResource(this.overlord, this.theResource.getId(), 10000L, 20000L);
        this.assertEquals("all surrogate", 1, avails.size());
        assert (((Availability)avails.get(0)).getAvailabilityType() == UNKNOWN);
        assert (((Availability)avails.get(0)).getStartTime().equals(10000L));
        assert (((Availability)avails.get(0)).getEndTime().equals(20000L));
        avails = this.availabilityManager.getAvailabilitiesForResource(this.overlord, this.theResource.getId(), 50000L, 70000L);
        this.assertEquals("surrogate to start and then real avail", 2, avails.size());
        assert (((Availability)avails.get(0)).getAvailabilityType() == UNKNOWN);
        assert (((Availability)avails.get(0)).getStartTime().equals(50000L));
        assert (((Availability)avails.get(0)).getEndTime().equals(60000L));
        assert (((Availability)avails.get(1)).getAvailabilityType() == UP);
        assert (((Availability)avails.get(1)).getStartTime().equals(60000L));
        assert (((Availability)avails.get(1)).getEndTime().equals(70000L));
    }

    @Test(enabled=true)
    public void testGetResourceGroupAvailabilities() throws Exception {
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                AvailabilityManagerTest.this.setupResource();
                AvailabilityManagerTest.this.setupAnotherResource(1, AvailabilityManagerTest.this.theResource);
                AvailabilityManagerTest.this.setupAnotherResource(2, AvailabilityManagerTest.this.theResource);
            }
        });
        final Resource r1 = this.theResource;
        final Resource r2 = this.additionalResources.get(0);
        final Resource r3 = this.additionalResources.get(1);
        AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
        report.addAvailability(new Availability(r1, Long.valueOf(10000L), DOWN));
        report.addAvailability(new Availability(r2, Long.valueOf(10000L), DOWN));
        report.addAvailability(new Availability(r3, Long.valueOf(10000L), DOWN));
        report.addAvailability(new Availability(r1, Long.valueOf(20000L), UP));
        report.addAvailability(new Availability(r2, Long.valueOf(20000L), UP));
        report.addAvailability(new Availability(r3, Long.valueOf(30000L), UP));
        report.addAvailability(new Availability(r3, Long.valueOf(40000L), DISABLED));
        this.availabilityManager.mergeAvailabilityReport(report);
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Subject subject = SessionTestHelper.createNewSubject(AvailabilityManagerTest.this.em, "testSubject");
                Role roleWithSubject = SessionTestHelper.createNewRoleForSubject(AvailabilityManagerTest.this.em, subject, "role with subject");
                roleWithSubject.addPermission(Permission.VIEW_RESOURCE);
                ResourceGroup group = SessionTestHelper.createNewCompatibleGroupForRole(AvailabilityManagerTest.this.em, roleWithSubject, "accessible group");
                int groupId = group.getId();
                List avails = AvailabilityManagerTest.this.availabilityManager.getAvailabilitiesForResourceGroup(AvailabilityManagerTest.this.overlord, groupId, 0L, 20000L);
                AvailabilityManagerTest.this.assertEquals("Should have 1 EMPTY rgAvail", 1, avails.size());
                AvailabilityManagerTest.this.assertEquals("Should have 1 EMPTY rgAvail", ResourceGroupComposite.GroupAvailabilityType.EMPTY, ((ResourceGroupAvailability)avails.get(0)).getGroupAvailabilityType());
                AvailabilityManagerTest.this.assertEquals("Should cover whole range", 0L, ((ResourceGroupAvailability)avails.get(0)).getStartTime());
                AvailabilityManagerTest.this.assertEquals("Should cover whole range", 20000L, ((ResourceGroupAvailability)avails.get(0)).getEndTime());
                group.addExplicitResource(r1);
                group.addExplicitResource(r2);
                group.addExplicitResource(r3);
                AvailabilityManagerTest.this.em.merge((Object)group);
                AvailabilityManagerTest.this.em.flush();
                avails = AvailabilityManagerTest.this.availabilityManager.getAvailabilitiesForResourceGroup(AvailabilityManagerTest.this.overlord, groupId, 5000L, 50000L);
                AvailabilityManagerTest.this.assertEquals("Should have initial avail + 4 changes", 5, avails.size());
                AvailabilityManagerTest.this.assertEquals("AV0 WARN  5000-10000", ResourceGroupComposite.GroupAvailabilityType.WARN, ((ResourceGroupAvailability)avails.get(0)).getGroupAvailabilityType());
                AvailabilityManagerTest.this.assertEquals("AV0 WARN  5000-10000", 5000L, ((ResourceGroupAvailability)avails.get(0)).getStartTime());
                AvailabilityManagerTest.this.assertEquals("AV0 WARN  5000-10000", 10000L, ((ResourceGroupAvailability)avails.get(0)).getEndTime());
                AvailabilityManagerTest.this.assertEquals("AV1 DOWN  10000-20000", ResourceGroupComposite.GroupAvailabilityType.DOWN, ((ResourceGroupAvailability)avails.get(1)).getGroupAvailabilityType());
                AvailabilityManagerTest.this.assertEquals("AV1 DOWN  10000-20000", 10000L, ((ResourceGroupAvailability)avails.get(1)).getStartTime());
                AvailabilityManagerTest.this.assertEquals("AV1 DOWN  10000-20000", 20000L, ((ResourceGroupAvailability)avails.get(1)).getEndTime());
                AvailabilityManagerTest.this.assertEquals("AV2 WARN  20000-30000", ResourceGroupComposite.GroupAvailabilityType.WARN, ((ResourceGroupAvailability)avails.get(2)).getGroupAvailabilityType());
                AvailabilityManagerTest.this.assertEquals("AV2 WARN  20000-30000", 20000L, ((ResourceGroupAvailability)avails.get(2)).getStartTime());
                AvailabilityManagerTest.this.assertEquals("AV2 WARN  20000-30000", 30000L, ((ResourceGroupAvailability)avails.get(2)).getEndTime());
                AvailabilityManagerTest.this.assertEquals("AV3 DISABLED 30000-40000", ResourceGroupComposite.GroupAvailabilityType.UP, ((ResourceGroupAvailability)avails.get(3)).getGroupAvailabilityType());
                AvailabilityManagerTest.this.assertEquals("AV3 DISABLED 30000-40000", 30000L, ((ResourceGroupAvailability)avails.get(3)).getStartTime());
                AvailabilityManagerTest.this.assertEquals("AV3 DISABLED 30000-40000", 40000L, ((ResourceGroupAvailability)avails.get(3)).getEndTime());
                AvailabilityManagerTest.this.assertEquals("AV4 DISABLED 40000-50000", ResourceGroupComposite.GroupAvailabilityType.DISABLED, ((ResourceGroupAvailability)avails.get(4)).getGroupAvailabilityType());
                AvailabilityManagerTest.this.assertEquals("AV4 DISABLED 40000-50000", 40000L, ((ResourceGroupAvailability)avails.get(4)).getStartTime());
                AvailabilityManagerTest.this.assertEquals("AV4 DISABLED 40000-50000", 50000L, ((ResourceGroupAvailability)avails.get(4)).getEndTime());
            }
        });
    }

    @Test(enabled=true)
    @Deprecated
    public void testGetAvailabilities() throws Exception {
        this.beginTx();
        try {
            this.setupResource();
            this.commitAndClose();
            AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
            List availPoints = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), 1L, System.currentTimeMillis(), 3, false);
            assert (availPoints.size() == 3) : "There is no avail data, but should still get 3 availability points";
            assert (((AvailabilityPoint)availPoints.get(0)).getAvailabilityType() == UNKNOWN);
            assert (((AvailabilityPoint)availPoints.get(1)).getAvailabilityType() == UNKNOWN);
            assert (((AvailabilityPoint)availPoints.get(2)).getAvailabilityType() == UNKNOWN);
            Long startMillis = 60000L;
            Availability avail = new Availability(this.theResource, startMillis, UP);
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            availPoints = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), startMillis.longValue(), startMillis + 10000L, 3, false);
            assert (availPoints.size() == 3) : "There is 1 avail data, but should still get 3 availability points";
            assert (((AvailabilityPoint)availPoints.get(0)).getAvailabilityType() == UP);
            assert (((AvailabilityPoint)availPoints.get(1)).getAvailabilityType() == UP);
            assert (((AvailabilityPoint)availPoints.get(2)).getAvailabilityType() == UP);
            availPoints = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), startMillis - 3L, startMillis.longValue(), 3, false);
            assert (availPoints.size() == 3) : "There is 1 avail data, but should still get 3 availability points";
            assert (((AvailabilityPoint)availPoints.get(0)).getAvailabilityType() == UNKNOWN);
            assert (!((AvailabilityPoint)availPoints.get(0)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(1)).getAvailabilityType() == UNKNOWN);
            assert (!((AvailabilityPoint)availPoints.get(1)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(2)).getAvailabilityType() == UNKNOWN);
            assert (!((AvailabilityPoint)availPoints.get(2)).isKnown()) : availPoints;
            availPoints = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), startMillis - 20000L, startMillis + 10000L, 3, false);
            assert (availPoints.size() == 3) : "There is 1 avail data, but should still get 3 availability points";
            assert (((AvailabilityPoint)availPoints.get(0)).getAvailabilityType() == UNKNOWN);
            assert (!((AvailabilityPoint)availPoints.get(0)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(1)).getAvailabilityType() == UNKNOWN);
            assert (!((AvailabilityPoint)availPoints.get(1)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(2)).getAvailabilityType() == UP) : availPoints;
            availPoints = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), startMillis - 10000L, startMillis + 20000L, 3, false);
            assert (availPoints.size() == 3) : "There is 1 avail data, but should still get 3 availability points";
            assert (((AvailabilityPoint)availPoints.get(0)).getAvailabilityType() == UNKNOWN);
            assert (!((AvailabilityPoint)availPoints.get(0)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(1)).getAvailabilityType() == UP);
            assert (((AvailabilityPoint)availPoints.get(1)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(2)).getAvailabilityType() == UP);
            availPoints = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), startMillis - 20000L, startMillis + 20000L, 10, false);
            assert (availPoints.size() == 10) : "There is 1 avail data, but should still get 10 availability points";
            assert (((AvailabilityPoint)availPoints.get(0)).getAvailabilityType() == UNKNOWN) : availPoints;
            assert (!((AvailabilityPoint)availPoints.get(0)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(1)).getAvailabilityType() == UNKNOWN) : availPoints;
            assert (!((AvailabilityPoint)availPoints.get(1)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(2)).getAvailabilityType() == UNKNOWN) : availPoints;
            assert (!((AvailabilityPoint)availPoints.get(2)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(3)).getAvailabilityType() == UNKNOWN) : availPoints;
            assert (!((AvailabilityPoint)availPoints.get(3)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(4)).getAvailabilityType() == UNKNOWN) : availPoints;
            assert (!((AvailabilityPoint)availPoints.get(4)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(5)).getAvailabilityType() == UP) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(5)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(6)).getAvailabilityType() == UP) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(7)).getAvailabilityType() == UP) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(8)).getAvailabilityType() == UP) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(9)).getAvailabilityType() == UP) : availPoints;
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.setEnablementReport(true);
            report.addAvailability(new Availability(this.theResource, Long.valueOf(startMillis + 10000L), DISABLED));
            this.availabilityManager.mergeAvailabilityReport(report);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.setEnablementReport(true);
            report.addAvailability(new Availability(this.theResource, Long.valueOf(startMillis + 15000L), UNKNOWN));
            this.availabilityManager.mergeAvailabilityReport(report);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(new Availability(this.theResource, Long.valueOf(startMillis + 20000L), UP));
            this.availabilityManager.mergeAvailabilityReport(report);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(new Availability(this.theResource, Long.valueOf(startMillis + 30000L), DOWN));
            this.availabilityManager.mergeAvailabilityReport(report);
            availPoints = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), startMillis - 15000L, startMillis + 35000L, 5, false);
            assert (availPoints.size() == 5) : "should get 5 availability points";
            assert (((AvailabilityPoint)availPoints.get(0)).getAvailabilityType() == UNKNOWN) : availPoints;
            assert (!((AvailabilityPoint)availPoints.get(0)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(1)).getAvailabilityType() == UNKNOWN) : availPoints;
            assert (!((AvailabilityPoint)availPoints.get(1)).isKnown()) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(2)).getAvailabilityType() == DISABLED) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(3)).getAvailabilityType() == UNKNOWN) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(4)).getAvailabilityType() == DOWN) : availPoints;
            availPoints = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), startMillis - 30000L, startMillis + 30000L, 10, false);
            assert (availPoints.size() == 10) : "should get 10 availability points";
            assert (((AvailabilityPoint)availPoints.get(0)).getAvailabilityType() == UNKNOWN) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(1)).getAvailabilityType() == UNKNOWN) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(2)).getAvailabilityType() == UNKNOWN) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(3)).getAvailabilityType() == UNKNOWN) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(4)).getAvailabilityType() == UNKNOWN) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(5)).getAvailabilityType() == UP) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(6)).getAvailabilityType() == DISABLED) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(7)).getAvailabilityType() == DISABLED) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(8)).getAvailabilityType() == UNKNOWN) : availPoints;
            assert (((AvailabilityPoint)availPoints.get(9)).getAvailabilityType() == UP) : availPoints;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (0 == this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    @Test(enabled=true)
    public void testSetAllAgentResourceAvailabilities() throws Exception {
        this.beginTx();
        try {
            this.setupResource();
            this.commitAndClose();
            Availability avail = new Availability(this.theResource, UNKNOWN);
            this.persistAvailability(avail);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == UNKNOWN);
            this.availabilityManager.updateAgentResourceAvailabilities(this.theAgent.getId(), UP, UP);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == UP);
            this.availabilityManager.updateAgentResourceAvailabilities(this.theAgent.getId(), DOWN, DOWN);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == DOWN);
            this.availabilityManager.updateAgentResourceAvailabilities(this.theAgent.getId(), DOWN, DOWN);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == DOWN);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (0 == this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    @Test(enabled=true)
    public void testAgentBackfillNewResource() throws Exception {
        this.beginTx();
        try {
            this.setupResource();
            this.commitAndClose();
            LookupUtil.getAgentManager().checkForSuspectAgents();
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == UNKNOWN);
            this.beginTx();
            Resource resource = (Resource)this.em.find(Resource.class, (Object)this.theResource.getId());
            List avails = resource.getAvailability();
            assert (avails != null);
            assert (avails.size() == 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (0 == this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    @Test(enabled=true)
    public void testAgentBackfill() throws Exception {
        this.beginTx();
        try {
            this.prepareForTestAgents();
            this.setupResource();
            this.commitAndClose();
            Availability avail = new Availability(this.theResource, Long.valueOf(System.currentTimeMillis() - 12000000L), UP);
            AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == UP);
            this.beginTx();
            Agent agent = (Agent)this.em.find(Agent.class, (Object)this.theAgent.getId());
            agent.setLastAvailabilityPing(Long.valueOf(System.currentTimeMillis() - 1080000L));
            this.commitAndClose();
            LookupUtil.getAgentManager().checkForSuspectAgents();
            AvailabilityType curAvail = this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId());
            assert (curAvail == DOWN) : curAvail;
            this.beginTx();
            Resource resource = (Resource)this.em.find(Resource.class, (Object)this.theResource.getId());
            List allAvails = resource.getAvailability();
            assert (allAvails.size() == 3);
            this.commitAndClose();
            Availability a1 = (Availability)allAvails.get(0);
            Availability a2 = (Availability)allAvails.get(1);
            Availability a3 = (Availability)allAvails.get(2);
            assert (a1.getAvailabilityType() == UNKNOWN);
            assert (a2.getAvailabilityType() == UP) : a2.getAvailabilityType();
            assert (a3.getAvailabilityType() == DOWN) : a3.getAvailabilityType();
            assert (a1.getEndTime() != null);
            assert (a2.getEndTime() != null);
            assert (a3.getEndTime() == null);
            assert (a1.getEndTime() > a1.getStartTime());
            assert (a2.getEndTime() > a2.getStartTime());
            assert (a2.getStartTime().equals(a1.getEndTime()));
            assert (a3.getStartTime().equals(a2.getEndTime()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.unprepareForTestAgents();
            if (0 == this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    @Test(enabled=true)
    public void testAgentBackfillPerformance() throws Exception {
        this.beginTx();
        ArrayList<Resource> allResources = new ArrayList<Resource>();
        try {
            this.prepareForTestAgents();
            this.setupResource();
            allResources.add(this.theResource);
            for (int i = 0; i < 99; ++i) {
                allResources.add(this.setupAnotherResource(i, this.theResource));
            }
            this.em.flush();
            this.commitAndClose();
            for (Resource res : allResources) {
                int resId = res.getId();
                Availability currentAvailability = this.availabilityManager.getCurrentAvailabilityForResource(this.overlord, resId);
                assert (currentAvailability != null) : "Current Availability was null for " + resId;
                assert (currentAvailability.getAvailabilityType() == UNKNOWN) : "Current AvailabilityType should have been UNKNOWN for " + resId;
                AvailabilityCriteria c = new AvailabilityCriteria();
                c.addFilterResourceId(Integer.valueOf(resId));
                c.addFilterInterval(Long.valueOf(0L), Long.valueOf(Long.MAX_VALUE));
                c.addSortStartTime(PageOrdering.ASC);
                PageList allData = this.availabilityManager.findAvailabilityByCriteria(this.overlord, c);
                assert (allData != null) : "All availabilities was null for " + resId;
                assert (allData.size() == 1) : "All availabilities size was " + allData.size() + " for " + resId;
                ResourceAvailability currentResAvail = this.resourceAvailabilityManager.getLatestAvailability(resId);
                assert (currentResAvail != null) : "Current ResourceAvailability was null for " + resId;
                assert (currentResAvail.getAvailabilityType() == UNKNOWN) : "Current ResourceAvailabilityType should have been UNKNOWN for " + resId;
            }
            this.beginTx();
            Agent agent = (Agent)this.em.find(Agent.class, (Object)this.theAgent.getId());
            agent.setLastAvailabilityPing(Long.valueOf(System.currentTimeMillis() - 1080000L));
            this.commitAndClose();
            long start = System.currentTimeMillis();
            LookupUtil.getAgentManager().checkForSuspectAgents();
            System.out.println("testAgentBackfillPerformance: checkForSuspectAgents run 1 took " + (System.currentTimeMillis() - start) + "ms");
            Thread.sleep(500L);
            AvailabilityReport upReport = new AvailabilityReport(false, this.theAgent.getName());
            AvailabilityReport disabledReport = new AvailabilityReport(false, this.theAgent.getName());
            disabledReport.setEnablementReport(true);
            int resNum = 0;
            for (Resource resource : allResources) {
                if (resNum++ <= 80) {
                    upReport.addAvailability(new Availability(resource, UP));
                    continue;
                }
                disabledReport.addAvailability(new Availability(resource, DISABLED));
            }
            start = System.currentTimeMillis();
            this.availabilityManager.mergeAvailabilityReport(upReport);
            this.availabilityManager.mergeAvailabilityReport(disabledReport);
            System.out.println("testAgentBackfillPerformance: mergeAvailabilityReport run took " + (System.currentTimeMillis() - start) + "ms");
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == UP);
            this.beginTx();
            agent = (Agent)this.em.find(Agent.class, (Object)this.theAgent.getId());
            agent.setLastAvailabilityPing(Long.valueOf(System.currentTimeMillis() - 1080000L));
            this.commitAndClose();
            start = System.currentTimeMillis();
            LookupUtil.getAgentManager().checkForSuspectAgents();
            System.out.println("testAgentBackfillPerformance: checkForSuspectAgents run 2 took " + (System.currentTimeMillis() - start) + "ms");
            start = System.currentTimeMillis();
            resNum = 0;
            block12: for (Resource resource : allResources) {
                AvailabilityType curAvail = this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, resource.getId());
                AvailabilityType expected = 0 == resNum ? DOWN : (resNum > 80 ? DISABLED : UNKNOWN);
                ++resNum;
                assert (curAvail == expected) : "Expected " + expected.name() + " but got " + curAvail.name() + " for " + resource;
                this.beginTx();
                resource = (Resource)this.em.find(Resource.class, (Object)resource.getId());
                List allAvails = resource.getAvailability();
                assert (allAvails.size() == (expected == DOWN ? 4 : (expected == DISABLED ? 2 : 3))) : allAvails;
                this.commitAndClose();
                Availability a0 = (Availability)allAvails.get(0);
                Availability a1 = (Availability)allAvails.get(1);
                Availability a2 = null;
                Availability a3 = null;
                assert (a0.getAvailabilityType() == UNKNOWN) : allAvails;
                switch (expected) {
                    case DOWN: {
                        a2 = (Availability)allAvails.get(2);
                        a3 = (Availability)allAvails.get(3);
                        assert (a1.getAvailabilityType() == DOWN) : allAvails;
                        assert (a2.getAvailabilityType() == UP) : allAvails;
                        assert (a3.getAvailabilityType() == DOWN) : allAvails;
                        assert (a0.getEndTime() != null) : allAvails;
                        assert (a1.getEndTime() != null) : allAvails;
                        assert (a2.getEndTime() != null) : allAvails;
                        assert (a3.getEndTime() == null) : allAvails;
                        assert (a0.getEndTime() > a0.getStartTime()) : allAvails;
                        assert (a0.getEndTime().equals(a1.getStartTime())) : allAvails;
                        assert (a1.getEndTime().equals(a2.getStartTime())) : allAvails;
                        assert (a2.getEndTime().equals(a3.getStartTime())) : allAvails;
                        continue block12;
                    }
                    case DISABLED: {
                        assert (a1.getAvailabilityType() == DISABLED) : allAvails;
                        assert (a0.getEndTime() != null) : allAvails;
                        assert (a1.getEndTime() == null) : allAvails;
                        assert (a0.getEndTime() > a0.getStartTime()) : allAvails;
                        assert (a0.getEndTime().equals(a1.getStartTime())) : allAvails;
                        continue block12;
                    }
                }
                a2 = (Availability)allAvails.get(2);
                assert (a1.getAvailabilityType() == UP) : allAvails;
                assert (((Availability)allAvails.get(2)).getAvailabilityType() == UNKNOWN) : allAvails;
                assert (a0.getEndTime() != null) : allAvails;
                assert (a1.getEndTime() != null) : allAvails;
                assert (a2.getEndTime() == null) : allAvails;
                assert (a0.getEndTime() > a0.getStartTime()) : allAvails;
                assert (a0.getEndTime().equals(a1.getStartTime())) : allAvails;
                assert (a1.getEndTime().equals(a2.getStartTime())) : allAvails;
            }
            System.out.println("testAgentBackfillPerformance: checking validity of data took " + (System.currentTimeMillis() - start) + "ms");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.unprepareForTestAgents();
            if (0 == this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    @Test(enabled=true)
    public void testAgentOldReport() throws Exception {
        this.beginTx();
        try {
            this.setupResource();
            this.commitAndClose();
            long now = System.currentTimeMillis();
            Availability avail = new Availability(this.theResource, DOWN);
            AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            avail = new Availability(this.theResource, Long.valueOf(now - 600000L), UP);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            assert (this.getPointInTime(new Date(avail.getStartTime() - 2L)) == UNKNOWN);
            assert (this.getPointInTime(new Date(avail.getStartTime())) == UP);
            assert (this.getPointInTime(new Date(avail.getStartTime() + 2L)) == UP);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == DOWN);
            avail = new Availability(this.theResource, Long.valueOf(now - 300000L), UP);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            assert (this.getPointInTime(new Date(avail.getStartTime() - 2L)) == UP);
            assert (this.getPointInTime(new Date(avail.getStartTime())) == UP);
            assert (this.getPointInTime(new Date(avail.getStartTime() + 2L)) == UP);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == DOWN);
            avail = new Availability(this.theResource, Long.valueOf(now - 100000L), DOWN);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            assert (this.getPointInTime(new Date(avail.getStartTime() - 2L)) == UP);
            assert (this.getPointInTime(new Date(avail.getStartTime())) == DOWN);
            assert (this.getPointInTime(new Date(avail.getStartTime() + 2L)) == DOWN);
            avail = new Availability(this.theResource, Long.valueOf(now - 450000L), DOWN);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            assert (this.getPointInTime(new Date(avail.getStartTime() - 2L)) == UP);
            assert (this.getPointInTime(new Date(avail.getStartTime())) == DOWN);
            assert (this.getPointInTime(new Date(avail.getStartTime() + 2L)) == DOWN);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == DOWN);
            avail = new Availability(this.theResource, Long.valueOf(now - 700000L), UP);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            assert (this.getPointInTime(new Date(avail.getStartTime() - 2L)) == UNKNOWN);
            assert (this.getPointInTime(new Date(avail.getStartTime())) == UP);
            assert (this.getPointInTime(new Date(avail.getStartTime() + 2L)) == UP);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (0 == this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    @Test(enabled=true)
    public void testAgentCurrentAvailability() throws Exception {
        this.beginTx();
        try {
            this.setupResource();
            this.commitAndClose();
            long now = System.currentTimeMillis();
            Availability avail = new Availability(this.theResource, DOWN);
            AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            avail = new Availability(this.theResource, Long.valueOf(now - 600000L), UP);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            this.availabilityManager.mergeAvailabilityReport(report);
            assert (this.getPointInTime(new Date(avail.getStartTime() - 2L)) == UNKNOWN);
            Date unknownTime = new Date(avail.getStartTime() - 2L);
            List list = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), unknownTime.getTime(), unknownTime.getTime() + 1L, 1, true);
            AvailabilityType returnedAvail = ((AvailabilityPoint)list.get(0)).getAvailabilityType();
            assert (returnedAvail == DOWN) : "Expected current avail to be '" + DOWN + "' but was '" + returnedAvail + "'.";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (0 == this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    @Test(enabled=true)
    public void testAgentOldReport2() throws Exception {
        this.beginTx();
        try {
            this.setupResource();
            this.commitAndClose();
            long now = System.currentTimeMillis();
            this.persistAvailability(new Availability(this.theResource, Long.valueOf(now - 1000000L), UP));
            this.persistAvailability(new Availability(this.theResource, Long.valueOf(now - 900000L), DOWN));
            this.persistAvailability(new Availability(this.theResource, Long.valueOf(now - 800000L), UP));
            this.persistAvailability(new Availability(this.theResource, Long.valueOf(now - 50000L), DOWN));
            this.persistAvailability(new Availability(this.theResource, Long.valueOf(now - 30000L), UP));
            this.persistAvailability(new Availability(this.theResource, Long.valueOf(now), DOWN));
            this.persistAvailability(new Availability(this.theResource, Long.valueOf(now - 600000L), UP));
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == DOWN);
            this.persistAvailability(new Availability(this.theResource, Long.valueOf(now - 300000L), UP));
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == DOWN);
            this.persistAvailability(new Availability(this.theResource, Long.valueOf(now - 100000L), DOWN));
            this.persistAvailability(new Availability(this.theResource, Long.valueOf(now - 450000L), DOWN));
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, this.theResource.getId()) == DOWN);
            this.persistAvailability(new Availability(this.theResource, Long.valueOf(now - 700000L), UP));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (0 == this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    @Test(enabled=true)
    @Deprecated
    public void testGetAvailabilities2() throws Exception {
        this.beginTx();
        try {
            this.setupResource();
            this.commitAndClose();
            Calendar cal = Calendar.getInstance();
            cal.set(1, 2000);
            cal.set(2, 0);
            cal.set(5, 1);
            cal.set(10, 1);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Date date1 = cal.getTime();
            cal.set(10, 1);
            cal.set(12, 30);
            Date date2 = cal.getTime();
            cal.set(10, 2);
            cal.set(12, 0);
            Date date3 = cal.getTime();
            cal.set(10, 2);
            cal.set(12, 30);
            Date date4 = cal.getTime();
            cal.set(10, 3);
            cal.set(12, 0);
            Date date5 = cal.getTime();
            cal.set(10, 3);
            cal.set(12, 30);
            Date date6 = cal.getTime();
            Availability avail = new Availability(this.theResource, Long.valueOf(date1.getTime()), UP);
            avail.setEndTime(Long.valueOf(date2.getTime()));
            this.persistAvailability(avail);
            avail = new Availability(this.theResource, Long.valueOf(date2.getTime()), DOWN);
            avail.setEndTime(Long.valueOf(date3.getTime()));
            this.persistAvailability(avail);
            avail = new Availability(this.theResource, Long.valueOf(date3.getTime()), UP);
            avail.setEndTime(Long.valueOf(date4.getTime()));
            this.persistAvailability(avail);
            avail = new Availability(this.theResource, Long.valueOf(date4.getTime()), DOWN);
            avail.setEndTime(Long.valueOf(date5.getTime()));
            this.persistAvailability(avail);
            avail = new Availability(this.theResource, Long.valueOf(date5.getTime()), UP);
            avail.setEndTime(Long.valueOf(date6.getTime()));
            this.persistAvailability(avail);
            avail = new Availability(this.theResource, Long.valueOf(date6.getTime()), DOWN);
            this.persistAvailability(avail);
            List points = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), date1.getTime(), date6.getTime(), 5, false);
            assert (points.size() == 5);
            assert (((AvailabilityPoint)points.get(0)).getAvailabilityType() == UP);
            assert (((AvailabilityPoint)points.get(1)).getAvailabilityType() == DOWN);
            assert (((AvailabilityPoint)points.get(2)).getAvailabilityType() == UP);
            assert (((AvailabilityPoint)points.get(3)).getAvailabilityType() == DOWN);
            assert (((AvailabilityPoint)points.get(4)).getAvailabilityType() == UP);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (0 == this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    @Test(enabled=true)
    public void testMergeReport() throws Exception {
        this.beginTx();
        try {
            this.setupResource();
            this.commitAndClose();
            long allAvailCount = this.setUpAvailabilities();
            Subject overlord = LookupUtil.getSubjectManager().getOverlord();
            Availability avail = this.availabilityManager.getCurrentAvailabilityForResource(overlord, this.theResource.getId());
            assert (avail.getAvailabilityType() == UP);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(overlord, this.theResource.getId()) == UP);
            Long currentStartTime = avail.getStartTime();
            avail = new Availability(this.theResource, Long.valueOf(currentStartTime + 3600000L), UP);
            AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            Thread.sleep(1000L);
            this.availabilityManager.mergeAvailabilityReport(report);
            Agent agent = LookupUtil.getAgentManager().getAgentByName(this.theAgent.getName());
            Date lastReport = new Date(agent.getLastAvailabilityReport());
            assert (lastReport != null);
            assert (this.countAvailabilitiesInDB().equals(allAvailCount));
            avail = this.availabilityManager.getCurrentAvailabilityForResource(overlord, this.theResource.getId());
            assert (avail.getStartTime().equals(this.availability3.getStartTime()));
            assert (avail.getAvailabilityType() == this.availability3.getAvailabilityType());
            assert (Math.abs(avail.getStartTime() - this.availability3.getStartTime()) < 1000L);
            assert (avail.getEndTime() == null);
            assert (this.availability3.getEndTime() == null);
            avail = new Availability(this.theResource, Long.valueOf(currentStartTime + 0x6DDD00L), DOWN);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            Thread.sleep(1000L);
            this.availabilityManager.mergeAvailabilityReport(report);
            agent = LookupUtil.getAgentManager().getAgentByName(this.theAgent.getName());
            assert (new Date(agent.getLastAvailabilityReport()).after(lastReport));
            assert (this.countAvailabilitiesInDB().equals(allAvailCount + 1L));
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(overlord, this.theResource.getId()) == DOWN);
            Availability queriedAvail = this.availabilityManager.getCurrentAvailabilityForResource(overlord, this.theResource.getId());
            assert (queriedAvail.getId() > 0);
            assert (queriedAvail.getAvailabilityType() == avail.getAvailabilityType());
            assert (Math.abs(queriedAvail.getStartTime() - avail.getStartTime()) < 1000L);
            assert (queriedAvail.getEndTime() == null);
            assert (avail.getEndTime() == null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (0 == this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    @Test(enabled=true)
    public void testMergeReportWithStaleResource() throws Exception {
        this.beginTx();
        try {
            this.setupResource();
            this.commitAndClose();
            long allAvailCount = this.setUpAvailabilities();
            Subject overlord = LookupUtil.getSubjectManager().getOverlord();
            Availability avail = this.availabilityManager.getCurrentAvailabilityForResource(overlord, this.theResource.getId());
            assert (avail.getAvailabilityType() == UP);
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(overlord, this.theResource.getId()) == UP);
            Long currentStartTime = avail.getStartTime();
            avail = new Availability(this.theResource, Long.valueOf(currentStartTime + 3600000L), UP);
            AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            avail = new Availability(new Resource(898989), Long.valueOf(currentStartTime + 3600000L), UP);
            report.addAvailability(avail);
            Thread.sleep(1000L);
            this.availabilityManager.mergeAvailabilityReport(report);
            Agent agent = LookupUtil.getAgentManager().getAgentByName(this.theAgent.getName());
            Date lastReport = new Date(agent.getLastAvailabilityReport());
            assert (lastReport != null);
            assert (this.countAvailabilitiesInDB().equals(allAvailCount));
            avail = this.availabilityManager.getCurrentAvailabilityForResource(overlord, this.theResource.getId());
            assert (avail.getStartTime().equals(this.availability3.getStartTime()));
            assert (avail.getAvailabilityType() == this.availability3.getAvailabilityType());
            assert (Math.abs(avail.getStartTime() - this.availability3.getStartTime()) < 1000L);
            assert (avail.getEndTime() == null);
            assert (this.availability3.getEndTime() == null);
            avail = new Availability(this.theResource, Long.valueOf(currentStartTime + 0x6DDD00L), DOWN);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            Thread.sleep(1000L);
            this.availabilityManager.mergeAvailabilityReport(report);
            agent = LookupUtil.getAgentManager().getAgentByName(this.theAgent.getName());
            assert (new Date(agent.getLastAvailabilityReport()).after(lastReport));
            assert (this.countAvailabilitiesInDB().equals(allAvailCount + 1L));
            assert (this.availabilityManager.getCurrentAvailabilityTypeForResource(overlord, this.theResource.getId()) == DOWN);
            Availability queriedAvail = this.availabilityManager.getCurrentAvailabilityForResource(overlord, this.theResource.getId());
            assert (queriedAvail.getId() > 0);
            assert (queriedAvail.getAvailabilityType() == avail.getAvailabilityType());
            assert (Math.abs(queriedAvail.getStartTime() - avail.getStartTime()) < 1000L);
            assert (queriedAvail.getEndTime() == null);
            assert (avail.getEndTime() == null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (0 == this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    @Test(enabled=true)
    public void testBZ884338_1() throws Exception {
        this.beginTx();
        try {
            this.setupResource();
            this.commitAndClose();
            long allAvailCount = this.setUpAvailabilities();
            this.assertTrue("should have >= 3 avail records", 3L <= allAvailCount);
            List<Availability> avails = this.getResourceAvailabilities(this.theResource);
            this.assertEquals(avails.toString(), 4, avails.size());
            Availability avail = this.availabilityManager.getCurrentAvailabilityForResource(this.overlord, this.theResource.getId());
            assert (avail.getAvailabilityType() == UP);
            Long currentStartTime = avail.getStartTime();
            long newStartTime = currentStartTime;
            avail = new Availability(this.theResource, Long.valueOf(newStartTime), UP);
            AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            newStartTime = currentStartTime - 1200000L;
            avail = new Availability(this.theResource, Long.valueOf(newStartTime), DOWN);
            report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            Thread.sleep(1000L);
            this.availabilityManager.mergeAvailabilityReport(report);
            Agent agent = LookupUtil.getAgentManager().getAgentByName(this.theAgent.getName());
            Date lastReport = new Date(agent.getLastAvailabilityReport());
            assert (lastReport != null);
            this.assertEquals(allAvailCount, this.countAvailabilitiesInDB());
            avails = this.getResourceAvailabilities(this.theResource);
            this.assertEquals(avails.toString(), 4, avails.size());
            avail = avails.get(0);
            this.assertTrue(avail.toString(), Math.abs(avail.getStartTime() - 0L) < 1000L);
            this.assertEquals(avail.toString(), AvailabilityType.UNKNOWN, avail.getAvailabilityType());
            this.assertTrue(avail.toString(), Math.abs(avail.getEndTime() - avails.get(1).getStartTime()) < 1000L);
            avail = avails.get(1);
            this.assertTrue(avail.toString(), Math.abs(currentStartTime - (avail.getStartTime() + 2400000L)) < 1000L);
            this.assertEquals(avail.toString(), AvailabilityType.UP, avail.getAvailabilityType());
            this.assertTrue(avail.toString(), Math.abs(avail.getEndTime() - avails.get(2).getStartTime()) < 1000L);
            avail = avails.get(2);
            this.assertTrue(avail.toString(), Math.abs(currentStartTime - (avail.getStartTime() + 1200000L)) < 1000L);
            this.assertEquals(avail.toString(), AvailabilityType.DOWN, avail.getAvailabilityType());
            this.assertTrue(avail.toString(), Math.abs(avail.getEndTime() - avails.get(3).getStartTime()) < 1000L);
            avail = avails.get(3);
            this.assertTrue(avail.toString(), Math.abs(currentStartTime - avail.getStartTime()) < 1000L);
            this.assertEquals(avail.toString(), AvailabilityType.UP, avail.getAvailabilityType());
            this.assertEquals(avail.toString(), avail.getEndTime(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (0 == this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    @Test(enabled=true)
    public void testBZ884338_2() throws Exception {
        this.beginTx();
        try {
            this.setupResource();
            this.commitAndClose();
            long allAvailCount = this.setUpAvailabilities();
            this.assertTrue("should have >= 3 avail records", 3L <= allAvailCount);
            List<Availability> avails = this.getResourceAvailabilities(this.theResource);
            this.assertEquals(avails.toString(), 4, avails.size());
            Availability avail = this.availabilityManager.getCurrentAvailabilityForResource(this.overlord, this.theResource.getId());
            this.beginTx();
            avail = (Availability)this.em.find(Availability.class, (Object)avail.getId());
            assert (avail.getAvailabilityType() == UP);
            Long currentStartTime = avail.getStartTime();
            Long nonNullEndTime = currentStartTime + 1000L;
            avail.setEndTime(nonNullEndTime);
            avail = (Availability)this.em.merge((Object)avail);
            this.commitAndClose();
            long newStartTime = currentStartTime + 300000L;
            avail = new Availability(this.theResource, Long.valueOf(newStartTime), DOWN);
            AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
            report.addAvailability(avail);
            Thread.sleep(1000L);
            this.availabilityManager.mergeAvailabilityReport(report);
            avails = this.getResourceAvailabilities(this.theResource);
            this.assertEquals(avails.toString(), 5, avails.size());
            avail = avails.get(0);
            this.assertTrue(avail.toString(), Math.abs(avail.getStartTime() - 0L) < 1000L);
            this.assertEquals(avail.toString(), AvailabilityType.UNKNOWN, avail.getAvailabilityType());
            this.assertTrue(avail.toString(), Math.abs(avail.getEndTime() - avails.get(1).getStartTime()) < 1000L);
            avail = avails.get(1);
            this.assertTrue(avail.toString(), Math.abs(newStartTime - (avail.getStartTime() + 2700000L)) < 1000L);
            this.assertEquals(avail.toString(), AvailabilityType.UP, avail.getAvailabilityType());
            this.assertTrue(avail.toString(), Math.abs(avail.getEndTime() - avails.get(2).getStartTime()) < 1000L);
            avail = avails.get(2);
            this.assertTrue(avail.toString(), Math.abs(newStartTime - (avail.getStartTime() + 1500000L)) < 1000L);
            this.assertEquals(avail.toString(), AvailabilityType.DOWN, avail.getAvailabilityType());
            this.assertTrue(avail.toString(), Math.abs(avail.getEndTime() - avails.get(3).getStartTime()) < 1000L);
            avail = avails.get(3);
            this.assertTrue(avail.toString(), Math.abs(newStartTime - (avail.getStartTime() + 300000L)) < 1000L);
            this.assertEquals(avail.toString(), AvailabilityType.UP, avail.getAvailabilityType());
            this.assertTrue(avail.toString(), Math.abs(avail.getEndTime() - avails.get(4).getStartTime()) < 1000L);
            avail = avails.get(4);
            this.assertTrue(avail.toString(), Math.abs(newStartTime - avail.getStartTime()) < 1000L);
            this.assertEquals(avail.toString(), AvailabilityType.DOWN, avail.getAvailabilityType());
            this.assertEquals(avail.toString(), null, avail.getEndTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (0 == this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    @Test(enabled=true)
    public void testMergeReportPerformance() throws Exception {
        this.beginTx();
        ArrayList<Resource> allResources = new ArrayList<Resource>();
        try {
            Availability avail;
            AvailabilityType curAvail;
            this.setupResource();
            allResources.add(this.theResource);
            for (int i = 0; i < 100; ++i) {
                allResources.add(this.setupAnotherResource(i, this.theResource));
            }
            this.em.flush();
            this.commitAndClose();
            AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
            for (Resource resource : allResources) {
                Availability avail2 = new Availability(resource, UP);
                report.addAvailability(avail2);
            }
            long start = System.currentTimeMillis();
            this.availabilityManager.mergeAvailabilityReport(report);
            System.out.println("testMergeReportPerformance: mergeAvailabilityReport run 1 took " + (System.currentTimeMillis() - start) + "ms");
            start = System.currentTimeMillis();
            for (Resource resource : allResources) {
                curAvail = this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, resource.getId());
                assert (curAvail == UP) : curAvail;
            }
            System.out.println("testMergeReportPerformance: checking validity of data 1 took " + (System.currentTimeMillis() - start) + "ms");
            report = new AvailabilityReport(false, this.theAgent.getName());
            for (Resource resource : allResources) {
                avail = new Availability(resource, DOWN);
                report.addAvailability(avail);
            }
            start = System.currentTimeMillis();
            this.availabilityManager.mergeAvailabilityReport(report);
            System.out.println("testMergeReportPerformance: mergeAvailabilityReport run 2 took " + (System.currentTimeMillis() - start) + "ms");
            start = System.currentTimeMillis();
            for (Resource resource : allResources) {
                curAvail = this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, resource.getId());
                assert (curAvail == DOWN) : curAvail;
            }
            System.out.println("testMergeReportPerformance: checking validity of data 2 took " + (System.currentTimeMillis() - start) + "ms");
            report = new AvailabilityReport(false, this.theAgent.getName());
            for (Resource resource : allResources) {
                avail = new Availability(resource, UNKNOWN);
                report.addAvailability(avail);
            }
            start = System.currentTimeMillis();
            this.availabilityManager.mergeAvailabilityReport(report);
            System.out.println("testMergeReportPerformance: mergeAvailabilityReport run 3 took " + (System.currentTimeMillis() - start) + "ms");
            start = System.currentTimeMillis();
            for (Resource resource : allResources) {
                curAvail = this.availabilityManager.getCurrentAvailabilityTypeForResource(this.overlord, resource.getId());
                assert (curAvail == UNKNOWN) : curAvail;
            }
            System.out.println("testMergeReportPerformance: checking validity of data 3 took " + (System.currentTimeMillis() - start) + "ms");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (0 == this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    private void beginTx() throws Exception {
        this.getTransactionManager().begin();
    }

    private void commitAndClose() throws Exception {
        this.getTransactionManager().commit();
    }

    private AvailabilityType getPointInTime(Date time) {
        List list = this.availabilityManager.findAvailabilitiesForResource(this.overlord, this.theResource.getId(), time.getTime(), time.getTime() + 1L, 1, false);
        assert (list != null);
        assert (list.size() == 1) : "Should have returned a single point";
        AvailabilityType type = ((AvailabilityPoint)list.get(0)).getAvailabilityType();
        switch (type) {
            case DOWN: 
            case DISABLED: 
            case UP: 
            case UNKNOWN: {
                return type;
            }
        }
        assert (false) : "AvailabilityType enum has some additional values not known to this test: " + type;
        return null;
    }

    private Long countAvailabilitiesInDB() throws Exception {
        return this.executeInTransaction(new TransactionCallbackReturnable<Long>(){

            @Override
            public Long execute() throws Exception {
                Query q = AvailabilityManagerTest.this.em.createQuery("SELECT count(a) FROM Availability a");
                Long count = (Long)q.getSingleResult();
                return count;
            }
        });
    }

    private List<Availability> getResourceAvailabilities(Resource r) throws Exception {
        AvailabilityCriteria c = new AvailabilityCriteria();
        c.addFilterResourceId(Integer.valueOf(r.getId()));
        c.addSortStartTime(PageOrdering.ASC);
        return this.availabilityManager.findAvailabilityByCriteria(this.overlord, c);
    }

    private Resource setupResource() {
        String tuid = "" + new Random().nextInt();
        String prefix = ((Object)((Object)this)).getClass().getSimpleName() + "_" + tuid + "_";
        this.theAgent = new Agent(prefix + "agent", "localhost" + tuid, 1234, "", "randomToken" + tuid);
        this.em.persist((Object)this.theAgent);
        this.theResourceType = new ResourceType(prefix + "type", prefix + "plugin", ResourceCategory.PLATFORM, null);
        this.em.persist((Object)this.theResourceType);
        this.theResource = new Resource(prefix + "resourceKey", prefix + "resourceName", this.theResourceType);
        this.theResource.setUuid("" + new Random().nextInt());
        this.theResource.setAgent(this.theAgent);
        this.theResource.setInventoryStatus(InventoryStatus.COMMITTED);
        this.em.persist((Object)this.theResource);
        this.em.flush();
        return this.theResource;
    }

    private Resource setupAnotherResource(int uniqueNumber, Resource parentResource) {
        Resource newResource = new Resource("test-platform-key-" + uniqueNumber, "test-platform-name-" + uniqueNumber, this.theResourceType);
        newResource.setUuid("" + new Random().nextInt());
        newResource.setAgent(this.theAgent);
        newResource.setInventoryStatus(InventoryStatus.COMMITTED);
        if (null != parentResource) {
            parentResource.addChildResource(newResource);
        }
        this.em.persist((Object)newResource);
        this.additionalResources.add(newResource);
        return newResource;
    }

    private long setUpAvailabilities() throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(10, 1);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date start = cal.getTime();
        cal.set(10, 1);
        cal.set(12, 20);
        Date splitStart = cal.getTime();
        cal.set(12, 40);
        Date splitEnd = cal.getTime();
        long count = this.countAvailabilitiesInDB();
        this.availability1 = new Availability(this.theResource, Long.valueOf(start.getTime()), UP);
        this.availability1.setEndTime(Long.valueOf(splitStart.getTime()));
        this.persistAvailability(this.availability1);
        this.availability2 = new Availability(this.theResource, Long.valueOf(splitStart.getTime()), DOWN);
        this.availability2.setEndTime(Long.valueOf(splitEnd.getTime()));
        this.persistAvailability(this.availability2);
        this.availability3 = new Availability(this.theResource, Long.valueOf(splitEnd.getTime()), UP);
        this.persistAvailability(this.availability3);
        long countNow = this.countAvailabilitiesInDB();
        assert (countNow == count + 3L) : "Did not find three availabilities - instead found: " + countNow;
        return countNow;
    }

    private void persistAvailability(Availability ... availabilities) {
        AvailabilityReport report = new AvailabilityReport(false, this.theAgent.getName());
        for (Availability avail : availabilities) {
            report.addAvailability(avail);
        }
        this.availabilityManager.mergeAvailabilityReport(report);
    }
}

