/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.rhq.core.clientapi.agent.measurement.MeasurementAgentService;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.MeasurementDataTraitCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementCategory;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementDataPK;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.domain.measurement.calltime.CallTimeDataComposite;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.ResourceTreeHelper;
import org.testng.annotations.Test;

public class MeasurementDataManagerTest
extends AbstractEJB3Test {
    private static final int DELTA = 20;
    private MeasurementDataManagerLocal measurementDataManager;
    private CallTimeDataManagerLocal callTimeDataManager;
    private Subject overlord;
    private Resource resource1;
    private Resource resource2;
    private ResourceGroup group;
    private MeasurementDefinition definitionCt1;
    private MeasurementDefinition definitionCt2;
    private MeasurementDefinition definitionCt3;
    private MeasurementSchedule schedule1;
    private MeasurementSchedule schedule2;
    private MeasurementSchedule schedule3;
    private ResourceType theResourceType;
    private Agent theAgent;
    private Set<MeasurementData> expectedResult1;
    private Set<MeasurementData> expectedResult2;
    private Set<MeasurementData> expectedResult3;
    private Set<MeasurementData> expectedResult4;

    @Override
    protected void beforeMethod() {
        try {
            this.measurementDataManager = LookupUtil.getMeasurementDataManager();
            this.callTimeDataManager = LookupUtil.getCallTimeDataManager();
            this.overlord = LookupUtil.getSubjectManager().getOverlord();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    @Override
    protected void afterMethod() {
        try {
            this.callTimeDataManager.purgeCallTimeData(new Date());
            this.beginTx();
            ArrayList<Integer> resourceIds = new ArrayList<Integer>();
            resourceIds.add(this.resource1.getId());
            resourceIds.add(this.resource2.getId());
            Query q = this.em.createNamedQuery("CallTimeDataKey.deleteByResources");
            q.setParameter("resourceIds", resourceIds);
            q.executeUpdate();
            this.resource1 = (Resource)this.em.merge((Object)this.resource1);
            for (MeasurementSchedule sched : this.resource1.getSchedules()) {
                this.em.remove((Object)sched);
            }
            ResourceTreeHelper.deleteResource(this.em, this.resource1);
            this.resource2 = (Resource)this.em.merge((Object)this.resource2);
            for (MeasurementSchedule sched : this.resource2.getSchedules()) {
                this.em.remove((Object)sched);
            }
            ResourceTreeHelper.deleteResource(this.em, this.resource2);
            this.definitionCt1 = (MeasurementDefinition)this.em.merge((Object)this.definitionCt1);
            this.em.remove((Object)this.definitionCt1);
            this.definitionCt2 = (MeasurementDefinition)this.em.merge((Object)this.definitionCt2);
            this.em.remove((Object)this.definitionCt2);
            if (this.definitionCt3 != null) {
                this.definitionCt3 = (MeasurementDefinition)this.em.merge((Object)this.definitionCt3);
                this.em.remove((Object)this.definitionCt3);
            }
            this.theResourceType = (ResourceType)this.em.merge((Object)this.theResourceType);
            this.em.remove((Object)this.theResourceType);
            if (this.group != null) {
                this.group = (ResourceGroup)this.em.merge((Object)this.group);
                this.em.remove((Object)this.group);
            }
            this.theAgent = (Agent)this.em.merge((Object)this.theAgent);
            this.em.remove((Object)this.theAgent);
            this.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Test
    public void bz658491() throws Exception {
        try {
            this.beginTx();
            this.setupResources(this.em);
            this.em.flush();
            long now = System.currentTimeMillis();
            MeasurementScheduleRequest request1 = new MeasurementScheduleRequest(this.schedule1);
            MeasurementScheduleRequest request2 = new MeasurementScheduleRequest(this.schedule2);
            CallTimeData data1 = new CallTimeData(request1);
            CallTimeData data2 = new CallTimeData(request2);
            data1.addCallData("/foo", new Date(), 100L);
            data2.addCallData("/bar", new Date(), 200L);
            MeasurementReport report = new MeasurementReport();
            report.addData(data1);
            report.addData(data2);
            this.commit();
            this.measurementDataManager.mergeMeasurementReport(report);
            Thread.sleep(10000L);
            PageList list1 = this.callTimeDataManager.findCallTimeDataForResource(this.overlord, this.schedule1.getId(), now - 20L, System.currentTimeMillis() + 20L, new PageControl());
            PageList list2 = this.callTimeDataManager.findCallTimeDataForResource(this.overlord, this.schedule2.getId(), now - 20L, System.currentTimeMillis() + 20L, new PageControl());
            assert (list1 != null);
            assert (list2 != null);
            assert (list1.size() == 1) : "List 1 returned " + list1.size() + " entries, expected was 1";
            assert (list2.size() == 1) : "List 2 returned " + list2.size() + " entries, expected was 1";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Test
    public void bz658491OneResource() throws Exception {
        try {
            this.beginTx();
            this.setupResources(this.em);
            this.em.flush();
            long now = System.currentTimeMillis();
            MeasurementScheduleRequest request1 = new MeasurementScheduleRequest(this.schedule1);
            MeasurementScheduleRequest request2 = new MeasurementScheduleRequest(this.schedule2);
            CallTimeData data1 = new CallTimeData(request1);
            CallTimeData data2 = new CallTimeData(request2);
            data1.addCallData("/foo", new Date(), 100L);
            data2.addCallData("/bar", new Date(), 200L);
            MeasurementReport report = new MeasurementReport();
            report.addData(data1);
            report.addData(data2);
            this.commit();
            this.measurementDataManager.mergeMeasurementReport(report);
            Thread.sleep(10000L);
            PageList list1 = this.callTimeDataManager.findCallTimeDataForResource(this.overlord, this.schedule1.getId(), now - 20L, System.currentTimeMillis() + 20L, new PageControl());
            PageList list2 = this.callTimeDataManager.findCallTimeDataForResource(this.overlord, this.schedule2.getId(), now - 20L, System.currentTimeMillis() + 20L, new PageControl());
            assert (list1 != null);
            assert (list2 != null);
            assert (list1.size() == 1) : "List 1 returned " + list1.size() + " entries, expected was 1";
            assert (list2.size() == 1) : "List 2 returned " + list2.size() + " entries, expected was 1";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Test
    public void testFindCallTimeDataRaw() throws Exception {
        try {
            this.beginTx();
            this.setupResources(this.em);
            this.em.flush();
            long now = System.currentTimeMillis();
            MeasurementScheduleRequest request1 = new MeasurementScheduleRequest(this.schedule1);
            CallTimeData data1 = new CallTimeData(request1);
            CallTimeData data2 = new CallTimeData(request1);
            Date dNow = new Date();
            dNow.setTime(now);
            data1.addCallData("/1", dNow, 1L);
            data1.addCallData("/1", dNow, 1L);
            dNow.setTime(now + 1L);
            data2.addCallData("/1", dNow, 3L);
            dNow.setTime(now + 2L);
            data2.addCallData("/2a", dNow, 4L);
            dNow.setTime(now + 3L);
            data2.addCallData("/2b", dNow, 5L);
            this.commit();
            MeasurementReport report = new MeasurementReport();
            report.addData(data1);
            this.measurementDataManager.mergeMeasurementReport(report);
            report = new MeasurementReport();
            report.addData(data2);
            this.measurementDataManager.mergeMeasurementReport(report);
            Thread.sleep(10000L);
            PageList list = this.callTimeDataManager.findCallTimeDataRawForResource(this.overlord, this.schedule1.getId(), now - 20L, System.currentTimeMillis() + 20L, new PageControl());
            assert (list != null);
            assert (list.size() == 4) : "List 1 returned " + list.size() + " entries, expected was 4";
            assert (((CallTimeDataComposite)list.get(0)).getTotal() == 2.0) : "First value must be total = 2, but was " + ((CallTimeDataComposite)list.get(0)).getTotal();
            assert (((CallTimeDataComposite)list.get(1)).getTotal() == 3.0) : "Second value must be total = 3, but was " + ((CallTimeDataComposite)list.get(1)).getTotal();
            assert (((CallTimeDataComposite)list.get(2)).getTotal() == 4.0) : "Third value must be total = 4, but was " + ((CallTimeDataComposite)list.get(2)).getTotal();
            assert (((CallTimeDataComposite)list.get(3)).getTotal() == 5.0) : "Fourth value must be total = 5, but was " + ((CallTimeDataComposite)list.get(3)).getTotal();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void setupResources(EntityManager em) {
        this.theAgent = new Agent("testagent", "localhost", 1234, "", "randomToken");
        em.persist((Object)this.theAgent);
        this.theResourceType = new ResourceType("test-plat", "test-plugin", ResourceCategory.PLATFORM, null);
        em.persist((Object)this.theResourceType);
        this.definitionCt1 = new MeasurementDefinition("CT-Def1", MeasurementCategory.PERFORMANCE, MeasurementUnits.MILLISECONDS, DataType.CALLTIME, true, 60000L, DisplayType.SUMMARY);
        this.definitionCt1.setResourceType(this.theResourceType);
        em.persist((Object)this.definitionCt1);
        this.definitionCt2 = new MeasurementDefinition("CT-Def2", MeasurementCategory.PERFORMANCE, MeasurementUnits.MILLISECONDS, DataType.CALLTIME, true, 60000L, DisplayType.SUMMARY);
        this.definitionCt2.setResourceType(this.theResourceType);
        em.persist((Object)this.definitionCt2);
        this.resource1 = new Resource("test-platform-key1", "test-platform-name", this.theResourceType);
        this.resource1.setUuid("" + new Random().nextInt());
        this.resource1.setAgent(this.theAgent);
        em.persist((Object)this.resource1);
        this.resource2 = new Resource("test-platform-key2", "test-platform-name", this.theResourceType);
        this.resource2.setUuid("" + new Random().nextInt());
        this.resource2.setAgent(this.theAgent);
        em.persist((Object)this.resource2);
        this.schedule1 = new MeasurementSchedule(this.definitionCt1, this.resource1);
        em.persist((Object)this.schedule1);
        this.definitionCt1.addSchedule(this.schedule1);
        this.resource1.addSchedule(this.schedule1);
        this.schedule2 = new MeasurementSchedule(this.definitionCt2, this.resource1);
        em.persist((Object)this.schedule2);
        this.definitionCt1.addSchedule(this.schedule2);
        this.resource2.addSchedule(this.schedule2);
    }

    private void setupGroupOfResources(EntityManager em) {
        this.theAgent = new Agent("testagent", "localhost", 1234, "", "randomToken");
        em.persist((Object)this.theAgent);
        this.theResourceType = new ResourceType("test-plat", "test-plugin", ResourceCategory.PLATFORM, null);
        em.persist((Object)this.theResourceType);
        this.definitionCt1 = new MeasurementDefinition("CT-Def1", MeasurementCategory.PERFORMANCE, MeasurementUnits.MILLISECONDS, DataType.CALLTIME, true, 60000L, DisplayType.SUMMARY);
        this.definitionCt1.setResourceType(this.theResourceType);
        em.persist((Object)this.definitionCt1);
        this.definitionCt2 = new MeasurementDefinition("CT-Def2", MeasurementCategory.PERFORMANCE, MeasurementUnits.MILLISECONDS, DataType.CALLTIME, true, 60000L, DisplayType.SUMMARY);
        this.definitionCt2.setResourceType(this.theResourceType);
        em.persist((Object)this.definitionCt2);
        this.definitionCt3 = new MeasurementDefinition("CT-Def3", MeasurementCategory.PERFORMANCE, MeasurementUnits.MILLISECONDS, DataType.CALLTIME, true, 60000L, DisplayType.SUMMARY);
        this.definitionCt3.setResourceType(this.theResourceType);
        em.persist((Object)this.definitionCt3);
        this.resource1 = new Resource("test-platform-key1", "test-platform-name", this.theResourceType);
        this.resource1.setUuid("" + new Random().nextInt());
        this.resource1.setAgent(this.theAgent);
        em.persist((Object)this.resource1);
        this.resource2 = new Resource("test-platform-key2", "test-platform-name", this.theResourceType);
        this.resource2.setUuid("" + new Random().nextInt());
        this.resource2.setAgent(this.theAgent);
        em.persist((Object)this.resource2);
        this.schedule1 = new MeasurementSchedule(this.definitionCt1, this.resource1);
        em.persist((Object)this.schedule1);
        this.definitionCt1.addSchedule(this.schedule1);
        this.resource1.addSchedule(this.schedule1);
        this.schedule2 = new MeasurementSchedule(this.definitionCt2, this.resource2);
        em.persist((Object)this.schedule2);
        this.definitionCt2.addSchedule(this.schedule2);
        this.resource2.addSchedule(this.schedule2);
        this.schedule3 = new MeasurementSchedule(this.definitionCt3, this.resource2);
        em.persist((Object)this.schedule3);
        this.definitionCt3.addSchedule(this.schedule3);
        this.resource2.addSchedule(this.schedule3);
        this.group = new ResourceGroup("test-group", this.theResourceType);
        em.persist((Object)this.group);
        long time1 = System.currentTimeMillis();
        long time2 = time1 + 1L;
        long time3 = time2 + 1L;
        long time4 = time3 + 1L;
        String name1 = "a";
        String name2 = "b";
        String name3 = "c";
        String name4 = "d";
        String value1 = "test-value1";
        String value2 = "test-value2";
        String value3 = "test-value3";
        String value4 = "test-value4";
        MeasurementData expectedData1 = this.makeMeasurement(time1, this.schedule1.getId(), value1, name1);
        expectedData1.setName(this.resource1.getId() + ":" + name1);
        MeasurementData expectedData2 = this.makeMeasurement(time2, this.schedule2.getId(), value2, name2);
        expectedData2.setName(this.resource2.getId() + ":" + name2);
        MeasurementData expectedData3 = this.makeMeasurement(time3, this.schedule3.getId(), value3, name3);
        expectedData3.setName(this.resource2.getId() + ":" + name3);
        MeasurementData expectedData4 = this.makeMeasurement(time4, this.schedule2.getId(), value4, name4);
        expectedData4.setName(this.resource2.getId() + ":" + name4);
        this.expectedResult1 = new HashSet<MeasurementData>(1);
        this.expectedResult1.add(expectedData1);
        this.expectedResult2 = new HashSet<MeasurementData>(2);
        this.expectedResult2.add(expectedData2);
        this.expectedResult2.add(expectedData3);
        this.expectedResult3 = new HashSet<MeasurementData>(3);
        this.expectedResult3.addAll(this.expectedResult1);
        this.expectedResult3.addAll(this.expectedResult2);
        this.expectedResult4 = new HashSet<MeasurementData>(2);
        this.expectedResult4.add(expectedData2);
        this.expectedResult4.add(expectedData4);
        MeasurementAgentService mockedMeasurementService = (MeasurementAgentService)Mockito.mock(MeasurementAgentService.class);
        Mockito.when((Object)mockedMeasurementService.getRealTimeMeasurementValue(Matchers.eq((int)this.resource1.getId()), (Set)Matchers.any(Set.class))).thenReturn(new HashSet<MeasurementData>(Arrays.asList(this.makeMeasurement(time1, this.schedule1.getId(), value1, name1))));
        Mockito.when((Object)mockedMeasurementService.getRealTimeMeasurementValue(Matchers.eq((int)this.resource2.getId()), (Set)Matchers.any(Set.class))).thenReturn(new HashSet<MeasurementData>(Arrays.asList(this.makeMeasurement(time2, this.schedule2.getId(), value2, name2), this.makeMeasurement(time3, this.schedule3.getId(), value3, name3))));
        TestServerCommunicationsService agentServiceContainer = this.prepareForTestAgents();
        agentServiceContainer.measurementService = mockedMeasurementService;
    }

    @Test
    public void testFindLiveDataForGroup1() throws Exception {
        this.beginTx();
        this.setupGroupOfResources(this.em);
        this.commit();
        try {
            Set actualResult = this.measurementDataManager.findLiveDataForGroup(this.overlord, this.group.getId(), new int[]{this.resource1.getId()}, new int[]{this.definitionCt1.getId()});
            HashSet actualResultWithNewHashCodes = new HashSet(actualResult);
            this.assertEquals(this.expectedResult1, actualResultWithNewHashCodes);
            actualResult = this.measurementDataManager.findLiveDataForGroup(this.overlord, this.group.getId(), new int[]{this.resource2.getId()}, new int[]{this.definitionCt2.getId(), this.definitionCt3.getId()});
            actualResultWithNewHashCodes = new HashSet(actualResult);
            this.assertEquals(this.expectedResult2, actualResultWithNewHashCodes);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fail();
            throw e;
        }
    }

    @Test
    public void testFindLiveDataForGroup2() throws Exception {
        this.beginTx();
        this.setupGroupOfResources(this.em);
        this.commit();
        try {
            Set actualResult = this.measurementDataManager.findLiveDataForGroup(this.overlord, this.group.getId(), new int[]{this.resource1.getId(), this.resource2.getId()}, new int[]{this.definitionCt1.getId(), this.definitionCt2.getId(), this.definitionCt3.getId()});
            HashSet actualResultWithNewHashCodes = new HashSet(actualResult);
            this.assertEquals(this.expectedResult3, actualResultWithNewHashCodes);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fail();
            throw e;
        }
    }

    @Test
    public void testFindLiveDataForGroup3() throws Exception {
        this.beginTx();
        this.setupGroupOfResources(this.em);
        this.commit();
        try {
            Set actualResult = this.measurementDataManager.findLiveDataForGroup(this.overlord, this.group.getId(), null, new int[]{this.definitionCt1.getId()});
            this.assertEquals(Collections.emptySet(), actualResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fail();
            throw e;
        }
    }

    @Test
    public void testFindLiveDataForGroup4() throws Exception {
        this.beginTx();
        this.setupGroupOfResources(this.em);
        this.commit();
        try {
            this.measurementDataManager.findLiveDataForGroup(null, this.group.getId(), new int[]{this.resource1.getId()}, new int[]{this.definitionCt1.getId()});
            this.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testAddAndFindTrait1() throws Exception {
        this.beginTx();
        this.setupGroupOfResources(this.em);
        this.commit();
        try {
            HashSet<MeasurementDataTrait> expectedResult = new HashSet<MeasurementDataTrait>();
            for (MeasurementData data : this.expectedResult1) {
                data.setName(null);
                expectedResult.add((MeasurementDataTrait)data);
            }
            this.measurementDataManager.addTraitData(expectedResult);
            List actualResult = this.measurementDataManager.findTraits(this.overlord, this.resource1.getId(), this.definitionCt1.getId());
            HashSet actualResultSet = new HashSet(actualResult);
            this.assertEquals(expectedResult, actualResultSet);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fail();
            throw e;
        }
    }

    @Test
    public void testAddAndFindTrait2() throws Exception {
        this.beginTx();
        this.setupGroupOfResources(this.em);
        this.commit();
        try {
            HashSet<MeasurementDataTrait> expectedResult = new HashSet<MeasurementDataTrait>();
            for (MeasurementData data : this.expectedResult4) {
                data.setName(null);
                expectedResult.add((MeasurementDataTrait)data);
            }
            this.measurementDataManager.addTraitData(expectedResult);
            List actualResult = this.measurementDataManager.findTraits(this.overlord, this.resource2.getId(), this.definitionCt2.getId());
            HashSet actualResultSet = new HashSet(actualResult);
            this.assertEquals(expectedResult, actualResultSet);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fail();
            throw e;
        }
    }

    @Test
    public void testAddAndFindTrait3() throws Exception {
        this.beginTx();
        this.setupGroupOfResources(this.em);
        this.commit();
        try {
            HashSet<MeasurementDataTrait> traitsData = new HashSet<MeasurementDataTrait>();
            HashSet<MeasurementDataTrait> expectedResult = new HashSet<MeasurementDataTrait>();
            for (MeasurementData data : this.expectedResult2) {
                data.setName(null);
                traitsData.add((MeasurementDataTrait)data);
                if (data.getScheduleId() != this.schedule2.getId()) continue;
                expectedResult.add((MeasurementDataTrait)data);
            }
            this.measurementDataManager.addTraitData(traitsData);
            List actualResult = this.measurementDataManager.findTraits(this.overlord, this.resource2.getId(), this.definitionCt2.getId());
            HashSet actualResultSet = new HashSet(actualResult);
            this.assertEquals(expectedResult, actualResultSet);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fail();
            throw e;
        }
    }

    @Test
    public void testFindNonExistentTraitByResourceId() throws Exception {
        this.beginTx();
        this.setupGroupOfResources(this.em);
        this.commit();
        try {
            List actualResult = this.measurementDataManager.findTraits(this.overlord, this.resource2.getId(), this.definitionCt2.getId());
            HashSet actualResultSet = new HashSet(actualResult);
            this.assertEquals(Collections.emptySet(), actualResultSet);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fail();
            throw e;
        }
    }

    @Test
    public void testAddAndFindByCriteria() throws Exception {
        this.beginTx();
        this.setupGroupOfResources(this.em);
        this.commit();
        try {
            HashSet<MeasurementDataTrait> expectedResult = new HashSet<MeasurementDataTrait>();
            for (MeasurementData data : this.expectedResult1) {
                data.setName(null);
                expectedResult.add((MeasurementDataTrait)data);
            }
            this.measurementDataManager.addTraitData(expectedResult);
            MeasurementDataTraitCriteria criteria = new MeasurementDataTraitCriteria();
            criteria.addFilterScheduleId(Integer.valueOf(this.schedule1.getId()));
            PageList actualResult = this.measurementDataManager.findTraitsByCriteria(this.overlord, criteria);
            HashSet actualResultSet = new HashSet(actualResult);
            this.assertEquals(expectedResult, actualResultSet);
            criteria = new MeasurementDataTraitCriteria();
            criteria.addFilterResourceId(Integer.valueOf(this.resource1.getId()));
            actualResult = this.measurementDataManager.findTraitsByCriteria(this.overlord, criteria);
            actualResultSet = new HashSet(actualResult);
            this.assertEquals(expectedResult, actualResultSet);
            criteria = new MeasurementDataTraitCriteria();
            criteria.addFilterScheduleId(Integer.valueOf(this.schedule1.getId()));
            criteria.addFilterResourceId(Integer.valueOf(this.resource1.getId()));
            actualResult = this.measurementDataManager.findTraitsByCriteria(this.overlord, criteria);
            actualResultSet = new HashSet(actualResult);
            this.assertEquals(expectedResult, actualResultSet);
            criteria = new MeasurementDataTraitCriteria();
            criteria.addFilterScheduleId(Integer.valueOf(Integer.MIN_VALUE));
            actualResult = this.measurementDataManager.findTraitsByCriteria(this.overlord, criteria);
            this.assertTrue(actualResult.isEmpty());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fail();
            throw e;
        }
    }

    @Test
    public void testAddAndFindCurrentTraitByResourceId() throws Exception {
        this.beginTx();
        this.setupGroupOfResources(this.em);
        this.commit();
        try {
            List actualResult = this.measurementDataManager.findCurrentTraitsForResource(this.overlord, this.resource1.getId(), null);
            this.assertTrue(actualResult.isEmpty());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fail();
            throw e;
        }
    }

    @Test
    public void testAddAndFindCurrentTraitByResourceIdAcrossMoreSchedules() throws Exception {
        this.beginTx();
        this.setupGroupOfResources(this.em);
        this.commit();
        try {
            HashSet<MeasurementDataTrait> expectedResult = new HashSet<MeasurementDataTrait>();
            for (MeasurementData data : this.expectedResult2) {
                data.setName(null);
                expectedResult.add((MeasurementDataTrait)data);
            }
            this.measurementDataManager.addTraitData(expectedResult);
            List actualResult = this.measurementDataManager.findCurrentTraitsForResource(this.overlord, this.resource2.getId(), null);
            HashSet actualResultSet = new HashSet(actualResult);
            this.assertEquals(expectedResult, actualResultSet);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fail();
            throw e;
        }
    }

    @Test
    public void testFindNonExistentCurrentTraitByResourceId() throws Exception {
        this.beginTx();
        this.setupGroupOfResources(this.em);
        this.commit();
        try {
            HashSet<MeasurementDataTrait> expectedResult = new HashSet<MeasurementDataTrait>();
            for (MeasurementData data : this.expectedResult2) {
                data.setName(null);
                expectedResult.add((MeasurementDataTrait)data);
            }
            this.measurementDataManager.addTraitData(expectedResult);
            List actualResult = this.measurementDataManager.findCurrentTraitsForResource(this.overlord, this.resource2.getId(), null);
            HashSet actualResultSet = new HashSet(actualResult);
            this.assertEquals(expectedResult, actualResultSet);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fail();
            throw e;
        }
    }

    private MeasurementData makeMeasurement(long time, int scheduleId, String value, String name) {
        MeasurementDataTrait measurement = new MeasurementDataTrait(new MeasurementDataPK(time, scheduleId), value);
        measurement.setName(name);
        return measurement;
    }

    private void beginTx() throws Exception {
        this.getTransactionManager().begin();
    }

    private void commit() throws Exception {
        this.em.flush();
        this.getTransactionManager().commit();
    }
}

