/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement.test;

import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import javax.persistence.Query;
import junit.framework.Assert;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementCategory;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.ResourceMeasurementScheduleRequest;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.measurement.test.AbstractMeasurementScheduleManagerTest;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.ResourceTreeHelper;
import org.testng.annotations.Test;

public class MeasurementScheduleManagerTest
extends AbstractMeasurementScheduleManagerTest {
    private MeasurementScheduleManagerLocal measurementScheduleManager;
    private Subject overlord;
    private Resource resource1;
    private MeasurementDefinition definitionCt1;
    private ResourceType theResourceType;
    private Agent theAgent;
    private AbstractMeasurementScheduleManagerTest.MeasurementScheduleTestServerCommunicationsService testCommService;

    @Override
    protected void beforeMethod() {
        try {
            this.prepareScheduler();
            this.testCommService = (AbstractMeasurementScheduleManagerTest.MeasurementScheduleTestServerCommunicationsService)this.prepareForTestAgents();
            this.measurementScheduleManager = LookupUtil.getMeasurementScheduleManager();
            this.overlord = LookupUtil.getSubjectManager().getOverlord();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    @Override
    protected void afterMethod() {
        try {
            this.beginTx();
            ArrayList<Integer> resourceIds = new ArrayList<Integer>();
            resourceIds.add(this.resource1.getId());
            Query q = this.em.createNamedQuery("CallTimeDataKey.deleteByResources");
            q.setParameter("resourceIds", resourceIds);
            q.executeUpdate();
            this.resource1 = (Resource)this.em.merge((Object)this.resource1);
            for (MeasurementSchedule sched : this.resource1.getSchedules()) {
                this.em.remove((Object)sched);
            }
            ResourceTreeHelper.deleteResource(this.em, this.resource1);
            this.definitionCt1 = (MeasurementDefinition)this.em.merge((Object)this.definitionCt1);
            this.em.remove((Object)this.definitionCt1);
            this.theResourceType = (ResourceType)this.em.merge((Object)this.theResourceType);
            this.em.remove((Object)this.theResourceType);
            this.theAgent = (Agent)this.em.merge((Object)this.theAgent);
            this.em.remove((Object)this.theAgent);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.unprepareScheduler();
                this.unprepareForTestAgents();
            }
            catch (Exception e) {}
            this.commitAndClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIntervals() {
        try {
            this.beginTx();
            this.setupResources();
            MeasurementSchedule schedule1 = new MeasurementSchedule(this.definitionCt1, this.resource1);
            this.em.persist((Object)schedule1);
            this.definitionCt1.addSchedule(schedule1);
            this.resource1.addSchedule(schedule1);
            this.resource1 = (Resource)this.em.merge((Object)this.resource1);
            this.commitAndClose();
            schedule1.setInterval(60000L);
            this.measurementScheduleManager.updateSchedule(this.overlord, schedule1);
            schedule1 = this.measurementScheduleManager.getScheduleById(this.overlord, schedule1.getId());
            Assert.assertEquals((long)60000L, (long)schedule1.getInterval());
            schedule1.setInterval(10000L);
            this.measurementScheduleManager.updateSchedule(this.overlord, schedule1);
            schedule1 = this.measurementScheduleManager.getScheduleById(this.overlord, schedule1.getId());
            Assert.assertEquals((long)30000L, (long)schedule1.getInterval());
            schedule1.setInterval(0L);
            this.measurementScheduleManager.updateSchedule(this.overlord, schedule1);
            schedule1 = this.measurementScheduleManager.getScheduleById(this.overlord, schedule1.getId());
            Assert.assertEquals((long)30000L, (long)schedule1.getInterval());
            schedule1.setInterval(-60000L);
            this.measurementScheduleManager.updateSchedule(this.overlord, schedule1);
            schedule1 = this.measurementScheduleManager.getScheduleById(this.overlord, schedule1.getId());
            Assert.assertEquals((long)30000L, (long)schedule1.getInterval());
            this.measurementScheduleManager.updateSchedulesForResource(this.overlord, this.resource1.getId(), new int[]{this.definitionCt1.getId()}, 60000L);
            Set resScheds = this.measurementScheduleManager.findSchedulesForResourceAndItsDescendants(new int[]{this.resource1.getId()}, false);
            Assert.assertEquals((int)1, (int)resScheds.size());
            Set scheds = ((ResourceMeasurementScheduleRequest)resScheds.iterator().next()).getMeasurementSchedules();
            Assert.assertEquals((int)1, (int)scheds.size());
            Assert.assertEquals((long)60000L, (long)((MeasurementScheduleRequest)scheds.iterator().next()).getInterval());
            this.measurementScheduleManager.updateSchedulesForResource(this.overlord, this.resource1.getId(), new int[]{this.definitionCt1.getId()}, 10000L);
            resScheds = this.measurementScheduleManager.findSchedulesForResourceAndItsDescendants(new int[]{this.resource1.getId()}, false);
            Assert.assertEquals((int)1, (int)resScheds.size());
            scheds = ((ResourceMeasurementScheduleRequest)resScheds.iterator().next()).getMeasurementSchedules();
            Assert.assertEquals((int)1, (int)scheds.size());
            Assert.assertEquals((long)30000L, (long)((MeasurementScheduleRequest)scheds.iterator().next()).getInterval());
            this.measurementScheduleManager.updateSchedulesForResource(this.overlord, this.resource1.getId(), new int[]{this.definitionCt1.getId()}, 0L);
            resScheds = this.measurementScheduleManager.findSchedulesForResourceAndItsDescendants(new int[]{this.resource1.getId()}, false);
            Assert.assertEquals((int)1, (int)resScheds.size());
            scheds = ((ResourceMeasurementScheduleRequest)resScheds.iterator().next()).getMeasurementSchedules();
            Assert.assertEquals((int)1, (int)scheds.size());
            Assert.assertEquals((long)30000L, (long)((MeasurementScheduleRequest)scheds.iterator().next()).getInterval());
            this.measurementScheduleManager.updateSchedulesForResource(this.overlord, this.resource1.getId(), new int[]{this.definitionCt1.getId()}, -60000L);
            resScheds = this.measurementScheduleManager.findSchedulesForResourceAndItsDescendants(new int[]{this.resource1.getId()}, false);
            Assert.assertEquals((int)1, (int)resScheds.size());
            scheds = ((ResourceMeasurementScheduleRequest)resScheds.iterator().next()).getMeasurementSchedules();
            Assert.assertEquals((int)1, (int)scheds.size());
            Assert.assertEquals((long)30000L, (long)((MeasurementScheduleRequest)scheds.iterator().next()).getInterval());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            this.commitAndClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBug811696() {
        try {
            this.beginTx();
            this.setupResources();
            long defaultInterval = this.definitionCt1.getDefaultInterval();
            long updatedInterval = defaultInterval * 2L;
            MeasurementSchedule schedule1 = new MeasurementSchedule(this.definitionCt1, this.resource1);
            schedule1.setInterval(defaultInterval);
            this.em.persist((Object)schedule1);
            this.definitionCt1.addSchedule(schedule1);
            this.resource1.addSchedule(schedule1);
            this.resource1 = (Resource)this.em.merge((Object)this.resource1);
            this.commitAndClose();
            this.testCommService.init();
            this.testCommService.setExpectedInterval(updatedInterval);
            this.testCommService.setExpectedIsEnabled(true);
            this.measurementScheduleManager.updateSchedulesForResourceType(this.overlord, new int[]{this.definitionCt1.getId()}, updatedInterval, true);
            Assert.assertTrue((boolean)this.testCommService.isTested());
            if (this.testCommService.hasFailures()) {
                Assert.fail((String)this.testCommService.getFailures().get(0));
            }
            Set resScheds = this.measurementScheduleManager.findSchedulesForResourceAndItsDescendants(new int[]{this.resource1.getId()}, false);
            Assert.assertEquals((int)1, (int)resScheds.size());
            ResourceMeasurementScheduleRequest rmsr = (ResourceMeasurementScheduleRequest)resScheds.iterator().next();
            Set scheds = rmsr.getMeasurementSchedules();
            Assert.assertEquals((int)1, (int)scheds.size());
            MeasurementScheduleRequest msr = (MeasurementScheduleRequest)scheds.iterator().next();
            Assert.assertEquals((long)updatedInterval, (long)msr.getInterval());
            Assert.assertEquals((boolean)true, (boolean)msr.isEnabled());
            this.testCommService.init();
            this.testCommService.setExpectedInterval(updatedInterval);
            this.testCommService.setExpectedIsEnabled(false);
            this.measurementScheduleManager.disableSchedulesForResourceType(this.overlord, new int[]{this.definitionCt1.getId()}, true);
            Assert.assertTrue((boolean)this.testCommService.isTested());
            resScheds = this.measurementScheduleManager.findSchedulesForResourceAndItsDescendants(new int[]{this.resource1.getId()}, false);
            Assert.assertEquals((int)1, (int)resScheds.size());
            rmsr = (ResourceMeasurementScheduleRequest)resScheds.iterator().next();
            scheds = rmsr.getMeasurementSchedules();
            Assert.assertEquals((int)1, (int)scheds.size());
            msr = (MeasurementScheduleRequest)scheds.iterator().next();
            Assert.assertEquals((long)updatedInterval, (long)msr.getInterval());
            Assert.assertEquals((boolean)false, (boolean)msr.isEnabled());
            this.testCommService.init();
            this.testCommService.setExpectedInterval(updatedInterval);
            this.testCommService.setExpectedIsEnabled(false);
            this.measurementScheduleManager.enableSchedulesForResourceType(this.overlord, new int[]{this.definitionCt1.getId()}, true);
            Assert.assertTrue((boolean)this.testCommService.isTested());
            resScheds = this.measurementScheduleManager.findSchedulesForResourceAndItsDescendants(new int[]{this.resource1.getId()}, false);
            Assert.assertEquals((int)1, (int)resScheds.size());
            rmsr = (ResourceMeasurementScheduleRequest)resScheds.iterator().next();
            scheds = rmsr.getMeasurementSchedules();
            Assert.assertEquals((int)1, (int)scheds.size());
            msr = (MeasurementScheduleRequest)scheds.iterator().next();
            Assert.assertEquals((long)updatedInterval, (long)msr.getInterval());
            Assert.assertEquals((boolean)true, (boolean)msr.isEnabled());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            this.commitAndClose();
        }
    }

    private void setupResources() {
        this.theAgent = new Agent("testagent", "localhost", 1234, "", "randomToken");
        this.em.persist((Object)this.theAgent);
        this.theResourceType = new ResourceType("test-plat", "test-plugin", ResourceCategory.PLATFORM, null);
        this.em.persist((Object)this.theResourceType);
        this.definitionCt1 = new MeasurementDefinition("CT-Def1", MeasurementCategory.PERFORMANCE, MeasurementUnits.MILLISECONDS, DataType.MEASUREMENT, true, 120000L, DisplayType.SUMMARY);
        this.definitionCt1.setResourceType(this.theResourceType);
        this.em.persist((Object)this.definitionCt1);
        this.resource1 = new Resource("test-platform-key1", "test-platform-name", this.theResourceType);
        this.resource1.setUuid("" + new Random().nextInt());
        this.resource1.setAgent(this.theAgent);
        this.resource1.setInventoryStatus(InventoryStatus.COMMITTED);
        this.em.persist((Object)this.resource1);
    }

    private void beginTx() throws Exception {
        this.getTransactionManager().begin();
    }

    private void commitAndClose() {
        try {
            if (null != this.em) {
                this.em.flush();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            this.getTransactionManager().commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

