/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement.test;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Query;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementViewManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.ResourceTreeHelper;
import org.testng.annotations.Test;

public class MeasurementViewManagerTest
extends AbstractEJB3Test {
    private MeasurementViewManagerLocal viewManager;
    private SubjectManagerLocal subjectManager;
    private static final int SIZE = 5;
    private ResourceType type;
    private List<Resource> resources;
    private List<MeasurementDefinition> definitions;
    private List<MeasurementSchedule> schedules;
    private Subject overlord;

    @Test
    public void testAll() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeMethod() throws Exception {
        this.viewManager = LookupUtil.getMeasurementViewManager();
        this.subjectManager = LookupUtil.getSubjectManager();
        this.overlord = this.subjectManager.getOverlord();
        this.getTransactionManager().begin();
        try {
            int i;
            String prefix = MeasurementViewManagerTest.class.getSimpleName();
            this.type = new ResourceType(prefix + "type", prefix + "plugin", ResourceCategory.PLATFORM, null);
            this.em.persist((Object)this.type);
            this.resources = new ArrayList<Resource>();
            for (i = 0; i < 5; ++i) {
                Resource resource = new Resource(prefix + "key " + i, prefix + "key " + i, this.type);
                resource.setUuid(resource.getResourceKey());
                this.resources.add(resource);
                this.em.persist((Object)resource);
            }
            this.definitions = new ArrayList<MeasurementDefinition>();
            for (i = 0; i < 5; ++i) {
                MeasurementDefinition definition = new MeasurementDefinition(this.type, prefix + "definition " + i);
                this.definitions.add(definition);
                this.type.addMetricDefinition(definition);
                this.em.persist((Object)definition);
            }
            this.type = (ResourceType)this.em.merge((Object)this.type);
            this.schedules = new ArrayList<MeasurementSchedule>();
            for (i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    MeasurementDefinition definition = this.definitions.get(i);
                    Resource resource = this.resources.get(j);
                    MeasurementSchedule schedule = new MeasurementSchedule(definition, resource);
                    this.schedules.add(schedule);
                    definition.addSchedule(schedule);
                    resource.addSchedule(schedule);
                    this.em.persist((Object)schedule);
                }
            }
            for (i = 0; i < 5; ++i) {
                MeasurementDefinition definition = this.definitions.get(i);
                this.definitions.set(i, (MeasurementDefinition)this.em.merge((Object)definition));
            }
            for (int j = 0; j < 5; ++j) {
                Resource resource = this.resources.get(j);
                this.resources.set(j, (Resource)this.em.merge((Object)resource));
            }
        }
        finally {
            this.getTransactionManager().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterMethod() throws Exception {
        this.getTransactionManager().begin();
        try {
            ArrayList<Integer> measurementDefinitionIds = new ArrayList<Integer>();
            for (int i = 0; i < this.definitions.size(); ++i) {
                measurementDefinitionIds.add(this.definitions.get(i).getId());
            }
            Query removeSchedules = this.em.createQuery("delete from MeasurementSchedule ms where ms.definition.id IN ( :ids ) ");
            removeSchedules.setParameter("ids", measurementDefinitionIds);
            removeSchedules.executeUpdate();
            ArrayList<Integer> resourceIds = new ArrayList<Integer>();
            for (int i = 0; i < this.resources.size(); ++i) {
                resourceIds.add(this.resources.get(i).getId());
            }
            if (this.type != null) {
                Query removeDefinitions = this.em.createQuery("delete from MeasurementDefinition md where md.resourceType.id = :resourceTypeId ");
                removeDefinitions.setParameter("resourceTypeId", (Object)this.type.getId());
                removeDefinitions.executeUpdate();
            }
            Iterator i$ = resourceIds.iterator();
            while (i$.hasNext()) {
                int resourceId = (Integer)i$.next();
                Resource r = (Resource)this.em.find(Resource.class, (Object)resourceId);
                ResourceTreeHelper.deleteResource(this.em, r);
            }
            if (this.type != null) {
                this.type = (ResourceType)this.em.find(ResourceType.class, (Object)this.type.getId());
                this.em.remove((Object)this.type);
            }
        }
        finally {
            this.getTransactionManager().commit();
        }
    }
}

