/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.operation;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.ejb.EJBException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.operation.CancelResults;
import org.rhq.core.clientapi.agent.operation.OperationAgentService;
import org.rhq.core.clientapi.server.operation.OperationServerService;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.JobTrigger;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.operation.GroupOperationHistory;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.operation.bean.GroupOperationSchedule;
import org.rhq.core.domain.operation.bean.ResourceOperationSchedule;
import org.rhq.core.domain.operation.composite.GroupOperationLastCompletedComposite;
import org.rhq.core.domain.operation.composite.GroupOperationScheduleComposite;
import org.rhq.core.domain.operation.composite.ResourceOperationLastCompletedComposite;
import org.rhq.core.domain.operation.composite.ResourceOperationScheduleComposite;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.exception.ExceptionPackage;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.operation.OperationServerServiceImpl;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

@Test(groups={"operation.manager"})
public class OperationManagerBeanTest
extends AbstractEJB3Test {
    private static final boolean ENABLE_TESTS = true;
    private static final String PREFIX = OperationManagerBeanTest.class.getSimpleName() + "_";
    private ConfigurationManagerLocal configurationManager;
    private OperationManagerLocal operationManager;
    private SchedulerLocal schedulerManager;
    private Resource newResource;
    private OperationDefinition newOperation;
    private ResourceGroup newGroup;
    private OperationServerService operationServerService;
    private long simulatedOperation_Sleep;
    private boolean simulatedOperation_Timeout;
    private String simulatedOperation_Error;
    private CancelResults simulatedOperation_CancelResults;

    @Override
    protected void beforeMethod() throws Exception {
        this.configurationManager = LookupUtil.getConfigurationManager();
        this.operationManager = LookupUtil.getOperationManager();
        this.schedulerManager = LookupUtil.getSchedulerBean();
        this.operationServerService = new OperationServerServiceImpl();
        TestServerCommunicationsService agentServiceContainer = this.prepareForTestAgents();
        agentServiceContainer.operationService = new TestConfigService();
        this.prepareScheduler();
        this.simulatedOperation_Sleep = 500L;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Error = null;
        this.newResource = this.createNewResource();
        this.newOperation = (OperationDefinition)this.newResource.getResourceType().getOperationDefinitions().iterator().next();
        this.newGroup = (ResourceGroup)this.newResource.getExplicitGroups().iterator().next();
    }

    public Subject overlord() {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        return overlord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterMethod() throws Exception {
        try {
            this.deleteNewResource(this.newResource);
        }
        finally {
            this.unprepareScheduler();
            this.unprepareForTestAgents();
        }
    }

    @Test(enabled=true)
    public void testSchedulerCustomProperties() throws Exception {
        assert (this.schedulerManager.getDefaultOperationTimeout() != null);
        assert (this.schedulerManager.getDefaultOperationTimeout() == 5);
    }

    @Test(enabled=true)
    public void testTrueTimeout() throws Exception {
        Resource resource = this.newResource;
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 20000L;
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date(System.currentTimeMillis() + 5000L));
        ResourceOperationSchedule schedule = this.operationManager.scheduleResourceOperation(this.overlord(), resource.getId(), PREFIX + "testOp", null, (Trigger)trigger, PREFIX + "desc");
        List schedules = this.operationManager.findScheduledResourceOperations(this.overlord(), resource.getId());
        assert (schedules != null);
        assert (schedules.size() == 1);
        Thread.sleep(17000L);
        this.operationManager.checkForTimedOutOperations(this.overlord());
        PageList results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        ResourceOperationHistory history = (ResourceOperationHistory)results.get(0);
        System.out.println("~~~~~~~~~~~~~~~~~" + history);
        assert (history.getErrorMessage() != null) : history;
        assert (history.getErrorMessage().indexOf("Timed out") > -1) : history;
        assert (history.getStatus() == OperationRequestStatus.FAILURE) : history;
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
        schedules = this.operationManager.findScheduledResourceOperations(this.overlord(), resource.getId());
        assert (schedules != null);
        assert (schedules.size() == 0);
    }

    @Test(enabled=true)
    public void testUnscheduledGroupOperation() throws Exception {
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 0L;
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date(System.currentTimeMillis() + 10000L));
        GroupOperationSchedule schedule = this.operationManager.scheduleGroupOperation(this.overlord(), this.newGroup.getId(), null, true, PREFIX + "testOp", null, (Trigger)trigger, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() == null);
        assert (schedule.getGroup().getId() == this.newGroup.getId());
        List schedules = this.operationManager.findScheduledGroupOperations(this.overlord(), this.newGroup.getId());
        assert (schedules != null);
        assert (schedules.size() == 1);
        GroupOperationSchedule returnedSchedule = (GroupOperationSchedule)schedules.get(0);
        assert (returnedSchedule.getSubject().equals((Object)this.overlord()));
        assert (returnedSchedule.getGroup().getId() == this.newGroup.getId());
        assert (returnedSchedule.getParameters() == null);
        assert (returnedSchedule.getOperationName().equals(PREFIX + "testOp"));
        assert (returnedSchedule.getDescription().equals(PREFIX + "desc"));
        this.operationManager.unscheduleGroupOperation(this.overlord(), returnedSchedule.getJobId().toString(), returnedSchedule.getGroup().getId());
        PageList results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results.size() == 0);
        PageList results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2 != null);
        assert (results2.size() == 0);
    }

    @Test(enabled=true)
    public void testUnscheduledGroupOperationWithParameters() throws Exception {
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 0L;
        Configuration params = new Configuration();
        params.put((Property)new PropertySimple("param1", (Object)"group-test"));
        params.put((Property)new PropertySimple("param2", (Object)"blah"));
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date(System.currentTimeMillis() + 3600000L));
        GroupOperationSchedule schedule = this.operationManager.scheduleGroupOperation(this.overlord(), this.newGroup.getId(), null, true, PREFIX + "testOp", params, (Trigger)trigger, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() != null);
        assert (schedule.getGroup().getId() == this.newGroup.getId());
        int configId = params.getId();
        Configuration returnedConfiguration = this.configurationManager.getConfigurationById(configId);
        assert (returnedConfiguration.getProperties().size() == 2);
        assert (returnedConfiguration.getSimple("param1").getStringValue().equals("group-test"));
        assert (returnedConfiguration.getSimple("param2").getStringValue().equals("blah"));
        List schedules = this.operationManager.findScheduledGroupOperations(this.overlord(), this.newGroup.getId());
        assert (schedules != null);
        assert (schedules.size() == 1);
        GroupOperationSchedule returnedSchedule = (GroupOperationSchedule)schedules.get(0);
        assert (returnedSchedule.getSubject().equals((Object)this.overlord()));
        assert (returnedSchedule.getGroup().getId() == this.newGroup.getId());
        assert (returnedSchedule.getParameters() != null);
        assert (returnedSchedule.getOperationName().equals(PREFIX + "testOp"));
        assert (returnedSchedule.getDescription().equals(PREFIX + "desc"));
        PageList list = this.operationManager.findCurrentlyScheduledGroupOperations(this.overlord(), PageControl.getUnlimitedInstance());
        assert (list.size() == 1);
        assert (((GroupOperationScheduleComposite)list.get(0)).getGroupId() == this.newGroup.getId());
        assert (((GroupOperationScheduleComposite)list.get(0)).getGroupName().equals(this.newGroup.getName()));
        assert (((GroupOperationScheduleComposite)list.get(0)).getOperationName().equals("Test Operation"));
        this.operationManager.unscheduleGroupOperation(this.overlord(), returnedSchedule.getJobId().toString(), returnedSchedule.getGroup().getId());
        list = this.operationManager.findCurrentlyScheduledGroupOperations(this.overlord(), PageControl.getUnlimitedInstance());
        assert (list.size() == 0);
        PageList results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results.size() == 0);
        PageList results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2 != null);
        assert (results2.size() == 0);
        Configuration returnedConfiguration2 = this.configurationManager.getConfigurationById(configId);
        assert (returnedConfiguration2 == null);
    }

    @Test(enabled=true)
    public void testGetScheduledGroupOperations() throws Exception {
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 0L;
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date(System.currentTimeMillis() + 5000L));
        GroupOperationSchedule schedule = this.operationManager.scheduleGroupOperation(this.overlord(), this.newGroup.getId(), null, true, PREFIX + "testOp", null, (Trigger)trigger, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() == null);
        assert (schedule.getGroup().getId() == this.newGroup.getId());
        List schedules = this.operationManager.findScheduledGroupOperations(this.overlord(), this.newGroup.getId());
        assert (schedules != null);
        assert (schedules.size() == 1);
        GroupOperationSchedule returnedSchedule = (GroupOperationSchedule)schedules.get(0);
        assert (returnedSchedule.getSubject().equals((Object)this.overlord()));
        assert (returnedSchedule.getGroup().getId() == this.newGroup.getId());
        assert (returnedSchedule.getParameters() == null);
        assert (returnedSchedule.getOperationName().equals(PREFIX + "testOp"));
        assert (returnedSchedule.getDescription().equals(PREFIX + "desc"));
        Thread.sleep(9000L);
        PageList results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results.size() == 1) : "Expected 1 result, but got " + results.size();
        this.operationManager.deleteOperationHistory(this.overlord(), ((GroupOperationHistory)results.get(0)).getId(), false);
        results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results.size() == 0);
        PageList results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2 != null);
        assert (results2.size() == 0);
        schedules = this.operationManager.findScheduledGroupOperations(this.overlord(), this.newGroup.getId());
        assert (schedules != null);
        assert (schedules.size() == 0);
    }

    @Test(enabled=true)
    public void testCancelGroupOperation() throws Exception {
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 30000L;
        this.simulatedOperation_CancelResults = new CancelResults(CancelResults.InterruptedState.RUNNING);
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date());
        this.operationManager.scheduleGroupOperation(this.overlord(), this.newGroup.getId(), new int[]{this.newResource.getId()}, true, PREFIX + "testOp", null, (Trigger)trigger, PREFIX + "desc");
        PageList results = null;
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(1000L);
            results = this.operationManager.findPendingGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
            if (results != null && results.size() > 0) break;
        }
        assert (results != null);
        assert (results.size() == 1) : "-->" + results;
        GroupOperationHistory history = (GroupOperationHistory)results.get(0);
        assert (history.getStatus() == OperationRequestStatus.INPROGRESS) : history;
        PageList results2 = null;
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(1000L);
            results2 = this.operationManager.findPendingResourceOperationHistories(this.overlord(), this.newResource.getId(), PageControl.getUnlimitedInstance());
            if (results2 != null && results2.size() > 0) break;
        }
        assert (results2.size() == 1) : "Should have had 1 resource history result: " + results2;
        ResourceOperationHistory rHistory = (ResourceOperationHistory)results2.get(0);
        assert (rHistory.getStatus() == OperationRequestStatus.INPROGRESS) : rHistory;
        this.operationManager.cancelOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 1);
        assert (((GroupOperationHistory)results.get(0)).getStatus() == OperationRequestStatus.CANCELED) : (GroupOperationHistory)results.get(0);
        results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2.size() == 1) : "Should have had 1 resource history result: " + results2;
        assert (((ResourceOperationHistory)results2.get(0)).getStatus() == OperationRequestStatus.CANCELED) : (ResourceOperationHistory)results2.get(0);
        try {
            this.operationManager.cancelOperationHistory(this.overlord(), history.getId(), false);
            assert (false) : "Should not have been able to cancel an operation that is not INPROGRESS";
        }
        catch (EJBException expected) {
            // empty catch block
        }
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
        results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2 != null);
        assert (results2.size() == 0);
    }

    @Test(enabled=true)
    public void testCancelUncancelableGroupOperation() throws Exception {
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 30000L;
        this.simulatedOperation_CancelResults = new CancelResults(CancelResults.InterruptedState.FINISHED);
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date());
        this.operationManager.scheduleGroupOperation(this.overlord(), this.newGroup.getId(), new int[]{this.newResource.getId()}, true, PREFIX + "testOp", null, (Trigger)trigger, PREFIX + "desc");
        PageList results = null;
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(1000L);
            results = this.operationManager.findPendingGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
            if (results != null && results.size() > 0) break;
        }
        assert (results != null);
        assert (results.size() == 1);
        GroupOperationHistory history = (GroupOperationHistory)results.get(0);
        assert (history.getStatus() == OperationRequestStatus.INPROGRESS) : history;
        PageList results2 = this.operationManager.findPendingResourceOperationHistories(this.overlord(), this.newResource.getId(), PageControl.getUnlimitedInstance());
        assert (results2.size() == 1) : "Should have had 1 resource history result: " + results2;
        ResourceOperationHistory rHistory = (ResourceOperationHistory)results2.get(0);
        assert (rHistory.getStatus() == OperationRequestStatus.INPROGRESS) : rHistory;
        this.operationManager.cancelOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results.size() == 1);
        assert (((GroupOperationHistory)results.get(0)).getStatus() == OperationRequestStatus.CANCELED) : (GroupOperationHistory)results.get(0);
        results = this.operationManager.findPendingGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results.size() == 0);
        results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2.size() == 0);
        results2 = this.operationManager.findPendingResourceOperationHistories(this.overlord(), this.newResource.getId(), PageControl.getUnlimitedInstance());
        assert (results2.size() == 1);
        assert (((ResourceOperationHistory)results2.get(0)).getStatus() == OperationRequestStatus.INPROGRESS) : (ResourceOperationHistory)results2.get(0);
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), true);
        results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
        results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2 != null);
        assert (results2.size() == 0);
    }

    @Test(enabled=true)
    public void testScheduleGroupOperation1() throws Exception {
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 0L;
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date());
        GroupOperationSchedule schedule = this.operationManager.scheduleGroupOperation(this.overlord(), this.newGroup.getId(), new int[]{this.newResource.getId()}, true, PREFIX + "testOp", null, (Trigger)trigger, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() == null);
        assert (schedule.getGroup().getId() == this.newGroup.getId());
        Thread.sleep(4000L);
        PageList results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 1);
        GroupOperationHistory history = (GroupOperationHistory)results.get(0);
        assert (history.getId() > 0) : history;
        assert (history.getJobId() != null) : history;
        assert (history.getJobName() != null) : history;
        assert (history.getJobGroup() != null) : history;
        assert (history.getErrorMessage() == null) : history;
        assert (history.getStatus() == OperationRequestStatus.SUCCESS) : history;
        assert (history.getSubjectName().equals(this.overlord().getName())) : history;
        PageList list = this.operationManager.findRecentlyCompletedGroupOperations(this.overlord(), PageControl.getUnlimitedInstance());
        assert (list.size() == 1);
        assert (((GroupOperationLastCompletedComposite)list.get(0)).getOperationHistoryId() == history.getId());
        assert (((GroupOperationLastCompletedComposite)list.get(0)).getGroupId() == this.newGroup.getId());
        assert (((GroupOperationLastCompletedComposite)list.get(0)).getGroupName().equals(this.newGroup.getName()));
        assert (((GroupOperationLastCompletedComposite)list.get(0)).getOperationName().equals("Test Operation"));
        PageList results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2.size() == 1) : "Should have had 1 result: " + results2;
        ResourceOperationHistory rHistory = (ResourceOperationHistory)results2.get(0);
        assert (rHistory.getId() > 0) : rHistory;
        assert (rHistory.getJobId() != null) : rHistory;
        assert (rHistory.getJobName() != null) : rHistory;
        assert (rHistory.getJobGroup() != null) : rHistory;
        assert (rHistory.getErrorMessage() == null) : rHistory;
        assert (rHistory.getStatus() == OperationRequestStatus.SUCCESS) : rHistory;
        assert (rHistory.getSubjectName().equals(this.overlord().getName())) : rHistory;
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
        results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2 != null);
        assert (results2.size() == 0);
        list = this.operationManager.findRecentlyCompletedGroupOperations(this.overlord(), PageControl.getUnlimitedInstance());
        assert (list.size() == 0);
    }

    @Test(enabled=true)
    public void testScheduleGroupOperation2() throws Exception {
        PageList results;
        boolean testOpComplete;
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 0L;
        GroupOperationSchedule schedule = this.operationManager.scheduleGroupOperation(this.overlord(), this.newGroup.getId(), new int[]{this.newResource.getId()}, true, PREFIX + "testOp", null, 0L, 0L, 0, 20, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() != null);
        assert (schedule.getGroup().getId() == this.newGroup.getId());
        long start = System.nanoTime();
        do {
            Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
            results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
            boolean bl = testOpComplete = !results.isEmpty();
        } while (!testOpComplete && System.nanoTime() - start < TimeUnit.MINUTES.toNanos(2L));
        assert (testOpComplete);
        this.assertEquals(1, results.size());
        GroupOperationHistory history = (GroupOperationHistory)results.get(0);
        assert (history.getId() > 0) : history;
        assert (history.getJobId() != null) : history;
        assert (history.getJobName() != null) : history;
        assert (history.getJobGroup() != null) : history;
        assert (history.getErrorMessage() == null) : history;
        assert (history.getStatus() == OperationRequestStatus.SUCCESS) : history;
        assert (history.getSubjectName().equals(this.overlord().getName())) : history;
        PageList list = this.operationManager.findRecentlyCompletedGroupOperations(this.overlord(), PageControl.getUnlimitedInstance());
        assert (list.size() == 1);
        assert (((GroupOperationLastCompletedComposite)list.get(0)).getOperationHistoryId() == history.getId());
        assert (((GroupOperationLastCompletedComposite)list.get(0)).getGroupId() == this.newGroup.getId());
        assert (((GroupOperationLastCompletedComposite)list.get(0)).getGroupName().equals(this.newGroup.getName()));
        assert (((GroupOperationLastCompletedComposite)list.get(0)).getOperationName().equals("Test Operation"));
        PageList results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2.size() == 1) : "Should have had 1 result: " + results2;
        ResourceOperationHistory rHistory = (ResourceOperationHistory)results2.get(0);
        assert (rHistory.getId() > 0) : rHistory;
        assert (rHistory.getJobId() != null) : rHistory;
        assert (rHistory.getJobName() != null) : rHistory;
        assert (rHistory.getJobGroup() != null) : rHistory;
        assert (rHistory.getErrorMessage() == null) : rHistory;
        assert (rHistory.getStatus() == OperationRequestStatus.SUCCESS) : rHistory;
        assert (rHistory.getSubjectName().equals(this.overlord().getName())) : rHistory;
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
        results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2 != null);
        assert (results2.size() == 0);
        list = this.operationManager.findRecentlyCompletedGroupOperations(this.overlord(), PageControl.getUnlimitedInstance());
        assert (list.size() == 0);
    }

    @Test(enabled=true)
    public void testScheduleGroupOperation3() throws Exception {
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 0L;
        GroupOperationSchedule newSchedule = new GroupOperationSchedule();
        newSchedule.setGroup(this.newGroup);
        newSchedule.setExecutionOrder(Arrays.asList(this.newResource));
        newSchedule.setHaltOnFailure(true);
        newSchedule.setOperationName(PREFIX + "testOp");
        newSchedule.setParameters(null);
        newSchedule.setJobTrigger(JobTrigger.createNowTrigger());
        newSchedule.setDescription(PREFIX + "desc");
        int scheduleId = this.operationManager.scheduleGroupOperation(this.overlord(), newSchedule);
        List schedules = this.operationManager.findScheduledGroupOperations(this.overlord(), this.newGroup.getId());
        assert (schedules != null);
        assert (!schedules.isEmpty());
        GroupOperationSchedule schedule = (GroupOperationSchedule)schedules.get(0);
        assert (schedule != null);
        assert (schedule.getId() == scheduleId);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() == null);
        assert (schedule.getGroup().getId() == this.newGroup.getId());
        Thread.sleep(4000L);
        PageList results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 1);
        GroupOperationHistory history = (GroupOperationHistory)results.get(0);
        assert (history.getId() > 0) : history;
        assert (history.getJobId() != null) : history;
        assert (history.getJobName() != null) : history;
        assert (history.getJobGroup() != null) : history;
        assert (history.getErrorMessage() == null) : history;
        assert (history.getStatus() == OperationRequestStatus.SUCCESS) : history;
        assert (history.getSubjectName().equals(this.overlord().getName())) : history;
        PageList list = this.operationManager.findRecentlyCompletedGroupOperations(this.overlord(), PageControl.getUnlimitedInstance());
        assert (list.size() == 1);
        assert (((GroupOperationLastCompletedComposite)list.get(0)).getOperationHistoryId() == history.getId());
        assert (((GroupOperationLastCompletedComposite)list.get(0)).getGroupId() == this.newGroup.getId());
        assert (((GroupOperationLastCompletedComposite)list.get(0)).getGroupName().equals(this.newGroup.getName()));
        assert (((GroupOperationLastCompletedComposite)list.get(0)).getOperationName().equals("Test Operation"));
        PageList results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2.size() == 1) : "Should have had 1 result: " + results2;
        ResourceOperationHistory rHistory = (ResourceOperationHistory)results2.get(0);
        assert (rHistory.getId() > 0) : rHistory;
        assert (rHistory.getJobId() != null) : rHistory;
        assert (rHistory.getJobName() != null) : rHistory;
        assert (rHistory.getJobGroup() != null) : rHistory;
        assert (rHistory.getErrorMessage() == null) : rHistory;
        assert (rHistory.getStatus() == OperationRequestStatus.SUCCESS) : rHistory;
        assert (rHistory.getSubjectName().equals(this.overlord().getName())) : rHistory;
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
        results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2 != null);
        assert (results2.size() == 0);
        list = this.operationManager.findRecentlyCompletedGroupOperations(this.overlord(), PageControl.getUnlimitedInstance());
        assert (list.size() == 0);
    }

    @Test(enabled=true)
    public void testScheduleGroupOperationRecurring() throws Exception {
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 0L;
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", 1, 2000L);
        GroupOperationSchedule schedule = this.operationManager.scheduleGroupOperation(this.overlord(), this.newGroup.getId(), new int[]{this.newResource.getId()}, true, PREFIX + "testOp", null, (Trigger)trigger, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() == null);
        assert (schedule.getGroup().getId() == this.newGroup.getId());
        Thread.sleep(8000L);
        PageList results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 2) : results;
        GroupOperationHistory history0 = (GroupOperationHistory)results.get(0);
        GroupOperationHistory history1 = (GroupOperationHistory)results.get(1);
        assert (history0.getId() > 0) : history0;
        assert (history0.getJobId() != null) : history0;
        assert (history0.getJobName() != null) : history0;
        assert (history0.getJobGroup() != null) : history0;
        assert (history0.getErrorMessage() == null) : history0;
        assert (history0.getStatus() == OperationRequestStatus.SUCCESS) : history0;
        assert (history0.getSubjectName().equals(this.overlord().getName())) : history0;
        assert (history1.getId() > 0) : history1;
        assert (history1.getId() != history0.getId()) : history1;
        assert (history1.getJobId() != null) : history1;
        assert (!history1.getJobId().equals((Object)history0.getJobId())) : history1;
        assert (history1.getJobName() != null) : history1;
        assert (history1.getJobGroup() != null) : history1;
        assert (history1.getErrorMessage() == null) : history1;
        assert (history1.getStatus() == OperationRequestStatus.SUCCESS) : history1;
        assert (history1.getSubjectName().equals(this.overlord().getName())) : history1;
        PageList results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2.size() == 2) : "Should have had 2 results since it was triggered twice: " + results2;
        ResourceOperationHistory rHistory0 = (ResourceOperationHistory)results2.get(0);
        assert (rHistory0.getId() > 0) : rHistory0;
        assert (rHistory0.getJobId() != null) : rHistory0;
        assert (rHistory0.getJobName() != null) : rHistory0;
        assert (rHistory0.getJobGroup() != null) : rHistory0;
        assert (rHistory0.getErrorMessage() == null) : rHistory0;
        assert (rHistory0.getStatus() == OperationRequestStatus.SUCCESS) : rHistory0;
        assert (rHistory0.getSubjectName().equals(this.overlord().getName())) : rHistory0;
        ResourceOperationHistory rHistory1 = (ResourceOperationHistory)results2.get(1);
        assert (rHistory1.getId() > 0) : rHistory1;
        assert (rHistory1.getId() != rHistory0.getId()) : rHistory1;
        assert (rHistory1.getJobId() != null) : rHistory1;
        assert (!rHistory1.getJobId().equals((Object)rHistory0.getJobId())) : rHistory1;
        assert (rHistory1.getJobId().getJobGroup().equals(rHistory1.getJobGroup())) : rHistory1;
        assert (rHistory1.getJobId().getJobName().equals(rHistory1.getJobName())) : rHistory1;
        assert (rHistory1.getJobName() != null) : rHistory1;
        assert (rHistory1.getJobGroup() != null) : rHistory1;
        assert (rHistory1.getJobGroup().equals(rHistory0.getJobGroup())) : rHistory1;
        assert (rHistory1.getErrorMessage() == null) : rHistory1;
        assert (rHistory1.getStatus() == OperationRequestStatus.SUCCESS) : rHistory1;
        assert (rHistory1.getSubjectName().equals(this.overlord().getName())) : rHistory1;
        this.operationManager.deleteOperationHistory(this.overlord(), history0.getId(), false);
        this.operationManager.deleteOperationHistory(this.overlord(), history1.getId(), false);
        results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0) : results;
        results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2 != null);
        assert (results2.size() == 0);
    }

    @Test(enabled=true)
    public void testScheduleGroupOperationWithParameters() throws Exception {
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 0L;
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date());
        Configuration params = new Configuration();
        params.put((Property)new PropertySimple("param1", (Object)"group-test"));
        params.put((Property)new PropertySimple("param2", (Object)"blah"));
        int[] order = new int[]{this.newResource.getId(), this.newResource.getId()};
        GroupOperationSchedule schedule = this.operationManager.scheduleGroupOperation(this.overlord(), this.newGroup.getId(), order, true, PREFIX + "testOp", params, (Trigger)trigger, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() != null);
        assert (schedule.getParameters().getId() > 0);
        assert (schedule.getParameters().getNames().size() == 2);
        assert (schedule.getParameters().getNames().contains("param1"));
        assert (schedule.getParameters().getNames().contains("param2"));
        assert (schedule.getParameters().getSimple("param1").getStringValue().equals("group-test"));
        assert (schedule.getParameters().getSimple("param2").getStringValue().equals("blah"));
        assert (schedule.getGroup().getId() == this.newGroup.getId());
        int scheduleParamId = schedule.getParameters().getId();
        Thread.sleep(4000L);
        PageList results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 1);
        GroupOperationHistory history = (GroupOperationHistory)results.get(0);
        assert (history.getId() > 0) : history;
        assert (history.getJobId() != null) : history;
        assert (history.getJobName() != null) : history;
        assert (history.getJobGroup() != null) : history;
        assert (history.getErrorMessage() == null) : history;
        assert (history.getStatus() == OperationRequestStatus.SUCCESS) : history;
        assert (history.getSubjectName().equals(this.overlord().getName())) : history;
        assert (history.getGroup().getId() == this.newGroup.getId());
        history = (GroupOperationHistory)this.operationManager.getOperationHistoryByHistoryId(this.overlord(), history.getId());
        assert (history.getParameters().getId() != scheduleParamId) : "params should be copies - not shared";
        PageList results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        ResourceOperationHistory rHistory = (ResourceOperationHistory)results2.get(0);
        assert (rHistory.getId() > 0) : rHistory;
        assert (rHistory.getJobId() != null) : rHistory;
        assert (rHistory.getJobName() != null) : rHistory;
        assert (rHistory.getJobGroup() != null) : rHistory;
        assert (rHistory.getErrorMessage() == null) : rHistory;
        assert (rHistory.getStatus() == OperationRequestStatus.SUCCESS) : rHistory;
        assert (rHistory.getSubjectName().equals(this.overlord().getName())) : rHistory;
        rHistory = (ResourceOperationHistory)this.operationManager.getOperationHistoryByHistoryId(this.overlord(), rHistory.getId());
        assert (rHistory.getResults() != null);
        assert (rHistory.getResults().getSimple("param1echo") != null);
        assert (rHistory.getResults().getSimple("param1echo").getStringValue().equals("group-test"));
        assert (rHistory.getParameters().getId() != scheduleParamId) : "params should be copies - not shared";
        assert (rHistory.getParameters().getId() != history.getParameters().getId()) : "params should be copies - not shared";
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
        results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2 != null);
        assert (results2.size() == 0);
    }

    @Test(enabled=true)
    public void testScheduleGroupOperationError() throws Exception {
        this.simulatedOperation_Error = "an error!";
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 0L;
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date());
        GroupOperationSchedule schedule = this.operationManager.scheduleGroupOperation(this.overlord(), this.newGroup.getId(), new int[]{this.newResource.getId()}, true, PREFIX + "testOp", null, (Trigger)trigger, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() == null);
        assert (schedule.getGroup().getId() == this.newGroup.getId());
        Thread.sleep(4000L);
        PageList results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 1) : "Did not get 1 result back, but " + results.size();
        GroupOperationHistory history = (GroupOperationHistory)results.get(0);
        assert (history.getId() > 0) : history;
        assert (history.getJobId() != null) : history;
        assert (history.getJobName() != null) : history;
        assert (history.getJobGroup() != null) : history;
        assert (history.getErrorMessage() != null) : history;
        assert (history.getErrorMessage().indexOf(this.newResource.getName()) > -1) : history;
        assert (history.getStatus() == OperationRequestStatus.FAILURE) : history;
        assert (history.getSubjectName().equals(this.overlord().getName())) : history;
        PageList results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        ResourceOperationHistory rHistory = (ResourceOperationHistory)results2.get(0);
        assert (rHistory.getId() > 0) : rHistory;
        assert (rHistory.getJobId() != null) : rHistory;
        assert (rHistory.getJobName() != null) : rHistory;
        assert (rHistory.getJobGroup() != null) : rHistory;
        assert (rHistory.getErrorMessage() != null) : rHistory;
        assert (rHistory.getErrorMessage().indexOf("an error!") > -1) : rHistory;
        assert (rHistory.getStatus() == OperationRequestStatus.FAILURE) : rHistory;
        assert (rHistory.getSubjectName().equals(this.overlord().getName())) : rHistory;
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
        results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2 != null);
        assert (results2.size() == 0);
    }

    @Test(enabled=true)
    public void testScheduleGroupOperationTimeout() throws Exception {
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = true;
        this.simulatedOperation_Sleep = 0L;
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date());
        GroupOperationSchedule schedule = this.operationManager.scheduleGroupOperation(this.overlord(), this.newGroup.getId(), new int[]{this.newResource.getId()}, true, PREFIX + "testOp", null, (Trigger)trigger, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() == null);
        assert (schedule.getGroup().getId() == this.newGroup.getId());
        Thread.sleep(4000L);
        PageList results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 1);
        GroupOperationHistory history = (GroupOperationHistory)results.get(0);
        assert (history.getId() > 0) : history;
        assert (history.getJobId() != null) : history;
        assert (history.getJobName() != null) : history;
        assert (history.getJobGroup() != null) : history;
        assert (history.getErrorMessage() != null) : history;
        assert (history.getErrorMessage().indexOf(this.newResource.getName()) > -1) : history;
        assert (history.getStatus() == OperationRequestStatus.FAILURE) : history;
        assert (history.getSubjectName().equals(this.overlord().getName())) : history;
        PageList results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        ResourceOperationHistory rHistory = (ResourceOperationHistory)results2.get(0);
        assert (rHistory.getId() > 0) : rHistory;
        assert (rHistory.getJobId() != null) : rHistory;
        assert (rHistory.getJobName() != null) : rHistory;
        assert (rHistory.getJobGroup() != null) : rHistory;
        assert (rHistory.getErrorMessage() != null) : rHistory;
        assert (rHistory.getErrorMessage().indexOf("Timed out") > -1) : rHistory;
        assert (rHistory.getStatus() == OperationRequestStatus.FAILURE) : rHistory;
        assert (rHistory.getSubjectName().equals(this.overlord().getName())) : rHistory;
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedGroupOperationHistories(this.overlord(), this.newGroup.getId(), PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
        results2 = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results2 != null);
        assert (results2.size() == 0);
    }

    @Test(enabled=true)
    public void testUnscheduledResourceOperation() throws Exception {
        Resource resource = this.newResource;
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 0L;
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date(System.currentTimeMillis() + 10000L));
        ResourceOperationSchedule schedule = this.operationManager.scheduleResourceOperation(this.overlord(), resource.getId(), PREFIX + "testOp", null, (Trigger)trigger, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() == null);
        assert (schedule.getResource().getId() == this.newResource.getId());
        List schedules = this.operationManager.findScheduledResourceOperations(this.overlord(), resource.getId());
        assert (schedules != null);
        assert (schedules.size() == 1);
        ResourceOperationSchedule returnedSchedule = (ResourceOperationSchedule)schedules.get(0);
        assert (returnedSchedule.getSubject().equals((Object)this.overlord()));
        assert (returnedSchedule.getResource().getId() == resource.getId());
        assert (returnedSchedule.getParameters() == null);
        assert (returnedSchedule.getOperationName().equals(PREFIX + "testOp"));
        assert (returnedSchedule.getDescription().equals(PREFIX + "desc"));
        PageList list = this.operationManager.findCurrentlyScheduledResourceOperations(this.overlord(), PageControl.getUnlimitedInstance());
        assert (list.size() == 1);
        assert (((ResourceOperationScheduleComposite)list.get(0)).getResourceId() == resource.getId());
        assert (((ResourceOperationScheduleComposite)list.get(0)).getResourceName().equals(resource.getName()));
        assert (((ResourceOperationScheduleComposite)list.get(0)).getOperationName().equals("Test Operation"));
        this.operationManager.unscheduleResourceOperation(this.overlord(), returnedSchedule.getJobId().toString(), returnedSchedule.getResource().getId());
        list = this.operationManager.findCurrentlyScheduledResourceOperations(this.overlord(), PageControl.getUnlimitedInstance());
        assert (list.size() == 0);
        PageList results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
    }

    @Test(enabled=true)
    public void testUnscheduledResourceOperationWithParameters() throws Exception {
        Resource resource = this.newResource;
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 0L;
        Configuration params = new Configuration();
        params.put((Property)new PropertySimple("param1", (Object)"group-test"));
        params.put((Property)new PropertySimple("param2", (Object)"blah"));
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date(System.currentTimeMillis() + 10000L));
        ResourceOperationSchedule schedule = this.operationManager.scheduleResourceOperation(this.overlord(), resource.getId(), PREFIX + "testOp", params, (Trigger)trigger, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() != null);
        assert (schedule.getResource().getId() == this.newResource.getId());
        int configId = params.getId();
        Configuration returnedConfiguration = this.configurationManager.getConfigurationById(configId);
        assert (returnedConfiguration.getProperties().size() == 2);
        assert (returnedConfiguration.getSimple("param1").getStringValue().equals("group-test"));
        assert (returnedConfiguration.getSimple("param2").getStringValue().equals("blah"));
        List schedules = this.operationManager.findScheduledResourceOperations(this.overlord(), resource.getId());
        assert (schedules != null);
        assert (schedules.size() == 1);
        ResourceOperationSchedule returnedSchedule = (ResourceOperationSchedule)schedules.get(0);
        assert (returnedSchedule.getSubject().equals((Object)this.overlord()));
        assert (returnedSchedule.getResource().getId() == resource.getId());
        assert (returnedSchedule.getParameters() != null);
        assert (returnedSchedule.getOperationName().equals(PREFIX + "testOp"));
        assert (returnedSchedule.getDescription().equals(PREFIX + "desc"));
        this.operationManager.unscheduleResourceOperation(this.overlord(), returnedSchedule.getJobId().toString(), returnedSchedule.getResource().getId());
        PageList results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
        Configuration returnedConfiguration2 = this.configurationManager.getConfigurationById(configId);
        assert (returnedConfiguration2 == null);
    }

    @Test(enabled=true)
    public void testGetScheduledResourceOperations() throws Exception {
        Resource resource = this.newResource;
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 0L;
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date(System.currentTimeMillis() + 5000L));
        ResourceOperationSchedule schedule = this.operationManager.scheduleResourceOperation(this.overlord(), resource.getId(), PREFIX + "testOp", null, (Trigger)trigger, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() == null);
        assert (schedule.getResource().getId() == this.newResource.getId());
        List schedules = this.operationManager.findScheduledResourceOperations(this.overlord(), resource.getId());
        assert (schedules != null);
        assert (schedules.size() == 1);
        ResourceOperationSchedule returnedSchedule = (ResourceOperationSchedule)schedules.get(0);
        assert (returnedSchedule.getSubject().equals((Object)this.overlord()));
        assert (returnedSchedule.getResource().getId() == resource.getId());
        assert (returnedSchedule.getParameters() == null);
        assert (returnedSchedule.getOperationName().equals(PREFIX + "testOp"));
        assert (returnedSchedule.getDescription().equals(PREFIX + "desc"));
        Thread.sleep(9000L);
        PageList results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null) : "Results were unexpectedly empty";
        if (results.isEmpty()) {
            System.out.println("We did not yet get a result -- waiting some more");
            Thread.sleep(5000L);
            results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        }
        assert (results != null) : "Results were unexpectedly empty";
        assert (!results.isEmpty()) : "We did not get results back";
        this.operationManager.deleteOperationHistory(this.overlord(), ((ResourceOperationHistory)results.get(0)).getId(), false);
        results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
        schedules = this.operationManager.findScheduledResourceOperations(this.overlord(), resource.getId());
        assert (schedules != null);
        assert (schedules.size() == 0);
    }

    @Test(enabled=true)
    public void testGetScheduledResourceOperationsError() throws Exception {
        Resource resource = this.newResource;
        this.simulatedOperation_Error = "some error";
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 0L;
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date(System.currentTimeMillis() + 5000L));
        ResourceOperationSchedule schedule = this.operationManager.scheduleResourceOperation(this.overlord(), resource.getId(), PREFIX + "testOp", null, (Trigger)trigger, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() == null);
        assert (schedule.getResource().getId() == this.newResource.getId());
        List schedules = this.operationManager.findScheduledResourceOperations(this.overlord(), resource.getId());
        assert (schedules != null);
        assert (schedules.size() == 1);
        ResourceOperationSchedule returnedSchedule = (ResourceOperationSchedule)schedules.get(0);
        assert (returnedSchedule.getSubject().equals((Object)this.overlord()));
        assert (returnedSchedule.getResource().getId() == resource.getId());
        assert (returnedSchedule.getParameters() == null);
        assert (returnedSchedule.getOperationName().equals(PREFIX + "testOp"));
        assert (returnedSchedule.getDescription().equals(PREFIX + "desc"));
        Thread.sleep(9000L);
        PageList results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        if (results.isEmpty()) {
            System.out.println("We did not yet get a result -- waiting some more");
            Thread.sleep(5000L);
            results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        }
        assert (results.size() == 1) : "Did not get 1 result, but " + results.size();
        ResourceOperationHistory history = (ResourceOperationHistory)results.get(0);
        assert (history.getErrorMessage() != null) : history;
        assert (history.getErrorMessage().indexOf("some error") > -1) : history;
        assert (history.getStatus() == OperationRequestStatus.FAILURE) : history;
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
    }

    @Test(enabled=true)
    public void testGetScheduledResourceOperationsTimeout() throws Exception {
        Resource resource = this.newResource;
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = true;
        this.simulatedOperation_Sleep = 0L;
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date(System.currentTimeMillis() + 5000L));
        ResourceOperationSchedule schedule = this.operationManager.scheduleResourceOperation(this.overlord(), resource.getId(), PREFIX + "testOp", null, (Trigger)trigger, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() == null);
        assert (schedule.getResource().getId() == this.newResource.getId());
        List schedules = this.operationManager.findScheduledResourceOperations(this.overlord(), resource.getId());
        assert (schedules != null);
        assert (schedules.size() == 1);
        ResourceOperationSchedule returnedSchedule = (ResourceOperationSchedule)schedules.get(0);
        assert (returnedSchedule.getSubject().equals((Object)this.overlord()));
        assert (returnedSchedule.getResource().getId() == resource.getId());
        assert (returnedSchedule.getParameters() == null);
        assert (returnedSchedule.getOperationName().equals(PREFIX + "testOp"));
        assert (returnedSchedule.getDescription().equals(PREFIX + "desc"));
        Thread.sleep(9000L);
        PageList results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        if (results.isEmpty()) {
            System.out.println("We did not yet get a result -- waiting some more");
            Thread.sleep(5000L);
            results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        }
        assert (results.size() == 1) : "Did not get 1 result but " + results.size();
        ResourceOperationHistory history = (ResourceOperationHistory)results.get(0);
        assert (history.getErrorMessage() != null) : history;
        assert (history.getErrorMessage().indexOf("Timed out") > -1) : history;
        assert (history.getStatus() == OperationRequestStatus.FAILURE) : history;
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), this.newResource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0) : "Did not get 0 result but " + results.size();
    }

    @Test(enabled=true)
    public void testCancelResourceOperation() throws Exception {
        Resource resource = this.newResource;
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 30000L;
        this.simulatedOperation_CancelResults = new CancelResults(CancelResults.InterruptedState.RUNNING);
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date());
        this.operationManager.scheduleResourceOperation(this.overlord(), resource.getId(), PREFIX + "testOp", null, (Trigger)trigger, PREFIX + "desc");
        PageList results = null;
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(1000L);
            results = this.operationManager.findPendingResourceOperationHistories(this.overlord(), resource.getId(), PageControl.getUnlimitedInstance());
            if (results != null && results.size() > 0) break;
        }
        assert (results != null);
        assert (results.size() == 1);
        ResourceOperationHistory history = (ResourceOperationHistory)results.get(0);
        assert (history.getStatus() == OperationRequestStatus.INPROGRESS) : history;
        this.operationManager.cancelOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 1);
        history = (ResourceOperationHistory)results.get(0);
        assert (history.getStatus() == OperationRequestStatus.CANCELED) : history;
        System.out.println("test: Canceled resource history: " + history);
        try {
            this.operationManager.cancelOperationHistory(this.overlord(), history.getId(), false);
            assert (false) : "Should not have been able to cancel an operation that is not INPROGRESS";
        }
        catch (EJBException expected) {
            // empty catch block
        }
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
    }

    @Test(enabled=true)
    public void testCancelUncancelableResourceOperation() throws Exception {
        Resource resource = this.newResource;
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 30000L;
        this.simulatedOperation_CancelResults = new CancelResults(CancelResults.InterruptedState.FINISHED);
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date());
        this.operationManager.scheduleResourceOperation(this.overlord(), resource.getId(), PREFIX + "testOp", null, (Trigger)trigger, PREFIX + "desc");
        PageList results = null;
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(1000L);
            results = this.operationManager.findPendingResourceOperationHistories(this.overlord(), resource.getId(), PageControl.getUnlimitedInstance());
            if (results != null && results.size() > 0) break;
        }
        assert (results != null);
        assert (results.size() == 1);
        ResourceOperationHistory history = (ResourceOperationHistory)results.get(0);
        assert (history.getStatus() == OperationRequestStatus.INPROGRESS) : history;
        this.operationManager.cancelOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
        results = this.operationManager.findPendingResourceOperationHistories(this.overlord(), resource.getId(), PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 1);
        history = (ResourceOperationHistory)results.get(0);
        assert (history.getStatus() == OperationRequestStatus.INPROGRESS) : history;
        System.out.println("test: Uncancelable resource history: " + history);
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), true);
        results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
    }

    @Test(enabled=true)
    public void testScheduleResourceOperation1() throws Exception {
        Resource resource = this.newResource;
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 0L;
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date(System.currentTimeMillis()));
        ResourceOperationSchedule schedule = this.operationManager.scheduleResourceOperation(this.overlord(), resource.getId(), PREFIX + "testOp", null, (Trigger)trigger, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() == null);
        assert (schedule.getResource().getId() == this.newResource.getId());
        Thread.sleep(4000L);
        PageList results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 1);
        ResourceOperationHistory history = (ResourceOperationHistory)results.get(0);
        assert (history.getId() > 0) : history;
        assert (history.getJobId() != null) : history;
        assert (history.getJobName() != null) : history;
        assert (history.getJobGroup() != null) : history;
        assert (history.getErrorMessage() == null) : history;
        assert (history.getStatus() == OperationRequestStatus.SUCCESS) : history;
        assert (history.getSubjectName().equals(this.overlord().getName())) : history;
        PageList list = this.operationManager.findRecentlyCompletedResourceOperations(this.overlord(), null, PageControl.getUnlimitedInstance());
        assert (list.size() == 1);
        assert (((ResourceOperationLastCompletedComposite)list.get(0)).getOperationHistoryId() == history.getId());
        assert (((ResourceOperationLastCompletedComposite)list.get(0)).getResourceId() == resource.getId());
        assert (((ResourceOperationLastCompletedComposite)list.get(0)).getResourceName().equals(resource.getName()));
        assert (((ResourceOperationLastCompletedComposite)list.get(0)).getOperationName().equals("Test Operation"));
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
        list = this.operationManager.findRecentlyCompletedResourceOperations(this.overlord(), null, PageControl.getUnlimitedInstance());
        assert (list.size() == 0);
    }

    @Test(enabled=true)
    public void testScheduleResourceOperation2() throws Exception {
        Resource resource = this.newResource;
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 0L;
        ResourceOperationSchedule newSchedule = new ResourceOperationSchedule();
        newSchedule.setJobTrigger(JobTrigger.createNowTrigger());
        newSchedule.setResource(resource);
        newSchedule.setOperationName(PREFIX + "testOp");
        newSchedule.setDescription(PREFIX + "desc");
        newSchedule.setParameters(null);
        newSchedule.setParameters(null);
        int scheduleId = this.operationManager.scheduleResourceOperation(this.overlord(), newSchedule);
        List schedules = this.operationManager.findScheduledResourceOperations(this.overlord(), resource.getId());
        assert (schedules != null);
        assert (!schedules.isEmpty());
        ResourceOperationSchedule schedule = (ResourceOperationSchedule)schedules.get(0);
        assert (schedule != null);
        assert (schedule.getId() == scheduleId);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() == null);
        assert (schedule.getResource().getId() == this.newResource.getId());
        Thread.sleep(4000L);
        PageList results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 1);
        ResourceOperationHistory history = (ResourceOperationHistory)results.get(0);
        assert (history.getId() > 0) : history;
        assert (history.getJobId() != null) : history;
        assert (history.getJobName() != null) : history;
        assert (history.getJobGroup() != null) : history;
        assert (history.getErrorMessage() == null) : history;
        assert (history.getStatus() == OperationRequestStatus.SUCCESS) : history;
        assert (history.getSubjectName().equals(this.overlord().getName())) : history;
        PageList list = this.operationManager.findRecentlyCompletedResourceOperations(this.overlord(), null, PageControl.getUnlimitedInstance());
        assert (list.size() == 1);
        assert (((ResourceOperationLastCompletedComposite)list.get(0)).getOperationHistoryId() == history.getId());
        assert (((ResourceOperationLastCompletedComposite)list.get(0)).getResourceId() == resource.getId());
        assert (((ResourceOperationLastCompletedComposite)list.get(0)).getResourceName().equals(resource.getName()));
        assert (((ResourceOperationLastCompletedComposite)list.get(0)).getOperationName().equals("Test Operation"));
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
        list = this.operationManager.findRecentlyCompletedResourceOperations(this.overlord(), null, PageControl.getUnlimitedInstance());
        assert (list.size() == 0);
    }

    @Test(enabled=true)
    public void testScheduleResourceOperationRecurring() throws Exception {
        Resource resource = this.newResource;
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 0L;
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", 1, 750L);
        ResourceOperationSchedule schedule = this.operationManager.scheduleResourceOperation(this.overlord(), resource.getId(), PREFIX + "testOp", null, (Trigger)trigger, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() == null);
        assert (schedule.getResource().getId() == this.newResource.getId());
        Thread.sleep(4000L);
        PageList results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 2) : "Should have had multiple results: " + results;
        ResourceOperationHistory history0 = (ResourceOperationHistory)results.get(0);
        assert (history0.getId() > 0) : history0;
        assert (history0.getJobId() != null) : history0;
        assert (history0.getJobName() != null) : history0;
        assert (history0.getJobGroup() != null) : history0;
        assert (history0.getErrorMessage() == null) : history0;
        assert (history0.getStatus() == OperationRequestStatus.SUCCESS) : history0;
        assert (history0.getSubjectName().equals(this.overlord().getName())) : history0;
        ResourceOperationHistory history1 = (ResourceOperationHistory)results.get(1);
        assert (history1.getId() > 0) : history1;
        assert (history1.getId() != history0.getId()) : history1;
        assert (history1.getJobId() != null) : history1;
        assert (!history1.getJobId().equals((Object)history0.getJobId())) : history1;
        assert (history1.getJobName() != null) : history1;
        assert (history1.getJobName().equals(history1.getJobId().getJobName())) : history1;
        assert (history1.getJobId().getJobName().equals(history0.getJobId().getJobName())) : history1;
        assert (history1.getJobGroup() != null) : history1;
        assert (history1.getJobGroup().equals(history1.getJobId().getJobGroup())) : history1;
        assert (history1.getJobGroup().equals(history0.getJobGroup())) : history1;
        assert (history1.getJobId().getJobGroup().equals(history0.getJobId().getJobGroup())) : history1;
        assert (history1.getErrorMessage() == null) : history1;
        assert (history1.getStatus() == OperationRequestStatus.SUCCESS) : history1;
        assert (history1.getSubjectName().equals(this.overlord().getName())) : history1;
        this.operationManager.deleteOperationHistory(this.overlord(), history0.getId(), false);
        this.operationManager.deleteOperationHistory(this.overlord(), history1.getId(), false);
        results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
    }

    @Test(enabled=true)
    public void testScheduleResourceOperationWithParameters() throws Exception {
        Resource resource = this.newResource;
        this.simulatedOperation_Error = null;
        this.simulatedOperation_Timeout = false;
        this.simulatedOperation_Sleep = 0L;
        SimpleTrigger trigger = new SimpleTrigger(PREFIX + "triggername", PREFIX + "triggergroup", new Date());
        Configuration params = new Configuration();
        params.put((Property)new PropertySimple("param1", (Object)"test-value!"));
        ResourceOperationSchedule schedule = this.operationManager.scheduleResourceOperation(this.overlord(), resource.getId(), PREFIX + "testOp", params, (Trigger)trigger, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() != null);
        assert (schedule.getParameters().getId() > 0);
        assert (schedule.getParameters().getSimple("param1") != null);
        assert (schedule.getResource().getId() == this.newResource.getId());
        int scheduleParamId = schedule.getParameters().getId();
        Thread.sleep(4000L);
        PageList results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 1) : "size was " + results.size();
        ResourceOperationHistory history = (ResourceOperationHistory)results.get(0);
        assert (history.getId() > 0) : history;
        assert (history.getJobId() != null) : history;
        assert (history.getJobName() != null) : history;
        assert (history.getJobGroup() != null) : history;
        assert (history.getErrorMessage() == null) : history;
        assert (history.getStatus() == OperationRequestStatus.SUCCESS) : history;
        assert (history.getSubjectName().equals(this.overlord().getName())) : history;
        history = (ResourceOperationHistory)this.operationManager.getOperationHistoryByHistoryId(this.overlord(), history.getId());
        assert (history.getResults() != null);
        assert (history.getResults().getSimple("param1echo").getStringValue().equals("test-value!"));
        assert (history.getParameters().getId() != scheduleParamId) : "params should be copies - not shared";
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), false);
        results = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (results != null);
        assert (results.size() == 0);
    }

    @Test(enabled=true)
    public void testGetSupportedOperations() throws Exception {
        Resource resource = this.newResource;
        assert (this.operationManager.isResourceOperationSupported(this.overlord(), resource.getId()));
        assert (this.operationManager.isGroupOperationSupported(this.overlord(), this.newGroup.getId()));
        OperationDefinition op = this.operationManager.getSupportedGroupOperation(this.overlord(), this.newGroup.getId(), PREFIX + "testOp", true);
        assert (op != null);
        assert (op.getId() > 0);
        assert (op.getName().equals(PREFIX + "testOp"));
        assert (op.equals((Object)this.newOperation));
        List ops = this.operationManager.findSupportedGroupOperations(this.overlord(), this.newGroup.getId(), true);
        assert (ops != null);
        assert (ops.size() == 1);
        op = (OperationDefinition)ops.iterator().next();
        assert (op != null);
        assert (op.getId() > 0);
        assert (op.getName().equals(PREFIX + "testOp"));
        assert (op.equals((Object)this.newOperation));
        op = this.operationManager.getSupportedResourceOperation(this.overlord(), this.newResource.getId(), PREFIX + "testOp", true);
        assert (op != null);
        assert (op.getId() > 0);
        assert (op.getName().equals(PREFIX + "testOp"));
        assert (op.equals((Object)this.newOperation));
        ops = this.operationManager.findSupportedResourceOperations(this.overlord(), this.newResource.getId(), true);
        assert (ops != null);
        assert (ops.size() == 1);
        op = (OperationDefinition)ops.iterator().next();
        assert (op != null);
        assert (op.getId() > 0);
        assert (op.getName().equals(PREFIX + "testOp"));
        assert (op.equals((Object)this.newOperation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testNoPermissions() throws Exception {
        Subject noPermSubject = new Subject("userWithNoPermissions", true, false);
        Resource resource = this.newResource;
        try {
            noPermSubject = LookupUtil.getSubjectManager().createSubject(this.overlord(), noPermSubject);
            noPermSubject = this.createSession(noPermSubject);
            assert (!this.operationManager.isResourceOperationSupported(noPermSubject, resource.getId())) : "Should not have permission to get control info";
            assert (!this.operationManager.isGroupOperationSupported(noPermSubject, this.newGroup.getId())) : "Should not have permission to get control info";
            try {
                SimpleTrigger trigger = new SimpleTrigger();
                this.operationManager.scheduleResourceOperation(noPermSubject, resource.getId(), PREFIX + "testOp", null, (Trigger)trigger, "");
                assert (false) : "Should not have permission to schedule a new op";
            }
            catch (PermissionException expected) {
                // empty catch block
            }
            try {
                this.operationManager.findScheduledGroupOperations(noPermSubject, this.newGroup.getId());
                assert (false) : "Should not have permission to do this";
            }
            catch (PermissionException expected) {
                // empty catch block
            }
            try {
                this.operationManager.findScheduledResourceOperations(noPermSubject, this.newResource.getId());
                assert (false) : "Should not have permission to do this";
            }
            catch (PermissionException expected) {
                // empty catch block
            }
            try {
                this.operationManager.getSupportedGroupOperation(noPermSubject, this.newGroup.getId(), PREFIX + "testOp", false);
                assert (false) : "Should not have permission to do this";
            }
            catch (PermissionException expected) {
                // empty catch block
            }
            try {
                this.operationManager.findSupportedGroupOperations(noPermSubject, this.newGroup.getId(), false);
                assert (false) : "Should not have permission to do this";
            }
            catch (PermissionException expected) {
                // empty catch block
            }
            try {
                this.operationManager.getSupportedResourceOperation(noPermSubject, this.newResource.getId(), PREFIX + "testOp", false);
                assert (false) : "Should not have permission to do this";
            }
            catch (PermissionException expected) {
                // empty catch block
            }
            try {
                this.operationManager.findSupportedResourceOperations(noPermSubject, this.newResource.getId(), false);
                assert (false) : "Should not have permission to do this";
            }
            catch (PermissionException permissionException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            LookupUtil.getSubjectManager().deleteUsers(this.overlord(), new int[]{noPermSubject.getId()});
            throw throwable;
        }
        LookupUtil.getSubjectManager().deleteUsers(this.overlord(), new int[]{noPermSubject.getId()});
    }

    @Test(enabled=true)
    public void testCronResourceScheduling() throws Exception {
        Resource resource = this.newResource;
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(13, 2);
        Subject overlord = this.overlord();
        ResourceOperationSchedule schedule = this.operationManager.scheduleResourceOperationUsingCron(overlord, resource.getId(), PREFIX + "testOp", calendar.get(13) + " " + calendar.get(12) + " * * * ?", 20, null, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() != null);
        assert (schedule.getResource().getId() == resource.getId());
        List results = this.operationManager.findScheduledResourceOperations(overlord, resource.getId());
        assert (results != null);
        assert (results.size() == 1);
        ResourceOperationSchedule returnedSchedule = (ResourceOperationSchedule)results.get(0);
        assert (returnedSchedule.getId() > 0) : returnedSchedule;
        assert (returnedSchedule.getJobId() != null) : returnedSchedule;
        assert (returnedSchedule.getJobName() != null) : returnedSchedule;
        assert (returnedSchedule.getJobGroup() != null) : returnedSchedule;
        assert (returnedSchedule.getDescription().equals(PREFIX + "desc"));
        assert (returnedSchedule.getOperationName().equals(PREFIX + "testOp"));
        assert (returnedSchedule.getParameters() != null);
        assert (returnedSchedule.getResource().getId() == resource.getId());
        System.out.println("WAITING FOR 4.5s FOR THE SCHEDULED OPERATION TO FINISH");
        Thread.sleep(4500L);
        PageList resultsHist = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (resultsHist != null);
        assert (resultsHist.size() == 1);
        ResourceOperationHistory history = (ResourceOperationHistory)resultsHist.get(0);
        assert (history.getId() > 0) : history;
        assert (history.getJobId() != null) : history;
        assert (history.getJobName() != null) : history;
        assert (history.getJobGroup() != null) : history;
        assert (history.getErrorMessage() == null) : history;
        assert (history.getStatus() == OperationRequestStatus.SUCCESS) : history;
        assert (history.getSubjectName().equals(this.overlord().getName())) : history;
        PageList list = this.operationManager.findRecentlyCompletedResourceOperations(this.overlord(), null, PageControl.getUnlimitedInstance());
        assert (list.size() == 1);
        assert (((ResourceOperationLastCompletedComposite)list.get(0)).getOperationHistoryId() == history.getId());
        assert (((ResourceOperationLastCompletedComposite)list.get(0)).getResourceId() == resource.getId());
        assert (((ResourceOperationLastCompletedComposite)list.get(0)).getResourceName().equals(resource.getName()));
        assert (((ResourceOperationLastCompletedComposite)list.get(0)).getOperationName().equals("Test Operation"));
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), false);
        resultsHist = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (resultsHist != null);
        assert (resultsHist.size() == 0);
        list = this.operationManager.findRecentlyCompletedResourceOperations(this.overlord(), null, PageControl.getUnlimitedInstance());
        assert (list.size() == 0);
    }

    @Test(enabled=true)
    public void testCronGroupScheduling() throws Exception {
        Resource resource = this.newResource;
        ResourceGroup group = this.newGroup;
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(13, 2);
        Subject overlord = this.overlord();
        GroupOperationSchedule schedule = this.operationManager.scheduleGroupOperationUsingCron(overlord, this.newGroup.getId(), new int[]{resource.getId()}, true, PREFIX + "testOp", null, calendar.get(13) + " " + calendar.get(12) + " * * * ?", 20, PREFIX + "desc");
        assert (schedule != null);
        assert (schedule.getDescription().equals(PREFIX + "desc"));
        assert (schedule.getOperationName().equals(PREFIX + "testOp"));
        assert (schedule.getParameters() != null);
        assert (schedule.getGroup().getId() == group.getId());
        List results = this.operationManager.findScheduledGroupOperations(overlord, group.getId());
        assert (results != null);
        assert (results.size() == 1);
        GroupOperationSchedule returnedSchedule = (GroupOperationSchedule)results.get(0);
        assert (returnedSchedule.getId() > 0) : returnedSchedule;
        assert (returnedSchedule.getJobId() != null) : returnedSchedule;
        assert (returnedSchedule.getJobName() != null) : returnedSchedule;
        assert (returnedSchedule.getJobGroup() != null) : returnedSchedule;
        assert (returnedSchedule.getDescription().equals(PREFIX + "desc"));
        assert (returnedSchedule.getOperationName().equals(PREFIX + "testOp"));
        assert (returnedSchedule.getParameters() != null);
        assert (returnedSchedule.getGroup().getId() == group.getId());
        System.out.println("WAITING FOR 4.5s FOR THE SCHEDULED OPERATION TO FINISH");
        Thread.sleep(4500L);
        PageList resultsHist = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (resultsHist != null);
        assert (resultsHist.size() == 1);
        ResourceOperationHistory history = (ResourceOperationHistory)resultsHist.get(0);
        assert (history.getId() > 0) : history;
        assert (history.getJobId() != null) : history;
        assert (history.getJobName() != null) : history;
        assert (history.getJobGroup() != null) : history;
        assert (history.getErrorMessage() == null) : history;
        assert (history.getStatus() == OperationRequestStatus.SUCCESS) : history;
        assert (history.getSubjectName().equals(this.overlord().getName())) : history;
        PageList list = this.operationManager.findRecentlyCompletedResourceOperations(this.overlord(), null, PageControl.getUnlimitedInstance());
        assert (list.size() == 1);
        assert (((ResourceOperationLastCompletedComposite)list.get(0)).getOperationHistoryId() == history.getId());
        assert (((ResourceOperationLastCompletedComposite)list.get(0)).getResourceId() == resource.getId());
        assert (((ResourceOperationLastCompletedComposite)list.get(0)).getResourceName().equals(resource.getName()));
        assert (((ResourceOperationLastCompletedComposite)list.get(0)).getOperationName().equals("Test Operation"));
        this.operationManager.deleteOperationHistory(this.overlord(), history.getId(), false);
        resultsHist = this.operationManager.findCompletedResourceOperationHistories(this.overlord(), resource.getId(), null, null, PageControl.getUnlimitedInstance());
        assert (resultsHist != null);
        assert (resultsHist.size() == 0);
        list = this.operationManager.findRecentlyCompletedResourceOperations(this.overlord(), null, PageControl.getUnlimitedInstance());
        assert (list.size() == 0);
    }

    private Resource createNewResource() throws Exception {
        Resource resource;
        this.getTransactionManager().begin();
        try {
            ResourceType resourceType = new ResourceType(PREFIX + "platformType", PREFIX + "plugin", ResourceCategory.PLATFORM, null);
            OperationDefinition def = new OperationDefinition(resourceType, PREFIX + "testOp");
            def.setTimeout(Integer.valueOf(10));
            def.setDisplayName("Test Operation");
            resourceType.addOperationDefinition(def);
            this.em.persist((Object)resourceType);
            Agent agent = new Agent(PREFIX + "agent", PREFIX + "address", 1, "", PREFIX + "token");
            this.em.persist((Object)agent);
            this.em.flush();
            resource = new Resource(PREFIX + "reskey", PREFIX + "resname", resourceType);
            resource.setUuid("" + new Random().nextInt());
            resource.setAgent(agent);
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
            this.em.persist((Object)resource);
            ResourceGroup group = new ResourceGroup(PREFIX + "groupOMB" + System.currentTimeMillis(), resourceType);
            this.em.persist((Object)group);
            group.addExplicitResource(resource);
            this.em.flush();
        }
        catch (Exception e) {
            System.out.println("CANNOT PREPARE TEST: " + e);
            this.getTransactionManager().rollback();
            throw e;
        }
        this.getTransactionManager().commit();
        return resource;
    }

    private void deleteNewResource(Resource resource) throws Exception {
        if (null != resource) {
            try {
                ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
                ResourceGroupManagerLocal resourceGroupManager = LookupUtil.getResourceGroupManager();
                this.getTransactionManager().begin();
                this.em = this.getEntityManager();
                ResourceGroup group = null;
                Resource res = (Resource)this.em.find(Resource.class, (Object)resource.getId());
                if (null != res && res.getExplicitGroups().iterator().hasNext()) {
                    group = (ResourceGroup)res.getExplicitGroups().iterator().next();
                }
                this.getTransactionManager().commit();
                Subject overlord = this.overlord();
                if (null != group) {
                    resourceGroupManager.deleteResourceGroup(overlord, group.getId());
                }
                if (null != res) {
                    List deletedIds = resourceManager.uninventoryResource(overlord, res.getId());
                    for (Integer deletedResourceId : deletedIds) {
                        resourceManager.uninventoryResourceAsyncWork(overlord, deletedResourceId.intValue());
                    }
                }
                this.getTransactionManager().begin();
                this.em = this.getEntityManager();
                ResourceType type = (ResourceType)this.em.find(ResourceType.class, (Object)resource.getResourceType().getId());
                Agent agent = (Agent)this.em.find(Agent.class, (Object)resource.getAgent().getId());
                if (null != agent) {
                    this.em.remove((Object)agent);
                }
                if (null != type) {
                    this.em.remove((Object)type);
                }
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                try {
                    System.out.println("CANNOT CLEAN UP TEST (" + ((Object)((Object)this)).getClass().getSimpleName() + ") Cause: " + e);
                    this.getTransactionManager().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class TestConfigService
    implements OperationAgentService {
        private TestConfigService() {
        }

        public void invokeOperation(final String jobId, int resourceId, final String operationName, final Configuration paramConfig) throws PluginContainerException {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        System.out.println("~~~~~OPERATION TRIGGERED! op=" + operationName + ", jobId=" + jobId + ", time=" + new Date());
                        long start = System.currentTimeMillis();
                        if (OperationManagerBeanTest.this.simulatedOperation_Sleep > 0L) {
                            Thread.sleep(OperationManagerBeanTest.this.simulatedOperation_Sleep);
                        }
                        long end = System.currentTimeMillis();
                        if (OperationManagerBeanTest.this.simulatedOperation_Error != null) {
                            ExceptionPackage error = new ExceptionPackage((Throwable)new Exception(OperationManagerBeanTest.this.simulatedOperation_Error));
                            if (OperationManagerBeanTest.this.operationServerService != null) {
                                OperationManagerBeanTest.this.operationServerService.operationFailed(jobId, null, error, start, end);
                            }
                        } else if (OperationManagerBeanTest.this.simulatedOperation_Timeout) {
                            if (OperationManagerBeanTest.this.operationServerService != null) {
                                OperationManagerBeanTest.this.operationServerService.operationTimedOut(jobId, start, end);
                            }
                        } else {
                            Configuration results = null;
                            if (paramConfig != null && paramConfig.getSimple("param1") != null) {
                                results = new Configuration();
                                results.put((Property)new PropertySimple("param1echo", (Object)paramConfig.getSimple("param1").getStringValue()));
                            }
                            if (OperationManagerBeanTest.this.operationServerService != null) {
                                OperationManagerBeanTest.this.operationServerService.operationSucceeded(jobId, results, start, end);
                            }
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        throw new RuntimeException(t);
                    }
                }
            };
            thread.start();
        }

        public CancelResults cancelOperation(String jobId) {
            return OperationManagerBeanTest.this.simulatedOperation_CancelResults;
        }
    }
}

