/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.performance.test;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3PerformanceTest;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.helpers.perftest.support.reporting.ExcelExporter;
import org.rhq.helpers.perftest.support.testng.DatabaseSetupInterceptor;
import org.rhq.helpers.perftest.support.testng.DatabaseState;
import org.rhq.helpers.perftest.support.testng.PerformanceReporting;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Test(groups={"PERF"})
@Listeners(value={DatabaseSetupInterceptor.class})
@PerformanceReporting(exporter=ExcelExporter.class)
@DatabaseState(url="perftest/AvailabilityInsertPurgeTest-testOne-data.xml.zip", dbVersion="2.125")
public class AvailabilityInsertPurgeTest
extends AbstractEJB3PerformanceTest {
    ResourceManagerLocal resourceManager;
    AvailabilityManagerLocal availabilityManager;
    AgentManagerLocal agentManager;
    SystemManagerLocal systemManager;
    AlertDefinitionManagerLocal alertDefinitionManager;
    private static final int MILLIS_APART = 2000;
    private static final String ROUND__FORMAT = "Round %6d";
    private static final String PURGE__FORMAT = "Purge %6d";
    private static final int[] ROUNDS = new int[]{1000, 2000, 3000, 5000, 10000};

    @Override
    protected void beforeMethod(Method method) {
        super.setupTimings(method);
        Date now = new Date();
        try {
            this.availabilityManager = LookupUtil.getAvailabilityManager();
            this.resourceManager = LookupUtil.getResourceManager();
            this.agentManager = LookupUtil.getAgentManager();
            this.systemManager = LookupUtil.getSystemManager();
            this.alertDefinitionManager = LookupUtil.getAlertDefinitionManager();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.flush();
            throw new RuntimeException(t);
        }
    }

    public void testAlternating() throws Exception {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Date now = new Date();
        Query q = this.em.createQuery("SELECT r FROM Resource r");
        List resources = q.getResultList();
        Resource res = (Resource)resources.get(0);
        Agent agent = this.agentManager.getAgentByResourceId(overlord, res.getId());
        q = this.em.createQuery("SELECT COUNT(a) FROM Availability a ");
        Object o = q.getSingleResult();
        Long l = (Long)o;
        if (l != 0L) {
            throw new IllegalStateException("Availabilities table is not empty");
        }
        this.systemManager.vacuum(overlord, new String[]{"rhq_availability"});
        for (int MULTI : ROUNDS) {
            String round = String.format(ROUND__FORMAT, MULTI);
            long t1 = System.currentTimeMillis() - (long)(MULTI * 2000);
            for (int i = 0; i < MULTI; ++i) {
                AvailabilityReport report = new AvailabilityReport(agent.getName());
                for (Resource r : resources) {
                    AvailabilityType at = i % 2 == 0 ? AvailabilityType.UP : AvailabilityType.DOWN;
                    Availability a = new Availability(r, Long.valueOf(t1 + (long)(i * 2000)), at);
                    report.addAvailability(a);
                }
                this.startTiming(round);
                this.availabilityManager.mergeAvailabilityReport(report);
                this.endTiming(round);
            }
            this.startTiming(String.format(PURGE__FORMAT, MULTI));
            this.availabilityManager.purgeAvailabilities(t1 + (long)(MULTI / 2 * 2000));
            this.endTiming(String.format(PURGE__FORMAT, MULTI));
            this.startTiming(String.format(PURGE__FORMAT, MULTI));
            this.availabilityManager.purgeAvailabilities(t1);
            this.endTiming(String.format(PURGE__FORMAT, MULTI));
            overlord = LookupUtil.getSubjectManager().getOverlord();
            this.systemManager.vacuum(overlord, new String[]{"rhq_availability"});
        }
        long timing1000 = this.getTiming(String.format(ROUND__FORMAT, 1000));
        long timing2000 = this.getTiming(String.format(ROUND__FORMAT, 2000));
        long timing3000 = this.getTiming(String.format(ROUND__FORMAT, 3000));
        long timing5000 = this.getTiming(String.format(ROUND__FORMAT, 5000));
        long timing10000 = this.getTiming(String.format(ROUND__FORMAT, 10000));
        this.assertLinear(timing1000, timing2000, 2.0, "Merge2");
        this.assertLinear(timing1000, timing3000, 3.0, "Merge3");
        this.assertLinear(timing1000, timing5000, 5.0, "Merge5");
        this.assertLinear(timing1000, timing10000, 10.0, "Merge10");
        long purge1000 = this.getTiming(String.format(PURGE__FORMAT, 1000));
        long purge2000 = this.getTiming(String.format(PURGE__FORMAT, 2000));
        long purge3000 = this.getTiming(String.format(PURGE__FORMAT, 3000));
        long purge5000 = this.getTiming(String.format(PURGE__FORMAT, 5000));
        this.assertLinear(purge1000, purge2000, 2.0, "Purge2");
        this.assertLinear(purge1000, purge3000, 3.0, "Purge3");
        this.assertLinear(purge1000, purge5000, 5.0, "Purge3");
    }

    public void testRandom() throws Exception {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Query q = this.em.createQuery("SELECT r FROM Resource r");
        List resources = q.getResultList();
        Resource res = (Resource)resources.get(0);
        Agent agent = this.agentManager.getAgentByResourceId(overlord, res.getId());
        for (int MULTI : ROUNDS) {
            String round = String.format(ROUND__FORMAT, MULTI);
            long t1 = System.currentTimeMillis() - (long)(MULTI * 2000);
            for (int i = 0; i < MULTI; ++i) {
                AvailabilityReport report = new AvailabilityReport(agent.getName());
                for (Resource r : resources) {
                    int rand = (int)(Math.random() * 2.0);
                    AvailabilityType at = rand == 1 ? AvailabilityType.UP : AvailabilityType.DOWN;
                    Availability a = new Availability(r, Long.valueOf(t1 + (long)(i * 2000)), at);
                    report.addAvailability(a);
                }
                this.startTiming(round);
                this.availabilityManager.mergeAvailabilityReport(report);
                this.endTiming(round);
            }
            this.startTiming(String.format(PURGE__FORMAT, MULTI));
            this.availabilityManager.purgeAvailabilities(t1 + (long)(MULTI / 2 * 2000));
            this.endTiming(String.format(PURGE__FORMAT, MULTI));
            this.startTiming(String.format(PURGE__FORMAT, MULTI));
            this.availabilityManager.purgeAvailabilities(t1);
            this.endTiming(String.format(PURGE__FORMAT, MULTI));
            overlord = LookupUtil.getSubjectManager().getOverlord();
            this.systemManager.vacuum(overlord, new String[]{"rhq_availability"});
        }
        long timing1000 = this.getTiming(String.format(ROUND__FORMAT, 1000));
        long timing2000 = this.getTiming(String.format(ROUND__FORMAT, 2000));
        long timing3000 = this.getTiming(String.format(ROUND__FORMAT, 3000));
        long timing5000 = this.getTiming(String.format(ROUND__FORMAT, 5000));
        long timing10000 = this.getTiming(String.format(ROUND__FORMAT, 10000));
        this.assertLinear(timing1000, timing2000, 2.0, "Merge2");
        this.assertLinear(timing1000, timing3000, 3.0, "Merge3");
        this.assertLinear(timing1000, timing5000, 5.0, "Merge5");
        this.assertLinear(timing1000, timing10000, 10.0, "Merge10");
        long purge1000 = this.getTiming(String.format(PURGE__FORMAT, 1000));
        long purge2000 = this.getTiming(String.format(PURGE__FORMAT, 2000));
        long purge3000 = this.getTiming(String.format(PURGE__FORMAT, 3000));
        long purge5000 = this.getTiming(String.format(PURGE__FORMAT, 5000));
        this.assertLinear(purge1000, purge2000, 2.0, "Purge2");
        this.assertLinear(purge1000, purge3000, 3.0, "Purge3");
        this.assertLinear(purge1000, purge5000, 5.0, "Purge3");
    }

    public void testAlwaysUp() throws Exception {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Query q = this.em.createQuery("SELECT r FROM Resource r");
        List resources = q.getResultList();
        Resource res = (Resource)resources.get(0);
        Agent agent = this.agentManager.getAgentByResourceId(overlord, res.getId());
        for (int MULTI : ROUNDS) {
            String round = String.format(ROUND__FORMAT, MULTI);
            long t1 = System.currentTimeMillis() - (long)(MULTI * 2000);
            for (int i = 0; i < MULTI; ++i) {
                AvailabilityReport report = new AvailabilityReport(agent.getName());
                for (Resource r : resources) {
                    AvailabilityType at = AvailabilityType.UP;
                    Availability a = new Availability(r, Long.valueOf(t1 + (long)(i * 2000)), at);
                    report.addAvailability(a);
                }
                this.startTiming(round);
                this.availabilityManager.mergeAvailabilityReport(report);
                this.endTiming(round);
            }
            this.startTiming(String.format(PURGE__FORMAT, MULTI));
            this.availabilityManager.purgeAvailabilities(t1 + (long)(MULTI / 2 * 2000));
            this.endTiming(String.format(PURGE__FORMAT, MULTI));
            this.startTiming(String.format(PURGE__FORMAT, MULTI));
            this.availabilityManager.purgeAvailabilities(t1);
            this.endTiming(String.format(PURGE__FORMAT, MULTI));
            overlord = LookupUtil.getSubjectManager().getOverlord();
            this.systemManager.vacuum(overlord, new String[]{"rhq_availability"});
        }
        long timing1000 = this.getTiming(String.format(ROUND__FORMAT, 1000));
        long timing2000 = this.getTiming(String.format(ROUND__FORMAT, 2000));
        long timing3000 = this.getTiming(String.format(ROUND__FORMAT, 3000));
        long timing5000 = this.getTiming(String.format(ROUND__FORMAT, 5000));
        long timing10000 = this.getTiming(String.format(ROUND__FORMAT, 10000));
        this.assertLinear(timing1000, timing2000, 2.0, "Merge2");
        this.assertLinear(timing1000, timing3000, 3.0, "Merge3");
        this.assertLinear(timing1000, timing5000, 5.0, "Merge5");
        this.assertLinear(timing1000, timing10000, 10.0, "Merge10");
        long purge1000 = this.getTiming(String.format(PURGE__FORMAT, 1000));
        long purge2000 = this.getTiming(String.format(PURGE__FORMAT, 2000));
        long purge3000 = this.getTiming(String.format(PURGE__FORMAT, 3000));
        long purge5000 = this.getTiming(String.format(PURGE__FORMAT, 5000));
        this.assertLinear(purge1000, purge2000, 2.0, "Purge2");
        this.assertLinear(purge1000, purge3000, 3.0, "Purge3");
        this.assertLinear(purge1000, purge5000, 5.0, "Purge3");
    }

    public void testAlternatingWithAlert() throws Exception {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Query q = this.em.createQuery("SELECT r FROM Resource r");
        List resources = q.getResultList();
        Resource res = (Resource)resources.get(0);
        Agent agent = this.agentManager.getAgentByResourceId(overlord, res.getId());
        q = this.em.createQuery("SELECT COUNT(a) FROM Availability a ");
        Object o = q.getSingleResult();
        Long l = (Long)o;
        if (l != 0L) {
            throw new IllegalStateException("Availabilities table is not empty");
        }
        this.systemManager.vacuum(overlord, new String[]{"rhq_availability"});
        AlertCondition goingDown = new AlertCondition();
        goingDown.setCategory(AlertConditionCategory.AVAILABILITY);
        goingDown.setComparator("==");
        goingDown.setOption(AvailabilityType.DOWN.toString());
        AlertDefinition def = new AlertDefinition();
        def.addCondition(goingDown);
        def.setName("Test alert definition");
        def.setPriority(AlertPriority.MEDIUM);
        def.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        def.setRecoveryId(Integer.valueOf(0));
        this.alertDefinitionManager.createAlertDefinitionInNewTransaction(overlord, def, Integer.valueOf(res.getId()), true);
        for (int MULTI : ROUNDS) {
            String round = String.format(ROUND__FORMAT, MULTI);
            long t1 = System.currentTimeMillis() - (long)(MULTI * 2000);
            for (int i = 0; i < MULTI; ++i) {
                AvailabilityReport report = new AvailabilityReport(agent.getName());
                for (Resource r : resources) {
                    AvailabilityType at = i % 2 == 0 ? AvailabilityType.UP : AvailabilityType.DOWN;
                    Availability a = new Availability(r, Long.valueOf(t1 + (long)(i * 2000)), at);
                    report.addAvailability(a);
                }
                this.startTiming(round);
                this.availabilityManager.mergeAvailabilityReport(report);
                this.endTiming(round);
            }
            this.startTiming(String.format(PURGE__FORMAT, MULTI));
            this.availabilityManager.purgeAvailabilities(t1 + (long)(MULTI / 2 * 2000));
            this.endTiming(String.format(PURGE__FORMAT, MULTI));
            this.startTiming(String.format(PURGE__FORMAT, MULTI));
            this.availabilityManager.purgeAvailabilities(t1);
            this.endTiming(String.format(PURGE__FORMAT, MULTI));
            overlord = LookupUtil.getSubjectManager().getOverlord();
            this.systemManager.vacuum(overlord, new String[]{"rhq_availability"});
        }
        long timing1000 = this.getTiming(String.format(ROUND__FORMAT, 1000));
        long timing2000 = this.getTiming(String.format(ROUND__FORMAT, 2000));
        long timing3000 = this.getTiming(String.format(ROUND__FORMAT, 3000));
        long timing5000 = this.getTiming(String.format(ROUND__FORMAT, 5000));
        long timing10000 = this.getTiming(String.format(ROUND__FORMAT, 10000));
        this.assertLinear(timing1000, timing2000, 2.0, "Merge2");
        this.assertLinear(timing1000, timing3000, 3.0, "Merge3");
        this.assertLinear(timing1000, timing5000, 5.0, "Merge5");
        this.assertLinear(timing1000, timing10000, 10.0, "Merge10");
        long purge1000 = this.getTiming(String.format(PURGE__FORMAT, 1000));
        long purge2000 = this.getTiming(String.format(PURGE__FORMAT, 2000));
        long purge3000 = this.getTiming(String.format(PURGE__FORMAT, 3000));
        long purge5000 = this.getTiming(String.format(PURGE__FORMAT, 5000));
        this.assertLinear(purge1000, purge2000, 2.0, "Purge2");
        this.assertLinear(purge1000, purge3000, 3.0, "Purge3");
        this.assertLinear(purge1000, purge5000, 5.0, "Purge3");
    }
}

