/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.performance.test;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3PerformanceTest;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.helpers.perftest.support.reporting.ExcelExporter;
import org.rhq.helpers.perftest.support.testng.DatabaseSetupInterceptor;
import org.rhq.helpers.perftest.support.testng.DatabaseState;
import org.rhq.helpers.perftest.support.testng.PerformanceReporting;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Test(groups={"PERF"})
@Listeners(value={DatabaseSetupInterceptor.class})
@PerformanceReporting(exporter=ExcelExporter.class)
@DatabaseState(url="perftest/AvailabilityInsertPurgeTest-testOne-data.xml.zip", dbVersion="2.125")
public class CallTimeInsertPurgeTest
extends AbstractEJB3PerformanceTest {
    private final Log log = LogFactory.getLog(CallTimeInsertPurgeTest.class);
    private static final int ROUNDS = 200;
    private static final int NUM_SOURCES = 10;
    private static final int LINES_PER_REPORT = 50;
    ResourceManagerLocal resourceManager;
    AvailabilityManagerLocal availabilityManager;
    AgentManagerLocal agentManager;
    SystemManagerLocal systemManager;
    AlertDefinitionManagerLocal alertDefinitionManager;
    MeasurementDataManagerLocal measurementDataManager;
    private static final int MILLIS_APART = 2000;
    private static final String ROUND__FORMAT = "Round %6d";
    private static final String PURGE__FORMAT = "Purge %6d";

    @Override
    protected void beforeMethod(Method method) {
        super.setupTimings(method);
        try {
            this.availabilityManager = LookupUtil.getAvailabilityManager();
            this.resourceManager = LookupUtil.getResourceManager();
            this.agentManager = LookupUtil.getAgentManager();
            this.systemManager = LookupUtil.getSystemManager();
            this.alertDefinitionManager = LookupUtil.getAlertDefinitionManager();
            this.measurementDataManager = LookupUtil.getMeasurementDataManager();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    public void testSimple() throws Exception {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Query q = this.em.createQuery("SELECT r FROM Resource r");
        List resources = q.getResultList();
        Resource res = (Resource)resources.get(0);
        if (res.getResourceType().getCategory() != ResourceCategory.PLATFORM) {
            res = this.resourceManager.getPlaformOfResource(overlord, res.getId());
        }
        ResourceType type = res.getResourceType();
        MeasurementDefinition def = null;
        Set definitions = type.getMetricDefinitions();
        for (MeasurementDefinition d : definitions) {
            if (!d.getName().equals("myCallTime")) continue;
            def = d;
        }
        MeasurementSchedule schedule = new MeasurementSchedule(def, res);
        MeasurementScheduleRequest request = new MeasurementScheduleRequest(schedule);
        for (int i = 0; i < 200; ++i) {
            CallTimeData data = new CallTimeData(request);
            MeasurementReport report = new MeasurementReport();
            for (int j = 0; j < 10; ++j) {
                data.addCallData("/foo/" + j, new Date(), (long)(10 - j));
            }
            report.addData(data);
            this.startTiming();
            this.measurementDataManager.mergeMeasurementReport(report);
            this.endTiming();
        }
    }
}

