/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.content;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.TransactionManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.core.domain.content.Distribution;
import org.rhq.core.domain.content.DownloadMode;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.DistributionManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetails;
import org.rhq.enterprise.server.plugin.pc.content.TestContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.TestContentServerPluginService;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

public class ContentProviderManagerSyncRepoTest
extends AbstractEJB3Test {
    private static final boolean TESTS_ENABLED = true;
    private TestContentServerPluginService pluginService;
    private TestContentProvider contentProvider1 = new TestContentProvider();
    private TestContentProvider contentProvider2 = new TestContentProvider();
    private ContentSourceType contentSourceType;
    private PackageType packageType;
    private ResourceType resourceType;
    private List<ContentSource> repoContentSources = new ArrayList<ContentSource>();
    private Repo repoToSync;

    @Override
    protected void beforeMethod() throws Exception {
        this.prepareScheduler();
        this.pluginService = new TestContentServerPluginService(this);
        TransactionManager tx = this.getTransactionManager();
        try {
            List packageTypes;
            ContentSource cs2;
            ContentSource cs1;
            tx.begin();
            EntityManager entityManager = this.getEntityManager();
            ContentManagerLocal contentManager = LookupUtil.getContentManager();
            ContentSourceManagerLocal contentSourceManager = LookupUtil.getContentSourceManager();
            RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
            ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            Subject overlord = subjectManager.getOverlord();
            this.contentSourceType = contentSourceManager.getContentSourceType("testType");
            if (null == this.contentSourceType) {
                this.contentSourceType = new ContentSourceType("testType");
                entityManager.persist((Object)this.contentSourceType);
                entityManager.flush();
            }
            if (null == (cs1 = contentSourceManager.getContentSourceByNameAndType(overlord, "contentSource1", "testType"))) {
                cs1 = new ContentSource("contentSource1", this.contentSourceType);
                cs1.setDownloadMode(DownloadMode.DATABASE);
                cs1 = contentSourceManager.simpleCreateContentSource(overlord, cs1);
            }
            if (null == (cs2 = contentSourceManager.getContentSourceByNameAndType(overlord, "contentSource2", "testType"))) {
                cs2 = new ContentSource("contentSource2", this.contentSourceType);
                cs2.setDownloadMode(DownloadMode.DATABASE);
                cs2 = contentSourceManager.simpleCreateContentSource(overlord, cs2);
            }
            this.pluginService.associateContentProvider(cs1, this.contentProvider1);
            this.pluginService.associateContentProvider(cs2, this.contentProvider2);
            this.repoContentSources.add(cs1);
            this.repoContentSources.add(cs2);
            this.resourceType = resourceTypeManager.getResourceTypeByNameAndPlugin("testContentProviderFakeResourceType", "testContentProviderFakeResourceTypePlugin");
            if (null == this.resourceType) {
                this.resourceType = new ResourceType("testContentProviderFakeResourceType", "testContentProviderFakeResourceTypePlugin", ResourceCategory.PLATFORM, null);
                entityManager.persist((Object)this.resourceType);
                entityManager.flush();
            }
            if (!(packageTypes = contentManager.findPackageTypes(overlord, "testContentProviderFakeResourceType", "testContentProviderFakeResourceTypePlugin")).isEmpty()) {
                this.packageType = (PackageType)packageTypes.get(0);
            } else {
                this.packageType = new PackageType("testContentProviderFakePackage", this.resourceType);
                entityManager.persist((Object)this.packageType);
            }
            List repos = repoManager.getRepoByName("testRepoImportedExisting");
            if (!repos.isEmpty()) {
                this.repoToSync = (Repo)repos.get(0);
            } else {
                Repo repo = new Repo("testRepoImportedExisting");
                repo.addContentSource(cs1);
                this.repoToSync = repoManager.createRepo(overlord, repo);
            }
            tx.commit();
        }
        catch (Throwable t) {
            tx.rollback();
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterMethod() throws Exception {
        try {
            Query query;
            TransactionManager tx = this.getTransactionManager();
            tx.begin();
            EntityManager entityManager = this.getEntityManager();
            ContentSourceManagerLocal contentSourceManagerLocal = LookupUtil.getContentSourceManager();
            RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
            DistributionManagerLocal distroManager = LookupUtil.getDistributionManagerLocal();
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            Subject overlord = subjectManager.getOverlord();
            distroManager.deleteDistributionMappingsForRepo(overlord, this.repoToSync.getId());
            for (String distroLabel : TestContentProvider.DISTRIBUTIONS.keySet()) {
                Distribution distro = distroManager.getDistributionByLabel(distroLabel);
                if (distro == null) continue;
                query = entityManager.createNamedQuery("DistributionFile.deleteByDistId");
                query.setParameter("distId", (Object)distro.getId());
                query.executeUpdate();
                distroManager.deleteDistributionByDistId(overlord, distro.getId());
            }
            for (ContentSource source : this.repoContentSources) {
                contentSourceManagerLocal.deleteContentSource(overlord, source.getId());
            }
            this.repoContentSources.clear();
            repoManager.deleteRepo(overlord, this.repoToSync.getId());
            for (ContentProviderPackageDetails details : TestContentProvider.PACKAGES.values()) {
                String packageName = details.getContentProviderPackageDetailsKey().getName();
                query = entityManager.createNamedQuery("Package.findByNameAndPkgTypeId");
                query.setParameter("name", (Object)packageName);
                query.setParameter("packageTypeId", (Object)this.packageType.getId());
                Package p = (Package)query.getSingleResult();
                entityManager.remove((Object)p);
            }
            this.packageType = (PackageType)entityManager.find(PackageType.class, (Object)this.packageType.getId());
            entityManager.remove((Object)this.packageType);
            this.resourceType = (ResourceType)entityManager.find(ResourceType.class, (Object)this.resourceType.getId());
            entityManager.remove((Object)this.resourceType);
            this.contentSourceType = (ContentSourceType)entityManager.find(ContentSourceType.class, (Object)this.contentSourceType.getId());
            entityManager.remove((Object)this.contentSourceType);
            tx.commit();
            this.contentProvider1.reset();
            this.contentProvider2.reset();
        }
        finally {
            this.unprepareServerPluginService();
            this.unprepareScheduler();
        }
    }

    @Test(enabled=true)
    public void synchronizeRepo() throws Exception {
        boolean completed = this.pluginService.getContentProviderManager().synchronizeRepo(this.repoToSync.getId());
        assert (completed);
        assert (this.contentProvider1.getLogSynchronizePackagesRepos().size() == 1) : "Expected: 1, Found: " + this.contentProvider1.getLogSynchronizePackagesRepos().size();
        assert (this.contentProvider1.getLogGetInputStreamLocations().size() == TestContentProvider.PACKAGE_COUNT_FOR_BITS) : "Expected: " + TestContentProvider.PACKAGE_COUNT_FOR_BITS + ", Found: " + this.contentProvider1.getLogGetInputStreamLocations().size();
        TransactionManager tx = this.getTransactionManager();
        tx.begin();
        EntityManager entityManager = this.getEntityManager();
        Query query = entityManager.createNamedQuery("PackageVersion.findByRepoId");
        query.setParameter("repoId", (Object)this.repoToSync.getId());
        List repoPackages = query.getResultList();
        assert (repoPackages.size() == TestContentProvider.PACKAGES.size()) : "Expected: " + TestContentProvider.PACKAGES.size() + ", Found: " + repoPackages.size();
        query = entityManager.createNamedQuery("RepoDistribution.queryFindByRepoId");
        query.setParameter("repoId", (Object)this.repoToSync.getId());
        List repoDistributions = query.getResultList();
        assert (repoDistributions.size() == TestContentProvider.DISTRIBUTIONS.size()) : "Expected: " + TestContentProvider.DISTRIBUTIONS.size() + ", Found: " + repoDistributions.size();
        int distro1FileCount = this.countDistroFiles(entityManager, "distribution1");
        assert (distro1FileCount == 2) : "Expected: 2, Found: " + distro1FileCount;
        int distro2FileCount = this.countDistroFiles(entityManager, "distribution2");
        assert (distro2FileCount == 1) : "Expected: 1, Found: " + distro1FileCount;
        tx.rollback();
    }

    private int countDistroFiles(EntityManager entityManager, String label) {
        Query query = entityManager.createNamedQuery("Distribution.findByDistLabel");
        query.setParameter("label", (Object)label);
        Distribution distro = (Distribution)query.getSingleResult();
        query = entityManager.createNamedQuery("DistributionFile.selectByDistId");
        query.setParameter("distId", (Object)distro.getId());
        List distroFiles = query.getResultList();
        if (distroFiles == null) {
            return 0;
        }
        return distroFiles.size();
    }
}

