/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.content;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.enterprise.server.plugin.pc.AbstractTypeServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainerConfiguration;
import org.rhq.enterprise.server.plugin.pc.ServerPluginService;
import org.rhq.enterprise.server.plugin.pc.content.ContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderManager;
import org.rhq.enterprise.server.plugin.pc.content.ContentServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.content.ContentServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.content.TestContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.TestContentServerPluginServiceMBean;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginDescriptorType;

public class TestContentServerPluginService
extends ServerPluginService
implements TestContentServerPluginServiceMBean {
    private TestContentProviderManager contentProviderManager;
    private Map<Integer, ContentProvider> providers = new HashMap<Integer, ContentProvider>();
    private TestContentProvider defaultTestContentProvider;
    private File tmpdir;

    public TestContentServerPluginService(AbstractEJB3Test testContainer) {
        this.tmpdir = testContainer.getTempDir();
        testContainer.prepareCustomServerPluginService(this);
        this.startMasterPluginContainer();
        this.defaultTestContentProvider = new TestContentProvider();
    }

    public TestContentProviderManager getContentProviderManager() {
        return this.contentProviderManager;
    }

    public void associateContentProvider(ContentSource source, ContentProvider provider) {
        this.providers.put(source.getId(), provider);
    }

    protected MasterServerPluginContainer createMasterPluginContainer() {
        TestMasterServerPluginContainer master = new TestMasterServerPluginContainer();
        MasterServerPluginContainerConfiguration config = new MasterServerPluginContainerConfiguration(this.tmpdir, this.tmpdir, this.tmpdir, null);
        master.initialize(config);
        return master;
    }

    public class TestContentProviderManager
    extends ContentProviderManager {
        public ContentProvider getIsolatedContentProvider(int contentProviderId) throws RuntimeException {
            return this.getContentProvider(contentProviderId);
        }

        protected ContentProvider getIsolatedContentSourceAdapter(ContentSource contentSource) throws RuntimeException {
            return this.getContentProvider(contentSource.getId());
        }

        protected ContentProvider instantiateAdapter(ContentSource contentSource) {
            return this.getContentProvider(contentSource.getId());
        }

        private ContentProvider getContentProvider(int contentSourceId) {
            if (TestContentServerPluginService.this.providers.size() == 0) {
                return TestContentServerPluginService.this.defaultTestContentProvider;
            }
            return (ContentProvider)TestContentServerPluginService.this.providers.get(contentSourceId);
        }
    }

    private class TestContentProviderPluginManager
    extends ContentServerPluginManager {
        public TestContentProviderPluginManager(ContentServerPluginContainer pc) {
            super(pc);
        }
    }

    private class TestContentServerPluginContainer
    extends ContentServerPluginContainer {
        public TestContentServerPluginContainer(MasterServerPluginContainer master) {
            super(master);
        }

        protected ContentProviderManager createAdapterManager() {
            TestContentServerPluginService.this.contentProviderManager = new TestContentProviderManager();
            return TestContentServerPluginService.this.contentProviderManager;
        }

        protected ContentServerPluginManager createPluginManager() {
            TestContentProviderPluginManager pm = new TestContentProviderPluginManager(this);
            return pm;
        }
    }

    private class TestMasterServerPluginContainer
    extends MasterServerPluginContainer {
        private TestMasterServerPluginContainer() {
        }

        protected List<AbstractTypeServerPluginContainer> createPluginContainers() {
            ArrayList<AbstractTypeServerPluginContainer> pcs = new ArrayList<AbstractTypeServerPluginContainer>(1);
            pcs.add((AbstractTypeServerPluginContainer)new TestContentServerPluginContainer(this));
            return pcs;
        }

        protected ClassLoader createRootServerPluginClassLoader() {
            return ((Object)((Object)this)).getClass().getClassLoader();
        }

        protected Map<URL, ? extends ServerPluginDescriptorType> preloadAllPlugins() throws Exception {
            return new HashMap();
        }
    }
}

