/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.generic;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.core.domain.plugin.PluginStatusType;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.plugin.ServerPluginsLocal;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainerConfiguration;
import org.rhq.enterprise.server.plugin.pc.ServerPluginType;
import org.rhq.enterprise.server.plugin.pc.generic.TestGenericServerPluginService;
import org.rhq.enterprise.server.plugin.pc.generic.TestLifecycleListener;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginDescriptorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.generic.GenericPluginDescriptorType;
import org.testng.annotations.Test;

@Test
public class GenericServerPluginTest
extends AbstractEJB3Test {
    private TestGenericServerPluginService pluginService;

    @Override
    protected void beforeMethod() throws Exception {
        this.pluginService = new TestGenericServerPluginService(this.getTempDir());
        this.deleteAllTestPluginJars();
        this.prepareCustomServerPluginService(this.pluginService);
    }

    @Override
    protected void afterMethod() throws Exception {
        this.unprepareServerPluginService();
        this.deleteAllTestPluginJars();
        this.pluginService = null;
    }

    public void testSimpleGenericPlugin() throws Exception {
        this.createPluginJar("testSimpleGenericPlugin.jar", "serverplugins/simple-generic-serverplugin.xml");
        this.pluginService.startMasterPluginContainer();
        TestGenericServerPluginService.TestGenericServerPluginContainer pc = this.pluginService.genericPC;
        assert (pc.state == TestGenericServerPluginService.State.STARTED);
        TestGenericServerPluginService.TestGenericPluginManager pm = (TestGenericServerPluginService.TestGenericPluginManager)pc.getPluginManager();
        TestLifecycleListener component = (TestLifecycleListener)pm.components.values().iterator().next();
        assert (component.state == TestLifecycleListener.LifecycleState.STARTED);
        Configuration config = component.context.getPluginConfiguration();
        assert (config != null);
        assert (config.getSimple("plugin-simple-prop-1") != null);
        List schedules = component.context.getSchedules();
        assert (schedules == null);
        this.pluginService.stopMasterPluginContainer();
        assert (pc.state == TestGenericServerPluginService.State.UNINITIALIZED);
        assert (component.state == TestLifecycleListener.LifecycleState.UNINITIALIZED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetInstalledPlugins() throws Exception {
        boolean got_it;
        List pluginKeys;
        Map map;
        File jar = this.createPluginJar("testSimpleGenericPlugin.jar", "serverplugins/simple-generic-serverplugin.xml");
        ServerPluginType type = new ServerPluginType(GenericPluginDescriptorType.class);
        ServerPluginDescriptorType descriptor = ServerPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)jar.toURI().toURL());
        ServerPlugin plugin = new ServerPlugin(0, descriptor.getName(), jar.getName(), descriptor.getDisplayName(), true, PluginStatusType.INSTALLED, descriptor.getDescription(), null, MessageDigestGenerator.getDigestString((File)jar), descriptor.getVersion(), descriptor.getApiVersion(), null, null, type.stringify(), System.currentTimeMillis(), System.currentTimeMillis());
        ServerPluginsLocal serverPluginsLocal = LookupUtil.getServerPlugins();
        Map original = serverPluginsLocal.getInstalledServerPluginsGroupedByType();
        serverPluginsLocal.registerServerPlugin(LookupUtil.getSubjectManager().getOverlord(), plugin, jar);
        try {
            map = serverPluginsLocal.getInstalledServerPluginsGroupedByType();
            pluginKeys = (List)map.get(type);
            if (original.containsKey(type)) {
                assert (map.size() == original.size());
                assert (pluginKeys.size() == ((List)original.get(type)).size() + 1);
            } else {
                assert (map.size() == original.size() + 1);
                assert (pluginKeys.size() == 1);
            }
            got_it = false;
            for (PluginKey pluginKey : pluginKeys) {
                if (!pluginKey.getPluginName().equals("TestSimpleGenericPlugin")) continue;
                got_it = true;
                break;
            }
            assert (got_it);
        }
        finally {
            serverPluginsLocal.purgeServerPlugin(plugin.getId());
        }
        map = serverPluginsLocal.getInstalledServerPluginsGroupedByType();
        pluginKeys = (List)map.get(type);
        assert (map.size() == original.size());
        if (pluginKeys == null) {
            assert (!original.containsKey(type)) : "we dont have any plugins of this type, neither should original";
        } else {
            assert (pluginKeys.size() == ((List)original.get(type)).size());
            got_it = false;
            for (PluginKey pluginKey : pluginKeys) {
                if (!pluginKey.getPluginName().equals("TestSimpleGenericPlugin")) continue;
                got_it = true;
                break;
            }
            assert (!got_it) : "we still have the plugin, but it should have been purged";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createPluginJar(String jarName, String descriptorXmlFilename) throws Exception {
        FileOutputStream stream = null;
        ZipOutputStream out = null;
        InputStream in = null;
        try {
            this.pluginService.masterConfig.getPluginDirectory().mkdirs();
            File jarFile = new File(this.pluginService.masterConfig.getPluginDirectory(), jarName);
            stream = new FileOutputStream(jarFile);
            out = new JarOutputStream(stream);
            JarEntry jarAdd = new JarEntry("META-INF/rhq-serverplugin.xml");
            jarAdd.setTime(System.currentTimeMillis());
            ((JarOutputStream)out).putNextEntry(jarAdd);
            in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(descriptorXmlFilename);
            StreamUtil.copy((InputStream)in, (OutputStream)out, (boolean)false);
            File file = jarFile;
            return file;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    private void deleteAllTestPluginJars() {
        if (this.pluginService == null) {
            System.err.println("Plugin service was null !!");
            return;
        }
        MasterServerPluginContainerConfiguration masterConfig = this.pluginService.masterConfig;
        if (masterConfig == null) {
            return;
        }
        File pluginDirectory = masterConfig.getPluginDirectory();
        File[] files = pluginDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".jar")) continue;
                file.delete();
            }
        }
    }
}

