/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.persistence.Query;
import javax.transaction.TransactionManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.bundle.BundleManagerLocal;
import org.rhq.enterprise.server.core.CoreServer;
import org.rhq.enterprise.server.core.CoreServerMBean;
import org.rhq.enterprise.server.core.plugin.PluginDeploymentScanner;
import org.rhq.enterprise.server.core.plugin.PluginDeploymentScannerMBean;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ServerPluginService;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestAgentClient;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

public class RecipeValidationTest
extends AbstractEJB3Test {
    public static final String ITESTS = "itests";
    private static final String ENTITY_NAME_PREFIX = "recipeValidationTest";
    private static final String FAKE_RESOURCE_TYPE_NAME = "recipeValidationTest-antbundle-resourcetype";
    private static final String ANT_BUNDLE_TYPE_NAME = "Ant Bundle";
    private TestServerCommunicationsService agentServiceContainer;
    private MasterServerPluginContainer pc;
    private ServerPluginService ps;
    private BundleManagerLocal bundleManager;
    private File serverPluginsDir;

    @Override
    protected void beforeMethod() throws Exception {
        this.cleanupDatabase();
        this.bundleManager = LookupUtil.getBundleManager();
        this.createAntBundleType();
        this.prepareCustomServerService((Object)new CoreServer(), CoreServerMBean.OBJECT_NAME);
        this.prepareCustomServerService((Object)new PluginDeploymentScanner(), PluginDeploymentScannerMBean.OBJECT_NAME);
        this.prepareCustomServerPluginService(new ServerPluginService());
        this.agentServiceContainer = this.prepareForTestAgents();
        this.agentServiceContainer.bundleService = new TestAgentClient(null, this.agentServiceContainer);
        this.ps = new ServerPluginService();
        this.serverPluginsDir = this.ps.getServerPluginsDirectory();
        this.serverPluginsDir.mkdirs();
        File agentPluginsDir = new File(this.serverPluginsDir.getParentFile(), "agentplugins");
        agentPluginsDir.mkdirs();
        File antBundlePlugin = new File(System.getProperty("rhq.ant-bundle.serverplugin.path"));
        PluginDeploymentScannerMBean scanner = LookupUtil.getPluginDeploymentScanner();
        this.prepareScheduler();
        File targetFile = new File(this.serverPluginsDir, antBundlePlugin.getName());
        targetFile.setLastModified(System.currentTimeMillis());
        FileUtil.copyFile((File)antBundlePlugin, (File)targetFile);
        scanner.setAgentPluginDir(agentPluginsDir.getAbsolutePath());
        scanner.setServerPluginDir(this.serverPluginsDir.getAbsolutePath());
        this.prepareCustomServerPluginService(this.ps);
        this.ps.startMasterPluginContainer();
        LookupUtil.getPluginDeploymentScanner().startDeployment();
        LookupUtil.getPluginDeploymentScanner().scanAndRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterMethod() throws Exception {
        FileUtil.purge((File)this.serverPluginsDir.getParentFile(), (boolean)true);
        this.unprepareForTestAgents();
        this.unprepareScheduler();
        try {
            this.cleanupDatabase();
        }
        finally {
            this.unprepareServerPluginService();
            this.unprepareCustomServerService(CoreServerMBean.OBJECT_NAME);
            this.unprepareCustomServerService(PluginDeploymentScannerMBean.OBJECT_NAME);
        }
    }

    private void cleanupDatabase() throws Exception {
        try {
            this.getTransactionManager().begin();
            Query q = this.em.createQuery("SELECT rt FROM ResourceType rt WHERE rt.deleted = false and rt.name = 'recipeValidationTest-antbundle-resourcetype'");
            List doomed = q.getResultList();
            for (Object removeMe : doomed) {
                this.em.remove(this.em.getReference(ResourceType.class, (Object)((ResourceType)removeMe).getId()));
            }
            this.em.flush();
            q = this.em.createQuery("SELECT bt FROM BundleType bt WHERE bt.name = 'Ant Bundle'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                this.em.remove(this.em.getReference(BundleType.class, (Object)((BundleType)removeMe).getId()));
            }
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            try {
                System.out.println("CANNOT CLEAN UP TEST: Cause: " + e);
                this.getTransactionManager().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"itests"})
    public void testManageRootDirMandatoryOnBundleVersionCreation() throws Exception {
        File root = FileUtil.createTempDirectory((String)((Object)((Object)this)).getClass().getName(), null, null);
        this.copyFromClasspath("recipe-no-manageRootDir.xml", "deploy.xml", root);
        File bundleZip = this.createDistributionZip(root);
        try {
            this.bundleManager.createBundleVersionViaURL(this.getFreshOverlord(), bundleZip.toURI().toURL().toString());
            this.fail("A recipe without explicit managerRootDir should not have been created");
        }
        catch (Exception e) {
            this.checkForExpectedException(e, "org.rhq.bundle.ant.InvalidBuildFileException", "The deployment unit must specifically declare compliance mode of the destination directory.");
        }
        finally {
            FileUtil.purge((File)root, (boolean)true);
        }
    }

    @Test(groups={"itests"})
    public void testManageRootDirAbsenceToleratedDuringUpdate() {
    }

    @Test(groups={"itests"})
    public void testManageRootDirAbsenceToleratedDuringRevert() {
    }

    private Subject getFreshOverlord() {
        return LookupUtil.getSubjectManager().getOverlord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createDistributionZip(File root) throws IOException {
        File ret = File.createTempFile(((Object)((Object)this)).getClass().getName(), "zip");
        ZipOutputStream distribFile = new ZipOutputStream(new FileOutputStream(ret));
        for (File f : RecipeValidationTest.getAllFilesRelativeToRoot(root, root)) {
            distribFile.putNextEntry(new ZipEntry(f.getPath()));
            File resultFile = new File(root, f.getPath());
            FileInputStream in = new FileInputStream(resultFile);
            try {
                StreamUtil.copy((InputStream)in, (OutputStream)distribFile, (boolean)false);
            }
            finally {
                in.close();
            }
            distribFile.closeEntry();
        }
        distribFile.close();
        return ret;
    }

    private static Set<File> getAllFilesRelativeToRoot(File parent, File root) {
        HashSet<File> ret = new HashSet<File>();
        RecipeValidationTest.getAllFilesRelativeToRoot(parent, root, ret);
        return ret;
    }

    private static void getAllFilesRelativeToRoot(File parent, File root, Set<File> out) {
        for (File f : parent.listFiles()) {
            if (f.isDirectory()) {
                RecipeValidationTest.getAllFilesRelativeToRoot(f, root, out);
                continue;
            }
            String path = FileUtil.getRelativePath((File)f, (File)root).substring(2);
            out.add(new File(path));
        }
    }

    private void copyFromClasspath(String resourceUrl, String filename, File target) throws FileNotFoundException, URISyntaxException {
        target.getParentFile().mkdirs();
        InputStream content = ((Object)((Object)this)).getClass().getResourceAsStream(resourceUrl);
        FileOutputStream out = new FileOutputStream(new File(target, filename));
        StreamUtil.copy((InputStream)content, (OutputStream)out, (boolean)true);
    }

    private void createAntBundleType() throws Exception {
        ResourceType rt = this.createResourceTypeForBundleType();
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        BundleType bt = this.bundleManager.createBundleType(overlord, ANT_BUNDLE_TYPE_NAME, rt.getId());
        assert (bt.getId() > 0);
    }

    private ResourceType createResourceTypeForBundleType() throws Exception {
        String fullName = FAKE_RESOURCE_TYPE_NAME;
        ResourceType rt = new ResourceType(FAKE_RESOURCE_TYPE_NAME, RecipeValidationTest.class.getSimpleName(), ResourceCategory.PLATFORM, null);
        TransactionManager txMgr = this.getTransactionManager();
        txMgr.begin();
        this.em.persist((Object)rt);
        txMgr.commit();
        return rt;
    }

    private void checkForExpectedException(Throwable t, String expectedExceptionClassName, String expectedMessage) {
        Throwable test = t;
        do {
            if (!expectedExceptionClassName.equals(test.getClass().getName()) || expectedMessage != null && !expectedMessage.equals(test.getMessage())) continue;
            return;
        } while ((test = test.getCause()) != null);
        this.fail("Exception " + expectedExceptionClassName + (expectedMessage == null ? "" : " with message [" + expectedMessage + "]") + " not detected in the thrown exception " + t);
    }
}

