/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.group.definition.framework.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.rhq.core.domain.resource.group.DuplicateExpressionTypeException;
import org.rhq.core.domain.resource.group.InvalidExpressionException;
import org.rhq.enterprise.server.resource.group.definition.framework.ExpressionEvaluator;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.QueryUtility;
import org.testng.annotations.Test;

public class ExpressionEvaluatorTest
extends AbstractEJB3Test {
    private String[][] getSuccessTestCases() {
        String escapeChar = QueryUtility.getEscapeClauseCharacter();
        return new String[][]{{"resource.child.name = joseph", "SELECT res.id FROM Resource res  JOIN res.childResources child WHERE child.name = :arg1 "}, {"resource.name = joseph", "SELECT res.id FROM Resource res WHERE res.name = :arg1"}, {"resource.version = 1.0", "SELECT res.id FROM Resource res WHERE res.version = :arg1"}, {"resource.type.plugin = harry", "SELECT res.id FROM Resource res WHERE res.resourceType.plugin = :arg1"}, {"resource.type.name = sally", "SELECT res.id FROM Resource res WHERE res.resourceType.name = :arg1"}, {"resource.pluginConfiguration[partition] = cluster-1", "SELECT res.id FROM Resource res   JOIN res.pluginConfiguration pluginConf, PropertySimple simple, PropertyDefinition simpleDef    JOIN res.resourceType.pluginConfigurationDefinition pluginConfDef  WHERE simple.name = :arg1    AND simple.stringValue = :arg2    AND simple.configuration = pluginConf    AND simpleDef.configurationDefinition = pluginConfDef    AND simple.name = simpleDef.name AND simpleDef.type != 'PASSWORD' "}, {"resource.resourceConfiguration[partition].contains = cluster-1", "SELECT res.id FROM Resource res   JOIN res.resourceConfiguration conf, PropertySimple simple, PropertyDefinition simpleDef    JOIN res.resourceType.resourceConfigurationDefinition confDef  WHERE simple.name = :arg1    AND simple.stringValue LIKE :arg2 ESCAPE '" + escapeChar + "'" + "   AND simple.configuration = conf " + "   AND simpleDef.configurationDefinition = confDef " + "   AND simple.name = simpleDef.name AND simpleDef.type != 'PASSWORD' "}, {"groupBy resource.type.plugin; groupBy resource.type.name", "  SELECT res.resourceType.plugin, res.resourceType.name     FROM Resource res GROUP BY res.resourceType.plugin, res.resourceType.name", "  SELECT res.id FROM Resource res    WHERE res.resourceType.plugin = :arg1      AND res.resourceType.name = :arg2 "}, {"groupBy resource.resourceConfiguration[partition-name]", "  SELECT simple.stringValue FROM Resource res     JOIN res.resourceConfiguration conf, PropertySimple simple, PropertyDefinition simpleDef      JOIN res.resourceType.resourceConfigurationDefinition confDef    WHERE simple.name = :arg1      AND simple.configuration = conf      AND simpleDef.configurationDefinition = confDef      AND simple.name = simpleDef.name AND simpleDef.type != 'PASSWORD' GROUP BY simple.stringValue ", "  SELECT res.id FROM Resource res   JOIN res.resourceConfiguration conf, PropertySimple simple, PropertyDefinition simpleDef    JOIN res.resourceType.resourceConfigurationDefinition confDef  WHERE simple.name = :arg1    AND simple.stringValue = :arg2      AND simple.configuration = conf      AND simpleDef.configurationDefinition = confDef      AND simple.name = simpleDef.name AND simpleDef.type != 'PASSWORD' "}, {"resource.type.name = Windows;resource.trait[Trait.osversion] = 5.1", "   SELECT res.id  FROM Resource res JOIN res.schedules sched JOIN sched.definition def, MeasurementDataTrait trait WHERE res.resourceType.name = :arg1  AND def.name LIKE :arg2 ESCAPE '" + escapeChar + "'" + " AND trait.value = :arg3 " + " AND trait.schedule = sched " + " AND trait.id.timestamp = " + "     (SELECT max(mdt.id.timestamp) FROM MeasurementDataTrait mdt WHERE sched.id = mdt.schedule.id)"}, {" ;resource.name.contains = joseph;  ;resource.parent.name.contains = joseph;  ;", "SELECT res.id FROM Resource res WHERE res.name LIKE :arg1 ESCAPE '" + escapeChar + "'" + "  AND res.parentResource.name LIKE :arg2 ESCAPE '" + escapeChar + "'"}, {"EMPTY resource.name", "SELECT res.id FROM Resource res WHERE res.name IS NULL"}, {"empty resource.pluginConfiguration[partition]", "SELECT res.id FROM Resource res   JOIN res.pluginConfiguration pluginConf, PropertySimple simple, PropertyDefinition simpleDef    JOIN res.resourceType.pluginConfigurationDefinition pluginConfDef  WHERE simple.name = :arg1    AND simple.stringValue IS NULL    AND simple.configuration = pluginConf    AND simpleDef.configurationDefinition = pluginConfDef    AND simple.name = simpleDef.name AND simpleDef.type != 'PASSWORD' "}, {"resource.name = joseph; memberof = Group Name", "SELECT res.id FROM Resource res JOIN  res.implicitGroups implicitGroup  WHERE res.name = :arg1   AND implicitGroup.name IN ('Group Name') "}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.session"})
    public void testWellFormedExpressions() throws Exception {
        String[][] successTestCases = this.getSuccessTestCases();
        List suppressedCases = Collections.emptyList();
        this.getTransactionManager().begin();
        try {
            for (int i = 0; i < successTestCases.length; ++i) {
                boolean success;
                if (suppressedCases.contains(i)) continue;
                String inputExpressions = successTestCases[i][0];
                String expectedTopResult = successTestCases[i][1];
                String expectedGroupResult = "";
                if (successTestCases[i].length == 3) {
                    expectedGroupResult = successTestCases[i][2];
                }
                ExpressionEvaluator evaluator = new ExpressionEvaluator();
                evaluator.setTestMode(true);
                for (String expression : inputExpressions.split(";")) {
                    try {
                        evaluator.addExpression(expression);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                        assert (false) : "Error in TestCase[" + i + "], could not add expression[" + expression + "], input[" + inputExpressions + "]";
                    }
                }
                evaluator.execute();
                String actualTopResult = evaluator.getComputedJPQLStatement();
                String actualGroupResult = evaluator.getComputedJPQLGroupStatement();
                expectedTopResult = this.cleanUp(expectedTopResult);
                actualTopResult = this.cleanUp(actualTopResult);
                expectedGroupResult = this.cleanUp(expectedGroupResult);
                actualGroupResult = this.cleanUp(actualGroupResult);
                boolean bl = success = expectedTopResult.equalsIgnoreCase(actualTopResult) && expectedGroupResult.equalsIgnoreCase(actualGroupResult);
                if (!success) {
                    System.out.println("TestCase[" + i + "] = \"" + inputExpressions + "\" failed. \n" + "Expected Top Result: \"" + expectedTopResult + "\"\n" + "Received Top Result: \"" + actualTopResult + "\"\n" + "Expected Group Result: \"" + expectedGroupResult + "\"\n" + "Received Group Result: \"" + actualGroupResult + "\"\n");
                }
                assert (success);
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    @Test(groups={"integration.session"})
    public void testTokenizer() {
        String[] input = new String[]{"resource.child.name", "resource.pluginConfiguration[partition]", "resource.pluginConfiguration[partition].contains", "resource.pluginConfiguration[partition.name].contains", "memberof = GroupName"};
        String[][] expectedOutput = new String[][]{{"resource", "child", "name"}, {"resource", "pluginConfiguration[partition]"}, {"resource", "pluginConfiguration[partition]", "contains"}, {"resource", "pluginConfiguration[partition.name]", "contains"}, {"memberof"}};
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.setTestMode(true);
        for (int i = 0; i < input.length; ++i) {
            String[] nextExpectedOutput = expectedOutput[i];
            String nextInput = input[i];
            List output = evaluator.tokenizeCondition(nextInput);
            String[] outputArray = output.toArray(new String[0]);
            if (nextExpectedOutput.length != outputArray.length) {
                System.out.println("Expected (" + Arrays.asList(nextExpectedOutput) + "), Received (" + output + ")");
                continue;
            }
            boolean failed = false;
            for (int j = 0; j < nextExpectedOutput.length; ++j) {
                if (nextExpectedOutput[j].equals(outputArray[j])) continue;
                System.out.println("Expected (" + Arrays.asList(nextExpectedOutput) + "), Received (" + output + ")");
                failed = true;
            }
            if (failed) continue;
            System.out.println("Successfully tokenized (" + nextInput + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateExpressions(ExpressionGenerator generator) throws Exception {
        try {
            this.getTransactionManager().begin();
            ExpressionEvaluator evaluator = new ExpressionEvaluator();
            for (String expression : generator.getExpressions()) {
                evaluator.addExpression(expression);
            }
            evaluator.execute();
            evaluator.iterator().next();
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleResourceTraitExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.trait[agentHomeDirectory] = /var/rhq-agent", "resource.trait[reasonForLastRestart] = OOMError"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleChildResourceTraitExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.child.trait[agentHomeDirectory] = /var/rhq-agent", "resource.child.trait[reasonForLastRestart] = OOMError"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleParentResourceTraitExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.parent.trait[agentHomeDirectory] = /var/rhq-agent", "resource.parent.trait[reasonForLastRestart] = OOMError"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGrandParentResourceTraitExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.grandParent.trait[agentHomeDirectory] = /var/rhq-agent", "resource.grandParent.trait[reasonForLastRestart] = OOMError"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGreatGrandParentResourceTraitExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.greatGrandParent.trait[agentHomeDirectory] = /var/rhq-agent", "resource.greatGrandParent.trait[reasonForLastRestart] = OOMError"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGreatGreatGrandParentResourceTraitExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.greatGreatGrandParent.trait[agentHomeDirectory] = /var/rhq-agent", "resource.greatGreatGrandParent.trait[reasonForLastRestart] = OOMError"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleResourceIdExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.id = 5", "resource.id = 6"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleChildResourceIdExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.child.id = 5", "resource.child.id = 6"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleParentResourceIdExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.parent.id = 5", "resource.parent.id = 6"};
            }
        });
    }

    @Test(expectedExceptions={InvalidExpressionException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGrandParentResourceIdExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.grandParent.id = 5", "resource.grandParent.id = 6"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGreatGrandParentResourceIdExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.greatGrandParent.id = 5", "resource.greatGrandParent.id = 6"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGreatGreatGrandParentResourceIdExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.greatGreatGrandParent.id = 5", "resource.greatGreatGrandParent.id = 6"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleResourceNameExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.name = foo", "resource.name = bar"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleChildResourceNameExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.child.name = foo", "resource.child.name = bar"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleParentResourceNameExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.parent.name = foo", "resource.parent.name = bar"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGrandParentResourceNameExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.grandParent.name = foo", "resource.grandParent.name = bar"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGreatGrandParentResourceNameExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.greatGrandParent.name = foo", "resource.greatGrandParent.name = bar"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGreatGreatGrandParentResourceNameExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.greatGreatGrandParent.name = foo", "resource.greatGreatGrandParent.name = bar"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleResourceTypeExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.type.plugin = rhq-agent", "resource.type.name = RHQ Agent", "resource.type.plugin = rhq-server", "resource.type.name = RHQ Server"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleChildResourceTypeExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.child.type.plugin = rhq-agent", "resource.child.type.name = RHQ Agent", "resource.child.type.plugin = rhq-server", "resource.child.type.name = RHQ Server"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleParentResourceTypeExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.parent.type.plugin = rhq-agent", "resource.parent.type.name = RHQ Agent", "resource.parent.type.plugin = rhq-server", "resource.parent.type.name = RHQ Server"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGrandParentResourceTypeExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.grandParent.type.plugin = rhq-agent", "resource.grandParent.type.name = RHQ Agent", "resource.grandParent.type.plugin = rhq-server", "resource.grandParent.type.name = RHQ Server"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGreatGrandParentResourceTypeExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.greatGrandParent.type.plugin = rhq-agent", "resource.greatGrandParent.type.name = RHQ Agent", "resource.greatGrandParent.type.plugin = rhq-server", "resource.greatGrandParent.type.name = RHQ Server"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGreatGreatGrandParentResourceTypeExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.greatGreatGrandParent.type.plugin = rhq-agent", "resource.greatGreatGrandParent.type.name = RHQ Agent", "resource.greatGreatGrandParent.type.plugin = rhq-server", "resource.greatGreatGrandParent.type.name = RHQ Server"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleResourceCategoryExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.type.category = PLATFORM", "resource.type.category = SERVER"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleChildResourceCategoryExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.child.type.category = PLATFORM", "resource.child.type.category = SERVER"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleParentResourceCategoryExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.parent.type.category = PLATFORM", "resource.parent.type.category = SERVER"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGrandParentResourceCategoryExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.grandParent.type.category = PLATFORM", "resource.grandParent.type.category = SERVER"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGreatGrandParentResourceCategoryExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.greatGrandParent.type.category = PLATFORM", "resource.greatGrandParent.type.category = SERVER"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGreatGreatGrandParentResourceCategoryExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.greatGreatGrandParent.type.category = PLATFORM", "resource.greatGreatGrandParent.type.category = SERVER"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleResourceAvailabilityExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.availability = UP", "resource.availability = UNKNOWN"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleChildResourceAvailabilityExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.child.availability = UP", "resource.child.availability = UNKNOWN"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleParentResourceAvailabilityExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.parent.availability = UP", "resource.parent.availability = UNKNOWN"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGrandParentResourceAvailabilityExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.grandParent.availability = UP", "resource.grandParent.availability = UNKNOWN"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGreatGrandParentResourceAvailabilityExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.greatGrandParent.availability = UP", "resource.greatGrandParent.availability = UNKNOWN"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGreatGreatGrandParentResourceAvailabilityExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.greatGreatGrandParent.availability = UP", "resource.greatGreatGrandParent.availability = UNKNOWN"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleResourcePluginConfigExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.pluginConfiguration[x] = 1", "resource.pluginConfiguration[y] = 2"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleChildResourcePluginConfigExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.child.pluginConfiguration[x] = 1", "resource.child.pluginConfiguration[y] = 2"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleParentResourcePluginConfigExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.parent.pluginConfiguration[x] = 1", "resource.parent.pluginConfiguration[y] = 2"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGrandParentResourcePluginConfigExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.grandParent.pluginConfiguration[x] = 1", "resource.grandParent.pluginConfiguration[y] = 2"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGreatGrandParentResourcePluginConfigExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.greatGrandParent.pluginConfiguration[x] = 1", "resource.greatGrandParent.pluginConfiguration[y] = 2"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGreatGreatGrandParentResourcePluginConfigExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.greatGreatGrandParent.pluginConfiguration[x] = 1", "resource.greatGreatGrandParent.pluginConfiguration[y] = 2"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleResourceConfigExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.resourceConfiguration[x] = 1", "resource.resourceConfiguration[y] = 2"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleChildResourceConfigExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.child.resourceConfiguration[x] = 1", "resource.child.resourceConfiguration[y] = 2"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleParentResourceConfigExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.parent.resourceConfiguration[x] = 1", "resource.parent.resourceConfiguration[y] = 2"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGrandParentResourceConfigExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.grandParent.resourceConfiguration[x] = 1", "resource.grandParent.resourceConfiguration[y] = 2"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGreatGrandParentResourceConfigExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.greatGrandParent.resourceConfiguration[x] = 1", "resource.greatGrandParent.resourceConfiguration[y] = 2"};
            }
        });
    }

    @Test(expectedExceptions={DuplicateExpressionTypeException.class}, expectedExceptionsMessageRegExp="You cannot specify multiple.*")
    public void doNotAllowMultipleGreatGreatGrandParentResourceConfigExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.greatGreatGrandParent.resourceConfiguration[x] = 1", "resource.greatGreatGrandParent.resourceConfiguration[y] = 2"};
            }
        });
    }

    @Test(expectedExceptions={InvalidExpressionException.class}, expectedExceptionsMessageRegExp="Redundant.*")
    public void doNotAllowDuplicateMemberOfExpressions() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"memberof = foo", "memberof = foo"};
            }
        });
    }

    @Test(expectedExceptions={InvalidExpressionException.class}, expectedExceptionsMessageRegExp="Unrecognized.*")
    public void doNotAllowEmptyProperty() throws Exception {
        this.evaluateExpressions(new ExpressionGenerator(){

            @Override
            public String[] getExpressions() {
                return new String[]{"resource.greatGreatGrandParent.resourceConfiguration[] = 1"};
            }
        });
    }

    private String cleanUp(String result) {
        return result.replaceAll("\\s+", " ").trim();
    }

    private static interface ExpressionGenerator {
        public String[] getExpressions();
    }
}

