/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.group.test;

import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.group.composite.ResourceGroupComposite;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.test.LargeGroupTestBase;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.Test;

@Test
public class GroupWithUncommittedTest
extends LargeGroupTestBase {
    private static final boolean TESTS_ENABLED = true;
    private LargeGroupTestBase.LargeGroupEnvironment env;

    @Override
    protected void setupMockAgentServices(TestServerCommunicationsService agentServiceContainer) {
    }

    @Override
    protected void afterMethod() throws Exception {
        if (this.env != null) {
            this.tearDownLargeGroupWithNormalUserRoleAccess(this.env, false);
            SessionTestHelper.simulateLogout(this.env.normalSubject);
        }
        this.env = null;
        super.afterMethod();
    }

    @Test(enabled=true)
    public void testResourceGroupQueries() throws Exception {
        GroupAvailCounts gac = new GroupAvailCounts(1, 1, 1, 1, 1);
        this.env = this.createLargeGroupWithNormalUserRoleAccessWithInventoryStatus(null, gac.total, gac.down, gac.unknown, gac.disabled, gac.uncommitted, Permission.CONFIGURE_READ);
        assert (null != this.pickUncommittedResource(this.env.platformResource)) : "there should have been an uncommitted resource";
        SessionTestHelper.simulateLogin(this.env.normalSubject);
        PageList results = this.resourceGroupManager.findResourceGroupComposites(this.env.normalSubject, null, null, null, null, null, null, Integer.valueOf(this.env.compatibleGroup.getId()), new PageControl(0, 50));
        int count = results.size();
        assert (count == 1) : "results=" + results;
        ResourceGroupComposite rgc = (ResourceGroupComposite)results.get(0);
        assert (rgc.getExplicitCount() == (long)gac.visibleTotal);
        assert (rgc.getImplicitCount() == (long)gac.visibleTotal);
    }

    @Test(enabled=true)
    public void testGetResourceNameOptionItems() {
        GroupAvailCounts gac = new GroupAvailCounts(1, 1, 1, 1, 1);
        this.env = this.createLargeGroupWithNormalUserRoleAccessWithInventoryStatus(null, gac.total, gac.down, gac.unknown, gac.disabled, gac.uncommitted, Permission.CONFIGURE_READ);
        assert (null != this.pickUncommittedResource(this.env.platformResource)) : "there should have been an uncommitted resource";
        SessionTestHelper.simulateLogin(this.env.normalSubject);
        List results = LookupUtil.getOperationManager().getResourceNameOptionItems(this.env.compatibleGroup.getId());
        int count = results.size();
        assert (count == gac.visibleTotal) : "results=" + results;
    }

    @Test(enabled=true)
    public void testAnotherResourceGroupQuery() throws Exception {
        GroupAvailCounts gac = new GroupAvailCounts(1, 1, 1, 1, 1);
        this.env = this.createLargeGroupWithNormalUserRoleAccessWithInventoryStatus(null, gac.total, gac.down, gac.unknown, gac.disabled, gac.uncommitted, Permission.CONFIGURE_READ);
        assert (null != this.pickUncommittedResource(this.env.platformResource)) : "there should have been an uncommitted resource";
        SessionTestHelper.simulateLogin(this.env.normalSubject);
        Query q = this.getEntityManager().createNamedQuery("ResourceGroup.findResourceIdsNotInGroupExplicit");
        q.setParameter("groupId", (Object)this.env.compatibleGroup.getId());
        q.setParameter("resourceIds", Collections.singletonList(((Resource)this.env.platformResource.getChildResources().iterator().next()).getId()));
        List results = q.getResultList();
        assert (results.isEmpty()) : "results should have been empty" + results;
    }

    @Test(enabled=true)
    public void testResourceTypeQueries() throws Exception {
        GroupAvailCounts gac = new GroupAvailCounts(1, 1, 1, 1, 1);
        this.env = this.createLargeGroupWithNormalUserRoleAccessWithInventoryStatus(null, gac.total, gac.down, gac.unknown, gac.disabled, gac.uncommitted, Permission.CONFIGURE_READ);
        assert (null != this.pickUncommittedResource(this.env.platformResource)) : "there should have been an uncommitted resource";
        SessionTestHelper.simulateLogin(this.env.normalSubject);
        Query q = this.getEntityManager().createNamedQuery("ResourceType.getExplicitResourceTypeCountsByGroup");
        q.setParameter("groupId", (Object)this.env.compatibleGroup.getId());
        List results = q.getResultList();
        int count = results.size();
        assert (count == 1) : "results=" + results;
        q = this.getEntityManager().createNamedQuery("ResourceType.getImplicitResourceTypeCountsByGroup");
        q.setParameter("groupId", (Object)this.env.compatibleGroup.getId());
        results = q.getResultList();
        count = results.size();
        assert (count == 1) : "results=" + results;
    }

    @Test(enabled=true)
    public void testResourceQueries() throws Exception {
        GroupAvailCounts gac = new GroupAvailCounts(1, 1, 1, 1, 1);
        this.env = this.createLargeGroupWithNormalUserRoleAccessWithInventoryStatus(null, gac.total, gac.down, gac.unknown, gac.disabled, gac.uncommitted, Permission.CONFIGURE_READ);
        assert (null != this.pickUncommittedResource(this.env.platformResource)) : "there should have been an uncommitted resource";
        SessionTestHelper.simulateLogin(this.env.normalSubject);
        Query q = this.getEntityManager().createNamedQuery("Resource.findExplicitIdsByResourceGroup_admin");
        q.setParameter("groupId", (Object)this.env.compatibleGroup.getId());
        List results = q.getResultList();
        int count = results.size();
        assert (count == gac.visibleTotal) : "results=" + results;
        q = this.getEntityManager().createNamedQuery("Resource.findImplicitIdsByResourceGroup_admin");
        q.setParameter("groupId", (Object)this.env.compatibleGroup.getId());
        results = q.getResultList();
        count = results.size();
        assert (count == gac.visibleTotal) : "results=" + results;
        q = this.getEntityManager().createNamedQuery("Resource.findByExplicitResourceGroup");
        q.setParameter("group", (Object)this.env.compatibleGroup);
        q.setParameter("subject", (Object)this.env.normalSubject);
        results = q.getResultList();
        count = results.size();
        assert (count == gac.visibleTotal) : "results=" + results;
        q = this.getEntityManager().createNamedQuery("Resource.findByExplicitResourceGroup_admin");
        q.setParameter("group", (Object)this.env.compatibleGroup);
        results = q.getResultList();
        count = results.size();
        assert (count == gac.visibleTotal) : "results=" + results;
        q = this.getEntityManager().createNamedQuery("Resource.findByImplicitResourceGroup");
        q.setParameter("group", (Object)this.env.compatibleGroup);
        q.setParameter("subject", (Object)this.env.normalSubject);
        results = q.getResultList();
        count = results.size();
        assert (count == gac.visibleTotal) : "results=" + results;
        q = this.getEntityManager().createNamedQuery("Resource.findByImplicitResourceGroup_admin");
        q.setParameter("group", (Object)this.env.compatibleGroup);
        results = q.getResultList();
        count = results.size();
        assert (count == gac.visibleTotal) : "results=" + results;
    }

    @Test(enabled=true)
    public void testAvailGroupQueries() throws Exception {
        GroupAvailCounts gac = new GroupAvailCounts(1, 1, 1, 1, 1);
        this.env = this.createLargeGroupWithNormalUserRoleAccessWithInventoryStatus(null, gac.total, gac.down, gac.unknown, gac.disabled, gac.uncommitted, Permission.CONFIGURE_READ);
        assert (null != this.pickUncommittedResource(this.env.platformResource)) : "there should have been an uncommitted resource";
        SessionTestHelper.simulateLogin(this.env.normalSubject);
        Query q = this.getEntityManager().createNamedQuery("Availability.findForResourceGroupWithinInterval");
        q.setParameter("groupId", (Object)this.env.compatibleGroup.getId());
        q.setParameter("start", (Object)0L);
        q.setParameter("end", (Object)System.currentTimeMillis());
        List results = q.getResultList();
        int availCount = results.size();
        assert (availCount == gac.visibleTotal) : "availCount=" + availCount;
    }

    @Test(enabled=true)
    public void testConfigGroupQueries() throws Exception {
        GroupAvailCounts gac = new GroupAvailCounts(5, 4, 3, 2, 1);
        this.env = this.createLargeGroupWithNormalUserRoleAccessWithInventoryStatus(null, gac.total, gac.down, gac.unknown, gac.disabled, gac.uncommitted, Permission.CONFIGURE_READ);
        assert (null != this.pickUncommittedResource(this.env.platformResource)) : "there should have been an uncommitted resource";
        SessionTestHelper.simulateLogin(this.env.normalSubject);
        Query resConfigCountQuery = PersistenceUtility.createCountQuery((EntityManager)this.getEntityManager(), (String)"Configuration.getResourceConfigMapByGroupId");
        resConfigCountQuery.setParameter("resourceGroupId", (Object)this.env.compatibleGroup.getId());
        long resConfigCount = (Long)resConfigCountQuery.getSingleResult();
        Query pluginConfigCountQuery = PersistenceUtility.createCountQuery((EntityManager)this.getEntityManager(), (String)"Configuration.getPluginConfigMapByGroupId");
        pluginConfigCountQuery.setParameter("resourceGroupId", (Object)this.env.compatibleGroup.getId());
        long pluginConfigCount = (Long)pluginConfigCountQuery.getSingleResult();
        assert (resConfigCount == (long)gac.visibleTotal);
        assert (pluginConfigCount == (long)gac.visibleTotal);
        int groupSize = this.resourceGroupManager.getExplicitGroupMemberCount(this.env.compatibleGroup.getId());
        assert (resConfigCount == (long)groupSize);
        assert (pluginConfigCount == (long)groupSize);
    }

    private Resource pickUncommittedResource(Resource platformResource) {
        for (Resource r : platformResource.getChildResources()) {
            if (r.getInventoryStatus() != InventoryStatus.NEW) continue;
            return r;
        }
        return null;
    }

    private class GroupAvailCounts {
        public final int up;
        public final int down;
        public final int unknown;
        public final int disabled;
        public final int uncommitted;
        public final int total;
        public final int visibleTotal;

        GroupAvailCounts(int up, int down, int unknown, int disabled, int uncommitted) {
            this.up = up;
            this.down = down;
            this.unknown = unknown;
            this.disabled = disabled;
            this.uncommitted = uncommitted;
            this.total = up + down + unknown + disabled + uncommitted;
            this.visibleTotal = up + down + unknown + disabled;
            assert (this.visibleTotal != this.total) : "all of our tests should have at least 1 uncommitted resource";
        }
    }
}

