/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.group.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceGroupCriteria;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.group.composite.ResourceGroupComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.test.LargeGroupTestBase;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.Test;

@Test
public class LargeGroupCriteriaTest
extends LargeGroupTestBase {
    private static final boolean TEST_ENABLED = true;
    private ArrayList<LargeGroupTestBase.LargeGroupEnvironment> env;

    @Override
    protected void setupMockAgentServices(TestServerCommunicationsService agentServiceContainer) {
    }

    @Override
    protected void afterMethod() throws Exception {
        this.tearDownGroups();
        super.afterMethod();
    }

    private void tearDownGroups() throws Exception {
        if (this.env != null) {
            System.out.println("Tearing down groups...");
            Iterator<LargeGroupTestBase.LargeGroupEnvironment> iter = this.env.iterator();
            while (iter.hasNext()) {
                LargeGroupTestBase.LargeGroupEnvironment doomed = iter.next();
                this.tearDownLargeGroupWithNormalUserRoleAccess(doomed, iter.hasNext());
                SessionTestHelper.simulateLogout(doomed.normalSubject);
            }
            this.env = null;
        }
    }

    @Test(enabled=true)
    public void testSearchBarAvailabilityQueryUP() throws Exception {
        GroupAvailCounts gac = new GroupAvailCounts(5, 0, 0, 0);
        PageList<ResourceGroupComposite> pageList = this.testGroupQueriesWithSearchBar(gac, "availability=up");
        assert (pageList.size() == 1);
        this.tearDownGroups();
        pageList = this.testGroupQueriesWithSearchBar(gac, "availability != up");
        assert (pageList.size() == 0);
    }

    @Test(enabled=true)
    public void testSearchBarAvailabilityQueryDOWN() throws Exception {
        GroupAvailCounts gac = new GroupAvailCounts(0, 5, 0, 0);
        PageList<ResourceGroupComposite> pageList = this.testGroupQueriesWithSearchBar(gac, "availability=down");
        assert (pageList.size() == 1);
        this.tearDownGroups();
        pageList = this.testGroupQueriesWithSearchBar(gac, "availability != down");
        assert (pageList.size() == 0);
    }

    @Test(enabled=true)
    public void testSearchBarAvailabilityQueryDISABLED() throws Exception {
        GroupAvailCounts gac = new GroupAvailCounts(0, 0, 0, 5);
        PageList<ResourceGroupComposite> pageList = this.testGroupQueriesWithSearchBar(gac, "availability=disabled");
        assert (pageList.size() == 1);
        this.tearDownGroups();
        pageList = this.testGroupQueriesWithSearchBar(gac, "availability != disabled");
        assert (pageList.size() == 0);
    }

    @Test(enabled=true)
    public void testSearchBarAvailabilityQueryMIXED() throws Exception {
        GroupAvailCounts gac = new GroupAvailCounts(2, 2, 0, 2);
        PageList<ResourceGroupComposite> pageList = this.testGroupQueriesWithSearchBar(gac, "availability=up");
        assert (pageList.size() == 0);
        this.tearDownGroups();
        pageList = this.testGroupQueriesWithSearchBar(gac, "availability=down");
        assert (pageList.size() == 0);
        this.tearDownGroups();
        pageList = this.testGroupQueriesWithSearchBar(gac, "availability=disabled");
        assert (pageList.size() == 0);
    }

    @Test(enabled=true)
    public void testUncommitted() throws Exception {
        ArrayList<GroupAvailCounts> gacs = new ArrayList<GroupAvailCounts>();
        gacs.add(new GroupAvailCounts(1, 1, 1, 1, 1));
        this.testGroupQueries(gacs);
    }

    @Test(enabled=true)
    public void testSmallGroupsWithUncommitted() throws Exception {
        ArrayList<GroupAvailCounts> gacs = new ArrayList<GroupAvailCounts>();
        gacs.add(new GroupAvailCounts(8, 4, 2, 1, 1));
        gacs.add(new GroupAvailCounts(2, 4, 6, 8, 10));
        this.testGroupQueries(gacs);
    }

    @Test(enabled=true)
    public void testSmallGroups() throws Exception {
        ArrayList<GroupAvailCounts> gacs = new ArrayList<GroupAvailCounts>();
        gacs.add(new GroupAvailCounts(8, 4, 2, 1));
        gacs.add(new GroupAvailCounts(2, 4, 6, 8));
        this.testGroupQueries(gacs);
    }

    @Test(enabled=true)
    public void testLotsOfSmallGroups() throws Exception {
        ArrayList<GroupAvailCounts> gacs = new ArrayList<GroupAvailCounts>();
        for (int i = 0; i < 50; ++i) {
            gacs.add(new GroupAvailCounts(1, 1, 1, 1));
            gacs.add(new GroupAvailCounts(2, 2, 2, 2));
        }
        this.testGroupQueries(gacs);
    }

    @Test(enabled=true)
    public void testLargeGroup() throws Exception {
        ArrayList<GroupAvailCounts> gacs = new ArrayList<GroupAvailCounts>();
        gacs.add(new GroupAvailCounts(500, 250, 150, 110));
        this.testGroupQueries(gacs);
    }

    @Test(enabled=true)
    public void testLotsOfLargeGroups() throws Exception {
        ArrayList<GroupAvailCounts> gacs = new ArrayList<GroupAvailCounts>();
        for (int i = 0; i < 5; ++i) {
            gacs.add(new GroupAvailCounts(10, 10, 10, 10));
            gacs.add(new GroupAvailCounts(20, 20, 20, 20));
        }
        this.testGroupQueries(gacs);
    }

    @Test(enabled=true)
    public void testResourceCriteriaBounded() throws Exception {
        ArrayList<GroupAvailCounts> gacs = new ArrayList<GroupAvailCounts>();
        gacs.add(new GroupAvailCounts(1100, 0, 0, 0));
        ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        AuthorizationManagerLocal authManager = LookupUtil.getAuthorizationManager();
        this.env = new ArrayList(gacs.size());
        LargeGroupTestBase.LargeGroupEnvironment lgeWithTypes = null;
        for (GroupAvailCounts gac : gacs) {
            this.env.add(this.createLargeGroupWithNormalUserRoleAccessWithInventoryStatus(lgeWithTypes, gac.total, gac.down, gac.unknown, gac.disabled, gac.uncommitted, Permission.CONFIGURE_READ));
            lgeWithTypes = this.env.get(0);
        }
        ResourceCriteria criteria = new ResourceCriteria();
        SessionTestHelper.simulateLogin(this.env.get((int)0).normalSubject);
        criteria.addFilterParentResourceId(Integer.valueOf(lgeWithTypes.platformResource.getId()));
        criteria.setPageControl(PageControl.getUnlimitedInstance());
        Object result = resourceManager.findResourcesByCriteria(this.env.get((int)0).normalSubject, criteria);
        assert (null != result);
        assert (result.size() == 1100) : "Expected unbounded query to return all 1100 resources";
        result = resourceManager.findResourcesByCriteriaBounded(this.env.get((int)0).normalSubject, criteria, 2000, 100);
        assert (null != result);
        assert (result.size() == 1100) : "Expected 2000/100 bounded query to return all 1100 resources";
        result = resourceManager.findResourcesByCriteriaBounded(this.env.get((int)0).normalSubject, criteria, 1100, 100);
        assert (null != result);
        assert (result.size() == 1100) : "Expected 1100/100 bounded query to return all 1100 resources";
        result = resourceManager.findResourcesByCriteriaBounded(this.env.get((int)0).normalSubject, criteria, 0, 0);
        assert (null != result);
        assert (result.size() == 200) : "Expected default (1000/200) bounded query to return 200 resources";
        result = resourceManager.findResourcesByCriteriaBounded(this.env.get((int)0).normalSubject, criteria, 0, 500);
        assert (null != result);
        assert (result.size() == 500) : "Expected default (1000)/500) bounded query to return 500 resources";
        result = resourceManager.findResourcesByCriteriaBounded(this.env.get((int)0).normalSubject, criteria, 100, 200);
        assert (null != result);
        assert (result.size() == 100) : "Expected 100/200 bounded query to return 100 resources";
    }

    private PageList<ResourceGroupComposite> testGroupQueriesWithSearchBar(GroupAvailCounts gac, String searchExpression) throws Exception {
        ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
        this.env = new ArrayList(1);
        LargeGroupTestBase.LargeGroupEnvironment lgeWithTypes = null;
        this.env.add(this.createLargeGroupWithNormalUserRoleAccessWithInventoryStatus(lgeWithTypes, gac.total, gac.down, gac.unknown, gac.disabled, gac.uncommitted, Permission.CONFIGURE_READ));
        SessionTestHelper.simulateLogin(this.env.get((int)0).normalSubject);
        ResourceGroupCriteria criteria = new ResourceGroupCriteria();
        criteria.setSearchExpression(searchExpression);
        long start = System.currentTimeMillis();
        PageList pageList = groupManager.findResourceGroupCompositesByCriteria(this.env.get((int)0).normalSubject, criteria);
        System.out.println("criteria with search==>" + (System.currentTimeMillis() - start) + "ms");
        return pageList;
    }

    private void testGroupQueries(ArrayList<GroupAvailCounts> groupAvailCounts) throws Exception {
        ResourceGroupComposite groupComp;
        long start;
        GroupAvailCounts gac;
        LargeGroupTestBase.LargeGroupEnvironment lge;
        int i;
        ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
        AuthorizationManagerLocal authManager = LookupUtil.getAuthorizationManager();
        this.env = new ArrayList(groupAvailCounts.size());
        LargeGroupTestBase.LargeGroupEnvironment lgeWithTypes = null;
        for (GroupAvailCounts gac2 : groupAvailCounts) {
            this.env.add(this.createLargeGroupWithNormalUserRoleAccessWithInventoryStatus(lgeWithTypes, gac2.total, gac2.down, gac2.unknown, gac2.disabled, gac2.uncommitted, Permission.CONFIGURE_READ));
            lgeWithTypes = this.env.get(0);
        }
        for (i = 0; i < groupAvailCounts.size(); ++i) {
            lge = this.env.get(i);
            gac = groupAvailCounts.get(i);
            SessionTestHelper.simulateLogin(lge.normalSubject);
            ResourceGroupCriteria criteria = new ResourceGroupCriteria();
            start = System.currentTimeMillis();
            PageList pageList = groupManager.findResourceGroupCompositesByCriteria(lge.normalSubject, criteria);
            System.out.println("findResourceGroupCompositesByCriteria #" + i + "==>" + (System.currentTimeMillis() - start) + "ms");
            assert (pageList.size() == 1) : "the query should only have selected the one group for our user";
            groupComp = (ResourceGroupComposite)pageList.get(0);
            System.out.println("-->" + groupComp);
            assert (groupComp.getExplicitCount() == (long)gac.visibleTotal);
            assert (groupComp.getExplicitCount() == groupComp.getImplicitCount());
            assert (groupComp.getExplicitUp() == (long)gac.up);
            assert (groupComp.getExplicitDown() == (long)gac.down);
            assert (groupComp.getExplicitUnknown() == (long)gac.unknown);
            assert (groupComp.getExplicitDisabled() == (long)gac.disabled);
            Resource committed = this.pickAResourceWithInventoryStatus(lge.platformResource, InventoryStatus.COMMITTED);
            assert (authManager.hasResourcePermission(lge.normalSubject, Permission.CONFIGURE_READ, Collections.singletonList(committed.getId())));
            assert (!authManager.hasResourcePermission(lge.normalSubject, Permission.CONTROL, Collections.singletonList(committed.getId())));
            Resource uncommitted = this.pickAResourceWithInventoryStatus(lge.platformResource, InventoryStatus.NEW);
            if (uncommitted != null) assert (!authManager.hasResourcePermission(lge.normalSubject, Permission.CONFIGURE_READ, Collections.singletonList(uncommitted.getId())));
        }
        for (i = 0; i < groupAvailCounts.size(); ++i) {
            lge = this.env.get(i);
            gac = groupAvailCounts.get(i);
            SessionTestHelper.simulateLogin(lge.normalSubject);
            start = System.currentTimeMillis();
            groupComp = groupManager.getResourceGroupComposite(lge.normalSubject, lge.compatibleGroup.getId());
            System.out.println("getResourceGroupComposite #" + i + "==>" + (System.currentTimeMillis() - start) + "ms");
            System.out.println("-->" + groupComp);
            assert (groupComp.getExplicitCount() == (long)gac.visibleTotal);
            assert (groupComp.getExplicitCount() == groupComp.getImplicitCount());
            assert (groupComp.getExplicitUp() == (long)gac.up);
            assert (groupComp.getExplicitDown() == (long)gac.down);
            assert (groupComp.getExplicitUnknown() == (long)gac.unknown);
            assert (groupComp.getExplicitDisabled() == (long)gac.disabled);
        }
    }

    private Resource pickAResourceWithInventoryStatus(Resource platformResource, InventoryStatus status) {
        for (Resource r : platformResource.getChildResources()) {
            if (r.getInventoryStatus() != status) continue;
            return r;
        }
        return null;
    }

    private class GroupAvailCounts {
        public final int up;
        public final int down;
        public final int unknown;
        public final int disabled;
        public final int uncommitted;
        public final int total;
        public final int visibleTotal;

        GroupAvailCounts(int up, int down, int unknown, int disabled) {
            this(up, down, unknown, disabled, 0);
        }

        GroupAvailCounts(int up, int down, int unknown, int disabled, int uncommitted) {
            this.up = up;
            this.down = down;
            this.unknown = unknown;
            this.disabled = disabled;
            this.uncommitted = uncommitted;
            this.total = up + down + unknown + disabled + uncommitted;
            this.visibleTotal = up + down + unknown + disabled;
        }
    }
}

