/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.group.test;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import javax.persistence.Query;
import org.rhq.core.domain.common.SystemConfiguration;
import org.rhq.core.domain.common.composite.SystemSetting;
import org.rhq.enterprise.server.RHQConstants;
import org.rhq.enterprise.server.resource.group.LdapGroupManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerPluginService;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.test.ldap.FakeLdapCtxFactory;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

public class LdapGroupManagerBeanTest
extends AbstractEJB3Test {
    public static String RHQ_TEST_LDAP_URL_PROPERTY = "rhq.test.ldap.url";
    public static String RHQ_TEST_LDAP_LDAPFACTORY_PROPERTY = "rhq.test.ldap.LDAPFactory";
    public static String RHQ_TEST_LDAP_DEFAULT_CONTEXT_FACTORY = FakeLdapCtxFactory.class.getCanonicalName();
    public static String RHQ_TEST_LDAP_DEFAULT_URL = "ldap://localhost:389";
    private LdapGroupManagerLocal ldapGroupManager = null;
    private SystemManagerLocal systemManager = null;
    private TestServerPluginService testServerPluginService = null;

    @Override
    protected void beforeMethod() throws Exception {
        this.systemManager = LookupUtil.getSystemManager();
        this.ldapGroupManager = LookupUtil.getLdapGroupManager();
        this.testServerPluginService = new TestServerPluginService(this.getTempDir());
        this.prepareCustomServerPluginService(this.testServerPluginService);
        this.testServerPluginService.startMasterPluginContainer();
        URL url = LdapGroupManagerBeanTest.class.getClassLoader().getResource("test-ldap.properties");
        Properties mvnProps = new Properties();
        try {
            if (url == null) {
                throw new IOException("Unable to find test-ldap.properties in test envrionment's class loader");
            }
            mvnProps.load(url.openStream());
        }
        catch (IOException e) {
            System.err.println(" !!! Unable to load test-ldap.properties - All defaults are in place !!! ");
            e.printStackTrace();
        }
        String LDAPFactory = mvnProps.getProperty(RHQ_TEST_LDAP_LDAPFACTORY_PROPERTY);
        if (LDAPFactory == null || ("${" + RHQ_TEST_LDAP_LDAPFACTORY_PROPERTY + "}").equals(LDAPFactory)) {
            LDAPFactory = RHQ_TEST_LDAP_DEFAULT_CONTEXT_FACTORY;
        }
        this.setLdapCtxFactory(LDAPFactory);
        System.out.println("!! Initial LDAP Context Factory is " + LDAPFactory + " !!");
        String ldapUrl = mvnProps.getProperty(RHQ_TEST_LDAP_URL_PROPERTY);
        if (ldapUrl == null || ("${" + RHQ_TEST_LDAP_URL_PROPERTY + "}").equals(ldapUrl)) {
            ldapUrl = RHQ_TEST_LDAP_DEFAULT_URL;
        }
        this.setLdapUrl(ldapUrl);
        this.setLdapBaseDN("dc=test,dc=rhq,dc=redhat,dc=com");
        this.setLdapBindDN("uid=admin,ou=system");
        this.setLdapBindPassword("secret");
        this.setLdapUserFilter("objectClass=person");
        this.setLdapLoginAttribute("uid");
        this.setLdapGroupFilter("objectClass=groupOfNames");
        this.setLdapGroupMemberAttribute("member");
    }

    @Override
    protected void afterMethod() throws Exception {
        this.unprepareServerPluginService();
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForNonUser() throws Throwable {
        this.assertEquals(new HashSet(), this.ldapGroupManager.findAvailableGroupsFor("gsmith"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserSimpleUseCase() throws Throwable {
        this.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("rjosmith"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("jsmith"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), this.ldapGroupManager.findAvailableGroupsFor("ssmith"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserCommaChar() throws Throwable {
        this.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("bcannon"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("ghause"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), this.ldapGroupManager.findAvailableGroupsFor("bwalsh"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserBackslashChar() throws Throwable {
        this.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("csamlin"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("cgroober"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), this.ldapGroupManager.findAvailableGroupsFor("jkirk"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserHashChar() throws Throwable {
        this.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("csellers"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("brogers"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), this.ldapGroupManager.findAvailableGroupsFor("sphillips"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserPlusChar() throws Throwable {
        this.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("bbalanger"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("sreed"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), this.ldapGroupManager.findAvailableGroupsFor("woverture"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserGTLTChar() throws Throwable {
        this.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("bwallace"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("ltoller"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), this.ldapGroupManager.findAvailableGroupsFor("callen"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserSemiColonChar() throws Throwable {
        this.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("zbalanger"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("hsimpsonite"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), this.ldapGroupManager.findAvailableGroupsFor("wfredrick"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserQuoteChar() throws Throwable {
        this.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("acallen"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("jmathers"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), this.ldapGroupManager.findAvailableGroupsFor("smein"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserEqualChar() throws Throwable {
        this.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("ssmitherson"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("hrein"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), this.ldapGroupManager.findAvailableGroupsFor("nsadler"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserLTSpaceChar() throws Throwable {
        this.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("bkiddough"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("sferguson"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), this.ldapGroupManager.findAvailableGroupsFor("ssmiley"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserSlashChar() throws Throwable {
        this.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("sysapi"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("pscarlson"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), this.ldapGroupManager.findAvailableGroupsFor("sysapi2"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserHyphenChar() throws Throwable {
        this.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("lecroutche"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("samathers"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), this.ldapGroupManager.findAvailableGroupsFor("sajeopardy"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserAsteriskChar() throws Throwable {
        this.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("sjeopardy"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("lcroutche"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), this.ldapGroupManager.findAvailableGroupsFor("smathers"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUserParenthesisChar() throws Throwable {
        this.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("bstrafford"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("kkrawford"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), this.ldapGroupManager.findAvailableGroupsFor("jwilbright"));
    }

    @Test(groups={"integration.session"})
    public void testFindGroupsForUser8BitAsciiChar() throws Throwable {
        this.assertEquals(new HashSet<String>(Arrays.asList("RHQ Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("mmechura"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Admin Group")), this.ldapGroupManager.findAvailableGroupsFor("wsequerl"));
        this.assertEquals(new HashSet<String>(Arrays.asList("JBoss Monitor Group")), this.ldapGroupManager.findAvailableGroupsFor("pbrady"));
    }

    private void setSystemConfigProperty(String name, String value) throws Exception {
        Properties sysConfig = this.systemManager.getSystemConfiguration(LookupUtil.getSubjectManager().getOverlord());
        sysConfig.setProperty(name, value);
        this.systemManager.setSystemConfiguration(LookupUtil.getSubjectManager().getOverlord(), sysConfig, true);
    }

    private void setLdapGroupFilter(String filter) throws Exception {
        this.setSystemConfigProperty(RHQConstants.LDAPGroupFilter, filter);
    }

    private void setLdapGroupMemberAttribute(String attributeName) throws Exception {
        this.setSystemConfigProperty(RHQConstants.LDAPGroupMember, attributeName);
    }

    private void setLdapBaseDN(String dn) throws Exception {
        this.setSystemConfigProperty(RHQConstants.LDAPBaseDN, dn);
    }

    private void setLdapLoginAttribute(String attributeName) throws Exception {
        this.setSystemConfigProperty(RHQConstants.LDAPLoginProperty, attributeName);
    }

    private void setLdapBindDN(String dn) throws Exception {
        this.setSystemConfigProperty(RHQConstants.LDAPBindDN, dn);
    }

    private void setLdapBindPassword(String password) throws Exception {
        this.setSystemConfigProperty(RHQConstants.LDAPBindPW, password);
    }

    private void setLdapUserFilter(String filter) throws Exception {
        this.setSystemConfigProperty(RHQConstants.LDAPFilter, filter);
    }

    private void setLdapUrl(String url) throws Exception {
        this.setSystemConfigProperty(RHQConstants.LDAPUrl, url);
    }

    private void setLdapCtxFactory(final String name) throws Exception {
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Query q = LdapGroupManagerBeanTest.this.getEntityManager().createNamedQuery("SystemConfiguration.FIND_PROPERTY_BY_KEY");
                q.setParameter("key", (Object)SystemSetting.LDAP_NAMING_FACTORY.getInternalName());
                SystemConfiguration config = (SystemConfiguration)q.getSingleResult();
                config.setPropertyValue(name);
                LdapGroupManagerBeanTest.this.getEntityManager().merge((Object)config);
                LdapGroupManagerBeanTest.this.getEntityManager().flush();
            }
        });
        this.systemManager.loadSystemConfigurationCache();
    }
}

