/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.group.test;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.persistence.EntityManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.ResourceTreeHelper;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.Test;

public class RecursiveResourceGroupTest
extends AbstractEJB3Test {
    private ResourceGroupManagerLocal resourceGroupManager;
    private ResourceManagerLocal resourceManager;
    private RoleManagerLocal roleManager;
    private SubjectManagerLocal subjectManager;

    @Override
    protected void beforeMethod() throws Exception {
        this.resourceGroupManager = LookupUtil.getResourceGroupManager();
        this.resourceManager = LookupUtil.getResourceManager();
        this.roleManager = LookupUtil.getRoleManager();
        this.subjectManager = LookupUtil.getSubjectManager();
        this.prepareScheduler();
    }

    @Override
    protected void afterMethod() throws Exception {
        this.unprepareScheduler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.session"})
    public void testImplicitGroupMembershipFromInventoryUpdate() throws Throwable {
        this.getTransactionManager().begin();
        try {
            EntityManager em = this.getEntityManager();
            Subject subject = SessionTestHelper.createNewSubject(em, "fake subject");
            Role role = SessionTestHelper.createNewRoleForSubject(em, subject, "fake role", Permission.MANAGE_INVENTORY);
            ResourceGroup recursiveGroup = SessionTestHelper.createNewMixedGroupForRole(em, role, "fake group", true);
            List<Resource> fullTree = this.getSimpleTree(em);
            Resource nodeA = ResourceTreeHelper.findNode(fullTree, "A");
            List<Resource> resourcesFromTreeA = ResourceTreeHelper.getSubtree(nodeA);
            this.resourceGroupManager.addResourcesToGroup(subject, recursiveGroup.getId(), new int[]{nodeA.getId()});
            PageList initialExplicitResources = this.resourceManager.findExplicitResourcesByResourceGroup(subject, recursiveGroup, PageControl.getUnlimitedInstance());
            assert (initialExplicitResources.size() == 1) : "Failed: initial explicit resources, size was " + initialExplicitResources.size();
            assert (((Resource)initialExplicitResources.get(0)).getId() == nodeA.getId()) : "Failed: initial explicit resources id, found " + ((Resource)initialExplicitResources.get(0)).getId() + ", expected " + nodeA.getId();
            PageList initialImplicitResources = this.resourceManager.findImplicitResourcesByResourceGroup(subject, recursiveGroup, PageControl.getUnlimitedInstance());
            this.verifyEqualByIds("Failed: initial implicit resources", resourcesFromTreeA, (List<Resource>)initialImplicitResources);
            Resource newChildOfNodeA = new Resource("new nodeOne child", "new nodeOne child", nodeA.getResourceType());
            newChildOfNodeA.setUuid("" + new Random().nextInt());
            newChildOfNodeA.setInventoryStatus(InventoryStatus.COMMITTED);
            this.resourceManager.createResource(subject, newChildOfNodeA, nodeA.getId());
            PageList updatedImplicitResources = this.resourceManager.findImplicitResourcesByResourceGroup(subject, recursiveGroup, PageControl.getUnlimitedInstance());
            resourcesFromTreeA.add(newChildOfNodeA);
            this.verifyEqualByIds("Failed: simple implicit resources", resourcesFromTreeA, (List<Resource>)updatedImplicitResources);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.session"})
    public void testUpdateImplicitGroupMembership() throws Throwable {
        this.getTransactionManager().begin();
        try {
            EntityManager em = this.getEntityManager();
            Subject subject = SessionTestHelper.createNewSubject(em, "fake subject");
            Role role = SessionTestHelper.createNewRoleForSubject(em, subject, "fake role", Permission.MANAGE_INVENTORY);
            ResourceGroup lineageG1 = SessionTestHelper.createNewMixedGroupForRole(em, role, "gen1", true);
            ResourceGroup lineageG2 = SessionTestHelper.createNewMixedGroupForRole(em, role, "gen2", true);
            ResourceGroup lineageG3 = SessionTestHelper.createNewMixedGroupForRole(em, role, "gen3", true);
            ResourceGroup lineageG4 = SessionTestHelper.createNewMixedGroupForRole(em, role, "gen4", true);
            List<Resource> fullTree = ResourceTreeHelper.createTree(em, "A=1; 1=a; a=i;");
            Resource gen1 = ResourceTreeHelper.findNode(fullTree, "A");
            Resource gen2 = ResourceTreeHelper.findNode(fullTree, "1");
            Resource gen3 = ResourceTreeHelper.findNode(fullTree, "a");
            Resource gen4 = ResourceTreeHelper.findNode(fullTree, "i");
            this.resourceGroupManager.addResourcesToGroup(subject, lineageG1.getId(), new int[]{gen1.getId()});
            this.resourceGroupManager.addResourcesToGroup(subject, lineageG2.getId(), new int[]{gen2.getId()});
            this.resourceGroupManager.addResourcesToGroup(subject, lineageG3.getId(), new int[]{gen3.getId()});
            this.resourceGroupManager.addResourcesToGroup(subject, lineageG4.getId(), new int[]{gen4.getId()});
            Resource gen5 = new Resource("g5", "g5", gen4.getResourceType());
            gen5.setUuid("" + new Random().nextInt());
            gen5.setInventoryStatus(InventoryStatus.COMMITTED);
            this.resourceManager.createResource(subject, gen5, gen4.getId());
            List newLineageG1 = this.resourceManager.findImplicitResourceIdsByResourceGroup(lineageG1.getId());
            List newLineageG2 = this.resourceManager.findImplicitResourceIdsByResourceGroup(lineageG2.getId());
            List newLineageG3 = this.resourceManager.findImplicitResourceIdsByResourceGroup(lineageG3.getId());
            List newLineageG4 = this.resourceManager.findImplicitResourceIdsByResourceGroup(lineageG4.getId());
            List<Resource> treeGen1 = ResourceTreeHelper.getSubtree(gen1);
            List<Resource> treeGen2 = ResourceTreeHelper.getSubtree(gen2);
            List<Resource> treeGen3 = ResourceTreeHelper.getSubtree(gen3);
            List<Resource> treeGen4 = ResourceTreeHelper.getSubtree(gen4);
            treeGen1.add(gen5);
            treeGen2.add(gen5);
            treeGen3.add(gen5);
            treeGen4.add(gen5);
            this.verifyEqual("Failed: updateImplicitGroupMembership gen1", this.getIds(treeGen1), newLineageG1);
            this.verifyEqual("Failed: updateImplicitGroupMembership gen2", this.getIds(treeGen2), newLineageG2);
            this.verifyEqual("Failed: updateImplicitGroupMembership gen3", this.getIds(treeGen3), newLineageG3);
            this.verifyEqual("Failed: updateImplicitGroupMembership gen4", this.getIds(treeGen4), newLineageG4);
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test(groups={"integration.session"})
    public void testImplicitGroupMembershipFromComplexGroupUpdates() throws Throwable {
        EntityManager em;
        Subject subject = null;
        Role role = null;
        ResourceGroup recursiveGroup = null;
        List<Resource> fullTree = null;
        Resource nodeBigA = null;
        Resource nodeOne = null;
        Resource nodeThree = null;
        Resource nodeLittleA = null;
        Resource nodeTripleLittleI = null;
        PageList resultsExplicit = null;
        List<Resource> expectedImplicit = null;
        ArrayList<Resource> expectedExplicit = new ArrayList<Resource>();
        try {
            try {
                this.getTransactionManager().begin();
                em = this.getEntityManager();
                subject = SessionTestHelper.createNewSubject(em, "fake subject");
                role = SessionTestHelper.createNewRoleForSubject(em, subject, "fake role", Permission.MANAGE_INVENTORY);
                recursiveGroup = SessionTestHelper.createNewMixedGroupForRole(em, role, "fake group", true);
                fullTree = this.getSimpleTree(em);
                ResourceTreeHelper.printForest(fullTree);
                nodeBigA = ResourceTreeHelper.findNode(fullTree, "A");
                nodeOne = ResourceTreeHelper.findNode(fullTree, "1");
                nodeThree = ResourceTreeHelper.findNode(fullTree, "3");
                nodeLittleA = ResourceTreeHelper.findNode(fullTree, "a");
                nodeTripleLittleI = ResourceTreeHelper.findNode(fullTree, "iii");
                expectedImplicit = ResourceTreeHelper.getSubtree(nodeLittleA);
                this.implicitGroupMembershipAddHelper(subject, recursiveGroup, nodeLittleA, expectedImplicit);
                resultsExplicit = this.resourceManager.findExplicitResourcesByResourceGroup(subject, recursiveGroup, PageControl.getUnlimitedInstance());
                expectedExplicit.add(nodeLittleA);
                this.verifyEqualByIds("explicit add 1", expectedExplicit, (List<Resource>)resultsExplicit);
                expectedImplicit.add(nodeThree);
                this.implicitGroupMembershipAddHelper(subject, recursiveGroup, nodeThree, expectedImplicit);
                resultsExplicit = this.resourceManager.findExplicitResourcesByResourceGroup(subject, recursiveGroup, PageControl.getUnlimitedInstance());
                expectedExplicit.add(nodeThree);
                this.verifyEqualByIds("explicit add 2", expectedExplicit, (List<Resource>)resultsExplicit);
                expectedImplicit = ResourceTreeHelper.getSubtree(nodeBigA);
                expectedImplicit.addAll(ResourceTreeHelper.getSubtree(nodeThree));
                this.implicitGroupMembershipAddHelper(subject, recursiveGroup, nodeBigA, expectedImplicit);
                resultsExplicit = this.resourceManager.findExplicitResourcesByResourceGroup(subject, recursiveGroup, PageControl.getUnlimitedInstance());
                expectedExplicit.add(nodeBigA);
                this.verifyEqualByIds("explicit add 3", expectedExplicit, (List<Resource>)resultsExplicit);
                this.implicitGroupMembershipAddHelper(subject, recursiveGroup, nodeOne, expectedImplicit);
                resultsExplicit = this.resourceManager.findExplicitResourcesByResourceGroup(subject, recursiveGroup, PageControl.getUnlimitedInstance());
                expectedExplicit.add(nodeOne);
                this.verifyEqualByIds("explicit add 4", expectedExplicit, (List<Resource>)resultsExplicit);
                this.implicitGroupMembershipAddHelper(subject, recursiveGroup, nodeTripleLittleI, expectedImplicit);
                resultsExplicit = this.resourceManager.findExplicitResourcesByResourceGroup(subject, recursiveGroup, PageControl.getUnlimitedInstance());
                expectedExplicit.add(nodeTripleLittleI);
                this.verifyEqualByIds("explicit add 5", expectedExplicit, (List<Resource>)resultsExplicit);
            }
            catch (Throwable t) {
                this.handleThrowable(t);
            }
            finally {
                this.handleTransaction();
            }
            try {
                this.getTransactionManager().begin();
                this.implicitGroupMembershipRemoveHelper(subject, recursiveGroup, nodeTripleLittleI, expectedImplicit);
            }
            catch (Throwable t) {
                this.handleThrowable(t);
            }
            finally {
                this.handleTransaction();
            }
            try {
                this.getTransactionManager().begin();
                this.implicitGroupMembershipRemoveHelper(subject, recursiveGroup, nodeOne, expectedImplicit);
                expectedImplicit.remove(nodeThree);
                this.implicitGroupMembershipRemoveHelper(subject, recursiveGroup, nodeThree, expectedImplicit);
                this.implicitGroupMembershipRemoveHelper(subject, recursiveGroup, nodeBigA, ResourceTreeHelper.getSubtree(nodeLittleA));
            }
            catch (Throwable t) {
                this.handleThrowable(t);
            }
            finally {
                this.handleTransaction();
            }
            try {
                this.getTransactionManager().begin();
                try {
                    this.implicitGroupMembershipRemoveHelper(subject, recursiveGroup, nodeBigA, ResourceTreeHelper.getSubtree(nodeLittleA));
                    assert (false) : "Failed: removed non-existent successfully: node = " + nodeBigA.getName();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            catch (Throwable t) {
                this.handleThrowable(t);
            }
            finally {
                this.handleTransaction();
            }
            try {
                this.getTransactionManager().begin();
                this.implicitGroupMembershipRemoveHelper(subject, recursiveGroup, nodeLittleA, new ArrayList<Resource>());
            }
            catch (Throwable t) {
                this.handleThrowable(t);
            }
            finally {
                this.handleTransaction();
            }
            try {
                this.getTransactionManager().begin();
                try {
                    Resource nodeBigB = ResourceTreeHelper.findNode(fullTree, "B");
                    this.implicitGroupMembershipRemoveHelper(subject, recursiveGroup, nodeBigB, ResourceTreeHelper.getSubtree(nodeBigA));
                    assert (false) : "Failed: removed non-existent successfully: node = " + nodeBigB.getName();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            catch (Throwable t) {
                this.handleThrowable(t);
            }
            finally {
                this.handleTransaction();
            }
            try {
                this.getTransactionManager().begin();
                resultsExplicit = this.resourceManager.findExplicitResourcesByResourceGroup(subject, recursiveGroup, PageControl.getUnlimitedInstance());
                this.verifyEqualByIds("explicit remove 0", new ArrayList<Resource>(), (List<Resource>)resultsExplicit);
            }
            catch (Throwable t) {
                this.handleThrowable(t);
            }
            finally {
                this.handleTransaction();
            }
        }
        catch (Throwable throwable) {
            try {
                this.getTransactionManager().begin();
                EntityManager em2 = this.getEntityManager();
                Subject overlord = this.subjectManager.getOverlord();
                if (null != subject) {
                    this.subjectManager.deleteUsers(overlord, new int[]{subject.getId()});
                }
                if (null != role) {
                    this.roleManager.deleteRoles(overlord, new int[]{role.getId()});
                }
                if (null != recursiveGroup) {
                    this.resourceGroupManager.deleteResourceGroup(overlord, recursiveGroup.getId());
                }
                if (null == fullTree) throw throwable;
                ResourceTreeHelper.deleteForest(em2, fullTree);
                throw throwable;
            }
            catch (Throwable t) {
                this.handleThrowable(t);
                throw throwable;
            }
            finally {
                this.handleTransaction();
            }
        }
        try {
            this.getTransactionManager().begin();
            em = this.getEntityManager();
            Subject overlord = this.subjectManager.getOverlord();
            if (null != subject) {
                this.subjectManager.deleteUsers(overlord, new int[]{subject.getId()});
            }
            if (null != role) {
                this.roleManager.deleteRoles(overlord, new int[]{role.getId()});
            }
            if (null != recursiveGroup) {
                this.resourceGroupManager.deleteResourceGroup(overlord, recursiveGroup.getId());
            }
            if (null == fullTree) return;
            ResourceTreeHelper.deleteForest(em, fullTree);
            return;
        }
        catch (Throwable t) {
            this.handleThrowable(t);
            return;
        }
        finally {
            this.handleTransaction();
        }
    }

    private void handleTransaction() {
        try {
            if (this.getTransactionManager().getTransaction().getStatus() == 1) {
                this.getTransactionManager().rollback();
            } else {
                this.getTransactionManager().commit();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void handleThrowable(Throwable t) throws Throwable {
        if (t instanceof SQLException) {
            String error = JDBCUtil.convertSQLExceptionToString((SQLException)((SQLException)t));
            System.err.println(error);
        } else {
            t.printStackTrace();
        }
        throw t;
    }

    private void printGroup(String prefix, Subject subject, ResourceGroup group) {
        this.print(prefix + ": exp", (List<Resource>)this.resourceManager.findExplicitResourcesByResourceGroup(subject, group, PageControl.getUnlimitedInstance()));
        this.print(prefix + ": imp", (List<Resource>)this.resourceManager.findImplicitResourcesByResourceGroup(subject, group, PageControl.getUnlimitedInstance()));
    }

    private void print(String prefix, List<Resource> resources) {
        System.out.print(prefix + ": ");
        for (Resource res : resources) {
            System.out.print(res.getName() + " ");
        }
        System.out.println();
    }

    private void implicitGroupMembershipAddHelper(Subject subject, ResourceGroup recursiveGroup, Resource node, List<Resource> expectedResults) {
        this.printGroup("complex implicit before add: node = " + node.getName() + " [" + node.getId() + "]", subject, recursiveGroup);
        this.resourceGroupManager.addResourcesToGroup(subject, recursiveGroup.getId(), new int[]{node.getId()});
        this.printGroup("complex implicit after add: node = " + node.getName() + " [" + node.getId() + "]", subject, recursiveGroup);
        PageList implicitResources = this.resourceManager.findImplicitResourcesByResourceGroup(subject, recursiveGroup, PageControl.getUnlimitedInstance());
        this.verifyEqualByIds("Failed: complex implicit add: node = " + node.getName() + " [" + node.getId() + "]", expectedResults, (List<Resource>)implicitResources);
    }

    private void implicitGroupMembershipRemoveHelper(Subject subject, ResourceGroup recursiveGroup, Resource node, List<Resource> expectedResults) {
        this.printGroup("complex implicit before remove: node = " + node.getName() + " [" + node.getId() + "]", subject, recursiveGroup);
        this.resourceGroupManager.removeResourcesFromGroup(subject, recursiveGroup.getId(), new int[]{node.getId()});
        this.printGroup("complex implicit after remove: node = " + node.getName() + " [" + node.getId() + "]", subject, recursiveGroup);
        PageList implicitResources = this.resourceManager.findImplicitResourcesByResourceGroup(subject, recursiveGroup, PageControl.getUnlimitedInstance());
        this.verifyEqualByIds("Failed: complex implicit remove: node = " + node.getName() + " [" + node.getId() + "]", expectedResults, (List<Resource>)implicitResources);
    }

    private void verifyEqualByIds(String errorMessage, List<Resource> expected, List<Resource> results) {
        List<Integer> expectedIds = this.getIds(expected);
        List<Integer> resultsIds = this.getIds(results);
        this.verifyEqual(errorMessage, expectedIds, resultsIds);
    }

    private void verifyEqual(String errorMessage, List<Integer> expectedIds, List<Integer> resultsIds) {
        assert (expectedIds.containsAll(resultsIds) && resultsIds.containsAll(expectedIds)) : errorMessage + "\nexpected = " + expectedIds + "\nresults = " + resultsIds;
    }

    private List<Integer> getIds(List<Resource> resources) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (Resource res : resources) {
            results.add(res.getId());
        }
        Collections.sort(results);
        return results;
    }

    private List<Resource> getSimpleTree(EntityManager em) {
        return ResourceTreeHelper.createTree(em, "A=1,2; 1=a,b; a=i,ii; b=iii,iv; B=3");
    }
}

