/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.util.Arrays;
import java.util.Collections;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.resource.metadata.MetadataBeanTest;
import org.testng.annotations.Test;

public class ContentMetadataManagerBeanTest
extends MetadataBeanTest {
    @Test(groups={"plugin.metadata", "Content.NewPlugin"})
    public void registerContentPlugin() throws Exception {
        this.createPlugin("content-test-plugin", "1.0", "plugin_v1.xml");
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnGroups={"Content.NewPlugin"})
    public void upgradeContentPlugin() throws Exception {
        this.createPlugin("content-test-plugin", "2.0", "plugin_v2.xml");
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void addPackageTypes() throws Exception {
        this.assertResourceTypeAssociationEquals("ContentServer1", "ContentMetadataManagerBeanTestPlugin", "packageTypes", Arrays.asList("ContentServer1.Content.1", "ContentServer1.Content.2"));
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void deletePackageTypes() throws Exception {
        this.assertResourceTypeAssociationEquals("ContentServer2", "ContentMetadataManagerBeanTestPlugin", "packageTypes", Collections.EMPTY_LIST);
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void deletePackageTypesThatExistsInOldResourceTypeButNotInNewResourceType() throws Exception {
        this.assertResourceTypeAssociationEquals("ContentServer3", "ContentMetadataManagerBeanTestPlugin", "packageTypes", Arrays.asList("ContentServer3.Content.2", "ContentServer3.Content.3"));
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void addPackageThatAreAddedInNewResourceType() throws Exception {
        this.assertResourceTypeAssociationEquals("ContentServer4", "ContentMetadataManagerBeanTestPlugin", "packageTypes", Arrays.asList("ContentServer4.Content.1", "ContentServer4.Content.2"));
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void addNewDeploymentConfigurationDefinition() throws Exception {
        PackageType packageType = this.loadPackageType("ContentServer", "ContentMetadataManagerBeanTestPlugin", "ContentServer.Content.1");
        ConfigurationDefinition deploymentConfigDef = packageType.getDeploymentConfigurationDefinition();
        this.assertNotNull("Failed to create new deployment configuration definition for package type that previously did not have one", deploymentConfigDef);
        this.assertEquals("Expected to find 1 property definition in new deployment configuration definition", 1, deploymentConfigDef.getPropertyDefinitions().size());
        this.assertNotNull("Expected to find 1 property definition, <version>, in new deployment configuration definition", deploymentConfigDef.get("version"));
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void updateDeploymentConfigDefThatExistsInOldAndNewResourceType() throws Exception {
        PackageType packageType = this.loadPackageType("ContentServer5", "ContentMetadataManagerBeanTestPlugin", "ContentServer5.Content.1");
        ConfigurationDefinition deploymentConfigDef = packageType.getDeploymentConfigurationDefinition();
        this.assertNotNull("Failed to update deployment configuration definition for package type", deploymentConfigDef);
        this.assertEquals("Expected to find 2 property definitions in updated deployment configuration definition", 2, deploymentConfigDef.getPropertyDefinitions().size());
        this.assertNotNull("Expected existing property definition to be retained across update", deploymentConfigDef.get("x"));
        this.assertNotNull("Expected new property definition to be added during update", deploymentConfigDef.get("y"));
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void deleteDeploymentConfigDefThatIsRemovedInNewResourceType() {
        PackageType packageType = this.loadPackageType("ContentServer5", "ContentMetadataManagerBeanTestPlugin", "ContentServer5.Content.2");
        this.assertNull("Expected deployment configuration definition to be removed since it was removed from new resource type", packageType.getDeploymentConfigurationDefinition());
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void updateBundleType() {
        ResourceType resourceType = this.loadResourceTypeWithBundleType("ContentServer7", "ContentMetadataManagerBeanTestPlugin");
        BundleType bundleType = resourceType.getBundleType();
        this.assertNotNull("Failed to upgrade bundle type", bundleType);
        this.assertEquals("Failed to upgrade bundle type correctly. The bundle type name is wrong", "ContentServer.Bundle.2", bundleType.getName());
    }

    @Test(groups={"plugin.metadata", "Content.UpgradePlugin"}, dependsOnMethods={"upgradeContentPlugin"})
    public void addBundleTypeThatOnlyExistsInNewResourceType() {
        ResourceType resourceType = this.loadResourceTypeWithBundleType("ContentServer6", "ContentMetadataManagerBeanTestPlugin");
        BundleType bundleType = resourceType.getBundleType();
        this.assertNotNull("Expected to find bundle type added during upgrade", bundleType);
        this.assertEquals("Failed to correctly add bundle type during upgrade", "ContentServer6.Bundle.1", bundleType.getName());
    }

    @Test(priority=10, alwaysRun=true, dependsOnGroups={"Content.UpgradePlugin"})
    public void afterClassWorkTest() throws Exception {
        this.afterClassWork();
    }

    PackageType loadPackageType(String resourceType, String plugin, String packageType) {
        return (PackageType)this.getEntityManager().createQuery("from PackageType p left join fetch p.deploymentConfigurationDefinition pdcd where p.name = :packageType and p.resourceType.name = :resourceType and p.resourceType.plugin = :plugin").setParameter("packageType", (Object)packageType).setParameter("plugin", (Object)plugin).setParameter("resourceType", (Object)resourceType).getSingleResult();
    }

    ResourceType loadResourceTypeWithBundleType(String resourceType, String plugin) {
        return (ResourceType)this.getEntityManager().createQuery("from  ResourceType t left join fetch t.bundleType tbt where t.name = :resourceType and t.plugin = :plugin").setParameter("resourceType", (Object)resourceType).setParameter("plugin", (Object)plugin).getSingleResult();
    }
}

