/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.util.Arrays;
import java.util.Collections;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.enterprise.server.resource.metadata.MetadataBeanTest;
import org.testng.annotations.Test;

public class EventMetadataManagerBeanTest
extends MetadataBeanTest {
    @Test(groups={"plugin.metadata", "Events.NewPlugin"})
    public void registerEventsPlugin() throws Exception {
        this.createPlugin("event-test-plugin", "1.0", "plugin_v1.xml");
    }

    @Test(groups={"plugin.metadata", "Events.NewPlugin"}, dependsOnMethods={"registerEventsPlugin"})
    public void persistNewEventDefs() throws Exception {
        this.assertResourceTypeAssociationEquals("EventServer1", "EventMetadataManagerBeanTestPlugin", "eventDefinitions", Arrays.asList("event1", "event2"));
    }

    @Test(groups={"plugin.metadata", "Events.NewPlugin"}, dependsOnMethods={"persistNewEventDefs"})
    public void persistNewEventDefProperties() {
        EventDefinition eventDef = this.loadEventDef("event1", "EventServer1");
        this.assertEquals("Failed to set EventDefinition.name", "event1", eventDef.getName());
        this.assertEquals("Failed to set EventDefinition.description", "Event 1", eventDef.getDescription());
    }

    @Test(groups={"plugin.metadata", "Events.UpgradePlugin"}, dependsOnGroups={"Events.NewPlugin"})
    public void upgradeEventsPlugin() throws Exception {
        this.createPlugin("event-test-plugin", "2.0", "plugin_v2.xml");
    }

    @Test(groups={"plugin.metadata", "Events.UpgradePlugin"}, dependsOnMethods={"upgradeEventsPlugin"})
    public void retainEventDefsOfTypeThatIsNotChangedDuringUpgrade() throws Exception {
        this.assertResourceTypeAssociationEquals("EventServer1", "EventMetadataManagerBeanTestPlugin", "eventDefinitions", Arrays.asList("event1", "event2"));
    }

    @Test(groups={"plugin.metadata", "Events.UpgradePlugin"}, dependsOnMethods={"upgradeEventsPlugin"})
    public void addNewEventDefs() throws Exception {
        this.assertResourceTypeAssociationEquals("EventServer2", "EventMetadataManagerBeanTestPlugin", "eventDefinitions", Arrays.asList("event1", "event2"));
    }

    @Test(groups={"plugin.metadata", "Events.UpgradePlugin"}, dependsOnMethods={"upgradeEventsPlugin"})
    public void deleteEventDefsThatHaveBeenRemovedInUpgradedType() throws Exception {
        this.assertResourceTypeAssociationEquals("EventServer3", "EventMetadataManagerBeanTestPlugin", "eventDefinitions", Collections.EMPTY_LIST);
    }

    @Test(groups={"plugin.metadata", "Events.UpgradePlugin"}, dependsOnMethods={"upgradeEventsPlugin"})
    public void updateExistingEventDefs() throws Exception {
        this.assertResourceTypeAssociationEquals("EventServer4", "EventMetadataManagerBeanTestPlugin", "eventDefinitions", Arrays.asList("event1", "event3"));
        EventDefinition eventDef = this.loadEventDef("event1", "EventServer4");
        this.assertEquals("The description property should have been updated", "EVENT ONE", eventDef.getDescription());
    }

    @Test(priority=10, alwaysRun=true, dependsOnGroups={"Events.UpgradePlugin"})
    public void afterClassWorkTest() throws Exception {
        this.afterClassWork();
    }

    EventDefinition loadEventDef(String name, String resourceType) {
        return (EventDefinition)this.getEntityManager().createQuery("from  EventDefinition e where e.name = :name and e.resourceType.name = :resourceType").setParameter("name", (Object)name).setParameter("resourceType", (Object)resourceType).getSingleResult();
    }
}

