/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlProducer;
import org.dbunit.ext.oracle.Oracle10DataTypeFactory;
import org.dbunit.ext.oracle.OracleDataTypeFactory;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;
import org.dbunit.operation.DatabaseOperation;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.clientapi.shared.PluginDescriptorUtil;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.bundle.TestBundlePluginComponent;
import org.rhq.enterprise.server.bundle.TestBundleServerPluginService;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.scheduler.jobs.PurgePluginsJob;
import org.rhq.enterprise.server.scheduler.jobs.PurgeResourceTypesJob;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.xml.sax.InputSource;

public class MetadataBeanTest
extends AbstractEJB3Test {
    private final String objectFileName = "pluginIds.obj";
    private Set<Integer> pluginIds;

    protected void afterClassWork() throws Exception {
        PluginManagerLocal pluginMgr = LookupUtil.getPluginManager();
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        ArrayList<Integer> doomedPlugins = new ArrayList<Integer>(this.pluginIds);
        pluginMgr.deletePlugins(overlord, doomedPlugins);
        this.ackDeletedPlugins();
        new PurgeResourceTypesJob().executeJobCode(null);
        new PurgePluginsJob().executeJobCode(null);
        this.pluginIds.clear();
        this.deleteObjects("pluginIds.obj");
    }

    @Override
    protected void beforeMethod() throws Exception {
        this.setupDB();
        TestBundleServerPluginService bundleService = new TestBundleServerPluginService(this.getTempDir(), new TestBundlePluginComponent());
        this.prepareCustomServerPluginService(bundleService);
        bundleService.startMasterPluginContainerWithoutSchedulingJobs();
        this.prepareScheduler();
        this.preparePluginScannerService();
        try {
            List<Object> objects = this.readObjects("pluginIds.obj", 1);
            this.pluginIds = (Set)objects.get(0);
        }
        catch (Throwable t) {
            this.pluginIds = new HashSet<Integer>();
        }
    }

    @Override
    protected void afterMethod() throws Exception {
        if (!this.pluginIds.isEmpty()) {
            this.writeObjects("pluginIds.obj", this.pluginIds);
        }
        this.unpreparePluginScannerService();
        this.unprepareServerPluginService();
        this.unprepareScheduler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupDB() throws Exception {
        Connection connection = null;
        try {
            connection = MetadataBeanTest.getConnection();
            DatabaseConnection dbunitConnection = new DatabaseConnection(connection);
            this.setDbType((IDatabaseConnection)dbunitConnection);
            DatabaseOperation.REFRESH.execute((IDatabaseConnection)dbunitConnection, this.getDataSet());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private void setDbType(IDatabaseConnection connection) throws Exception {
        DatabaseConfig config = connection.getConfig();
        String name = connection.getConnection().getMetaData().getDatabaseProductName().toLowerCase();
        int major = connection.getConnection().getMetaData().getDatabaseMajorVersion();
        Object type = null;
        if (name.contains("postgres")) {
            type = new PostgresqlDataTypeFactory();
        } else if (name.contains("oracle")) {
            type = major >= 10 ? new Oracle10DataTypeFactory() : new OracleDataTypeFactory();
        }
        if (type != null) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", type);
        }
    }

    private IDataSet getDataSet() throws DataSetException {
        FlatXmlProducer xmlProducer = new FlatXmlProducer(new InputSource(((Object)((Object)this)).getClass().getResourceAsStream(this.getDataSetFile())));
        xmlProducer.setColumnSensing(true);
        return new FlatXmlDataSet(xmlProducer);
    }

    protected String getDataSetFile() {
        return "MetadataTest.xml";
    }

    protected void createPlugin(String pluginFileName, String version, String descriptorFileName) throws Exception {
        URL descriptorURL = this.getDescriptorURL(descriptorFileName);
        PluginDescriptor pluginDescriptor = PluginDescriptorUtil.loadPluginDescriptor((URL)descriptorURL);
        String pluginFilePath = this.getPluginScannerService().getAgentPluginDir() + "/" + pluginFileName + ".jar";
        Plugin plugin = new Plugin(pluginDescriptor.getName(), pluginFilePath);
        plugin.setDisplayName(pluginDescriptor.getName());
        plugin.setEnabled(true);
        plugin.setDescription(pluginDescriptor.getDescription());
        plugin.setAmpsVersion(this.getAmpsVersion(pluginDescriptor));
        plugin.setVersion(pluginDescriptor.getVersion());
        plugin.setMD5(MessageDigestGenerator.getDigestString((URL)descriptorURL));
        PluginManagerLocal pluginMgr = LookupUtil.getPluginManager();
        pluginMgr.registerPlugin(plugin, pluginDescriptor, null, true);
        this.pluginIds.add(plugin.getId());
    }

    private URL getDescriptorURL(String descriptor) {
        String dir = ((Object)((Object)this)).getClass().getSimpleName();
        return ((Object)((Object)this)).getClass().getResource(dir + "/" + descriptor);
    }

    String getAmpsVersion(PluginDescriptor pluginDescriptor) {
        ComparableVersion version2;
        if (pluginDescriptor.getAmpsVersion() == null) {
            return "2.0";
        }
        ComparableVersion version = new ComparableVersion(pluginDescriptor.getAmpsVersion());
        if (version.compareTo((Object)(version2 = new ComparableVersion("2.0"))) <= 0) {
            return "2.0";
        }
        return pluginDescriptor.getAmpsVersion();
    }

    protected ResourceType assertResourceTypeAssociationEquals(String resourceTypeName, String plugin, String propertyName, List<String> expected) throws Exception {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        String fetch = "fetch" + WordUtils.capitalize((String)propertyName);
        ResourceTypeCriteria criteria = new ResourceTypeCriteria();
        criteria.addFilterName(resourceTypeName);
        criteria.addFilterPluginName(plugin);
        criteria.setStrict(true);
        criteria.fetchBundleConfiguration(true);
        criteria.fetchDriftDefinitionTemplates(true);
        MethodUtils.invokeMethod((Object)criteria, (String)fetch, (Object)true);
        PageList resourceTypes = resourceTypeMgr.findResourceTypesByCriteria(subjectMgr.getOverlord(), criteria);
        this.assertEquals("too many types!", 1, resourceTypes.size());
        ResourceType resourceType = (ResourceType)resourceTypes.get(0);
        HashSet<String> expectedSet = new HashSet<String>(expected);
        ArrayList<String> missing = new ArrayList<String>();
        ArrayList<String> unexpected = new ArrayList<String>();
        for (String expectedProperty : expectedSet) {
            if (this.contains(resourceType, propertyName, expectedProperty)) continue;
            missing.add(expectedProperty);
        }
        Collection actualPropertyValues = (Collection)PropertyUtils.getProperty((Object)resourceType, (String)propertyName);
        for (Object actualPropertyValue : actualPropertyValues) {
            String actualName = (String)PropertyUtils.getProperty(actualPropertyValue, (String)"name");
            if (expectedSet.contains(actualName)) continue;
            unexpected.add(actualName);
        }
        String errors = "";
        if (!missing.isEmpty()) {
            errors = "Failed to find the following " + propertyName + "(s) for type " + resourceTypeName + ": " + missing;
        }
        if (unexpected.size() > 0) {
            errors = errors + "\nFound unexpected " + propertyName + "(s) for type " + resourceTypeName + ": " + unexpected;
        }
        assert (errors.isEmpty()) : errors;
        return resourceType;
    }

    private boolean contains(ResourceType type, String propertyName, String expected) throws Exception {
        Collection actualPropertyValues = (Collection)PropertyUtils.getProperty((Object)type, (String)propertyName);
        for (Object actualPropertyValue : actualPropertyValues) {
            String actualName = (String)PropertyUtils.getProperty(actualPropertyValue, (String)"name");
            if (!actualName.equals(expected)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createPluginJarFile(String jarName, String descriptorXmlFilename) throws Exception {
        FileOutputStream stream = null;
        ZipOutputStream out = null;
        InputStream in = null;
        try {
            String pluginDirPath = this.getPluginScannerService().getAgentPluginDir();
            File pluginDir = new File(pluginDirPath);
            pluginDir.mkdirs();
            File jarFile = new File(pluginDir, jarName);
            jarFile.delete();
            stream = new FileOutputStream(jarFile);
            out = new JarOutputStream(stream);
            JarEntry jarAdd = new JarEntry("META-INF/rhq-plugin.xml");
            jarAdd.setTime(System.currentTimeMillis());
            ((JarOutputStream)out).putNextEntry(jarAdd);
            URL descriptorURL = this.getDescriptorURL(descriptorXmlFilename);
            in = descriptorURL.openStream();
            StreamUtil.copy((InputStream)in, (OutputStream)out, (boolean)false);
            File file = jarFile;
            return file;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    protected void pluginDeployed(String pluginName) {
        PluginManagerLocal pluginMgr = LookupUtil.getPluginManager();
        Plugin plugin = pluginMgr.getPlugin(pluginName);
        if (plugin != null) {
            this.pluginIds.add(plugin.getId());
        }
    }

    protected void ignoreType(String typeName, String pluginName) {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceTypeManagerLocal typeMgr = LookupUtil.getResourceTypeManager();
        ResourceType rt = typeMgr.getResourceTypeByNameAndPlugin(typeName, pluginName);
        if (rt == null) {
            this.fail("Should have had a resource type named [" + typeName + "] from plugin [" + pluginName + "]");
        }
        typeMgr.setResourceTypeIgnoreFlagAndUninventoryResources(subjectMgr.getOverlord(), rt.getId(), true);
        rt = typeMgr.getResourceTypeByNameAndPlugin(typeName, pluginName);
        if (!rt.isIgnored()) {
            this.fail("Should have ignored resource type [" + rt + "]");
        }
    }
}

