/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.metadata.MetadataBeanTest;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

@Test(groups={"plugin.metadata.ignoretypes"})
public class MetadataUpdateWithIgnoredTypesTest
extends MetadataBeanTest {
    private static final String PLUGIN_NAME = "RemoveIgnoredTypesPlugin";

    @Override
    protected void afterMethod() throws Exception {
        this.afterClassWork();
        super.afterMethod();
    }

    @Test
    public void upgradePluginWithIgnoredTypes() throws Exception {
        this.performTest(true);
    }

    private void performTest(boolean ignoreTypes) throws Exception {
        this.createPlugin("remove-types-plugin", "1.0", "remove_types_v1.xml");
        this.ignoreAndGetPersistedType("ServerA", ignoreTypes);
        this.ignoreAndGetPersistedType("ServerA.Child1", ignoreTypes);
        this.ignoreAndGetPersistedType("ServerB", ignoreTypes);
        this.ignoreAndGetPersistedType("ServerB.Child1", ignoreTypes);
        this.ignoreAndGetPersistedType("ServerB.GrandChild1", ignoreTypes);
        this.ignoreAndGetPersistedType("ServerC", ignoreTypes);
        this.ignoreAndGetPersistedType("ServerC.Child1", ignoreTypes);
        this.ignoreAndGetPersistedType("ServerD", ignoreTypes);
        this.createPlugin("remove-types-plugin", "2.0", "remove_types_v2.xml");
        String newDescription = "v2";
        ResourceType serverA = this.getPersistedTypeAndAssert("ServerA", "v2", ignoreTypes);
        ResourceType serverA_Child1 = this.getPersistedTypeAndAssert("ServerA.Child1", "v2", ignoreTypes);
        ResourceType serverB = this.getPersistedTypeAndAssert("ServerB", "v2", ignoreTypes);
        this.assertTypeDeleted("ServerB.Child1");
        ResourceType serverB_GrandChild1 = this.getPersistedTypeAndAssert("ServerB.GrandChild1", "v2", ignoreTypes);
        ResourceType serverC = this.getPersistedTypeAndAssert("ServerC", "v2", ignoreTypes);
        this.assertTypeDeleted("ServerC.Child1");
        this.assertTypeDeleted("ServerD");
    }

    private ResourceType getPersistedTypeAndAssert(String typeName, String description, boolean isIgnored) {
        ResourceType rt = this.ignoreAndGetPersistedType(typeName, false);
        this.assertEquals(description, rt.getDescription());
        this.assertEquals(isIgnored, rt.isIgnored());
        return rt;
    }

    private ResourceType ignoreAndGetPersistedType(String typeName, boolean ignore) {
        ResourceTypeManagerLocal typeMgr = LookupUtil.getResourceTypeManager();
        ResourceType rt = typeMgr.getResourceTypeByNameAndPlugin(typeName, PLUGIN_NAME);
        if (rt == null) {
            this.fail("The following type was not found: " + typeName);
        }
        if (ignore) {
            SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
            typeMgr.setResourceTypeIgnoreFlagAndUninventoryResources(subjectMgr.getOverlord(), rt.getId(), true);
            rt = typeMgr.getResourceTypeByNameAndPlugin(typeName, PLUGIN_NAME);
            if (rt == null) {
                this.fail("Failed to reload type after ignoring it: " + typeName);
            }
            assert (rt.isIgnored()) : "Somehow the type didn't get ignored: " + rt;
        }
        return rt;
    }

    private void assertTypeDeleted(String typeName) {
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        ResourceType rt = resourceTypeMgr.getResourceTypeByNameAndPlugin(typeName, PLUGIN_NAME);
        if (rt != null) {
            this.fail("The following type was supposed to be deleted: " + typeName);
        }
    }
}

