/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.metadata.MetadataBeanTest;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

@Test(groups={"plugin.multiple.extension.metadata", "plugin.metadata"})
public class MultiplePluginExtensionMetadataTest
extends MetadataBeanTest {
    private static final String PLUGIN_NAME_PARENT = "MultiplePluginExtensionMetadataParentTestPlugin";
    private static final String PLUGIN_NAME_CHILD1 = "PluginExtensionMetadataChild1TestPlugin";
    private static final String PLUGIN_NAME_CHILD2 = "PluginExtensionMetadataChild2TestPlugin";
    private static final String TYPE_NAME_PARENT = "ParentServerA";
    private static final String TYPE_NAME_CHILD1 = "Child1ServerA";
    private static final String TYPE_NAME_CHILD2 = "Child2ServerA";
    private static final String OP_NAME = "A-op";
    private static final int OP_TIMEOUT = 123456;
    private static final String OP_DESC = "a op";
    private static final String NEW_OP_NAME = "A-op-NEW";
    private static final int NEW_OP_TIMEOUT = 987654;
    private static final String NEW_OP_DESC = "a new op";
    private SubjectManagerLocal subjectMgr;
    private ResourceTypeManagerLocal resourceTypeMgr;

    public void testRegisterPlugins() throws Exception {
        this.doTheTest(false);
    }

    public void testRegisterPluginsWithIgnoredTypes() throws Exception {
        this.doTheTest(true);
    }

    private void doTheTest(boolean ignoreTypes) throws Exception {
        this.subjectMgr = LookupUtil.getSubjectManager();
        this.resourceTypeMgr = LookupUtil.getResourceTypeManager();
        this.registerParentPluginV1(ignoreTypes);
        this.registerChild1PluginV1(ignoreTypes);
        this.registerChild2PluginV1(ignoreTypes);
        this.registerParentPluginV2(ignoreTypes);
        this.checkChild1Plugin(ignoreTypes);
        this.checkChild2Plugin(ignoreTypes);
    }

    @Test(priority=10, alwaysRun=true, dependsOnMethods={"testRegisterPlugins"})
    public void afterClassWorkTest() throws Exception {
        this.afterClassWork();
    }

    private void registerParentPluginV1(boolean ignoreTypes) throws Exception {
        this.createPlugin("parent-plugin.jar", "1.0", "parent_plugin_v1.xml");
        if (ignoreTypes) {
            this.ignoreType(TYPE_NAME_PARENT, PLUGIN_NAME_PARENT);
        }
        ResourceType resourceType = this.loadResourceTypeFully(TYPE_NAME_PARENT, PLUGIN_NAME_PARENT);
        assert (resourceType.getName().equals(TYPE_NAME_PARENT));
        assert (resourceType.getPlugin().equals(PLUGIN_NAME_PARENT));
        assert (resourceType.isIgnored() == ignoreTypes);
        this.assertVersion1(resourceType);
    }

    private void registerChild1PluginV1(boolean ignoreTypes) throws Exception {
        this.createPlugin("child1-plugin.jar", "1.0", "child1_plugin_v1.xml");
        if (ignoreTypes) {
            this.ignoreType(TYPE_NAME_CHILD1, PLUGIN_NAME_CHILD1);
        }
        ResourceType resourceType = this.loadResourceTypeFully(TYPE_NAME_CHILD1, PLUGIN_NAME_CHILD1);
        assert (resourceType.getName().equals(TYPE_NAME_CHILD1));
        assert (resourceType.getPlugin().equals(PLUGIN_NAME_CHILD1));
        assert (resourceType.isIgnored() == ignoreTypes);
        this.assertVersion1(resourceType);
        assert (resourceType.getParentResourceTypes() != null);
        assert (resourceType.getParentResourceTypes().size() == 1);
        assert (((ResourceType)resourceType.getParentResourceTypes().iterator().next()).getName().equals("OuterServerA"));
    }

    private void registerChild2PluginV1(boolean ignoreTypes) throws Exception {
        this.createPlugin("child2-plugin.jar", "1.0", "child2_plugin_v1.xml");
        if (ignoreTypes) {
            this.ignoreType(TYPE_NAME_CHILD2, PLUGIN_NAME_CHILD2);
        }
        ResourceType resourceType = this.loadResourceTypeFully(TYPE_NAME_CHILD2, PLUGIN_NAME_CHILD2);
        assert (resourceType.getName().equals(TYPE_NAME_CHILD2));
        assert (resourceType.getPlugin().equals(PLUGIN_NAME_CHILD2));
        assert (resourceType.isIgnored() == ignoreTypes);
        this.assertVersion1(resourceType);
    }

    private void registerParentPluginV2(boolean ignoreTypes) throws Exception {
        this.createPlugin("parent-plugin.jar", "2.0", "parent_plugin_v2.xml");
        ResourceType resourceType = this.loadResourceTypeFully(TYPE_NAME_PARENT, PLUGIN_NAME_PARENT);
        assert (resourceType.getName().equals(TYPE_NAME_PARENT));
        assert (resourceType.getPlugin().equals(PLUGIN_NAME_PARENT));
        assert (resourceType.isIgnored() == ignoreTypes);
        this.assertVersion2(resourceType);
    }

    private void checkChild1Plugin(boolean ignoreTypes) throws Exception {
        ResourceType resourceType = this.loadResourceTypeFully(TYPE_NAME_CHILD1, PLUGIN_NAME_CHILD1);
        assert (resourceType.getName().equals(TYPE_NAME_CHILD1));
        assert (resourceType.getPlugin().equals(PLUGIN_NAME_CHILD1));
        assert (resourceType.isIgnored() == ignoreTypes);
        this.assertVersion2(resourceType);
        assert (resourceType.getParentResourceTypes() != null);
        assert (resourceType.getParentResourceTypes().size() == 1);
        assert (((ResourceType)resourceType.getParentResourceTypes().iterator().next()).getName().equals("OuterServerA"));
    }

    private void checkChild2Plugin(boolean ignoreTypes) throws Exception {
        ResourceType resourceType = this.loadResourceTypeFully(TYPE_NAME_CHILD2, PLUGIN_NAME_CHILD2);
        assert (resourceType.getName().equals(TYPE_NAME_CHILD2));
        assert (resourceType.getPlugin().equals(PLUGIN_NAME_CHILD2));
        assert (resourceType.isIgnored() == ignoreTypes);
        this.assertVersion2(resourceType);
    }

    private void assertVersion1(ResourceType resourceType) {
        assert (resourceType.getOperationDefinitions().size() == 1);
        OperationDefinition op = (OperationDefinition)resourceType.getOperationDefinitions().iterator().next();
        assert (op.getName().equals(OP_NAME));
        assert (op.getTimeout() == 123456);
        assert (op.getDescription().equals(OP_DESC));
    }

    private void assertVersion2(ResourceType resourceType) {
        assert (resourceType.getOperationDefinitions().size() == 1);
        OperationDefinition op = (OperationDefinition)resourceType.getOperationDefinitions().iterator().next();
        assert (op.getName().equals(NEW_OP_NAME));
        assert (op.getTimeout() == 987654);
        assert (op.getDescription().equals(NEW_OP_DESC));
    }

    private ResourceType loadResourceTypeFully(String typeName, String typePlugin) {
        ResourceTypeCriteria c = new ResourceTypeCriteria();
        c.addFilterName(typeName);
        c.addFilterPluginName(typePlugin);
        c.addFilterIgnored(null);
        c.setStrict(true);
        c.fetchParentResourceTypes(true);
        c.fetchOperationDefinitions(true);
        PageList t = this.resourceTypeMgr.findResourceTypesByCriteria(this.subjectMgr.getOverlord(), c);
        ResourceType resourceType = (ResourceType)t.get(0);
        return resourceType;
    }
}

