/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.resource.metadata.MetadataBeanTest;
import org.testng.annotations.Test;

public class OperationMetadataManagerBeanTest
extends MetadataBeanTest {
    @Test(groups={"plugin.metadata", "Operations.NewPlugin"})
    public void registerOperationsPlugin() throws Exception {
        this.createPlugin("operation-test-plugin", "1.0", "plugin_v1.xml");
    }

    @Test(groups={"plugin.metadata", "Operations.NewPlugin"}, dependsOnMethods={"registerOperationsPlugin"})
    public void createTypeWithOperationDefWithNoParamsAndNoResults() throws Exception {
        this.assertResourceTypeAssociationEquals("OperationServer1", "OperationMetadataManagerBeanTestPlugin", "operationDefinitions", Arrays.asList("OperationServer1.Operation1"));
    }

    @Test(groups={"plugin.metadata", "Operations.NewPlugin"}, dependsOnMethods={"registerOperationsPlugin"})
    public void createTypeWithOperationDefWithParams() {
        ResourceType resourceType = this.loadResourceTypeWithOperationDefs("OperationServer11", "OperationMetadataManagerBeanTestPlugin");
        ArrayList operationDefs = new ArrayList(resourceType.getOperationDefinitions());
        this.assertEquals("Expected to find an operation definition", 1, operationDefs.size());
        ConfigurationDefinition params = ((OperationDefinition)operationDefs.get(0)).getParametersConfigurationDefinition();
        this.assertNotNull("Expected to find parameters for operation definition", params);
        this.assertEquals("Expected to find 2 parameters", 2, params.getPropertyDefinitions().size());
        this.assertNotNull("Expected to find parameter named <param1>", params.get("param1"));
        this.assertNotNull("Expected to find parameter named <param2>", params.get("param2"));
    }

    @Test(groups={"plugin.metadata", "Operations.UpgradePlugin"}, dependsOnGroups={"Operations.NewPlugin"})
    public void upgradeOperationsPlugin() throws Exception {
        this.createPlugin("operation-test-plugin", "2.0", "plugin_v2.xml");
    }

    @Test(groups={"plugin.metadata", "Operations.UpgradePlugin"}, dependsOnMethods={"upgradeOperationsPlugin"})
    public void addOperationToTypeThatPreviouslyHadNoOperations() throws Exception {
        this.assertResourceTypeAssociationEquals("OperationServer2", "OperationMetadataManagerBeanTestPlugin", "operationDefinitions", Arrays.asList("OperationServer2.Operation1"));
    }

    @Test(groups={"plugin.metadata", "Operations.UpgradePlugin"}, dependsOnMethods={"upgradeOperationsPlugin"})
    public void removeOperationDefFromTypeThatPreviouslyDefinedOperationDef() throws Exception {
        this.assertResourceTypeAssociationEquals("OperationServer21", "OperationMetadataManagerBeanTestPlugin", "operationDefinitions", Collections.EMPTY_LIST);
    }

    @Test(groups={"plugin.metadata", "Operations.UpgradePlugin"}, dependsOnMethods={"upgradeOperationsPlugin"})
    public void removeParamsFromUpgradedOperationDef() {
        OperationDefinition operationDef = this.loadOperationDefinition("OperationServer22.Operation1", "OperationServer22", "OperationMetadataManagerBeanTestPlugin");
        this.assertNull("Operation parameters should have been removed", operationDef.getParametersConfigurationDefinition());
    }

    @Test(groups={"plugin.metadata", "Operations.UpgradePlugin"}, dependsOnMethods={"upgradeOperationsPlugin"})
    public void addResultsToUpgradedOperationDef() {
        OperationDefinition operationDef = this.loadOperationDefinition("OperationServer23.Operation1", "OperationServer23", "OperationMetadataManagerBeanTestPlugin");
        ConfigurationDefinition resultsDef = operationDef.getResultsConfigurationDefinition();
        this.assertNotNull("Results definition should have been added", resultsDef);
        this.assertEquals("Expected results to contain one property", 1, resultsDef.getPropertyDefinitions().size());
        this.assertNotNull("Expected results to contain property named <exitCode>", resultsDef.get("exitCode"));
    }

    @Test(groups={"plugin.metadata", "Operations.UpgradePlugin"}, dependsOnMethods={"upgradeOperationsPlugin"})
    public void addParamsToUpgradedOperationDef() {
        OperationDefinition operationDef = this.loadOperationDefinition("OperationServer24.Operation1", "OperationServer24", "OperationMetadataManagerBeanTestPlugin");
        ConfigurationDefinition paramsDef = operationDef.getParametersConfigurationDefinition();
        this.assertNotNull("Operation parameters definition should have been added.", paramsDef);
        this.assertEquals("Expected to find one parameter definition.", 1, paramsDef.getPropertyDefinitions().size());
        this.assertNotNull("Expected parameters to contain property named <param1>", paramsDef.getPropertyDefinitions().get("param1"));
    }

    @Test(groups={"plugin.metadata", "Operations.UpgradePlugin"}, dependsOnMethods={"upgradeOperationsPlugin"})
    public void removeResultsInUpgradedOperationDef() {
        OperationDefinition operationDef = this.loadOperationDefinition("OperationServer24.Operation1", "OperationServer24", "OperationMetadataManagerBeanTestPlugin");
        ConfigurationDefinition resultsDef = operationDef.getResultsConfigurationDefinition();
        this.assertNull("Results definition should have been removed", resultsDef);
    }

    @Test(priority=10, alwaysRun=true, dependsOnGroups={"Operations.UpgradePlugin"})
    public void afterClassWorkTest() throws Exception {
        this.afterClassWork();
    }

    ResourceType loadResourceTypeWithOperationDefs(String resourceType, String plugin) {
        return (ResourceType)this.getEntityManager().createQuery("from  ResourceType t left join fetch t.operationDefinitions tod where t.name = :resourceType and t.plugin = :plugin").setParameter("resourceType", (Object)resourceType).setParameter("plugin", (Object)plugin).getSingleResult();
    }

    OperationDefinition loadOperationDefinition(String opName, String resourceType, String plugin) {
        return (OperationDefinition)this.getEntityManager().createQuery("from  OperationDefinition o where o.name = :operationName and o.resourceType.name = :resourceType and o.resourceType.plugin = :plugin").setParameter("operationName", (Object)opName).setParameter("resourceType", (Object)resourceType).setParameter("plugin", (Object)plugin).getSingleResult();
    }
}

