/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.util.HashSet;
import org.rhq.core.domain.bundle.ResourceTypeBundleConfiguration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyGroupDefinition;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.drift.DriftConfigurationDefinition;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionTemplate;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.ProcessScan;
import org.rhq.core.domain.resource.ResourceSubCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.metadata.MetadataBeanTest;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

@Test(groups={"plugin.extension.metadata", "plugin.metadata"})
public class PluginExtensionMetadataTest
extends MetadataBeanTest {
    private static final String PLUGIN_NAME_PARENT = "PluginExtensionMetadataParentTestPlugin";
    private static final String PLUGIN_NAME_CHILD = "PluginExtensionMetadataChildTestPlugin";
    private static final String TYPE_NAME_PARENT = "ParentServerA";
    private static final String TYPE_NAME_CHILD = "ChildServerA";
    private static final String SUBCAT = "A-subcat";
    private static final String SUBCAT_DISPLAYNAME = "a subcat";
    private static final String PC_GROUP = "A-pc-group";
    private static final boolean PC_GROUP_HIDDEN = true;
    private static final String PC_PROP = "A-pc-prop";
    private static final boolean PC_PROP_REQUIRED = false;
    private static final String PROCESS_SCAN_NAME = "A-process-scan";
    private static final String PROCESS_SCAN_QUERY = "process|basename|match=A.exe";
    private static final String OP_NAME = "A-op";
    private static final int OP_TIMEOUT = 123456;
    private static final String OP_DESC = "a op";
    private static final String METRIC_PROP = "A-metric";
    private static final long METRIC_DEFAULT_INTERVAL = 123456L;
    private static final String EVENT_NAME = "A-event";
    private static final String EVENT_DESC = "a event";
    private static final String RC_PROP = "A-rc-prop";
    private static final boolean RC_PROP_REQUIRED = false;
    private static final String DRIFT_DEF_NAME = "A-drift-def";
    private static final DriftConfigurationDefinition.BaseDirValueContext DRIFT_DEF_BASEDIR_CONTEXT = DriftConfigurationDefinition.BaseDirValueContext.pluginConfiguration;
    private static final String DRIFT_DEF_BASEDIR_VALUE = "A-pc-prop";
    private static final String BUNDLE_TARGET_NAME = "A-bundle-basedir";
    private static final ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context BUNDLE_BASEDIR_CONTEXT = ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.resourceConfiguration;
    private static final String BUNDLE_BASEDIR_VALUE = "A-rc-prop";
    private static final String CHANGED_PC_GROUP = "A-pc-group";
    private static final boolean CHANGED_PC_GROUP_HIDDEN = false;
    private static final String CHANGED_PC_PROP = "A-pc-prop-CHANGED";
    private static final boolean CHANGED_PC_PROP_REQUIRED = true;
    private static final String NEW_PC_GROUP = "A-pc-group-NEW";
    private static final boolean NEW_PC_GROUP_HIDDEN = true;
    private static final String NEW_PC_PROP = "A-pc-prop-NEW";
    private static final boolean NEW_PC_PROP_REQUIRED = false;
    private static final String CHANGED_PROCESS_SCAN_NAME = "A-process-scan";
    private static final String CHANGED_PROCESS_SCAN_QUERY = "process|basename|match=CHANGED.exe";
    private static final String NEW_PROCESS_SCAN_NAME = "A-process-scan-NEW";
    private static final String NEW_PROCESS_SCAN_QUERY = "process|basename|match=NEW.exe";
    private static final String CHANGED_OP_NAME = "A-op";
    private static final int CHANGED_OP_TIMEOUT = 987654;
    private static final String CHANGED_OP_DESC = "a changed op";
    private static final String NEW_OP_NAME = "A-op-NEW";
    private static final int NEW_OP_TIMEOUT = 111111;
    private static final String NEW_OP_DESC = "a new op";
    private static final String CHANGED_METRIC_PROP = "A-metric";
    private static final String NEW_METRIC_PROP = "A-metric-NEW";
    private static final long NEW_METRIC_DEFAULT_INTERVAL = 98765L;
    private static final String CHANGED_EVENT_NAME = "A-event-CHANGED";
    private static final String CHANGED_EVENT_DESC = "a changed event";
    private static final String NEW_EVENT_NAME = "A-event-NEW";
    private static final String NEW_EVENT_DESC = "a new event";
    private static final String CHANGED_RC_PROP = "A-rc-prop-CHANGED";
    private static final boolean CHANGED_RC_PROP_REQUIRED = true;
    private static final String NEW_RC_PROP = "A-rc-prop-NEW";
    private static final boolean NEW_RC_PROP_REQUIRED = false;
    private static final String CHANGED_DRIFT_DEF_NAME = "A-drift-def-CHANGED";
    private static final DriftConfigurationDefinition.BaseDirValueContext CHANGED_DRIFT_DEF_BASEDIR_CONTEXT = DriftConfigurationDefinition.BaseDirValueContext.pluginConfiguration;
    private static final String CHANGED_DRIFT_DEF_BASEDIR_VALUE = "A-pc-prop";
    private static final String NEW_DRIFT_DEF_NAME = "A-drift-def-NEW";
    private static final DriftConfigurationDefinition.BaseDirValueContext NEW_DRIFT_DEF_BASEDIR_CONTEXT = DriftConfigurationDefinition.BaseDirValueContext.resourceConfiguration;
    private static final String NEW_DRIFT_DEF_BASEDIR_VALUE = "A-rc-prop";
    private static final String CHANGED_BUNDLE_TARGET_NAME = "A-bundle-basedir-CHANGED";
    private static final ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context CHANGED_BUNDLE_BASEDIR_CONTEXT = ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.resourceConfiguration;
    private static final String CHANGED_BUNDLE_BASEDIR_VALUE = "A-rc-prop";
    private static final String NEW_BUNDLE_TARGET_NAME = "A-bundle-basedir-NEW";
    private static final ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context NEW_BUNDLE_BASEDIR_CONTEXT = ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.pluginConfiguration;
    private static final String NEW_BUNDLE_BASEDIR_VALUE = "A-pc-prop";
    private SubjectManagerLocal subjectMgr;
    private ResourceTypeManagerLocal resourceTypeMgr;

    public void testRegisterPlugins() throws Exception {
        this.subjectMgr = LookupUtil.getSubjectManager();
        this.resourceTypeMgr = LookupUtil.getResourceTypeManager();
        this.registerParentPluginV1();
        this.registerChildPluginV1();
        this.registerParentPluginV2();
        this.checkChildPlugin();
    }

    @Test(priority=10, alwaysRun=true, dependsOnMethods={"testRegisterPlugins"})
    public void afterClassWorkTest() throws Exception {
        this.afterClassWork();
    }

    private void registerParentPluginV1() throws Exception {
        this.createPlugin("parent-plugin.jar", "1.0", "parent_plugin_v1.xml");
        ResourceType resourceType = this.loadResourceTypeFully(TYPE_NAME_PARENT, PLUGIN_NAME_PARENT);
        assert (resourceType.getName().equals(TYPE_NAME_PARENT));
        assert (resourceType.getPlugin().equals(PLUGIN_NAME_PARENT));
        this.assertVersion1(resourceType);
    }

    private void registerChildPluginV1() throws Exception {
        this.createPlugin("child-plugin.jar", "1.0", "child_plugin_v1.xml");
        ResourceType resourceType = this.loadResourceTypeFully(TYPE_NAME_CHILD, PLUGIN_NAME_CHILD);
        assert (resourceType.getName().equals(TYPE_NAME_CHILD));
        assert (resourceType.getPlugin().equals(PLUGIN_NAME_CHILD));
        this.assertVersion1(resourceType);
    }

    private void registerParentPluginV2() throws Exception {
        this.createPlugin("parent-plugin.jar", "2.0", "parent_plugin_v2.xml");
        ResourceType resourceType = this.loadResourceTypeFully(TYPE_NAME_PARENT, PLUGIN_NAME_PARENT);
        assert (resourceType.getName().equals(TYPE_NAME_PARENT));
        assert (resourceType.getPlugin().equals(PLUGIN_NAME_PARENT));
        this.assertVersion2(resourceType);
    }

    private void checkChildPlugin() throws Exception {
        ResourceType resourceType = this.loadResourceTypeFully(TYPE_NAME_CHILD, PLUGIN_NAME_CHILD);
        assert (resourceType.getName().equals(TYPE_NAME_CHILD));
        assert (resourceType.getPlugin().equals(PLUGIN_NAME_CHILD));
        this.assertVersion2(resourceType);
    }

    private void assertVersion1(ResourceType resourceType) {
        assert (resourceType.getChildSubCategories().size() == 1);
        assert (((ResourceSubCategory)resourceType.getChildSubCategories().get(0)).getName().equals(SUBCAT));
        assert (((ResourceSubCategory)resourceType.getChildSubCategories().get(0)).getDisplayName().equals(SUBCAT_DISPLAYNAME));
        assert (resourceType.getPluginConfigurationDefinition().getGroupDefinitions().size() == 1);
        PropertyGroupDefinition group = (PropertyGroupDefinition)resourceType.getPluginConfigurationDefinition().getGroupDefinitions().get(0);
        assert (group.getName().equals("A-pc-group"));
        assert (group.isDefaultHidden());
        PropertyDefinition prop = resourceType.getPluginConfigurationDefinition().get("A-pc-prop");
        assert (prop != null);
        assert (prop.getName().equals("A-pc-prop"));
        assert (!prop.isRequired());
        assert (prop.getPropertyGroupDefinition().getName().equals("A-pc-group"));
        assert (resourceType.getProcessScans().size() == 1);
        ProcessScan processScan = (ProcessScan)resourceType.getProcessScans().iterator().next();
        assert (processScan.getName().equals("A-process-scan"));
        assert (processScan.getQuery().equals(PROCESS_SCAN_QUERY));
        assert (resourceType.getOperationDefinitions().size() == 1);
        OperationDefinition op = (OperationDefinition)resourceType.getOperationDefinitions().iterator().next();
        assert (op.getName().equals("A-op"));
        assert (op.getTimeout() == 123456);
        assert (op.getDescription().equals(OP_DESC));
        assert (resourceType.getMetricDefinitions().size() == 2);
        MeasurementDefinition metric = (MeasurementDefinition)resourceType.getMetricDefinitions().iterator().next();
        assert (metric.getName().equals("A-metric"));
        assert (metric.getDefaultInterval() == 123456L);
        assert (resourceType.getEventDefinitions().size() == 1);
        EventDefinition event = (EventDefinition)resourceType.getEventDefinitions().iterator().next();
        assert (event.getName().equals(EVENT_NAME));
        assert (event.getDescription().equals(EVENT_DESC));
        assert (resourceType.getResourceConfigurationDefinition().getGroupDefinitions().size() == 0);
        prop = resourceType.getResourceConfigurationDefinition().get("A-rc-prop");
        assert (prop != null);
        assert (prop.getName().equals("A-rc-prop"));
        assert (!prop.isRequired());
        assert (resourceType.getDriftDefinitionTemplates().size() == 1);
        DriftDefinitionTemplate drift = (DriftDefinitionTemplate)resourceType.getDriftDefinitionTemplates().iterator().next();
        assert (drift.getTemplateDefinition().getName().equals(DRIFT_DEF_NAME));
        DriftDefinition.BaseDirectory driftBasedir = drift.getTemplateDefinition().getBasedir();
        assert (driftBasedir.getValueContext().equals((Object)DRIFT_DEF_BASEDIR_CONTEXT));
        assert (driftBasedir.getValueName().equals("A-pc-prop"));
        ResourceTypeBundleConfiguration bundle = resourceType.getResourceTypeBundleConfiguration();
        assert (bundle.getBundleDestinationBaseDirectories().size() == 1);
        ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory bundleBasedir = (ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory)bundle.getBundleDestinationBaseDirectories().iterator().next();
        assert (bundleBasedir.getName().equals(BUNDLE_TARGET_NAME));
        assert (bundleBasedir.getValueContext().equals((Object)BUNDLE_BASEDIR_CONTEXT));
        assert (bundleBasedir.getValueName().equals("A-rc-prop"));
    }

    private void assertVersion2(ResourceType resourceType) {
        HashSet<String> seen = new HashSet<String>(2);
        assert (resourceType.getChildSubCategories().size() == 1);
        assert (((ResourceSubCategory)resourceType.getChildSubCategories().get(0)).getName().equals(SUBCAT));
        assert (((ResourceSubCategory)resourceType.getChildSubCategories().get(0)).getDisplayName().equals(SUBCAT_DISPLAYNAME));
        seen.clear();
        ConfigurationDefinition pcDef = resourceType.getPluginConfigurationDefinition();
        assert (pcDef.getGroupDefinitions().size() == 2);
        for (PropertyGroupDefinition group : pcDef.getGroupDefinitions()) {
            seen.add(group.getName());
            if (group.getName().equals("A-pc-group")) {
                assert (!group.isDefaultHidden());
                continue;
            }
            if (group.getName().equals(NEW_PC_GROUP)) {
                assert (group.isDefaultHidden());
                continue;
            }
            assert (false) : "Unexpected group [" + group.getName() + "]:" + group;
        }
        if (seen.size() != 2) assert (false) : "did not see what we expected to see: " + seen;
        PropertyDefinition prop = pcDef.get(CHANGED_PC_PROP);
        assert (prop != null);
        assert (prop.getName().equals(CHANGED_PC_PROP));
        assert (prop.isRequired());
        assert (prop.getPropertyGroupDefinition().getName().equals("A-pc-group"));
        prop = pcDef.get(NEW_PC_PROP);
        assert (prop != null);
        assert (prop.getName().equals(NEW_PC_PROP));
        assert (!prop.isRequired());
        assert (prop.getPropertyGroupDefinition().getName().equals(NEW_PC_GROUP));
        seen.clear();
        assert (resourceType.getProcessScans().size() == 2);
        for (ProcessScan processScan : resourceType.getProcessScans()) {
            seen.add(processScan.getName());
            if (processScan.getName().equals("A-process-scan")) {
                assert (processScan.getQuery().equals(CHANGED_PROCESS_SCAN_QUERY));
                continue;
            }
            if (processScan.getName().equals(NEW_PROCESS_SCAN_NAME)) {
                assert (processScan.getQuery().equals(NEW_PROCESS_SCAN_QUERY));
                continue;
            }
            assert (false) : "Unexpected process scan[" + processScan.getName() + "]:" + processScan;
        }
        if (seen.size() != 2) assert (false) : "did not see what we expected to see: " + seen;
        seen.clear();
        assert (resourceType.getOperationDefinitions().size() == 2);
        for (OperationDefinition op : resourceType.getOperationDefinitions()) {
            seen.add(op.getName());
            if (op.getName().equals("A-op")) {
                assert (op.getTimeout() == 987654);
                assert (op.getDescription().equals(CHANGED_OP_DESC));
                continue;
            }
            if (op.getName().equals(NEW_OP_NAME)) {
                assert (op.getTimeout() == 111111);
                assert (op.getDescription().equals(NEW_OP_DESC));
                continue;
            }
            assert (false) : "Unexpected operation [" + op.getName() + "]:" + op;
        }
        if (seen.size() != 2) assert (false) : "did not see what we expected to see: " + seen;
        seen.clear();
        assert (resourceType.getMetricDefinitions().size() == 3);
        for (MeasurementDefinition metric : resourceType.getMetricDefinitions()) {
            if (metric.getName().equals("rhq.availability")) continue;
            seen.add(metric.getName());
            if (metric.getName().equals("A-metric")) {
                assert (metric.getDefaultInterval() == 123456L);
                continue;
            }
            if (metric.getName().equals(NEW_METRIC_PROP)) {
                assert (metric.getDefaultInterval() == 98765L);
                continue;
            }
            assert (false) : "Unexpected metric [" + metric.getName() + "]:" + metric;
        }
        if (seen.size() != 2) assert (false) : "did not see what we expected to see: " + seen;
        seen.clear();
        assert (resourceType.getEventDefinitions().size() == 2);
        for (EventDefinition event : resourceType.getEventDefinitions()) {
            seen.add(event.getName());
            if (event.getName().equals(CHANGED_EVENT_NAME)) {
                assert (event.getDescription().equals(CHANGED_EVENT_DESC));
                continue;
            }
            if (event.getName().equals(NEW_EVENT_NAME)) {
                assert (event.getDescription().equals(NEW_EVENT_DESC));
                continue;
            }
            assert (false) : "Unexpected event [" + event.getName() + "]:" + event;
        }
        if (seen.size() != 2) assert (false) : "did not see what we expected to see: " + seen;
        assert (resourceType.getResourceConfigurationDefinition().getGroupDefinitions().size() == 0);
        prop = resourceType.getResourceConfigurationDefinition().get(CHANGED_RC_PROP);
        assert (prop != null);
        assert (prop.getName().equals(CHANGED_RC_PROP));
        assert (prop.isRequired());
        prop = resourceType.getResourceConfigurationDefinition().get(NEW_RC_PROP);
        assert (prop != null);
        assert (prop.getName().equals(NEW_RC_PROP));
        assert (!prop.isRequired());
        seen.clear();
        assert (resourceType.getDriftDefinitionTemplates().size() == 2);
        for (DriftDefinitionTemplate drift : resourceType.getDriftDefinitionTemplates()) {
            DriftDefinition.BaseDirectory driftBasedir;
            DriftDefinition def = drift.getTemplateDefinition();
            seen.add(def.getName());
            if (def.getName().equals(CHANGED_DRIFT_DEF_NAME)) {
                driftBasedir = def.getBasedir();
                assert (driftBasedir.getValueContext().equals((Object)CHANGED_DRIFT_DEF_BASEDIR_CONTEXT));
                assert (driftBasedir.getValueName().equals("A-pc-prop"));
                continue;
            }
            if (def.getName().equals(NEW_DRIFT_DEF_NAME)) {
                driftBasedir = def.getBasedir();
                assert (driftBasedir.getValueContext().equals((Object)NEW_DRIFT_DEF_BASEDIR_CONTEXT));
                assert (driftBasedir.getValueName().equals("A-rc-prop"));
                continue;
            }
            assert (false) : "Unexpected drift def [" + def.getName() + "]:" + def;
        }
        if (seen.size() != 2) assert (false) : "did not see what we expected to see: " + seen;
        seen.clear();
        ResourceTypeBundleConfiguration bundle = resourceType.getResourceTypeBundleConfiguration();
        assert (bundle.getBundleDestinationBaseDirectories().size() == 2);
        for (ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory bundleBasedir : bundle.getBundleDestinationBaseDirectories()) {
            seen.add(bundleBasedir.getName());
            if (bundleBasedir.getName().equals(CHANGED_BUNDLE_TARGET_NAME)) {
                assert (bundleBasedir.getValueContext().equals((Object)CHANGED_BUNDLE_BASEDIR_CONTEXT));
                assert (bundleBasedir.getValueName().equals("A-rc-prop"));
                continue;
            }
            if (bundleBasedir.getName().equals(NEW_BUNDLE_TARGET_NAME)) {
                assert (bundleBasedir.getValueContext().equals((Object)NEW_BUNDLE_BASEDIR_CONTEXT));
                assert (bundleBasedir.getValueName().equals("A-pc-prop"));
                continue;
            }
            assert (false) : "Unexpected bundle basedir [" + bundleBasedir.getName() + "]:" + bundleBasedir;
        }
        if (seen.size() != 2) assert (false) : "did not see what we expected to see: " + seen;
    }

    private ResourceType loadResourceTypeFully(String typeName, String typePlugin) {
        ResourceTypeCriteria c = new ResourceTypeCriteria();
        c.addFilterName(typeName);
        c.addFilterPluginName(typePlugin);
        c.setStrict(true);
        c.fetchSubCategories(true);
        c.fetchPluginConfigurationDefinition(true);
        c.fetchProcessScans(true);
        c.fetchOperationDefinitions(true);
        c.fetchMetricDefinitions(true);
        c.fetchEventDefinitions(true);
        c.fetchResourceConfigurationDefinition(true);
        c.fetchDriftDefinitionTemplates(true);
        c.fetchBundleConfiguration(true);
        PageList t = this.resourceTypeMgr.findResourceTypesByCriteria(this.subjectMgr.getOverlord(), c);
        ResourceType resourceType = (ResourceType)t.get(0);
        return resourceType;
    }
}

