/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.ejb.EJBException;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.plugin.PluginStatusType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.util.file.FileUtil;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.inventory.InventoryManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.metadata.MetadataBeanTest;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.scheduler.jobs.PurgePluginsJob;
import org.rhq.enterprise.server.scheduler.jobs.PurgeResourceTypesJob;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

@Test(groups={"plugin.metadata", "PluginManagerBean"}, priority=100000)
public class PluginManagerBeanTest
extends MetadataBeanTest {
    private static final String PLUGIN_1 = "PluginManagerBeanTestPlugin1";
    private static final String PLUGIN_2 = "PluginManagerBeanTestPlugin2";
    private static final String PLUGIN_3 = "PluginManagerBeanTestPlugin3";
    private static final String PLUGIN_3_1 = "PluginManagerBeanTestPlugin3.1";
    private SubjectManagerLocal subjectMgr;
    private PluginManagerLocal pluginMgr;

    @Override
    protected void beforeMethod() throws Exception {
        super.beforeMethod();
        this.subjectMgr = LookupUtil.getSubjectManager();
        this.pluginMgr = LookupUtil.getPluginManager();
        this.getPluginScannerService().startDeployment();
    }

    @Override
    protected void afterMethod() throws Exception {
        FileUtil.purge((File)new File(this.getPluginScannerService().getAgentPluginDir()), (boolean)true);
        this.unpreparePluginScannerService();
        super.afterMethod();
    }

    public void registerPlugins() throws Exception {
        List plugins = this.getEntityManager().createQuery("from Plugin where name IN ('PluginManagerBeanTestPlugin1', 'PluginManagerBeanTestPlugin2', 'PluginManagerBeanTestPlugin3')").getResultList();
        if (!plugins.isEmpty()) {
            System.out.println("Purging plugins " + plugins + "...");
            for (Plugin plugin : plugins) {
                this.pluginMgr.deletePlugins(this.subjectMgr.getOverlord(), Arrays.asList(plugin.getId()));
            }
            new PurgeResourceTypesJob().execute(null);
            new PurgePluginsJob().execute(null);
        }
        this.createPluginJarFile("test-plugin1.jar", "plugin_1.xml");
        this.createPluginJarFile("test-plugin2.jar", "plugin_2.xml");
        this.createPluginJarFile("test-plugin3.jar", "plugin_3.xml");
        this.createPluginJarFile("test-plugin3.1.jar", "plugin_3.1.xml");
        this.getPluginScannerService().scanAndRegister();
        this.ignoreType("TestServer1Ignored", PLUGIN_1);
        this.ignoreType("TestServer2Ignored", PLUGIN_2);
        this.ignoreType("TestServer3Ignored", PLUGIN_3);
        this.ignoreType("TestServer3.1Ignored", PLUGIN_3_1);
    }

    @Test(dependsOnMethods={"registerPlugins"})
    public void scanAndRegisterTest() throws Exception {
        Plugin plugin = this.getPlugin(PLUGIN_1);
        this.assertNotNull(plugin);
        this.pluginDeployed(PLUGIN_1);
        plugin = this.getPlugin(PLUGIN_2);
        this.assertNotNull(plugin);
        this.pluginDeployed(PLUGIN_2);
        plugin = this.getPlugin(PLUGIN_3);
        this.assertNotNull(plugin);
        this.pluginDeployed(PLUGIN_3);
        plugin = this.getPlugin(PLUGIN_3_1);
        this.assertNotNull(plugin);
        this.pluginDeployed(PLUGIN_3_1);
    }

    @Test(dependsOnMethods={"registerPlugins"})
    public void disablePlugin() throws Exception {
        Plugin plugin = this.getPlugin(PLUGIN_3);
        this.assertTrue("Plugin should not already be disabled", plugin.isEnabled());
        this.pluginMgr.disablePlugins(this.subjectMgr.getOverlord(), Arrays.asList(plugin.getId()));
        plugin = this.pluginMgr.getPlugin(PLUGIN_3);
        this.assertNotNull(plugin);
        this.assertFalse("Failed to disable plugin", plugin.isEnabled());
    }

    @Test(dependsOnMethods={"registerPlugins"})
    public void doNotDisablePluginIfDependentPluginsAreNotAlsoDisabled() throws Exception {
        Plugin plugin = this.getPlugin(PLUGIN_1);
        this.assertTrue("Plugin should not already be disabled", plugin.isEnabled());
        Plugin plugin2 = this.getPlugin(PLUGIN_2);
        this.assertTrue("Plugin should not already be disabled", plugin.isEnabled());
        Exception exception = null;
        try {
            this.pluginMgr.disablePlugins(this.subjectMgr.getOverlord(), Arrays.asList(plugin.getId()));
        }
        catch (Exception e) {
            exception = e;
        }
        plugin = this.getPlugin(PLUGIN_1);
        this.assertTrue("Plugin should not have been disabled", plugin.isEnabled());
        this.assertNotNull("Expected exception to be thrown when trying to disable a plugin that has dependent plugins", exception);
        this.assertTrue("Expected an IllegalArgumentException when trying to disable a plugin with dependent plugins", exception.getCause() instanceof IllegalArgumentException);
    }

    @Test(dependsOnMethods={"doNotDisablePluginIfDependentPluginsAreNotAlsoDisabled"})
    public void disablePluginAndDependentPlugins() throws Exception {
        Plugin plugin1 = this.getPlugin(PLUGIN_1);
        Plugin plugin2 = this.getPlugin(PLUGIN_2);
        this.pluginMgr.disablePlugins(this.subjectMgr.getOverlord(), Arrays.asList(plugin1.getId(), plugin2.getId()));
        plugin1 = this.getPlugin(PLUGIN_1);
        plugin2 = this.getPlugin(PLUGIN_2);
        this.assertFalse("Failed to disable plugin", plugin1.isEnabled());
        this.assertFalse("Failed to disable plugin", plugin2.isEnabled());
    }

    @Test(groups={"plugin.metadata", "PluginManagerBean"}, dependsOnMethods={"disablePluginAndDependentPlugins"})
    public void enablePlugins() throws Exception {
        Plugin plugin1 = this.getPlugin(PLUGIN_1);
        Plugin plugin2 = this.getPlugin(PLUGIN_2);
        this.pluginMgr.enablePlugins(this.subjectMgr.getOverlord(), Arrays.asList(plugin1.getId(), plugin2.getId()));
        plugin1 = this.getPlugin(PLUGIN_1);
        plugin2 = this.getPlugin(PLUGIN_2);
        this.assertTrue("Failed to enable plugin", plugin1.isEnabled());
        this.assertTrue("Failed to enable plugin", plugin2.isEnabled());
    }

    @Test(dependsOnMethods={"enablePlugins"})
    public void doNotDeletePluginIfDependentPluginIsNotAlsoDeleted() throws Exception {
        Plugin plugin = this.getPlugin(PLUGIN_1);
        Object exception = null;
        try {
            this.pluginMgr.deletePlugins(this.subjectMgr.getOverlord(), Arrays.asList(plugin.getId()));
            this.fail("Expected an IllegalArgumentException when trying to delete a plugin with dependent plugins");
        }
        catch (IllegalArgumentException e) {
        }
        catch (EJBException ee) {
            if (ee.getCause() == null || !(ee.getCause() instanceof IllegalArgumentException)) {
                this.fail("Expected an IllegalArgumentException when trying to delete a plugin with dependent plugins, got: " + (Object)((Object)ee));
            }
        }
        catch (Throwable t) {
            this.fail("Expected an IllegalArgumentException when trying to delete a plugin with dependent plugins, got: " + t);
        }
    }

    @Test(dependsOnMethods={"doNotDeletePluginIfDependentPluginIsNotAlsoDeleted"})
    public void deletePlugins() throws Exception {
        Plugin plugin1 = this.getPlugin(PLUGIN_1);
        Plugin plugin2 = this.getPlugin(PLUGIN_2);
        this.pluginMgr.deletePlugins(this.subjectMgr.getOverlord(), Arrays.asList(plugin1.getId(), plugin2.getId()));
        plugin1 = this.getPlugin(PLUGIN_1, "Deleting a plugin should not remove it from the database");
        plugin2 = this.getPlugin(PLUGIN_2, "Deleting a plugin should not remove it from the database");
        this.assertTrue("Expected plugin status to be set to DELETED", plugin1.getStatus() == PluginStatusType.DELETED);
        this.assertTrue("Expected plugin status to be set to DELETED", plugin2.getStatus() == PluginStatusType.DELETED);
    }

    @Test(dependsOnMethods={"deletePlugins"})
    public void isPluginReadyForPurge() throws Exception {
        ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
        InventoryManagerLocal inventoryManager = LookupUtil.getInventoryManager();
        Plugin plugin = this.getDeletedPlugin(PLUGIN_1);
        if (plugin == null) {
            plugin = this.pluginMgr.getPlugin(PLUGIN_1);
            if (plugin != null) {
                this.fail("PluginManagerBeanTestPlugin1should have been deleted in PluginManagerBeanTest#deletePlugins()");
            }
            return;
        }
        List resourceTypes = resourceTypeManager.getResourceTypesByPlugin(plugin.getName());
        List deletedTypes = inventoryManager.getDeletedTypes();
        boolean resourceTypesPurged = resourceTypes.isEmpty() && deletedTypes.isEmpty();
        this.ackDeletedPlugins();
        this.assertTrue("A plugin is not ready to be purged until all of its resource types have already been purged and until the plugin itself has been acked for deletion by all servers", resourceTypesPurged == this.pluginMgr.isReadyForPurge(plugin));
    }

    private Plugin getDeletedPlugin(String name) {
        List deletedPlugins = this.pluginMgr.findAllDeletedPlugins();
        for (Plugin plugin : deletedPlugins) {
            if (!plugin.getName().equals(name)) continue;
            return plugin;
        }
        return null;
    }

    @Test(dependsOnMethods={"registerPlugins", "isPluginReadyForPurge"})
    public void pluginPurgeCheckShouldUseExactMatchesInQuery() throws Exception {
        InventoryManagerLocal inventoryManager = LookupUtil.getInventoryManager();
        ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
        Plugin plugin3 = this.getPlugin(PLUGIN_3);
        ResourceType resourceType = resourceTypeManager.getResourceTypeByNameAndPlugin("TestServer3", plugin3.getName());
        ResourceType resourceTypeIgnored = resourceTypeManager.getResourceTypeByNameAndPlugin("TestServer3Ignored", plugin3.getName());
        this.assertNotNull("Failed to find resource type. Did the resource type name in the plugin descriptor change?", resourceType);
        this.assertNotNull("Failed to find ignored resource type. Did the type name in the plugin descriptor change?", resourceTypeIgnored);
        this.pluginMgr.deletePlugins(this.subjectMgr.getOverlord(), Arrays.asList(plugin3.getId()));
        inventoryManager.purgeDeletedResourceType(resourceType);
        inventoryManager.purgeDeletedResourceType(resourceTypeIgnored);
        this.ackDeletedPlugins();
        this.assertTrue("Expected " + plugin3 + " to be ready for purge since all its resource types have been purged " + "and the servers acked its deletion", this.pluginMgr.isReadyForPurge(plugin3));
    }

    @Test(priority=10, alwaysRun=true, dependsOnMethods={"pluginPurgeCheckShouldUseExactMatchesInQuery"})
    public void afterClassWorkTest() throws Exception {
        this.afterClassWork();
    }

    private Plugin getPlugin(String name) {
        Plugin plugin = this.pluginMgr.getPlugin(name);
        this.assertNotNull("Failed to find plugin [" + name + "].", plugin);
        return plugin;
    }

    private Plugin getPlugin(String name, String msg) {
        List plugins = this.getEntityManager().createQuery("from Plugin where name = :name").setParameter("name", (Object)name).getResultList();
        this.assertTrue("Failed to find plugin [" + name + "]: " + msg, plugins.size() == 1);
        return (Plugin)plugins.get(0);
    }
}

