/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.metadata.MetadataBeanTest;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

@Test(groups={"plugin.extension.scanning.metadata", "plugin.metadata"})
public class PluginScanningExtensionMetadataTest
extends MetadataBeanTest {
    private static final String PLUGIN_NAME_PARENT = "PluginScanningExtensionMetadataParentTestPlugin";
    private static final String PLUGIN_NAME_CHILD1 = "PluginScanningExtensionMetadataChild1TestPlugin";
    private static final String PLUGIN_NAME_CHILD2 = "PluginScanningExtensionMetadataChild2TestPlugin";
    private static final String TYPE_NAME_PARENT = "ParentServerA";
    private static final String TYPE_NAME_CHILD1 = "Child1ServerA";
    private static final String TYPE_NAME_CHILD2 = "Child2ServerA";
    private static final String OP_NAME = "A-op";
    private static final int OP_TIMEOUT = 123456;
    private static final String OP_DESC = "a op";
    private static final String NEW_OP_NAME = "A-op-NEW";
    private static final int NEW_OP_TIMEOUT = 987654;
    private static final String NEW_OP_DESC = "a new op";
    private SubjectManagerLocal subjectMgr;
    private ResourceTypeManagerLocal resourceTypeMgr;
    private List<File> createdJarFiles = new ArrayList<File>();

    @Override
    protected void beforeMethod() throws Exception {
        super.beforeMethod();
        this.subjectMgr = LookupUtil.getSubjectManager();
        this.resourceTypeMgr = LookupUtil.getResourceTypeManager();
        if (!this.createdJarFiles.isEmpty()) {
            for (File doomed : this.createdJarFiles) {
                doomed.delete();
            }
        }
        this.createdJarFiles.clear();
    }

    @Override
    protected void afterMethod() throws Exception {
        if (!this.createdJarFiles.isEmpty()) {
            for (File doomed : this.createdJarFiles) {
                doomed.delete();
            }
        }
        this.createdJarFiles.clear();
        super.afterMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterPlugins() throws Exception {
        try {
            this.registerParentPluginV1();
            this.registerChild1PluginV1();
            this.registerChild2PluginV1();
            this.registerParentPluginV2();
            this.checkChild1Plugin();
            this.checkChild2Plugin();
        }
        finally {
            this.pluginDeployed(PLUGIN_NAME_PARENT);
            this.pluginDeployed(PLUGIN_NAME_CHILD1);
            this.pluginDeployed(PLUGIN_NAME_CHILD2);
        }
    }

    @Test(priority=10, alwaysRun=true, dependsOnMethods={"testRegisterPlugins"})
    public void afterClassWorkTest() throws Exception {
        this.afterClassWork();
    }

    private void registerParentPluginV1() throws Exception {
        this.createdJarFiles.add(this.createPluginJarFile("parent-plugin.jar", "parent_plugin_v1.xml"));
        this.getPluginScannerService().startDeployment();
        ResourceType resourceType = this.loadResourceTypeFully(TYPE_NAME_PARENT, PLUGIN_NAME_PARENT);
        assert (resourceType.getName().equals(TYPE_NAME_PARENT));
        assert (resourceType.getPlugin().equals(PLUGIN_NAME_PARENT));
        this.assertVersion1(resourceType);
    }

    private void registerChild1PluginV1() throws Exception {
        this.createdJarFiles.add(this.createPluginJarFile("child1-plugin.jar", "child1_plugin_v1.xml"));
        this.getPluginScannerService().scanAndRegister();
        ResourceType resourceType = this.loadResourceTypeFully(TYPE_NAME_CHILD1, PLUGIN_NAME_CHILD1);
        assert (resourceType.getName().equals(TYPE_NAME_CHILD1));
        assert (resourceType.getPlugin().equals(PLUGIN_NAME_CHILD1));
        this.assertVersion1(resourceType);
        assert (resourceType.getParentResourceTypes() != null);
        assert (resourceType.getParentResourceTypes().size() == 1);
        assert (((ResourceType)resourceType.getParentResourceTypes().iterator().next()).getName().equals("OuterServerA"));
    }

    private void registerChild2PluginV1() throws Exception {
        this.createdJarFiles.add(this.createPluginJarFile("child2-plugin.jar", "child2_plugin_v1.xml"));
        this.getPluginScannerService().scanAndRegister();
        ResourceType resourceType = this.loadResourceTypeFully(TYPE_NAME_CHILD2, PLUGIN_NAME_CHILD2);
        assert (resourceType.getName().equals(TYPE_NAME_CHILD2));
        assert (resourceType.getPlugin().equals(PLUGIN_NAME_CHILD2));
        this.assertVersion1(resourceType);
    }

    private void registerParentPluginV2() throws Exception {
        this.createdJarFiles.add(this.createPluginJarFile("parent-plugin.jar", "parent_plugin_v2.xml"));
        this.getPluginScannerService().scanAndRegister();
        ResourceType resourceType = this.loadResourceTypeFully(TYPE_NAME_PARENT, PLUGIN_NAME_PARENT);
        assert (resourceType.getName().equals(TYPE_NAME_PARENT));
        assert (resourceType.getPlugin().equals(PLUGIN_NAME_PARENT));
        this.assertVersion2(resourceType);
    }

    private void checkChild1Plugin() throws Exception {
        ResourceType resourceType = this.loadResourceTypeFully(TYPE_NAME_CHILD1, PLUGIN_NAME_CHILD1);
        assert (resourceType.getName().equals(TYPE_NAME_CHILD1));
        assert (resourceType.getPlugin().equals(PLUGIN_NAME_CHILD1));
        this.assertVersion2(resourceType);
        assert (resourceType.getParentResourceTypes() != null);
        assert (resourceType.getParentResourceTypes().size() == 1);
        assert (((ResourceType)resourceType.getParentResourceTypes().iterator().next()).getName().equals("OuterServerA"));
    }

    private void checkChild2Plugin() throws Exception {
        ResourceType resourceType = this.loadResourceTypeFully(TYPE_NAME_CHILD2, PLUGIN_NAME_CHILD2);
        assert (resourceType.getName().equals(TYPE_NAME_CHILD2));
        assert (resourceType.getPlugin().equals(PLUGIN_NAME_CHILD2));
        this.assertVersion2(resourceType);
    }

    private void assertVersion1(ResourceType resourceType) {
        assert (resourceType.getOperationDefinitions().size() == 1);
        OperationDefinition op = (OperationDefinition)resourceType.getOperationDefinitions().iterator().next();
        assert (op.getName().equals(OP_NAME));
        assert (op.getTimeout() == 123456);
        assert (op.getDescription().equals(OP_DESC));
    }

    private void assertVersion2(ResourceType resourceType) {
        assert (resourceType.getOperationDefinitions().size() == 1);
        OperationDefinition op = (OperationDefinition)resourceType.getOperationDefinitions().iterator().next();
        assert (op.getName().equals(NEW_OP_NAME));
        assert (op.getTimeout() == 987654);
        assert (op.getDescription().equals(NEW_OP_DESC));
    }

    private ResourceType loadResourceTypeFully(String typeName, String typePlugin) {
        ResourceTypeCriteria c = new ResourceTypeCriteria();
        c.addFilterName(typeName);
        c.addFilterPluginName(typePlugin);
        c.setStrict(true);
        c.fetchParentResourceTypes(true);
        c.fetchOperationDefinitions(true);
        PageList t = this.resourceTypeMgr.findResourceTypesByCriteria(this.subjectMgr.getOverlord(), c);
        ResourceType resourceType = (ResourceType)t.get(0);
        return resourceType;
    }
}

