/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.persistence.Query;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.WordUtils;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.bundle.Bundle;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.bundle.ResourceTypeBundleConfiguration;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.criteria.OperationDefinitionCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.drift.DriftConfigurationDefinition;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionTemplate;
import org.rhq.core.domain.drift.Filter;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.shared.ResourceBuilder;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertTemplateManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.bundle.BundleManagerLocal;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.metadata.MetadataBeanTest;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

@Test(groups={"plugin.metadata"})
public class ResourceMetadataManagerBeanTest
extends MetadataBeanTest {
    private static final String PLUGIN_NAME = "ResourceMetadataManagerBeanTestPlugin";
    private static Set<Integer> groupIds = Collections.synchronizedSet(new HashSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"plugin.resource.metadata.test", "NewPlugin"})
    public void testRemovalOfObsoleteBundleAndDriftConfig() throws Exception {
        Query qConfig;
        Query qTemplate;
        this.createPlugin("test-plugin.jar", "1.0", "remove_bundle_drift_config_v1.xml");
        ResourceType type1 = this.assertResourceTypeAssociationEquals("ServerWithBundleAndDriftConfig", PLUGIN_NAME, "driftDefinitionTemplates", Arrays.asList("drift1"));
        String qTemplateString = "from DriftDefinitionTemplate where id = :id";
        String qConfigString = "from Configuration c where id = :id";
        DriftDefinitionTemplate driftTemplate = (DriftDefinitionTemplate)type1.getDriftDefinitionTemplates().iterator().next();
        Configuration bundleConfig = type1.getResourceTypeBundleConfiguration().getBundleConfiguration();
        Configuration driftDefConfig = driftTemplate.getConfiguration();
        this.getTransactionManager().begin();
        try {
            qTemplate = this.getEntityManager().createQuery(qTemplateString).setParameter("id", (Object)driftTemplate.getId());
            qConfig = this.getEntityManager().createQuery(qConfigString).setParameter("id", (Object)driftDefConfig.getId());
            this.assertEquals("drift template didn't get persisted", 1, qTemplate.getResultList().size());
            this.assertEquals("drift template config didn't get persisted", 1, qConfig.getResultList().size());
            qConfig.setParameter("id", (Object)bundleConfig.getId());
            this.assertEquals("bundle config didn't get persisted", 1, qConfig.getResultList().size());
        }
        finally {
            this.getTransactionManager().commit();
        }
        this.assertNotNull(type1.getResourceTypeBundleConfiguration());
        this.assertEquals("destdir1", ((ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory)type1.getResourceTypeBundleConfiguration().getBundleDestinationBaseDirectories().iterator().next()).getName());
        this.createPlugin("test-plugin.jar", "2.0", "remove_bundle_drift_config_v2.xml");
        this.getTransactionManager().begin();
        try {
            qTemplate = this.getEntityManager().createQuery(qTemplateString).setParameter("id", (Object)driftTemplate.getId());
            qConfig = this.getEntityManager().createQuery(qConfigString).setParameter("id", (Object)driftDefConfig.getId());
            this.assertEquals("drift template didn't get purged", 0, qTemplate.getResultList().size());
            this.assertEquals("drift template config didn't get purged", 0, qConfig.getResultList().size());
            qConfig.setParameter("id", (Object)bundleConfig.getId());
            this.assertEquals("bundle config didn't get purged", 0, qConfig.getResultList().size());
        }
        finally {
            this.getTransactionManager().commit();
        }
    }

    @Test(groups={"plugin.resource.metadata.test", "NewPlugin"})
    public void registerPluginWithDuplicateDriftDefinitions() {
        try {
            this.createPlugin("test-plugin.jar", "1.0", "dup_drift.xml");
            this.fail("should not have succeeded - the drift definition had duplicate names");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(dependsOnMethods={"registerPluginWithDuplicateDriftDefinitions"}, groups={"plugin.resource.metadata.test", "NewPlugin"})
    public void registerPlugin() throws Exception {
        this.createPlugin("test-plugin.jar", "1.0", "plugin_v1.xml");
    }

    @Test(dependsOnMethods={"registerPluginWithDuplicateDriftDefinitions"}, groups={"plugin.resource.metadata.test", "NewPlugin"})
    public void registerParentResouceTypePlugin() throws Exception {
        this.createPlugin("parent_resource_type-plugin.jar", "1.0", "parent_resource_type-plugin.xml");
        this.assertResourceTypeAssociationEquals("Server A First Level", "ParentResourceTypeTestPlugin", "childResourceTypes", Arrays.asList("Server B Second Level", "Service A Second Level"));
        this.assertResourceTypeAssociationEquals("Server B Second Level", "ParentResourceTypeTestPlugin", "childResourceTypes", Arrays.asList("Server C First Level", "Service B First Level"));
        this.assertResourceTypeAssociationEquals("Service A Second Level", "ParentResourceTypeTestPlugin", "childResourceTypes", Arrays.asList("Service C First Level"));
    }

    @Test(dependsOnMethods={"registerPlugin"}, groups={"plugin.resource.metadata.test", "NewPlugin"})
    public void persistNewTypes() {
        List<String> newTypes = Arrays.asList("ServerA", "ServerB");
        this.assertTypesPersisted("Failed to persist new types", newTypes, PLUGIN_NAME);
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.resource.metadata.test", "NewPlugin"})
    public void persistMeasurementDefinitions() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", PLUGIN_NAME, "metricDefinitions", Arrays.asList("metric1", "metric2", "rhq.availability"));
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.resource.metadata.test", "NewPlugin"})
    public void persistEventDefinitions() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", PLUGIN_NAME, "eventDefinitions", Arrays.asList("logAEntry", "logBEntry"));
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.resource.metadata.test", "NewPlugin"})
    public void persistOperationDefinitions() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", PLUGIN_NAME, "operationDefinitions", Arrays.asList("start", "stop"));
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.resource.metadata.test", "NewPlugin"})
    public void persistProcessScans() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", PLUGIN_NAME, "processScans", Arrays.asList("serverA"));
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.resource.metadata.test", "NewPlugin"})
    public void persistDriftDefinitionTemplates() throws Exception {
        ResourceType type = this.assertResourceTypeAssociationEquals("ServerA", PLUGIN_NAME, "driftDefinitionTemplates", Arrays.asList("drift-pc", "drift-fs"));
        DriftDefinition driftDef = null;
        Set drifts = type.getDriftDefinitionTemplates();
        for (DriftDefinitionTemplate drift : drifts) {
            if (drift.getName().equals("drift-pc")) {
                driftDef = new DriftDefinition(drift.getConfiguration());
                this.assertTrue(driftDef.isEnabled());
                this.assertEquals(DriftConfigurationDefinition.BaseDirValueContext.pluginConfiguration, driftDef.getBasedir().getValueContext());
                this.assertEquals("connectionPropertyX", driftDef.getBasedir().getValueName());
                this.assertEquals(123456L, driftDef.getInterval());
                this.assertEquals(1, driftDef.getIncludes().size());
                this.assertEquals(2, driftDef.getExcludes().size());
                Filter filter = (Filter)driftDef.getIncludes().get(0);
                this.assertEquals("foo/bar", filter.getPath());
                this.assertEquals("**/*.blech", filter.getPattern());
                filter = (Filter)driftDef.getExcludes().get(0);
                this.assertEquals("/wot/gorilla", filter.getPath());
                this.assertEquals("*.xml", filter.getPattern());
                filter = (Filter)driftDef.getExcludes().get(1);
                this.assertEquals("/hello", filter.getPath());
                this.assertEquals("", filter.getPattern());
                continue;
            }
            if (drift.getName().equals("drift-fs")) {
                driftDef = new DriftDefinition(drift.getConfiguration());
                this.assertTrue(driftDef.isEnabled());
                this.assertEquals(DriftConfigurationDefinition.BaseDirValueContext.fileSystem, driftDef.getBasedir().getValueContext());
                this.assertEquals("/", driftDef.getBasedir().getValueName());
                this.assertEquals(1800L, driftDef.getInterval());
                this.assertEquals(0, driftDef.getIncludes().size());
                this.assertEquals(0, driftDef.getExcludes().size());
                continue;
            }
            this.fail("got an unexpected drift definition: " + driftDef);
        }
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.resource.metadata.test", "NewPlugin"})
    public void persistBundleTargetConfigurations() throws Exception {
        String resourceTypeName = "ServerA";
        String plugin = PLUGIN_NAME;
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        ResourceTypeCriteria criteria = new ResourceTypeCriteria();
        criteria.addFilterName(resourceTypeName);
        criteria.addFilterPluginName(plugin);
        criteria.fetchBundleConfiguration(true);
        PageList resourceTypes = resourceTypeMgr.findResourceTypesByCriteria(subjectMgr.getOverlord(), criteria);
        this.assertEquals("too many types returned!", 1, resourceTypes.size());
        ResourceType resourceType = (ResourceType)resourceTypes.get(0);
        ResourceTypeBundleConfiguration rtbc = resourceType.getResourceTypeBundleConfiguration();
        this.assertNotNull("missing bundle configuration", rtbc);
        Set dirs = rtbc.getBundleDestinationBaseDirectories();
        this.assertEquals("Should have persisted 2 bundle dest dirs", 2, dirs.size());
        for (ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory dir : dirs) {
            if (dir.getName().equals("bundleTarget-pc")) {
                this.assertEquals(ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.pluginConfiguration, dir.getValueContext());
                this.assertEquals("connectionPropertyY", dir.getValueName());
                this.assertEquals("pc-description", dir.getDescription());
                continue;
            }
            if (dir.getName().equals("bundleTarget-fs")) {
                this.assertEquals(ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.fileSystem, dir.getValueContext());
                this.assertEquals("/wot/gorilla", dir.getValueName());
                this.assertNull(dir.getDescription());
                continue;
            }
            this.fail("got an unexpected bundle target dest dir: " + dir);
        }
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.resource.metadata.test", "NewPlugin"})
    public void persistChildTypes() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", PLUGIN_NAME, "childResourceTypes", Arrays.asList("Child1", "Child2"));
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.resource.metadata.test", "NewPlugin"})
    public void persistPluginConfigurationDefinition() throws Exception {
        this.assertAssociationExists("ServerA", "pluginConfigurationDefinition");
    }

    @Test(dependsOnMethods={"persistNewTypes"}, groups={"plugin.resource.metadata.test", "NewPlugin"})
    public void persistPackageTypes() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", PLUGIN_NAME, "packageTypes", Arrays.asList("ServerA.Content.1", "ServerA.Content.2"));
    }

    @Test(groups={"plugin.resource.metadata.test", "UpgradePlugin"}, dependsOnGroups={"NewPlugin"})
    public void upgradePlugin() throws Exception {
        this.createPlugin("test-plugin.jar", "2.0", "plugin_v2.xml");
    }

    @Test(dependsOnMethods={"upgradePlugin"}, groups={"plugin.resource.metadata.test", "UpgradePlugin"})
    public void upgradeOperationDefinitions() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", PLUGIN_NAME, "operationDefinitions", Arrays.asList("start", "shutdown", "restart"));
    }

    @Test(dependsOnMethods={"upgradePlugin"}, groups={"plugin.resource.metadata.test", "UpgradePlugin"})
    public void upgradeChildResources() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", PLUGIN_NAME, "childResourceTypes", Arrays.asList("Child1", "Child3"));
    }

    @Test(dependsOnMethods={"upgradePlugin"}, groups={"plugin.resource.metadata.test", "UpgradePlugin"})
    public void upgradeParentTypeOfChild() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerB", PLUGIN_NAME, "childResourceTypes", Arrays.asList("Child2"));
    }

    @Test(dependsOnMethods={"upgradePlugin"}, groups={"plugin.resource.metadata.test", "UpgradePlugin"})
    public void upgradeEventDefinitions() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", PLUGIN_NAME, "eventDefinitions", Arrays.asList("logAEntry", "logCEntry"));
    }

    @Test(dependsOnMethods={"upgradePlugin"}, groups={"plugin.resource.metadata.test", "UpgradePlugin"})
    public void upgradeProcessScans() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", PLUGIN_NAME, "processScans", Arrays.asList("processA", "processB"));
    }

    @Test(dependsOnMethods={"upgradePlugin"}, groups={"plugin.resource.metadata.test", "UpgradePlugin"})
    public void upgradeDriftDefinitionTemplates() throws Exception {
        ResourceType type = this.assertResourceTypeAssociationEquals("ServerA", PLUGIN_NAME, "driftDefinitionTemplates", Arrays.asList("drift-rc", "drift-mt"));
        DriftDefinition driftDef = null;
        Set drifts = type.getDriftDefinitionTemplates();
        for (DriftDefinitionTemplate drift : drifts) {
            if (drift.getName().equals("drift-rc")) {
                driftDef = new DriftDefinition(drift.getConfiguration());
                this.assertTrue(driftDef.isEnabled());
                this.assertEquals(DriftConfigurationDefinition.BaseDirValueContext.resourceConfiguration, driftDef.getBasedir().getValueContext());
                this.assertEquals("resourceConfig1", driftDef.getBasedir().getValueName());
                this.assertEquals(1800L, driftDef.getInterval());
                this.assertEquals(0, driftDef.getIncludes().size());
                this.assertEquals(0, driftDef.getExcludes().size());
                continue;
            }
            if (drift.getName().equals("drift-mt")) {
                driftDef = new DriftDefinition(drift.getConfiguration());
                this.assertTrue(driftDef.isEnabled());
                this.assertEquals(DriftConfigurationDefinition.BaseDirValueContext.measurementTrait, driftDef.getBasedir().getValueContext());
                this.assertEquals("trait1", driftDef.getBasedir().getValueName());
                this.assertEquals(1800L, driftDef.getInterval());
                this.assertEquals(0, driftDef.getIncludes().size());
                this.assertEquals(0, driftDef.getExcludes().size());
                continue;
            }
            this.fail("got an unexpected drift definition: " + driftDef);
        }
    }

    @Test(dependsOnMethods={"upgradePlugin"}, groups={"plugin.resource.metadata.test", "UpgradePlugin"})
    public void upgradeBundleTargetConfigurations() throws Exception {
        String resourceTypeName = "ServerA";
        String plugin = PLUGIN_NAME;
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        ResourceTypeCriteria criteria = new ResourceTypeCriteria();
        criteria.addFilterName(resourceTypeName);
        criteria.addFilterPluginName(plugin);
        criteria.fetchBundleConfiguration(true);
        PageList resourceTypes = resourceTypeMgr.findResourceTypesByCriteria(subjectMgr.getOverlord(), criteria);
        ResourceType resourceType = (ResourceType)resourceTypes.get(0);
        ResourceTypeBundleConfiguration rtbc = resourceType.getResourceTypeBundleConfiguration();
        this.assertNotNull("missing bundle configuration", rtbc);
        Set dirs = rtbc.getBundleDestinationBaseDirectories();
        this.assertEquals("Should have persisted 2 bundle dest dirs", 2, dirs.size());
        for (ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory dir : dirs) {
            if (dir.getName().equals("bundleTarget-rc")) {
                this.assertEquals(ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.resourceConfiguration, dir.getValueContext());
                this.assertEquals("resourceConfig1", dir.getValueName());
                this.assertEquals("rc-description", dir.getDescription());
                continue;
            }
            if (dir.getName().equals("bundleTarget-mt")) {
                this.assertEquals(ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.measurementTrait, dir.getValueContext());
                this.assertEquals("trait1", dir.getValueName());
                this.assertEquals("mt-description", dir.getDescription());
                continue;
            }
            this.assertTrue("got an unexpected bundle target dest dir: " + dir, false);
        }
    }

    @Test(dependsOnMethods={"upgradePlugin"}, groups={"plugin.resource.metadata.test", "UpgradePlugin"})
    public void upgradePackageTypes() throws Exception {
        this.assertResourceTypeAssociationEquals("ServerA", PLUGIN_NAME, "packageTypes", Arrays.asList("ServerA.Content.1", "ServerA.Content.3"));
    }

    @Test(groups={"RemoveTypes"}, dependsOnGroups={"UpgradePlugin"})
    public void upgradePluginWithTypesRemoved() throws Exception {
        this.createPlugin("remove-types-plugin", "1.0", "remove_types_v1.xml");
        this.createBundle("test-bundle-1", "Test Bundle", "ServerC", "RemoveTypesPlugin");
        this.createPackage("ServerC::test-package", "ServerC", "RemoveTypesPlugin");
        this.createAlertTemplate("ServerC Alert Template", "ServerC", "RemoveTypesPlugin");
        List<Resource> resourcesServerE = this.createResources(3, "RemoveTypesPlugin", "ServerE", null);
        List<Resource> resourcesServiceE1 = this.createResources(2, "RemoveTypesPlugin", "ServiceE1", resourcesServerE.get(0));
        List<Resource> resourcesServiceE2 = this.createResources(2, "RemoveTypesPlugin", "ServiceE2", resourcesServiceE1.get(0));
        List<Resource> resourcesServiceE3 = this.createResources(2, "RemoveTypesPlugin", "ServiceE3", resourcesServiceE2.get(0));
        List<Resource> resourcesServiceE4 = this.createResources(205, "RemoveTypesPlugin", "ServiceE4", resourcesServiceE3.get(0));
        ResourceGroup rgRecursive = this.createResourceGroup("ServerE Group", "ServerE", "RemoveTypesPlugin", true);
        this.addResourcesToGroup(rgRecursive, resourcesServerE);
        ResourceGroup rgFlat = this.createResourceGroup("ServiceE4 Group", "ServiceE4", "RemoveTypesPlugin", false);
        this.addResourcesToGroup(rgFlat, resourcesServiceE4);
        this.createPlugin("remove-types-plugin", "2.0", "remove_types_v2.xml");
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceTypeCriteria criteria = new ResourceTypeCriteria();
        criteria.addFilterName("ServiceE4");
        criteria.addFilterPluginName("RemoveTypesPlugin");
        long start = System.nanoTime();
        boolean allTypesRemoved = false;
        do {
            Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
            boolean bl = allTypesRemoved = resourceTypeMgr.findResourceTypesByCriteria(subjectMgr.getOverlord(), criteria).size() == 0;
        } while (!allTypesRemoved && System.nanoTime() - start < TimeUnit.MINUTES.toNanos(10L));
        this.assertTrue("Resource type 'ServiceE4' not fully removed", allTypesRemoved);
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.resource.metadata.test", "RemoveTypes"})
    public void deleteOperationDefsForRemovedType() throws Exception {
        OperationManagerLocal operationMgr = LookupUtil.getOperationManager();
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        OperationDefinitionCriteria criteria = new OperationDefinitionCriteria();
        criteria.addFilterResourceTypeName("ServerC");
        criteria.addFilterName("run");
        List operationDefs = operationMgr.findOperationDefinitionsByCriteria(subjectMgr.getOverlord(), criteria);
        this.assertEquals("The operation definition should have been deleted", 0, operationDefs.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.resource.metadata.test", "RemoveTypes"})
    public void deleteEventDefsForRemovedType() throws Exception {
        List results = this.getEntityManager().createQuery("from EventDefinition e where e.name = :ename and e.resourceType.name = :rname").setParameter("ename", (Object)"serverCEvent").setParameter("rname", (Object)"ServerC").getResultList();
        this.assertEquals("The event definition(s) should have been deleted", 0, results.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.resource.metadata.test", "RemoveTypes"})
    public void deleteParent() throws Exception {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        ResourceTypeCriteria criteria = new ResourceTypeCriteria();
        criteria.addFilterName("ServerD.GrandChild1");
        criteria.addFilterPluginName("RemoveTypesPlugin");
        criteria.fetchParentResourceTypes(true);
        PageList types = resourceTypeMgr.findResourceTypesByCriteria(subjectMgr.getOverlord(), criteria);
        this.assertEquals("Expected to get back one resource type", 1, types.size());
        ResourceType type = (ResourceType)types.get(0);
        this.assertEquals("Expected to find one parent type", 1, type.getParentResourceTypes().size());
        ResourceType parentType = this.findByName(type.getParentResourceTypes(), "ServerD");
        this.assertNotNull("Expected to find 'ServerD' as the parent, but found, " + type.getParentResourceTypes(), parentType);
    }

    private ResourceType findByName(Collection<ResourceType> types, String name) {
        for (ResourceType type : types) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.resource.metadata.test", "RemoveTypes"})
    public void deleteTypeAndAllItsDescendantTypes() throws Exception {
        List typesNotRemoved = this.getEntityManager().createQuery("from ResourceType t where t.plugin = :plugin and t.name in (:resourceTypes)").setParameter("plugin", (Object)"RemoveTypesPlugin").setParameter("resourceTypes", Arrays.asList("ServerC", "ServiceC1", "ServiceE4", "ServerF", "ServiceF1", "ServiceF2", "ServiceF3", "ServiceF4")).getResultList();
        this.assertEquals("Failed to delete resource type or one or more of its descendant types", 0, typesNotRemoved.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.resource.metadata.test", "RemoveTypes"})
    public void deleteProcessScans() {
        List processScans = this.getEntityManager().createQuery("from ProcessScan p where p.name = :name1 or p.name = :name2").setParameter("name1", (Object)"scan1").setParameter("name2", (Object)"scan2").getResultList();
        this.assertEquals("The process scans should have been deleted", 0, processScans.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.resource.metadata.test", "RemoveTypes"})
    public void deleteSubcategories() {
        List subcategories = this.getEntityManager().createQuery("from ResourceSubCategory r where r.name = :name1 or r.name = :name2 or r.name = :name3").setParameter("name1", (Object)"ServerC.Category1").setParameter("name2", (Object)"ServerC.Category2").setParameter("name3", (Object)"ServerC.NestedCategory1").getResultList();
        this.assertEquals("The subcategories should have been deleted", 0, subcategories.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.resource.metadata.test", "RemoveTypes"})
    public void deleteResources() {
        ResourceManagerLocal resourceMgr = LookupUtil.getResourceManager();
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addFilterResourceTypeName("ServerC");
        criteria.addFilterPluginName("RemoveTypesPlugin");
        PageList resources = resourceMgr.findResourcesByCriteria(subjectMgr.getOverlord(), criteria);
        this.assertTrue("Did not expect to find any more that three resources. Database might need to be reset", resources.size() < 4);
        for (Resource resource : resources) {
            this.assertTrue("The resource should have been marked for deletion", InventoryStatus.UNINVENTORIED == resource.getInventoryStatus());
        }
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.resource.metadata.test", "RemoveTypes"})
    public void deleteBundles() {
        List bundles = this.getEntityManager().createQuery("from Bundle b where b.bundleType.name = :name").setParameter("name", (Object)"Test Bundle").getResultList();
        this.assertEquals("Failed to delete the bundles", 0, bundles.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.resource.metadata.test", "RemoveTypes"})
    public void deleteBundleTypes() {
        List bundleTypes = this.getEntityManager().createQuery("from BundleType b where b.name = :name").setParameter("name", (Object)"Test Bundle").getResultList();
        this.assertEquals("The bundle type should have been deleted", 0, bundleTypes.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.resource.metadata.test", "RemoveTypes"})
    public void deletePackages() {
        List packages = this.getEntityManager().createQuery("from Package p where p.name = :name").setParameter("name", (Object)"ServerC::test-package").getResultList();
        this.assertEquals("All packages should have been deleted", 0, packages.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.resource.metadata.test", "RemoveTypes"})
    public void deletePackageTypes() {
        List packageTypes = this.getEntityManager().createQuery("from PackageType p where p.name = :name").setParameter("name", (Object)"ServerC.Content").getResultList();
        this.assertEquals("All package types should have been deleted", 0, packageTypes.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.resource.metadata.test", "RemoveTypes"})
    public void deleteResourceGroups() {
        List groups = this.getEntityManager().createQuery("from ResourceGroup g where g.name = :name and g.resourceType.name = :typeName").setParameter("name", (Object)"ServerC Group").setParameter("typeName", (Object)"ServerC").getResultList();
        this.assertEquals("All resource groups should have been deleted", 0, groups.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.resource.metadata.test", "RemoveTypes"})
    public void deleteAlertTemplates() {
        List templates = this.getEntityManager().createQuery("from AlertDefinition a where a.name = :name and a.resourceType.name = :typeName").setParameter("name", (Object)"ServerC Alert Template").setParameter("typeName", (Object)"ServerC").getResultList();
        this.assertEquals("Alert templates should have been deleted.", 0, templates.size());
    }

    @Test(dependsOnMethods={"upgradePluginWithTypesRemoved"}, groups={"plugin.resource.metadata.test", "RemoveTypes"})
    public void deleteMeasurementDefinitions() {
        List measurementDefs = this.getEntityManager().createQuery("from MeasurementDefinition m where m.name = :name").setParameter("name", (Object)"ServerC::metric1").getResultList();
        this.assertEquals("Measurement definitions should have been deleted", 0, measurementDefs.size());
    }

    @Test(priority=1000, alwaysRun=true, dependsOnGroups={"RemoveTypes"})
    public void afterClassWorkTest() throws Exception {
        this.afterClassWork();
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
        for (int id : groupIds) {
            groupManager.deleteResourceGroup(overlord, id);
        }
    }

    void assertTypesPersisted(String msg, List<String> types, String plugin) {
        ArrayList<String> typesNotFound = new ArrayList<String>();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        for (String type : types) {
            if (resourceTypeMgr.getResourceTypeByNameAndPlugin(type, plugin) != null) continue;
            typesNotFound.add(type);
        }
        if (!typesNotFound.isEmpty()) {
            this.fail(msg + ": The following types were not found: " + typesNotFound);
        }
    }

    void assertAssociationExists(String resourceTypeName, String propertyName) throws Exception {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        String fetch = "fetch" + WordUtils.capitalize((String)propertyName);
        ResourceTypeCriteria criteria = new ResourceTypeCriteria();
        criteria.addFilterName(resourceTypeName);
        criteria.addFilterPluginName(PLUGIN_NAME);
        MethodUtils.invokeMethod((Object)criteria, (String)fetch, (Object)true);
        PageList resourceTypes = resourceTypeMgr.findResourceTypesByCriteria(subjectMgr.getOverlord(), criteria);
        ResourceType resourceType = (ResourceType)resourceTypes.get(0);
        Object property = PropertyUtils.getProperty((Object)resourceType, (String)propertyName);
        this.assertNotNull("Failed to find $propertyName for type '$resourceTypeName'", property);
    }

    List<Resource> createResources(int count, String pluginName, String resourceTypeName, Resource parent) throws Exception {
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        ResourceType resourceType = resourceTypeMgr.getResourceTypeByNameAndPlugin(resourceTypeName, pluginName);
        this.assertNotNull("Cannot create resources. Unable to find resource type for [name: " + resourceTypeName + ", plugin: " + pluginName + "]", resourceType);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (int i = 0; i < count; ++i) {
            resources.add(new ResourceBuilder().createServer().withResourceType(resourceType).withName(resourceType.getName() + "--" + i).withUuid(resourceType.getName()).withRandomResourceKey(resourceType.getName() + "--" + i).build());
        }
        this.getTransactionManager().begin();
        for (Resource resource : resources) {
            resource.setParentResource(parent);
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
            this.getEntityManager().persist((Object)resource);
        }
        this.getTransactionManager().commit();
        return resources;
    }

    void createBundle(String bundleName, String bundleTypeName, String resourceTypeName, String pluginName) throws Exception {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        BundleManagerLocal bundleMgr = LookupUtil.getBundleManager();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        ResourceType resourceType = resourceTypeMgr.getResourceTypeByNameAndPlugin(resourceTypeName, pluginName);
        this.assertNotNull("Cannot create bundle. Unable to find resource type for [name: " + resourceTypeName + ", plugin: " + pluginName + "]", resourceType);
        BundleType bundleType = bundleMgr.getBundleType(subjectMgr.getOverlord(), bundleTypeName);
        this.assertNotNull("Cannot create bundle. Unable to find bundle type for [name: " + bundleTypeName + "]", bundleType);
        Bundle bundle = bundleMgr.createBundle(subjectMgr.getOverlord(), bundleName, "test bundle: " + bundleName, bundleType.getId(), null);
        this.assertNotNull("Failed create bundle for [name: " + bundleName + "]", bundle);
    }

    void createPackage(String packageName, String resourceTypeName, String pluginName) throws Exception {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ContentManagerLocal contentMgr = LookupUtil.getContentManager();
        List packageTypes = contentMgr.findPackageTypes(subjectMgr.getOverlord(), resourceTypeName, pluginName);
        Package pkg = new Package(packageName, (PackageType)packageTypes.get(0));
        contentMgr.persistPackage(pkg);
    }

    ResourceGroup createResourceGroup(String groupName, String resourceTypeName, String pluginName, boolean recursive) throws Exception {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        ResourceGroupManagerLocal resourceGroupMgr = LookupUtil.getResourceGroupManager();
        ResourceType resourceType = resourceTypeMgr.getResourceTypeByNameAndPlugin(resourceTypeName, pluginName);
        this.assertNotNull("Cannot create resource group. Unable to find resource type for [name: " + resourceTypeName + ", plugin: " + pluginName + "]", resourceType);
        ResourceGroup resourceGroup = new ResourceGroup(groupName, resourceType);
        resourceGroup.setRecursive(recursive);
        ResourceGroup result = resourceGroupMgr.createResourceGroup(subjectMgr.getOverlord(), resourceGroup);
        groupIds.add(result.getId());
        return result;
    }

    void addResourcesToGroup(ResourceGroup rg, List<Resource> resources) throws Exception {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceGroupManagerLocal resourceGroupMgr = LookupUtil.getResourceGroupManager();
        int[] ids = new int[resources.size()];
        int i = 0;
        for (Resource r : resources) {
            ids[i++] = r.getId();
        }
        resourceGroupMgr.addResourcesToGroup(subjectMgr.getOverlord(), rg.getId(), ids);
    }

    void createAlertTemplate(String name, String resourceTypeName, String pluginName) throws Exception {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        ResourceTypeManagerLocal resourceTypeMgr = LookupUtil.getResourceTypeManager();
        AlertTemplateManagerLocal alertTemplateMgr = LookupUtil.getAlertTemplateManager();
        ResourceType resourceType = resourceTypeMgr.getResourceTypeByNameAndPlugin(resourceTypeName, pluginName);
        this.assertNotNull("Cannot create alert template. Unable to find resource type for [name: " + resourceTypeName + ", plugin: " + pluginName + "]", resourceType);
        AlertDefinition alertDef = new AlertDefinition();
        alertDef.setName(name);
        alertDef.setPriority(AlertPriority.MEDIUM);
        alertDef.setResourceType(resourceType);
        alertDef.setConditionExpression(BooleanExpression.ALL);
        alertDef.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        alertDef.setRecoveryId(Integer.valueOf(0));
        alertTemplateMgr.createAlertTemplate(subjectMgr.getOverlord(), alertDef, Integer.valueOf(resourceType.getId()));
    }
}

