/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata.test;

import java.io.File;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.rhq.enterprise.server.resource.metadata.test.UpdatePluginMetadataTestBase;
import org.testng.annotations.Test;

public class PluginDescriptorValidationTest
extends UpdatePluginMetadataTestBase {
    String BASE = "../../../plugins/";
    String EXT = "/src/main/resources/META-INF/rhq-plugin.xml";
    String[] plugins = new String[]{"database", "postgres", "platform", "jmx", "rhq-agent", "apache"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPluginDescriptors() throws Exception {
        int failed = 0;
        this.getTransactionManager().begin();
        try {
            for (String plugin : this.plugins) {
                String descriptor = this.BASE + plugin + this.EXT;
                try {
                    System.out.println("--- Testing plugin [" + plugin + "] ---");
                    File f = new File(descriptor);
                    descriptor = f.getCanonicalPath();
                    long then = System.currentTimeMillis();
                    this.validatePluginDescriptor(descriptor);
                    long now = System.currentTimeMillis();
                    System.out.println("   Validation took " + (now - then) + "ms");
                }
                catch (Exception e) {
                    ++failed;
                    System.out.println("!!! Validation of " + descriptor + " failed: " + e.getMessage() + " !!!");
                }
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
        if (failed > 0) {
            String msg = "Vaildation of [" + failed + "/" + this.plugins.length + "] descriptors failed";
            System.err.println(msg);
            throw new Exception(msg);
        }
        System.out.println("All tests passed");
    }

    public void validatePluginDescriptor(String descriptorFile) throws Exception {
        String PROTO = "file:///";
        URL descriptorUrl = new URL(PROTO + descriptorFile);
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.rhq.core.clientapi.descriptor.plugin");
        URL pluginSchemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("rhq-plugin.xsd");
        Schema pluginSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(pluginSchemaURL);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        ValidationEventCollector vec = new ValidationEventCollector();
        unmarshaller.setEventHandler((ValidationEventHandler)vec);
        unmarshaller.setSchema(pluginSchema);
        unmarshaller.unmarshal(descriptorUrl.openStream());
    }
}

