/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata.test;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.event.EventSource;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.resource.metadata.test.UpdatePluginMetadataTestBase;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

public class UpdateEventsSubsystemTest
extends UpdatePluginMetadataTestBase {
    static final boolean ENABLED = true;

    @Override
    protected String getSubsystemDirectory() {
        return "events";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testCreateDeleteEvent() throws Exception {
        System.out.println("= testCreateDeleteEvent");
        try {
            this.registerPlugin("event1-1.xml");
            ResourceType platform = this.getResourceType("events");
            assert (platform != null);
            this.getTransactionManager().begin();
            platform = (ResourceType)this.em.find(ResourceType.class, (Object)platform.getId());
            Set eDefs = platform.getEventDefinitions();
            assert (eDefs != null);
            assert (eDefs.size() == 1);
            EventDefinition hugo = (EventDefinition)eDefs.iterator().next();
            assert (hugo.getDescription().equals("One"));
            assert (hugo.getDisplayName().equals("HugoOne"));
            this.getTransactionManager().rollback();
            System.out.println("==> Done with v1");
            this.registerPlugin("event1-2.xml");
            platform = this.getResourceType("events");
            this.getTransactionManager().begin();
            this.em = this.getEntityManager();
            platform = (ResourceType)this.em.find(ResourceType.class, (Object)platform.getId());
            eDefs = platform.getEventDefinitions();
            assert (eDefs != null);
            assert (eDefs.size() == 2) : "Did not find 2 EventDefinitions, but " + eDefs.size();
            for (EventDefinition def : eDefs) {
                if (!def.getName().equals("hugo")) continue;
                assert (def.getDescription().equals("Two")) : "Expected 'Two', but got : " + def.getDescription();
                assert (def.getDisplayName().equals("HugoTwo"));
            }
            this.getTransactionManager().rollback();
            System.out.println("==> Done with v2");
            this.registerPlugin("event1-1.xml", "3.0");
            platform = this.getResourceType("events");
            this.getTransactionManager().begin();
            this.em = this.getEntityManager();
            platform = (ResourceType)this.em.find(ResourceType.class, (Object)platform.getId());
            eDefs = platform.getEventDefinitions();
            assert (eDefs != null);
            assert (eDefs.size() == 1) : "Did not find 1 EventDefinition, but " + eDefs.size();
            hugo = (EventDefinition)eDefs.iterator().next();
            assert (hugo.getDescription().equals("One"));
            assert (hugo.getDisplayName().equals("HugoOne"));
            System.out.println("==> Done with v1");
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testNoOpChange() throws Exception {
        System.out.println("= testNoOpChange");
        try {
            this.registerPlugin("event1-1.xml");
            ResourceType platform = this.getResourceType("events");
            assert (platform != null);
            this.getTransactionManager().begin();
            platform = (ResourceType)this.em.find(ResourceType.class, (Object)platform.getId());
            Set eDefs = platform.getEventDefinitions();
            assert (eDefs != null);
            assert (eDefs.size() == 1);
            EventDefinition hugo = (EventDefinition)eDefs.iterator().next();
            assert (hugo.getDescription().equals("One"));
            assert (hugo.getDisplayName().equals("HugoOne"));
            this.getTransactionManager().rollback();
            System.out.println("==> Done with v1");
            this.registerPlugin("event1-1.xml", "2.0");
            platform = this.getResourceType("events");
            assert (platform != null);
            this.getTransactionManager().begin();
            this.em = this.getEntityManager();
            platform = (ResourceType)this.em.find(ResourceType.class, (Object)platform.getId());
            eDefs = platform.getEventDefinitions();
            assert (eDefs != null);
            assert (eDefs.size() == 1);
            hugo = (EventDefinition)eDefs.iterator().next();
            assert (hugo.getDescription().equals("One"));
            assert (hugo.getDisplayName().equals("HugoOne"));
            System.out.println("==> Done with v2");
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testDeleteEventStuff() throws Exception {
        System.out.println("= testDeleteEvent");
        EventManagerLocal eventManager = LookupUtil.getEventManager();
        ResourceType platform = null;
        Resource testResource = null;
        try {
            this.registerPlugin("event1-2.xml");
            this.getTransactionManager().begin();
            platform = this.getResourceType("events");
            testResource = new Resource("-test-", "-test resource", platform);
            testResource.setUuid("" + new Random().nextInt());
            this.em.persist((Object)testResource);
            this.setUpAgent(testResource);
            this.getTransactionManager().commit();
            this.getTransactionManager().begin();
            platform = (ResourceType)this.em.find(ResourceType.class, (Object)platform.getId());
            testResource = (Resource)this.em.find(Resource.class, (Object)testResource.getId());
            Set eDefs = platform.getEventDefinitions();
            assert (eDefs.size() == 2) : "Did not find the expected 2 eventDefinitions, but " + eDefs.size();
            Iterator eIter = eDefs.iterator();
            boolean found = false;
            HashMap events = new HashMap(1);
            while (eIter.hasNext()) {
                EventDefinition def = (EventDefinition)eIter.next();
                if (!def.getName().equals("hans")) continue;
                found = true;
                EventSource source = new EventSource("test location", def, testResource);
                this.em.persist((Object)source);
                Event ev = new Event(def.getName(), source.getLocation(), System.currentTimeMillis(), EventSeverity.INFO, "This is a test");
                HashSet<Event> evSet = new HashSet<Event>(1);
                evSet.add(ev);
                events.put(source, evSet);
            }
            assert (found) : "Hans was not found";
            this.getTransactionManager().commit();
            eventManager.addEventData(events);
            this.registerPlugin("event1-1.xml", "3.0");
            platform = this.getResourceType("events");
            this.getTransactionManager().begin();
            platform = (ResourceType)this.em.find(ResourceType.class, (Object)platform.getId());
            eDefs = platform.getEventDefinitions();
            assert (eDefs != null);
            assert (eDefs.size() == 1) : "Did not find 1 EventDefinition, but " + eDefs.size();
            EventDefinition hugo = (EventDefinition)eDefs.iterator().next();
            assert (hugo.getDescription().equals("One"));
            assert (hugo.getDisplayName().equals("HugoOne"));
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }
}

