/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata.test;

import java.util.Random;
import java.util.Set;
import javax.persistence.NoResultException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementBaseline;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.resource.metadata.test.UpdatePluginMetadataTestBase;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

public class UpdateMeasurementSubsystemTest
extends UpdatePluginMetadataTestBase {
    static final boolean ENABLED = true;

    @Override
    protected String getSubsystemDirectory() {
        return "measurement";
    }

    @Test(enabled=true)
    public void testUpdateMeasurementDefinitions() throws Exception {
        this.registerPlugin("update-v1_0.xml");
        ResourceType server1 = this.getResourceType("testServer1");
        Set definitions1 = server1.getMetricDefinitions();
        assert (definitions1.size() == 5) : "There should be 5 metrics for v1";
        for (MeasurementDefinition def : definitions1) {
            if (def.getDisplayName().equals("Three")) assert (def.getDisplayType() == DisplayType.DETAIL) : "DisplayType for Three should be Detail in v1";
            if (def.getDisplayName().equals("Five")) assert (def.getDefaultInterval() == 30000L) : "DefaultInterval should be 30000 for Five in v1";
        }
        this.registerPlugin("update-v2_0.xml");
        ResourceType server2 = this.getResourceType("testServer1");
        Set definitions2 = server2.getMetricDefinitions();
        assert (definitions2.size() == 5) : "There should be 5 metrics in v2";
        boolean foundFour = false;
        for (MeasurementDefinition def : definitions2) {
            assert (!def.getDisplayName().equals("One")) : "One should be gone in v2";
            if (def.getDisplayName().equals("Three")) assert (def.getDisplayType() == DisplayType.SUMMARY) : "DisplayType for Three should be Summary in v2";
            if (def.getDisplayName().equals("Four")) {
                foundFour = true;
            }
            if (def.getDisplayName().equals("Five")) assert (def.getDefaultInterval() == 30000L) : "DefaultInterval should still be 30000 for Five in v2";
        }
        assert (foundFour) : "Four should be there in v2, but wasn't";
        this.registerPlugin("update-v1_0.xml", "3.0");
        ResourceType server3 = this.getResourceType("testServer1");
        Set definitions3 = server3.getMetricDefinitions();
        assert (definitions3.size() == 5) : "There should be 5 metrics for v3";
        for (MeasurementDefinition def : definitions3) {
            if (def.getDisplayName().equals("Three")) assert (def.getDisplayType() == DisplayType.DETAIL) : "DisplayType for Three should be Detail in v3";
            if (def.getDisplayName().equals("Five")) assert (def.getDefaultInterval() == 30000L) : "DefaultInterval should be 30000 for Five in v3";
        }
    }

    @Test(enabled=true)
    public void testDeleteMeasurementDefinition() throws Exception {
        this.registerPlugin("measurementDeletion-v1_0.xml");
        ResourceType server = this.getResourceType("testServer1");
        Set def = server.getMetricDefinitions();
        this.assertEquals(5, def.size());
        this.registerPlugin("measurementDeletion-v2_0.xml", "2.0");
        server = this.getResourceType("testServer1");
        def = server.getMetricDefinitions();
        this.assertEquals(1, def.size());
        this.registerPlugin("measurementDeletion-v1_0.xml", "3.0");
        server = this.getResourceType("testServer1");
        def = server.getMetricDefinitions();
        this.assertEquals(5, def.size());
    }

    @Test(enabled=true)
    public void testRenameServer() throws Exception {
        ResourceType server;
        Resource testResource = null;
        MeasurementSchedule sched = null;
        MeasurementBaseline baseline = null;
        EventDefinition eDef = null;
        try {
            this.registerPlugin("update6-1.xml");
            server = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            this.getPluginId();
            Set definitions1 = server.getMetricDefinitions();
            assert (definitions1.size() == 2);
            testResource = new Resource("-test-", "-test resource-", server);
            testResource.setUuid("" + new Random().nextInt());
            this.em.persist((Object)testResource);
            sched = new MeasurementSchedule((MeasurementDefinition)definitions1.iterator().next(), testResource);
            this.em.persist((Object)sched);
            this.em.flush();
            baseline = new MeasurementBaseline();
            baseline.setSchedule(sched);
            baseline.setUserEntered(true);
            this.em.persist((Object)baseline);
            eDef = new EventDefinition(server, "-test event definition-");
            this.em.persist((Object)eDef);
            this.setUpAgent(testResource);
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            this.getTransactionManager().rollback();
            this.fail("Setup of v1 failed: " + e);
        }
        System.out.println("Done with v1");
        this.registerPlugin("update6-2.xml");
        try {
            server = this.getResourceType("testServer1");
            assert (server == null) : "testServer1 found, but should not";
        }
        catch (NoResultException nre) {
            // empty catch block
        }
        server = this.getResourceType("testServer2");
        assert (server != null) : "testServer2 not found";
    }

    @Test(enabled=true)
    public void testAddScheduleOnExistingResources() throws Exception {
        ResourceType platform;
        try {
            this.registerPlugin("update7-1.xml");
            platform = this.getResourceType("myPlatform7");
            this.getTransactionManager().begin();
            this.getPluginId();
            Set definitions1 = platform.getMetricDefinitions();
            assert (definitions1.size() == 1);
            Resource testResource = new Resource("-test-", "-test resource", platform);
            testResource.setUuid("" + new Random().nextInt());
            this.em.persist((Object)testResource);
            this.setUpAgent(testResource);
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            this.getTransactionManager().rollback();
            this.fail("Setup of v1 failed: " + e);
        }
        System.out.println("Done with v1");
        try {
            this.registerPlugin("update7-2.xml");
        }
        catch (Throwable t) {
            System.err.println(t);
        }
        platform = this.getResourceType("myPlatform7");
        Set definitions2 = platform.getMetricDefinitions();
        assert (definitions2.size() == 2);
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        ResourceCriteria c = new ResourceCriteria();
        c.addFilterResourceTypeId(Integer.valueOf(platform.getId()));
        c.addFilterInventoryStatus(InventoryStatus.NEW);
        c.fetchSchedules(true);
        PageList resources = LookupUtil.getResourceManager().findResourcesByCriteria(overlord, c);
        assert (resources != null);
        this.assertEquals(1, resources.size());
        Resource res = (Resource)resources.get(0);
        Set schedules = res.getSchedules();
        assert (schedules != null);
        assert (schedules.size() == 1) : "Did not find the expected 1 new schedule, but: " + schedules.size();
    }
}

