/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata.test;

import java.util.Set;
import org.rhq.core.domain.resource.ProcessScan;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.resource.metadata.test.UpdatePluginMetadataTestBase;
import org.testng.annotations.Test;

public class UpdateNativesSubsystemTest
extends UpdatePluginMetadataTestBase {
    @Override
    protected String getSubsystemDirectory() {
        return "natives";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessScans() throws Exception {
        try {
            this.registerPlugin("update5-v1_0.xml");
            ResourceType platform1 = this.getResourceType("myPlatform5");
            this.getTransactionManager().begin();
            platform1 = (ResourceType)this.em.find(ResourceType.class, (Object)platform1.getId());
            Set servers = platform1.getChildResourceTypes();
            assert (servers.size() == 1) : "Expected to find 1 server in v1, but got " + servers.size();
            ResourceType server1 = (ResourceType)servers.iterator().next();
            Set scans1 = server1.getProcessScans();
            assert (scans1.size() == 3) : "Expected to find 3 process scans in v1, but got " + scans1.size();
            int found = 0;
            for (ProcessScan ps : scans1) {
                if (!this.containedIn(ps.getName(), new String[]{"JBoss4", "JBoss5", "JBoss6"})) continue;
                ++found;
            }
            assert (found == 3) : "Expected to find 3 process scans in v1";
            this.getTransactionManager().rollback();
            this.registerPlugin("update5-v2_0.xml");
            ResourceType platform2 = this.getResourceType("myPlatform5");
            this.getTransactionManager().begin();
            platform2 = (ResourceType)this.em.find(ResourceType.class, (Object)platform2.getId());
            Set servers2 = platform2.getChildResourceTypes();
            assert (servers2.size() == 1) : "Expected to find 1 server in v2, but got " + servers2.size();
            ResourceType server2 = (ResourceType)servers2.iterator().next();
            Set scans2 = server2.getProcessScans();
            assert (scans2.size() == 3) : "Expected to find 3 process scans in v2, but got " + scans2.size();
            found = 0;
            for (ProcessScan ps : scans2) {
                if (!this.containedIn(ps.getName(), new String[]{"JBoss5", "JBoss6", "Hibernate"})) continue;
                ++found;
            }
            assert (found == 3) : "Expected to find 3 specific process scans in v2, but got " + found;
            this.getTransactionManager().rollback();
            this.registerPlugin("update5-v1_0.xml", "3.0");
            platform1 = this.getResourceType("myPlatform5");
            this.getTransactionManager().begin();
            platform1 = (ResourceType)this.em.find(ResourceType.class, (Object)platform1.getId());
            servers = platform1.getChildResourceTypes();
            assert (servers.size() == 1) : "Expected to find 1 server in v1, but got " + servers.size();
            server1 = (ResourceType)servers.iterator().next();
            scans1 = server1.getProcessScans();
            assert (scans1.size() == 3) : "Expected to find 3 process scans in v1, but got " + scans1.size();
            found = 0;
            for (ProcessScan ps : scans1) {
                if (!this.containedIn(ps.getName(), new String[]{"JBoss4", "JBoss5", "JBoss6"})) continue;
                ++found;
            }
            assert (found == 3) : "Expected to find 3 specific process scans in v1 again, but got " + found;
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }
}

