/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata.test;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.resource.metadata.test.UpdatePluginMetadataTestBase;
import org.testng.annotations.Test;

public class UpdateOperationsSubsystemTest
extends UpdatePluginMetadataTestBase {
    private static final boolean ENABLED = true;

    @Override
    protected String getSubsystemDirectory() {
        return "operation";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testOperationAndArtifactUpdates() throws Exception {
        System.out.println("= testOperationAndArtifactUpdates");
        try {
            this.registerPlugin("update3-v1_0.xml");
            ResourceType platform1 = this.getResourceType("myPlatform3");
            this.getTransactionManager().begin();
            platform1 = (ResourceType)this.em.find(ResourceType.class, (Object)platform1.getId());
            Set packageTypes = platform1.getPackageTypes();
            assert (packageTypes.size() == 3) : "Did not find the three expected package types in v1";
            Set ops = platform1.getOperationDefinitions();
            assert (ops.size() == 3) : "Did not find three expected operations in v1";
            this.getTransactionManager().rollback();
            this.registerPlugin("update3-v2_0.xml");
            ResourceType platform2 = this.getResourceType("myPlatform3");
            this.getTransactionManager().begin();
            platform2 = (ResourceType)this.em.find(ResourceType.class, (Object)platform2.getId());
            Set packageTypes2 = platform2.getPackageTypes();
            assert (packageTypes2.size() == 3) : "Did not find the expected three package types in v2";
            Set opDefs = platform2.getOperationDefinitions();
            assert (opDefs.size() == 3) : "Did not find the three expected operations in v2";
            boolean ubuFound = false;
            for (PackageType pt : packageTypes2) {
                assert (!pt.getName().equals("rpm")) : "RPM should be gone in v2";
                if (!pt.getName().equals("ubu")) continue;
                ubuFound = true;
            }
            assert (ubuFound) : "Ubu should be in v2";
            boolean startFound = false;
            for (OperationDefinition opDef : opDefs) {
                assert (!opDef.getName().equals("restart")) : "Restart should be gone in v2";
                if (opDef.getName().equals("start")) {
                    startFound = true;
                }
                if (opDef.getName().equals("status")) assert (opDef.getDescription().equals("Yadda!")) : "Description for 'start' should be 'Yadda!', but was " + opDef.getDescription();
            }
            assert (startFound) : "Start should be in v2";
            this.getTransactionManager().rollback();
            this.registerPlugin("update3-v1_0.xml", "3.0");
            ResourceType platform3 = this.getResourceType("myPlatform3");
            this.getTransactionManager().begin();
            platform3 = (ResourceType)this.em.find(ResourceType.class, (Object)platform3.getId());
            Set packageTypes3 = platform3.getPackageTypes();
            assert (packageTypes3.size() == 3) : "Did not find the three package types in v3";
            Set ops3 = platform3.getOperationDefinitions();
            assert (ops3.size() == 3) : "Did not find three expected operations in v3";
            boolean rpmFound = false;
            for (PackageType pt : packageTypes3) {
                System.out.println(pt.getName());
                assert (!pt.getName().equals("ubu")) : "ubu should be gone in v3";
                if (!pt.getName().equals("rpm")) continue;
                rpmFound = true;
            }
            assert (rpmFound) : "rpm should be in v3";
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testAddRemoveOperationWithParams() throws Exception {
        System.out.println("= testAddRemoveOperationWithParams");
        try {
            this.registerPlugin("operation1-1.xml");
            ResourceType platform = this.getResourceType("ops");
            assert (platform != null);
            this.getTransactionManager().begin();
            platform = (ResourceType)this.em.find(ResourceType.class, (Object)platform.getId());
            Set opDefs = platform.getOperationDefinitions();
            assert (opDefs != null);
            assert (opDefs.size() == 1);
            OperationDefinition def = (OperationDefinition)opDefs.iterator().next();
            assert (def.getName().equals("sleep"));
            assert (def.getParametersConfigurationDefinition() == null);
            this.getTransactionManager().rollback();
            System.out.println("==> Done with v1");
            this.registerPlugin("operation1-2.xml");
            platform = this.getResourceType("ops");
            assert (platform != null);
            this.getTransactionManager().begin();
            platform = (ResourceType)this.em.find(ResourceType.class, (Object)platform.getId());
            opDefs = platform.getOperationDefinitions();
            assert (opDefs != null);
            assert (opDefs.size() == 2);
            for (OperationDefinition odef : opDefs) {
                if (!odef.getName().equals("invokeSql")) continue;
                assert (odef.getDescription().startsWith("Execute"));
                ConfigurationDefinition conf = odef.getParametersConfigurationDefinition();
                assert (conf != null);
                Map props = conf.getPropertyDefinitions();
                assert (props.size() == 2);
                for (PropertyDefinition pd : props.values()) {
                    PropertyDefinitionSimple pds = (PropertyDefinitionSimple)pd;
                    if (pds.getName().equals("sleep")) assert (pds.getDescription() == null);
                    if (!pds.getName().equals("invokeSql")) continue;
                    List pde = pds.getEnumeratedValues();
                    assert (pde.size() == 2);
                }
                conf = odef.getResultsConfigurationDefinition();
                assert (conf != null);
            }
            this.getTransactionManager().rollback();
            System.out.println("==> Done with v2");
            this.registerPlugin("operation1-1.xml", "3.0");
            platform = this.getResourceType("ops");
            assert (platform != null);
            this.getTransactionManager().begin();
            platform = (ResourceType)this.em.find(ResourceType.class, (Object)platform.getId());
            opDefs = platform.getOperationDefinitions();
            assert (opDefs != null);
            assert (opDefs.size() == 1);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testAddRemoveOperationWithParams2() throws Exception {
        System.out.println("= testAddRemoveOperationWithParams2");
        try {
            this.registerPlugin("operation2-1.xml");
            ResourceType platform = this.getResourceType("ops");
            assert (platform != null);
            this.getTransactionManager().begin();
            platform = (ResourceType)this.em.find(ResourceType.class, (Object)platform.getId());
            Set opDefs = platform.getOperationDefinitions();
            assert (opDefs != null);
            assert (opDefs.size() == 3) : "Did not find the expected 3 defs, but " + opDefs.size();
            int found = 0;
            for (OperationDefinition def : opDefs) {
                if (!this.containedIn(def.getName(), new String[]{"sleep", "wakeup", "getup"})) continue;
                ++found;
            }
            assert (found == 3) : "Did not find all 3 expected operations";
            this.getTransactionManager().rollback();
            System.out.println("==> Done with v1");
            this.registerPlugin("operation2-1.xml");
            System.out.println("==> Done with v1 (2)");
            this.registerPlugin("operation2-2.xml");
            platform = this.getResourceType("ops");
            assert (platform != null);
            this.getTransactionManager().begin();
            platform = (ResourceType)this.em.find(ResourceType.class, (Object)platform.getId());
            opDefs = platform.getOperationDefinitions();
            assert (opDefs != null);
            assert (opDefs.size() == 4) : "Did not find the expected 4 defs, but " + opDefs.size();
            found = 0;
            for (OperationDefinition def : opDefs) {
                if (!this.containedIn(def.getName(), new String[]{"wakeup", "getup", "eat", "goToWork"})) continue;
                ++found;
            }
            assert (found == 4) : "Did not find all 4 expected operations";
            this.getTransactionManager().rollback();
            System.out.println("==> Done with v2");
            this.registerPlugin("operation2-1.xml", "3.0");
            platform = this.getResourceType("ops");
            assert (platform != null);
            this.getTransactionManager().begin();
            platform = (ResourceType)this.em.find(ResourceType.class, (Object)platform.getId());
            opDefs = platform.getOperationDefinitions();
            assert (opDefs != null);
            assert (opDefs.size() == 3) : "Did not find the expected 3 defs, but " + opDefs.size();
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testAddRemoveOperationWithGrouping() throws Exception {
        System.out.println("= testAddRemoveOperationWithGrouping");
        try {
            this.registerPlugin("operation3-1.xml");
            ResourceType platform = this.getResourceType("ops");
            assert (platform != null);
            this.getTransactionManager().begin();
            platform = (ResourceType)this.em.find(ResourceType.class, (Object)platform.getId());
            Set opDefs = platform.getOperationDefinitions();
            assert (opDefs != null);
            assert (opDefs.size() == 3) : "Did not find the expected 3 defs, but " + opDefs.size();
            int found = 0;
            for (OperationDefinition def : opDefs) {
                if (!this.containedIn(def.getName(), new String[]{"sleep", "wakeup", "getup"})) continue;
                ++found;
            }
            assert (found == 3) : "Did not find all 3 expected operations";
            this.getTransactionManager().rollback();
            System.out.println("==> Done with v1");
            this.registerPlugin("operation3-1.xml");
            System.out.println("==> Done with v1 (2)");
            this.registerPlugin("operation3-2.xml");
            platform = this.getResourceType("ops");
            assert (platform != null);
            this.getTransactionManager().begin();
            platform = (ResourceType)this.em.find(ResourceType.class, (Object)platform.getId());
            opDefs = platform.getOperationDefinitions();
            assert (opDefs != null);
            assert (opDefs.size() == 4) : "Did not find the expected 4 defs, but " + opDefs.size();
            found = 0;
            for (OperationDefinition def : opDefs) {
                if (!this.containedIn(def.getName(), new String[]{"wakeup", "getup", "eat", "goToWork"})) continue;
                ++found;
            }
            assert (found == 4) : "Did not find all 4 expected operations";
            this.getTransactionManager().rollback();
            System.out.println("==> Done with v2");
            this.registerPlugin("operation3-1.xml", "3.0");
            platform = this.getResourceType("ops");
            assert (platform != null);
            this.getTransactionManager().begin();
            platform = (ResourceType)this.em.find(ResourceType.class, (Object)platform.getId());
            opDefs = platform.getOperationDefinitions();
            assert (opDefs != null);
            assert (opDefs.size() == 3) : "Did not find the expected 3 defs, but " + opDefs.size();
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }
}

